# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class K8SAuth(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'am_token_expiration': 'int',
        'auth_method_access_id': 'str',
        'auth_method_prv_key_pem': 'str',
        'cluster_api_type': 'str',
        'disable_iss_validation': 'bool',
        'id': 'str',
        'k8s_auth_type': 'str',
        'k8s_ca_cert': 'str',
        'k8s_client_cert_data': 'str',
        'k8s_client_key_data': 'str',
        'k8s_host': 'str',
        'k8s_issuer': 'str',
        'k8s_pub_keys_pem': 'list[str]',
        'k8s_token_reviewer_jwt': 'str',
        'name': 'str',
        'rancher_api_key': 'str',
        'rancher_cluster_id': 'str',
        'use_local_ca_jwt': 'bool'
    }

    attribute_map = {
        'am_token_expiration': 'am_token_expiration',
        'auth_method_access_id': 'auth_method_access_id',
        'auth_method_prv_key_pem': 'auth_method_prv_key_pem',
        'cluster_api_type': 'cluster_api_type',
        'disable_iss_validation': 'disable_iss_validation',
        'id': 'id',
        'k8s_auth_type': 'k8s_auth_type',
        'k8s_ca_cert': 'k8s_ca_cert',
        'k8s_client_cert_data': 'k8s_client_cert_data',
        'k8s_client_key_data': 'k8s_client_key_data',
        'k8s_host': 'k8s_host',
        'k8s_issuer': 'k8s_issuer',
        'k8s_pub_keys_pem': 'k8s_pub_keys_pem',
        'k8s_token_reviewer_jwt': 'k8s_token_reviewer_jwt',
        'name': 'name',
        'rancher_api_key': 'rancher_api_key',
        'rancher_cluster_id': 'rancher_cluster_id',
        'use_local_ca_jwt': 'use_local_ca_jwt'
    }

    def __init__(self, am_token_expiration=None, auth_method_access_id=None, auth_method_prv_key_pem=None, cluster_api_type=None, disable_iss_validation=None, id=None, k8s_auth_type=None, k8s_ca_cert=None, k8s_client_cert_data=None, k8s_client_key_data=None, k8s_host=None, k8s_issuer=None, k8s_pub_keys_pem=None, k8s_token_reviewer_jwt=None, name=None, rancher_api_key=None, rancher_cluster_id=None, use_local_ca_jwt=None, local_vars_configuration=None):  # noqa: E501
        """K8SAuth - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._am_token_expiration = None
        self._auth_method_access_id = None
        self._auth_method_prv_key_pem = None
        self._cluster_api_type = None
        self._disable_iss_validation = None
        self._id = None
        self._k8s_auth_type = None
        self._k8s_ca_cert = None
        self._k8s_client_cert_data = None
        self._k8s_client_key_data = None
        self._k8s_host = None
        self._k8s_issuer = None
        self._k8s_pub_keys_pem = None
        self._k8s_token_reviewer_jwt = None
        self._name = None
        self._rancher_api_key = None
        self._rancher_cluster_id = None
        self._use_local_ca_jwt = None
        self.discriminator = None

        if am_token_expiration is not None:
            self.am_token_expiration = am_token_expiration
        if auth_method_access_id is not None:
            self.auth_method_access_id = auth_method_access_id
        if auth_method_prv_key_pem is not None:
            self.auth_method_prv_key_pem = auth_method_prv_key_pem
        if cluster_api_type is not None:
            self.cluster_api_type = cluster_api_type
        if disable_iss_validation is not None:
            self.disable_iss_validation = disable_iss_validation
        if id is not None:
            self.id = id
        if k8s_auth_type is not None:
            self.k8s_auth_type = k8s_auth_type
        if k8s_ca_cert is not None:
            self.k8s_ca_cert = k8s_ca_cert
        if k8s_client_cert_data is not None:
            self.k8s_client_cert_data = k8s_client_cert_data
        if k8s_client_key_data is not None:
            self.k8s_client_key_data = k8s_client_key_data
        if k8s_host is not None:
            self.k8s_host = k8s_host
        if k8s_issuer is not None:
            self.k8s_issuer = k8s_issuer
        if k8s_pub_keys_pem is not None:
            self.k8s_pub_keys_pem = k8s_pub_keys_pem
        if k8s_token_reviewer_jwt is not None:
            self.k8s_token_reviewer_jwt = k8s_token_reviewer_jwt
        if name is not None:
            self.name = name
        if rancher_api_key is not None:
            self.rancher_api_key = rancher_api_key
        if rancher_cluster_id is not None:
            self.rancher_cluster_id = rancher_cluster_id
        if use_local_ca_jwt is not None:
            self.use_local_ca_jwt = use_local_ca_jwt

    @property
    def am_token_expiration(self):
        """Gets the am_token_expiration of this K8SAuth.  # noqa: E501

        AuthMethodTokenExpiration is time in seconds of expiration of the Akeyless Kube Auth Method token  # noqa: E501

        :return: The am_token_expiration of this K8SAuth.  # noqa: E501
        :rtype: int
        """
        return self._am_token_expiration

    @am_token_expiration.setter
    def am_token_expiration(self, am_token_expiration):
        """Sets the am_token_expiration of this K8SAuth.

        AuthMethodTokenExpiration is time in seconds of expiration of the Akeyless Kube Auth Method token  # noqa: E501

        :param am_token_expiration: The am_token_expiration of this K8SAuth.  # noqa: E501
        :type: int
        """

        self._am_token_expiration = am_token_expiration

    @property
    def auth_method_access_id(self):
        """Gets the auth_method_access_id of this K8SAuth.  # noqa: E501

        AuthMethodAccessId of the Kubernetes auth method  # noqa: E501

        :return: The auth_method_access_id of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._auth_method_access_id

    @auth_method_access_id.setter
    def auth_method_access_id(self, auth_method_access_id):
        """Sets the auth_method_access_id of this K8SAuth.

        AuthMethodAccessId of the Kubernetes auth method  # noqa: E501

        :param auth_method_access_id: The auth_method_access_id of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._auth_method_access_id = auth_method_access_id

    @property
    def auth_method_prv_key_pem(self):
        """Gets the auth_method_prv_key_pem of this K8SAuth.  # noqa: E501

        AuthMethodSigningKey is the private key (in base64 of the PEM format) associated with the public key defined in the Kubernetes auth method, that used to sign the internal token for the Akeyless Kubernetes Auth Method  # noqa: E501

        :return: The auth_method_prv_key_pem of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._auth_method_prv_key_pem

    @auth_method_prv_key_pem.setter
    def auth_method_prv_key_pem(self, auth_method_prv_key_pem):
        """Sets the auth_method_prv_key_pem of this K8SAuth.

        AuthMethodSigningKey is the private key (in base64 of the PEM format) associated with the public key defined in the Kubernetes auth method, that used to sign the internal token for the Akeyless Kubernetes Auth Method  # noqa: E501

        :param auth_method_prv_key_pem: The auth_method_prv_key_pem of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._auth_method_prv_key_pem = auth_method_prv_key_pem

    @property
    def cluster_api_type(self):
        """Gets the cluster_api_type of this K8SAuth.  # noqa: E501

        ClusterApiType defines types of API access to cluster  # noqa: E501

        :return: The cluster_api_type of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._cluster_api_type

    @cluster_api_type.setter
    def cluster_api_type(self, cluster_api_type):
        """Sets the cluster_api_type of this K8SAuth.

        ClusterApiType defines types of API access to cluster  # noqa: E501

        :param cluster_api_type: The cluster_api_type of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._cluster_api_type = cluster_api_type

    @property
    def disable_iss_validation(self):
        """Gets the disable_iss_validation of this K8SAuth.  # noqa: E501

        DisableISSValidation is optional parameter to disable ISS validation  # noqa: E501

        :return: The disable_iss_validation of this K8SAuth.  # noqa: E501
        :rtype: bool
        """
        return self._disable_iss_validation

    @disable_iss_validation.setter
    def disable_iss_validation(self, disable_iss_validation):
        """Sets the disable_iss_validation of this K8SAuth.

        DisableISSValidation is optional parameter to disable ISS validation  # noqa: E501

        :param disable_iss_validation: The disable_iss_validation of this K8SAuth.  # noqa: E501
        :type: bool
        """

        self._disable_iss_validation = disable_iss_validation

    @property
    def id(self):
        """Gets the id of this K8SAuth.  # noqa: E501


        :return: The id of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this K8SAuth.


        :param id: The id of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def k8s_auth_type(self):
        """Gets the k8s_auth_type of this K8SAuth.  # noqa: E501


        :return: The k8s_auth_type of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_auth_type

    @k8s_auth_type.setter
    def k8s_auth_type(self, k8s_auth_type):
        """Sets the k8s_auth_type of this K8SAuth.


        :param k8s_auth_type: The k8s_auth_type of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_auth_type = k8s_auth_type

    @property
    def k8s_ca_cert(self):
        """Gets the k8s_ca_cert of this K8SAuth.  # noqa: E501

        K8SCACert is the CA Cert to use to call into the kubernetes API  # noqa: E501

        :return: The k8s_ca_cert of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_ca_cert

    @k8s_ca_cert.setter
    def k8s_ca_cert(self, k8s_ca_cert):
        """Sets the k8s_ca_cert of this K8SAuth.

        K8SCACert is the CA Cert to use to call into the kubernetes API  # noqa: E501

        :param k8s_ca_cert: The k8s_ca_cert of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_ca_cert = k8s_ca_cert

    @property
    def k8s_client_cert_data(self):
        """Gets the k8s_client_cert_data of this K8SAuth.  # noqa: E501

        K8sClientCertData is the client certificate for k8s client certificate authentication  # noqa: E501

        :return: The k8s_client_cert_data of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_client_cert_data

    @k8s_client_cert_data.setter
    def k8s_client_cert_data(self, k8s_client_cert_data):
        """Sets the k8s_client_cert_data of this K8SAuth.

        K8sClientCertData is the client certificate for k8s client certificate authentication  # noqa: E501

        :param k8s_client_cert_data: The k8s_client_cert_data of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_client_cert_data = k8s_client_cert_data

    @property
    def k8s_client_key_data(self):
        """Gets the k8s_client_key_data of this K8SAuth.  # noqa: E501

        K8sClientKeyData is the client key for k8s client certificate authentication  # noqa: E501

        :return: The k8s_client_key_data of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_client_key_data

    @k8s_client_key_data.setter
    def k8s_client_key_data(self, k8s_client_key_data):
        """Sets the k8s_client_key_data of this K8SAuth.

        K8sClientKeyData is the client key for k8s client certificate authentication  # noqa: E501

        :param k8s_client_key_data: The k8s_client_key_data of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_client_key_data = k8s_client_key_data

    @property
    def k8s_host(self):
        """Gets the k8s_host of this K8SAuth.  # noqa: E501

        K8SHost is the url string for the kubernetes API  # noqa: E501

        :return: The k8s_host of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_host

    @k8s_host.setter
    def k8s_host(self, k8s_host):
        """Sets the k8s_host of this K8SAuth.

        K8SHost is the url string for the kubernetes API  # noqa: E501

        :param k8s_host: The k8s_host of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_host = k8s_host

    @property
    def k8s_issuer(self):
        """Gets the k8s_issuer of this K8SAuth.  # noqa: E501

        K8SIssuer is the claim that specifies who issued the Kubernetes token  # noqa: E501

        :return: The k8s_issuer of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_issuer

    @k8s_issuer.setter
    def k8s_issuer(self, k8s_issuer):
        """Sets the k8s_issuer of this K8SAuth.

        K8SIssuer is the claim that specifies who issued the Kubernetes token  # noqa: E501

        :param k8s_issuer: The k8s_issuer of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_issuer = k8s_issuer

    @property
    def k8s_pub_keys_pem(self):
        """Gets the k8s_pub_keys_pem of this K8SAuth.  # noqa: E501

        K8SPublicKeysPEM is the list of public key in PEM format  # noqa: E501

        :return: The k8s_pub_keys_pem of this K8SAuth.  # noqa: E501
        :rtype: list[str]
        """
        return self._k8s_pub_keys_pem

    @k8s_pub_keys_pem.setter
    def k8s_pub_keys_pem(self, k8s_pub_keys_pem):
        """Sets the k8s_pub_keys_pem of this K8SAuth.

        K8SPublicKeysPEM is the list of public key in PEM format  # noqa: E501

        :param k8s_pub_keys_pem: The k8s_pub_keys_pem of this K8SAuth.  # noqa: E501
        :type: list[str]
        """

        self._k8s_pub_keys_pem = k8s_pub_keys_pem

    @property
    def k8s_token_reviewer_jwt(self):
        """Gets the k8s_token_reviewer_jwt of this K8SAuth.  # noqa: E501

        K8STokenReviewerJWT is the bearer for clusterApiTypeK8s, used during TokenReview API call  # noqa: E501

        :return: The k8s_token_reviewer_jwt of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._k8s_token_reviewer_jwt

    @k8s_token_reviewer_jwt.setter
    def k8s_token_reviewer_jwt(self, k8s_token_reviewer_jwt):
        """Sets the k8s_token_reviewer_jwt of this K8SAuth.

        K8STokenReviewerJWT is the bearer for clusterApiTypeK8s, used during TokenReview API call  # noqa: E501

        :param k8s_token_reviewer_jwt: The k8s_token_reviewer_jwt of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._k8s_token_reviewer_jwt = k8s_token_reviewer_jwt

    @property
    def name(self):
        """Gets the name of this K8SAuth.  # noqa: E501


        :return: The name of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this K8SAuth.


        :param name: The name of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def rancher_api_key(self):
        """Gets the rancher_api_key of this K8SAuth.  # noqa: E501

        RancherApiKey the bear token for clusterApiTypeRancher  # noqa: E501

        :return: The rancher_api_key of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._rancher_api_key

    @rancher_api_key.setter
    def rancher_api_key(self, rancher_api_key):
        """Sets the rancher_api_key of this K8SAuth.

        RancherApiKey the bear token for clusterApiTypeRancher  # noqa: E501

        :param rancher_api_key: The rancher_api_key of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._rancher_api_key = rancher_api_key

    @property
    def rancher_cluster_id(self):
        """Gets the rancher_cluster_id of this K8SAuth.  # noqa: E501

        RancherClusterId cluster id as define in rancher (in case of clusterApiTypeRancher)  # noqa: E501

        :return: The rancher_cluster_id of this K8SAuth.  # noqa: E501
        :rtype: str
        """
        return self._rancher_cluster_id

    @rancher_cluster_id.setter
    def rancher_cluster_id(self, rancher_cluster_id):
        """Sets the rancher_cluster_id of this K8SAuth.

        RancherClusterId cluster id as define in rancher (in case of clusterApiTypeRancher)  # noqa: E501

        :param rancher_cluster_id: The rancher_cluster_id of this K8SAuth.  # noqa: E501
        :type: str
        """

        self._rancher_cluster_id = rancher_cluster_id

    @property
    def use_local_ca_jwt(self):
        """Gets the use_local_ca_jwt of this K8SAuth.  # noqa: E501

        UseLocalCAJwt is an optional parameter to set defaulting to using the local service account when running in a Kubernetes pod  # noqa: E501

        :return: The use_local_ca_jwt of this K8SAuth.  # noqa: E501
        :rtype: bool
        """
        return self._use_local_ca_jwt

    @use_local_ca_jwt.setter
    def use_local_ca_jwt(self, use_local_ca_jwt):
        """Sets the use_local_ca_jwt of this K8SAuth.

        UseLocalCAJwt is an optional parameter to set defaulting to using the local service account when running in a Kubernetes pod  # noqa: E501

        :param use_local_ca_jwt: The use_local_ca_jwt of this K8SAuth.  # noqa: E501
        :type: bool
        """

        self._use_local_ca_jwt = use_local_ca_jwt

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, K8SAuth):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, K8SAuth):
            return True

        return self.to_dict() != other.to_dict()
