# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class UpdatePKICertIssuer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'add_tag': 'list[str]',
        'allow_any_name': 'bool',
        'allow_copy_ext_from_csr': 'bool',
        'allow_subdomains': 'bool',
        'allowed_domains': 'str',
        'allowed_extra_extensions': 'str',
        'allowed_ip_sans': 'str',
        'allowed_uri_sans': 'str',
        'auto_renew': 'bool',
        'client_flag': 'bool',
        'code_signing_flag': 'bool',
        'country': 'str',
        'create_private_crl': 'bool',
        'create_public_crl': 'bool',
        'critical_key_usage': 'str',
        'delete_protection': 'str',
        'description': 'str',
        'destination_path': 'str',
        'disable_wildcards': 'bool',
        'enable_acme': 'bool',
        'expiration_event_in': 'list[str]',
        'gw_cluster_url': 'str',
        'is_ca': 'bool',
        'json': 'bool',
        'key_usage': 'str',
        'locality': 'str',
        'max_path_len': 'int',
        'metadata': 'str',
        'name': 'str',
        'new_name': 'str',
        'not_enforce_hostnames': 'bool',
        'not_require_cn': 'bool',
        'organizational_units': 'str',
        'organizations': 'str',
        'postal_code': 'str',
        'protect_certificates': 'bool',
        'province': 'str',
        'rm_tag': 'list[str]',
        'scheduled_renew': 'int',
        'server_flag': 'bool',
        'signer_key_name': 'str',
        'street_address': 'str',
        'token': 'str',
        'ttl': 'str',
        'uid_token': 'str'
    }

    attribute_map = {
        'add_tag': 'add-tag',
        'allow_any_name': 'allow-any-name',
        'allow_copy_ext_from_csr': 'allow-copy-ext-from-csr',
        'allow_subdomains': 'allow-subdomains',
        'allowed_domains': 'allowed-domains',
        'allowed_extra_extensions': 'allowed-extra-extensions',
        'allowed_ip_sans': 'allowed-ip-sans',
        'allowed_uri_sans': 'allowed-uri-sans',
        'auto_renew': 'auto-renew',
        'client_flag': 'client-flag',
        'code_signing_flag': 'code-signing-flag',
        'country': 'country',
        'create_private_crl': 'create-private-crl',
        'create_public_crl': 'create-public-crl',
        'critical_key_usage': 'critical-key-usage',
        'delete_protection': 'delete_protection',
        'description': 'description',
        'destination_path': 'destination-path',
        'disable_wildcards': 'disable-wildcards',
        'enable_acme': 'enable-acme',
        'expiration_event_in': 'expiration-event-in',
        'gw_cluster_url': 'gw-cluster-url',
        'is_ca': 'is-ca',
        'json': 'json',
        'key_usage': 'key-usage',
        'locality': 'locality',
        'max_path_len': 'max-path-len',
        'metadata': 'metadata',
        'name': 'name',
        'new_name': 'new-name',
        'not_enforce_hostnames': 'not-enforce-hostnames',
        'not_require_cn': 'not-require-cn',
        'organizational_units': 'organizational-units',
        'organizations': 'organizations',
        'postal_code': 'postal-code',
        'protect_certificates': 'protect-certificates',
        'province': 'province',
        'rm_tag': 'rm-tag',
        'scheduled_renew': 'scheduled-renew',
        'server_flag': 'server-flag',
        'signer_key_name': 'signer-key-name',
        'street_address': 'street-address',
        'token': 'token',
        'ttl': 'ttl',
        'uid_token': 'uid-token'
    }

    def __init__(self, add_tag=None, allow_any_name=None, allow_copy_ext_from_csr=None, allow_subdomains=None, allowed_domains=None, allowed_extra_extensions=None, allowed_ip_sans=None, allowed_uri_sans=None, auto_renew=None, client_flag=None, code_signing_flag=None, country=None, create_private_crl=None, create_public_crl=None, critical_key_usage='true', delete_protection=None, description=None, destination_path=None, disable_wildcards=None, enable_acme=None, expiration_event_in=None, gw_cluster_url=None, is_ca=None, json=False, key_usage='DigitalSignature,KeyAgreement,KeyEncipherment', locality=None, max_path_len=-1, metadata=None, name=None, new_name=None, not_enforce_hostnames=None, not_require_cn=None, organizational_units=None, organizations=None, postal_code=None, protect_certificates=None, province=None, rm_tag=None, scheduled_renew=None, server_flag=None, signer_key_name=None, street_address=None, token=None, ttl=None, uid_token=None, local_vars_configuration=None):  # noqa: E501
        """UpdatePKICertIssuer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._add_tag = None
        self._allow_any_name = None
        self._allow_copy_ext_from_csr = None
        self._allow_subdomains = None
        self._allowed_domains = None
        self._allowed_extra_extensions = None
        self._allowed_ip_sans = None
        self._allowed_uri_sans = None
        self._auto_renew = None
        self._client_flag = None
        self._code_signing_flag = None
        self._country = None
        self._create_private_crl = None
        self._create_public_crl = None
        self._critical_key_usage = None
        self._delete_protection = None
        self._description = None
        self._destination_path = None
        self._disable_wildcards = None
        self._enable_acme = None
        self._expiration_event_in = None
        self._gw_cluster_url = None
        self._is_ca = None
        self._json = None
        self._key_usage = None
        self._locality = None
        self._max_path_len = None
        self._metadata = None
        self._name = None
        self._new_name = None
        self._not_enforce_hostnames = None
        self._not_require_cn = None
        self._organizational_units = None
        self._organizations = None
        self._postal_code = None
        self._protect_certificates = None
        self._province = None
        self._rm_tag = None
        self._scheduled_renew = None
        self._server_flag = None
        self._signer_key_name = None
        self._street_address = None
        self._token = None
        self._ttl = None
        self._uid_token = None
        self.discriminator = None

        if add_tag is not None:
            self.add_tag = add_tag
        if allow_any_name is not None:
            self.allow_any_name = allow_any_name
        if allow_copy_ext_from_csr is not None:
            self.allow_copy_ext_from_csr = allow_copy_ext_from_csr
        if allow_subdomains is not None:
            self.allow_subdomains = allow_subdomains
        if allowed_domains is not None:
            self.allowed_domains = allowed_domains
        if allowed_extra_extensions is not None:
            self.allowed_extra_extensions = allowed_extra_extensions
        if allowed_ip_sans is not None:
            self.allowed_ip_sans = allowed_ip_sans
        if allowed_uri_sans is not None:
            self.allowed_uri_sans = allowed_uri_sans
        if auto_renew is not None:
            self.auto_renew = auto_renew
        if client_flag is not None:
            self.client_flag = client_flag
        if code_signing_flag is not None:
            self.code_signing_flag = code_signing_flag
        if country is not None:
            self.country = country
        if create_private_crl is not None:
            self.create_private_crl = create_private_crl
        if create_public_crl is not None:
            self.create_public_crl = create_public_crl
        if critical_key_usage is not None:
            self.critical_key_usage = critical_key_usage
        if delete_protection is not None:
            self.delete_protection = delete_protection
        if description is not None:
            self.description = description
        if destination_path is not None:
            self.destination_path = destination_path
        if disable_wildcards is not None:
            self.disable_wildcards = disable_wildcards
        if enable_acme is not None:
            self.enable_acme = enable_acme
        if expiration_event_in is not None:
            self.expiration_event_in = expiration_event_in
        if gw_cluster_url is not None:
            self.gw_cluster_url = gw_cluster_url
        if is_ca is not None:
            self.is_ca = is_ca
        if json is not None:
            self.json = json
        if key_usage is not None:
            self.key_usage = key_usage
        if locality is not None:
            self.locality = locality
        if max_path_len is not None:
            self.max_path_len = max_path_len
        if metadata is not None:
            self.metadata = metadata
        self.name = name
        if new_name is not None:
            self.new_name = new_name
        if not_enforce_hostnames is not None:
            self.not_enforce_hostnames = not_enforce_hostnames
        if not_require_cn is not None:
            self.not_require_cn = not_require_cn
        if organizational_units is not None:
            self.organizational_units = organizational_units
        if organizations is not None:
            self.organizations = organizations
        if postal_code is not None:
            self.postal_code = postal_code
        if protect_certificates is not None:
            self.protect_certificates = protect_certificates
        if province is not None:
            self.province = province
        if rm_tag is not None:
            self.rm_tag = rm_tag
        if scheduled_renew is not None:
            self.scheduled_renew = scheduled_renew
        if server_flag is not None:
            self.server_flag = server_flag
        if signer_key_name is not None:
            self.signer_key_name = signer_key_name
        if street_address is not None:
            self.street_address = street_address
        if token is not None:
            self.token = token
        self.ttl = ttl
        if uid_token is not None:
            self.uid_token = uid_token

    @property
    def add_tag(self):
        """Gets the add_tag of this UpdatePKICertIssuer.  # noqa: E501

        List of the new tags that will be attached to this item  # noqa: E501

        :return: The add_tag of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: list[str]
        """
        return self._add_tag

    @add_tag.setter
    def add_tag(self, add_tag):
        """Sets the add_tag of this UpdatePKICertIssuer.

        List of the new tags that will be attached to this item  # noqa: E501

        :param add_tag: The add_tag of this UpdatePKICertIssuer.  # noqa: E501
        :type: list[str]
        """

        self._add_tag = add_tag

    @property
    def allow_any_name(self):
        """Gets the allow_any_name of this UpdatePKICertIssuer.  # noqa: E501

        If set, clients can request certificates for any CN  # noqa: E501

        :return: The allow_any_name of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_any_name

    @allow_any_name.setter
    def allow_any_name(self, allow_any_name):
        """Sets the allow_any_name of this UpdatePKICertIssuer.

        If set, clients can request certificates for any CN  # noqa: E501

        :param allow_any_name: The allow_any_name of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._allow_any_name = allow_any_name

    @property
    def allow_copy_ext_from_csr(self):
        """Gets the allow_copy_ext_from_csr of this UpdatePKICertIssuer.  # noqa: E501

        If set, will allow copying the extra extensions from the csr file (if given)  # noqa: E501

        :return: The allow_copy_ext_from_csr of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_copy_ext_from_csr

    @allow_copy_ext_from_csr.setter
    def allow_copy_ext_from_csr(self, allow_copy_ext_from_csr):
        """Sets the allow_copy_ext_from_csr of this UpdatePKICertIssuer.

        If set, will allow copying the extra extensions from the csr file (if given)  # noqa: E501

        :param allow_copy_ext_from_csr: The allow_copy_ext_from_csr of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._allow_copy_ext_from_csr = allow_copy_ext_from_csr

    @property
    def allow_subdomains(self):
        """Gets the allow_subdomains of this UpdatePKICertIssuer.  # noqa: E501

        If set, clients can request certificates for subdomains of the allowed domains  # noqa: E501

        :return: The allow_subdomains of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_subdomains

    @allow_subdomains.setter
    def allow_subdomains(self, allow_subdomains):
        """Sets the allow_subdomains of this UpdatePKICertIssuer.

        If set, clients can request certificates for subdomains of the allowed domains  # noqa: E501

        :param allow_subdomains: The allow_subdomains of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._allow_subdomains = allow_subdomains

    @property
    def allowed_domains(self):
        """Gets the allowed_domains of this UpdatePKICertIssuer.  # noqa: E501

        A list of the allowed domains that clients can request to be included in the certificate (in a comma-delimited list)  # noqa: E501

        :return: The allowed_domains of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._allowed_domains

    @allowed_domains.setter
    def allowed_domains(self, allowed_domains):
        """Sets the allowed_domains of this UpdatePKICertIssuer.

        A list of the allowed domains that clients can request to be included in the certificate (in a comma-delimited list)  # noqa: E501

        :param allowed_domains: The allowed_domains of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._allowed_domains = allowed_domains

    @property
    def allowed_extra_extensions(self):
        """Gets the allowed_extra_extensions of this UpdatePKICertIssuer.  # noqa: E501

        A json string containing the allowed extra extensions for the pki cert issuer  # noqa: E501

        :return: The allowed_extra_extensions of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._allowed_extra_extensions

    @allowed_extra_extensions.setter
    def allowed_extra_extensions(self, allowed_extra_extensions):
        """Sets the allowed_extra_extensions of this UpdatePKICertIssuer.

        A json string containing the allowed extra extensions for the pki cert issuer  # noqa: E501

        :param allowed_extra_extensions: The allowed_extra_extensions of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._allowed_extra_extensions = allowed_extra_extensions

    @property
    def allowed_ip_sans(self):
        """Gets the allowed_ip_sans of this UpdatePKICertIssuer.  # noqa: E501

        A list of the allowed CIDRs for ips that clients can request to be included in the certificate as part of the IP Subject Alternative Names (in a comma-delimited list)  # noqa: E501

        :return: The allowed_ip_sans of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._allowed_ip_sans

    @allowed_ip_sans.setter
    def allowed_ip_sans(self, allowed_ip_sans):
        """Sets the allowed_ip_sans of this UpdatePKICertIssuer.

        A list of the allowed CIDRs for ips that clients can request to be included in the certificate as part of the IP Subject Alternative Names (in a comma-delimited list)  # noqa: E501

        :param allowed_ip_sans: The allowed_ip_sans of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._allowed_ip_sans = allowed_ip_sans

    @property
    def allowed_uri_sans(self):
        """Gets the allowed_uri_sans of this UpdatePKICertIssuer.  # noqa: E501

        A list of the allowed URIs that clients can request to be included in the certificate as part of the URI Subject Alternative Names (in a comma-delimited list)  # noqa: E501

        :return: The allowed_uri_sans of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._allowed_uri_sans

    @allowed_uri_sans.setter
    def allowed_uri_sans(self, allowed_uri_sans):
        """Sets the allowed_uri_sans of this UpdatePKICertIssuer.

        A list of the allowed URIs that clients can request to be included in the certificate as part of the URI Subject Alternative Names (in a comma-delimited list)  # noqa: E501

        :param allowed_uri_sans: The allowed_uri_sans of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._allowed_uri_sans = allowed_uri_sans

    @property
    def auto_renew(self):
        """Gets the auto_renew of this UpdatePKICertIssuer.  # noqa: E501

        Automatically renew certificates before expiration  # noqa: E501

        :return: The auto_renew of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._auto_renew

    @auto_renew.setter
    def auto_renew(self, auto_renew):
        """Sets the auto_renew of this UpdatePKICertIssuer.

        Automatically renew certificates before expiration  # noqa: E501

        :param auto_renew: The auto_renew of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._auto_renew = auto_renew

    @property
    def client_flag(self):
        """Gets the client_flag of this UpdatePKICertIssuer.  # noqa: E501

        If set, certificates will be flagged for client auth use  # noqa: E501

        :return: The client_flag of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._client_flag

    @client_flag.setter
    def client_flag(self, client_flag):
        """Sets the client_flag of this UpdatePKICertIssuer.

        If set, certificates will be flagged for client auth use  # noqa: E501

        :param client_flag: The client_flag of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._client_flag = client_flag

    @property
    def code_signing_flag(self):
        """Gets the code_signing_flag of this UpdatePKICertIssuer.  # noqa: E501

        If set, certificates will be flagged for code signing use  # noqa: E501

        :return: The code_signing_flag of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._code_signing_flag

    @code_signing_flag.setter
    def code_signing_flag(self, code_signing_flag):
        """Sets the code_signing_flag of this UpdatePKICertIssuer.

        If set, certificates will be flagged for code signing use  # noqa: E501

        :param code_signing_flag: The code_signing_flag of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._code_signing_flag = code_signing_flag

    @property
    def country(self):
        """Gets the country of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of countries that will be set in the issued certificate  # noqa: E501

        :return: The country of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this UpdatePKICertIssuer.

        A comma-separated list of countries that will be set in the issued certificate  # noqa: E501

        :param country: The country of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def create_private_crl(self):
        """Gets the create_private_crl of this UpdatePKICertIssuer.  # noqa: E501

        Set this to allow the issuer will expose a CRL endpoint in the Gateway  # noqa: E501

        :return: The create_private_crl of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._create_private_crl

    @create_private_crl.setter
    def create_private_crl(self, create_private_crl):
        """Sets the create_private_crl of this UpdatePKICertIssuer.

        Set this to allow the issuer will expose a CRL endpoint in the Gateway  # noqa: E501

        :param create_private_crl: The create_private_crl of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._create_private_crl = create_private_crl

    @property
    def create_public_crl(self):
        """Gets the create_public_crl of this UpdatePKICertIssuer.  # noqa: E501

        Set this to allow the cert issuer will expose a public CRL endpoint  # noqa: E501

        :return: The create_public_crl of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._create_public_crl

    @create_public_crl.setter
    def create_public_crl(self, create_public_crl):
        """Sets the create_public_crl of this UpdatePKICertIssuer.

        Set this to allow the cert issuer will expose a public CRL endpoint  # noqa: E501

        :param create_public_crl: The create_public_crl of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._create_public_crl = create_public_crl

    @property
    def critical_key_usage(self):
        """Gets the critical_key_usage of this UpdatePKICertIssuer.  # noqa: E501

        Mark key usage as critical [true/false]  # noqa: E501

        :return: The critical_key_usage of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._critical_key_usage

    @critical_key_usage.setter
    def critical_key_usage(self, critical_key_usage):
        """Sets the critical_key_usage of this UpdatePKICertIssuer.

        Mark key usage as critical [true/false]  # noqa: E501

        :param critical_key_usage: The critical_key_usage of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._critical_key_usage = critical_key_usage

    @property
    def delete_protection(self):
        """Gets the delete_protection of this UpdatePKICertIssuer.  # noqa: E501

        Protection from accidental deletion of this object [true/false]  # noqa: E501

        :return: The delete_protection of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._delete_protection

    @delete_protection.setter
    def delete_protection(self, delete_protection):
        """Sets the delete_protection of this UpdatePKICertIssuer.

        Protection from accidental deletion of this object [true/false]  # noqa: E501

        :param delete_protection: The delete_protection of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._delete_protection = delete_protection

    @property
    def description(self):
        """Gets the description of this UpdatePKICertIssuer.  # noqa: E501

        Description of the object  # noqa: E501

        :return: The description of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this UpdatePKICertIssuer.

        Description of the object  # noqa: E501

        :param description: The description of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def destination_path(self):
        """Gets the destination_path of this UpdatePKICertIssuer.  # noqa: E501

        A path in which to save generated certificates  # noqa: E501

        :return: The destination_path of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._destination_path

    @destination_path.setter
    def destination_path(self, destination_path):
        """Sets the destination_path of this UpdatePKICertIssuer.

        A path in which to save generated certificates  # noqa: E501

        :param destination_path: The destination_path of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._destination_path = destination_path

    @property
    def disable_wildcards(self):
        """Gets the disable_wildcards of this UpdatePKICertIssuer.  # noqa: E501

        If set, generation of wildcard certificates will be disabled.  # noqa: E501

        :return: The disable_wildcards of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._disable_wildcards

    @disable_wildcards.setter
    def disable_wildcards(self, disable_wildcards):
        """Sets the disable_wildcards of this UpdatePKICertIssuer.

        If set, generation of wildcard certificates will be disabled.  # noqa: E501

        :param disable_wildcards: The disable_wildcards of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._disable_wildcards = disable_wildcards

    @property
    def enable_acme(self):
        """Gets the enable_acme of this UpdatePKICertIssuer.  # noqa: E501

        If set, the cert issuer will support the acme protocol  # noqa: E501

        :return: The enable_acme of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._enable_acme

    @enable_acme.setter
    def enable_acme(self, enable_acme):
        """Sets the enable_acme of this UpdatePKICertIssuer.

        If set, the cert issuer will support the acme protocol  # noqa: E501

        :param enable_acme: The enable_acme of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._enable_acme = enable_acme

    @property
    def expiration_event_in(self):
        """Gets the expiration_event_in of this UpdatePKICertIssuer.  # noqa: E501

        How many days before the expiration of the certificate would you like to be notified.  # noqa: E501

        :return: The expiration_event_in of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: list[str]
        """
        return self._expiration_event_in

    @expiration_event_in.setter
    def expiration_event_in(self, expiration_event_in):
        """Sets the expiration_event_in of this UpdatePKICertIssuer.

        How many days before the expiration of the certificate would you like to be notified.  # noqa: E501

        :param expiration_event_in: The expiration_event_in of this UpdatePKICertIssuer.  # noqa: E501
        :type: list[str]
        """

        self._expiration_event_in = expiration_event_in

    @property
    def gw_cluster_url(self):
        """Gets the gw_cluster_url of this UpdatePKICertIssuer.  # noqa: E501

        The GW cluster URL to issue the certificate from. Required in Public CA mode, to allow CRLs on private CA, or to enable ACME  # noqa: E501

        :return: The gw_cluster_url of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._gw_cluster_url

    @gw_cluster_url.setter
    def gw_cluster_url(self, gw_cluster_url):
        """Sets the gw_cluster_url of this UpdatePKICertIssuer.

        The GW cluster URL to issue the certificate from. Required in Public CA mode, to allow CRLs on private CA, or to enable ACME  # noqa: E501

        :param gw_cluster_url: The gw_cluster_url of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._gw_cluster_url = gw_cluster_url

    @property
    def is_ca(self):
        """Gets the is_ca of this UpdatePKICertIssuer.  # noqa: E501

        If set, the basic constraints extension will be added to certificate  # noqa: E501

        :return: The is_ca of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._is_ca

    @is_ca.setter
    def is_ca(self, is_ca):
        """Sets the is_ca of this UpdatePKICertIssuer.

        If set, the basic constraints extension will be added to certificate  # noqa: E501

        :param is_ca: The is_ca of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._is_ca = is_ca

    @property
    def json(self):
        """Gets the json of this UpdatePKICertIssuer.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this UpdatePKICertIssuer.

        Set output format to JSON  # noqa: E501

        :param json: The json of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def key_usage(self):
        """Gets the key_usage of this UpdatePKICertIssuer.  # noqa: E501

        key-usage  # noqa: E501

        :return: The key_usage of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._key_usage

    @key_usage.setter
    def key_usage(self, key_usage):
        """Sets the key_usage of this UpdatePKICertIssuer.

        key-usage  # noqa: E501

        :param key_usage: The key_usage of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._key_usage = key_usage

    @property
    def locality(self):
        """Gets the locality of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of localities that will be set in the issued certificate  # noqa: E501

        :return: The locality of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._locality

    @locality.setter
    def locality(self, locality):
        """Sets the locality of this UpdatePKICertIssuer.

        A comma-separated list of localities that will be set in the issued certificate  # noqa: E501

        :param locality: The locality of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._locality = locality

    @property
    def max_path_len(self):
        """Gets the max_path_len of this UpdatePKICertIssuer.  # noqa: E501

        The maximum path length for the generated certificate. -1, means unlimited  # noqa: E501

        :return: The max_path_len of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: int
        """
        return self._max_path_len

    @max_path_len.setter
    def max_path_len(self, max_path_len):
        """Sets the max_path_len of this UpdatePKICertIssuer.

        The maximum path length for the generated certificate. -1, means unlimited  # noqa: E501

        :param max_path_len: The max_path_len of this UpdatePKICertIssuer.  # noqa: E501
        :type: int
        """

        self._max_path_len = max_path_len

    @property
    def metadata(self):
        """Gets the metadata of this UpdatePKICertIssuer.  # noqa: E501

        Deprecated - use description  # noqa: E501

        :return: The metadata of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this UpdatePKICertIssuer.

        Deprecated - use description  # noqa: E501

        :param metadata: The metadata of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._metadata = metadata

    @property
    def name(self):
        """Gets the name of this UpdatePKICertIssuer.  # noqa: E501

        PKI certificate issuer name  # noqa: E501

        :return: The name of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UpdatePKICertIssuer.

        PKI certificate issuer name  # noqa: E501

        :param name: The name of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def new_name(self):
        """Gets the new_name of this UpdatePKICertIssuer.  # noqa: E501

        New item name  # noqa: E501

        :return: The new_name of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._new_name

    @new_name.setter
    def new_name(self, new_name):
        """Sets the new_name of this UpdatePKICertIssuer.

        New item name  # noqa: E501

        :param new_name: The new_name of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._new_name = new_name

    @property
    def not_enforce_hostnames(self):
        """Gets the not_enforce_hostnames of this UpdatePKICertIssuer.  # noqa: E501

        If set, any names are allowed for CN and SANs in the certificate and not only a valid host name  # noqa: E501

        :return: The not_enforce_hostnames of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._not_enforce_hostnames

    @not_enforce_hostnames.setter
    def not_enforce_hostnames(self, not_enforce_hostnames):
        """Sets the not_enforce_hostnames of this UpdatePKICertIssuer.

        If set, any names are allowed for CN and SANs in the certificate and not only a valid host name  # noqa: E501

        :param not_enforce_hostnames: The not_enforce_hostnames of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._not_enforce_hostnames = not_enforce_hostnames

    @property
    def not_require_cn(self):
        """Gets the not_require_cn of this UpdatePKICertIssuer.  # noqa: E501

        If set, clients can request certificates without a CN  # noqa: E501

        :return: The not_require_cn of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._not_require_cn

    @not_require_cn.setter
    def not_require_cn(self, not_require_cn):
        """Sets the not_require_cn of this UpdatePKICertIssuer.

        If set, clients can request certificates without a CN  # noqa: E501

        :param not_require_cn: The not_require_cn of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._not_require_cn = not_require_cn

    @property
    def organizational_units(self):
        """Gets the organizational_units of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of organizational units (OU) that will be set in the issued certificate  # noqa: E501

        :return: The organizational_units of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._organizational_units

    @organizational_units.setter
    def organizational_units(self, organizational_units):
        """Sets the organizational_units of this UpdatePKICertIssuer.

        A comma-separated list of organizational units (OU) that will be set in the issued certificate  # noqa: E501

        :param organizational_units: The organizational_units of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._organizational_units = organizational_units

    @property
    def organizations(self):
        """Gets the organizations of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of organizations (O) that will be set in the issued certificate  # noqa: E501

        :return: The organizations of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations):
        """Sets the organizations of this UpdatePKICertIssuer.

        A comma-separated list of organizations (O) that will be set in the issued certificate  # noqa: E501

        :param organizations: The organizations of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._organizations = organizations

    @property
    def postal_code(self):
        """Gets the postal_code of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of postal codes that will be set in the issued certificate  # noqa: E501

        :return: The postal_code of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """Sets the postal_code of this UpdatePKICertIssuer.

        A comma-separated list of postal codes that will be set in the issued certificate  # noqa: E501

        :param postal_code: The postal_code of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._postal_code = postal_code

    @property
    def protect_certificates(self):
        """Gets the protect_certificates of this UpdatePKICertIssuer.  # noqa: E501

        Whether to protect generated certificates from deletion  # noqa: E501

        :return: The protect_certificates of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._protect_certificates

    @protect_certificates.setter
    def protect_certificates(self, protect_certificates):
        """Sets the protect_certificates of this UpdatePKICertIssuer.

        Whether to protect generated certificates from deletion  # noqa: E501

        :param protect_certificates: The protect_certificates of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._protect_certificates = protect_certificates

    @property
    def province(self):
        """Gets the province of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of provinces that will be set in the issued certificate  # noqa: E501

        :return: The province of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._province

    @province.setter
    def province(self, province):
        """Sets the province of this UpdatePKICertIssuer.

        A comma-separated list of provinces that will be set in the issued certificate  # noqa: E501

        :param province: The province of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._province = province

    @property
    def rm_tag(self):
        """Gets the rm_tag of this UpdatePKICertIssuer.  # noqa: E501

        List of the existent tags that will be removed from this item  # noqa: E501

        :return: The rm_tag of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: list[str]
        """
        return self._rm_tag

    @rm_tag.setter
    def rm_tag(self, rm_tag):
        """Sets the rm_tag of this UpdatePKICertIssuer.

        List of the existent tags that will be removed from this item  # noqa: E501

        :param rm_tag: The rm_tag of this UpdatePKICertIssuer.  # noqa: E501
        :type: list[str]
        """

        self._rm_tag = rm_tag

    @property
    def scheduled_renew(self):
        """Gets the scheduled_renew of this UpdatePKICertIssuer.  # noqa: E501

        Number of days before expiration to renew certificates  # noqa: E501

        :return: The scheduled_renew of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: int
        """
        return self._scheduled_renew

    @scheduled_renew.setter
    def scheduled_renew(self, scheduled_renew):
        """Sets the scheduled_renew of this UpdatePKICertIssuer.

        Number of days before expiration to renew certificates  # noqa: E501

        :param scheduled_renew: The scheduled_renew of this UpdatePKICertIssuer.  # noqa: E501
        :type: int
        """

        self._scheduled_renew = scheduled_renew

    @property
    def server_flag(self):
        """Gets the server_flag of this UpdatePKICertIssuer.  # noqa: E501

        If set, certificates will be flagged for server auth use  # noqa: E501

        :return: The server_flag of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: bool
        """
        return self._server_flag

    @server_flag.setter
    def server_flag(self, server_flag):
        """Sets the server_flag of this UpdatePKICertIssuer.

        If set, certificates will be flagged for server auth use  # noqa: E501

        :param server_flag: The server_flag of this UpdatePKICertIssuer.  # noqa: E501
        :type: bool
        """

        self._server_flag = server_flag

    @property
    def signer_key_name(self):
        """Gets the signer_key_name of this UpdatePKICertIssuer.  # noqa: E501

        A key to sign the certificate with, required in Private CA mode  # noqa: E501

        :return: The signer_key_name of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._signer_key_name

    @signer_key_name.setter
    def signer_key_name(self, signer_key_name):
        """Sets the signer_key_name of this UpdatePKICertIssuer.

        A key to sign the certificate with, required in Private CA mode  # noqa: E501

        :param signer_key_name: The signer_key_name of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._signer_key_name = signer_key_name

    @property
    def street_address(self):
        """Gets the street_address of this UpdatePKICertIssuer.  # noqa: E501

        A comma-separated list of street addresses that will be set in the issued certificate  # noqa: E501

        :return: The street_address of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._street_address

    @street_address.setter
    def street_address(self, street_address):
        """Sets the street_address of this UpdatePKICertIssuer.

        A comma-separated list of street addresses that will be set in the issued certificate  # noqa: E501

        :param street_address: The street_address of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._street_address = street_address

    @property
    def token(self):
        """Gets the token of this UpdatePKICertIssuer.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this UpdatePKICertIssuer.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def ttl(self):
        """Gets the ttl of this UpdatePKICertIssuer.  # noqa: E501

        The maximum requested Time To Live for issued certificates, in seconds. In case of Public CA, this is based on the CA target's supported maximum TTLs  # noqa: E501

        :return: The ttl of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """Sets the ttl of this UpdatePKICertIssuer.

        The maximum requested Time To Live for issued certificates, in seconds. In case of Public CA, this is based on the CA target's supported maximum TTLs  # noqa: E501

        :param ttl: The ttl of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and ttl is None:  # noqa: E501
            raise ValueError("Invalid value for `ttl`, must not be `None`")  # noqa: E501

        self._ttl = ttl

    @property
    def uid_token(self):
        """Gets the uid_token of this UpdatePKICertIssuer.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this UpdatePKICertIssuer.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this UpdatePKICertIssuer.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this UpdatePKICertIssuer.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdatePKICertIssuer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdatePKICertIssuer):
            return True

        return self.to_dict() != other.to_dict()
