# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Vulnerability(object):
    """
    A vulnerability is a weakness or error in an artifact.
    A vulnerability is a generalization of a CVE (every CVE is a vulnerability, but not every vulnerability has a CVE).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Vulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Vulnerability.
        :type id: str

        :param cvss_v2_score:
            The value to assign to the cvss_v2_score property of this Vulnerability.
        :type cvss_v2_score: float

        :param cvss_v3_score:
            The value to assign to the cvss_v3_score property of this Vulnerability.
        :type cvss_v3_score: float

        :param is_ignored:
            The value to assign to the is_ignored property of this Vulnerability.
        :type is_ignored: bool

        """
        self.swagger_types = {
            'id': 'str',
            'cvss_v2_score': 'float',
            'cvss_v3_score': 'float',
            'is_ignored': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'cvss_v2_score': 'cvssV2Score',
            'cvss_v3_score': 'cvssV3Score',
            'is_ignored': 'isIgnored'
        }

        self._id = None
        self._cvss_v2_score = None
        self._cvss_v3_score = None
        self._is_ignored = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Vulnerability.
        Unique vulnerability identifier, e.g. CVE-1999-0067.


        :return: The id of this Vulnerability.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Vulnerability.
        Unique vulnerability identifier, e.g. CVE-1999-0067.


        :param id: The id of this Vulnerability.
        :type: str
        """
        self._id = id

    @property
    def cvss_v2_score(self):
        """
        **[Required]** Gets the cvss_v2_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 2.


        :return: The cvss_v2_score of this Vulnerability.
        :rtype: float
        """
        return self._cvss_v2_score

    @cvss_v2_score.setter
    def cvss_v2_score(self, cvss_v2_score):
        """
        Sets the cvss_v2_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 2.


        :param cvss_v2_score: The cvss_v2_score of this Vulnerability.
        :type: float
        """
        self._cvss_v2_score = cvss_v2_score

    @property
    def cvss_v3_score(self):
        """
        **[Required]** Gets the cvss_v3_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 3.


        :return: The cvss_v3_score of this Vulnerability.
        :rtype: float
        """
        return self._cvss_v3_score

    @cvss_v3_score.setter
    def cvss_v3_score(self, cvss_v3_score):
        """
        Sets the cvss_v3_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 3.


        :param cvss_v3_score: The cvss_v3_score of this Vulnerability.
        :type: float
        """
        self._cvss_v3_score = cvss_v3_score

    @property
    def is_ignored(self):
        """
        **[Required]** Gets the is_ignored of this Vulnerability.
        Indicates if the vulnerability was ignored according to the audit configuration.


        :return: The is_ignored of this Vulnerability.
        :rtype: bool
        """
        return self._is_ignored

    @is_ignored.setter
    def is_ignored(self, is_ignored):
        """
        Sets the is_ignored of this Vulnerability.
        Indicates if the vulnerability was ignored according to the audit configuration.


        :param is_ignored: The is_ignored of this Vulnerability.
        :type: bool
        """
        self._is_ignored = is_ignored

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
