# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityAudit(object):
    """
    A Vulnerability Audit associates the Application Dependencies of a project with their associated vulnerabilities.
    Each Vulnerability is associated with a score (Common Vulnerability Scoring System V2 or V3).
    """

    #: A constant which can be used with the lifecycle_state property of a VulnerabilityAudit.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilityAudit.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilityAudit.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilityAudit.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilityAudit.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the build_type property of a VulnerabilityAudit.
    #: This constant has a value of "MAVEN"
    BUILD_TYPE_MAVEN = "MAVEN"

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityAudit object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VulnerabilityAudit.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this VulnerabilityAudit.
        :type display_name: str

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this VulnerabilityAudit.
        :type knowledge_base_id: str

        :param time_created:
            The value to assign to the time_created property of this VulnerabilityAudit.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this VulnerabilityAudit.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VulnerabilityAudit.
            Allowed values for this property are: "ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param vulnerabilities:
            The value to assign to the vulnerabilities property of this VulnerabilityAudit.
        :type vulnerabilities: list[oci.adm.models.Vulnerability]

        :param max_observed_cvss_v2_score:
            The value to assign to the max_observed_cvss_v2_score property of this VulnerabilityAudit.
        :type max_observed_cvss_v2_score: float

        :param max_observed_cvss_v3_score:
            The value to assign to the max_observed_cvss_v3_score property of this VulnerabilityAudit.
        :type max_observed_cvss_v3_score: float

        :param vulnerable_artifacts_count:
            The value to assign to the vulnerable_artifacts_count property of this VulnerabilityAudit.
        :type vulnerable_artifacts_count: int

        :param configuration:
            The value to assign to the configuration property of this VulnerabilityAudit.
        :type configuration: oci.adm.models.VulnerabilityAuditConfiguration

        :param is_success:
            The value to assign to the is_success property of this VulnerabilityAudit.
        :type is_success: bool

        :param build_type:
            The value to assign to the build_type property of this VulnerabilityAudit.
            Allowed values for this property are: "MAVEN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type build_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VulnerabilityAudit.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this VulnerabilityAudit.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this VulnerabilityAudit.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this VulnerabilityAudit.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'knowledge_base_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'vulnerabilities': 'list[Vulnerability]',
            'max_observed_cvss_v2_score': 'float',
            'max_observed_cvss_v3_score': 'float',
            'vulnerable_artifacts_count': 'int',
            'configuration': 'VulnerabilityAuditConfiguration',
            'is_success': 'bool',
            'build_type': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'knowledge_base_id': 'knowledgeBaseId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'vulnerabilities': 'vulnerabilities',
            'max_observed_cvss_v2_score': 'maxObservedCvssV2Score',
            'max_observed_cvss_v3_score': 'maxObservedCvssV3Score',
            'vulnerable_artifacts_count': 'vulnerableArtifactsCount',
            'configuration': 'configuration',
            'is_success': 'isSuccess',
            'build_type': 'buildType',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._knowledge_base_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._vulnerabilities = None
        self._max_observed_cvss_v2_score = None
        self._max_observed_cvss_v3_score = None
        self._vulnerable_artifacts_count = None
        self._configuration = None
        self._is_success = None
        self._build_type = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the Vulnerability Audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this VulnerabilityAudit.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the Vulnerability Audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this VulnerabilityAudit.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this VulnerabilityAudit.
        The name of the Vulnerability Audit.


        :return: The display_name of this VulnerabilityAudit.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this VulnerabilityAudit.
        The name of the Vulnerability Audit.


        :param display_name: The display_name of this VulnerabilityAudit.
        :type: str
        """
        self._display_name = display_name

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the Knowledge Base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this VulnerabilityAudit.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the Knowledge Base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this VulnerabilityAudit.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this VulnerabilityAudit.
        The creation date and time of the Vulnerability Audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this VulnerabilityAudit.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this VulnerabilityAudit.
        The creation date and time of the Vulnerability Audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this VulnerabilityAudit.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this VulnerabilityAudit.
        The update date and time of the Vulnerability Audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this VulnerabilityAudit.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this VulnerabilityAudit.
        The update date and time of the Vulnerability Audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this VulnerabilityAudit.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this VulnerabilityAudit.
        The current lifecycle state of the Vulnerability Audit.

        Allowed values for this property are: "ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this VulnerabilityAudit.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this VulnerabilityAudit.
        The current lifecycle state of the Vulnerability Audit.


        :param lifecycle_state: The lifecycle_state of this VulnerabilityAudit.
        :type: str
        """
        allowed_values = ["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def vulnerabilities(self):
        """
        **[Required]** Gets the vulnerabilities of this VulnerabilityAudit.
        List of vulnerabilities found in the Vulnerability Audit.


        :return: The vulnerabilities of this VulnerabilityAudit.
        :rtype: list[oci.adm.models.Vulnerability]
        """
        return self._vulnerabilities

    @vulnerabilities.setter
    def vulnerabilities(self, vulnerabilities):
        """
        Sets the vulnerabilities of this VulnerabilityAudit.
        List of vulnerabilities found in the Vulnerability Audit.


        :param vulnerabilities: The vulnerabilities of this VulnerabilityAudit.
        :type: list[oci.adm.models.Vulnerability]
        """
        self._vulnerabilities = vulnerabilities

    @property
    def max_observed_cvss_v2_score(self):
        """
        **[Required]** Gets the max_observed_cvss_v2_score of this VulnerabilityAudit.
        Maximum Common Vulnerability Scoring System Version 2 score of vulnerabilities.


        :return: The max_observed_cvss_v2_score of this VulnerabilityAudit.
        :rtype: float
        """
        return self._max_observed_cvss_v2_score

    @max_observed_cvss_v2_score.setter
    def max_observed_cvss_v2_score(self, max_observed_cvss_v2_score):
        """
        Sets the max_observed_cvss_v2_score of this VulnerabilityAudit.
        Maximum Common Vulnerability Scoring System Version 2 score of vulnerabilities.


        :param max_observed_cvss_v2_score: The max_observed_cvss_v2_score of this VulnerabilityAudit.
        :type: float
        """
        self._max_observed_cvss_v2_score = max_observed_cvss_v2_score

    @property
    def max_observed_cvss_v3_score(self):
        """
        **[Required]** Gets the max_observed_cvss_v3_score of this VulnerabilityAudit.
        Maximum Common Vulnerability Scoring System Version 3 score of vulnerabilities.


        :return: The max_observed_cvss_v3_score of this VulnerabilityAudit.
        :rtype: float
        """
        return self._max_observed_cvss_v3_score

    @max_observed_cvss_v3_score.setter
    def max_observed_cvss_v3_score(self, max_observed_cvss_v3_score):
        """
        Sets the max_observed_cvss_v3_score of this VulnerabilityAudit.
        Maximum Common Vulnerability Scoring System Version 3 score of vulnerabilities.


        :param max_observed_cvss_v3_score: The max_observed_cvss_v3_score of this VulnerabilityAudit.
        :type: float
        """
        self._max_observed_cvss_v3_score = max_observed_cvss_v3_score

    @property
    def vulnerable_artifacts_count(self):
        """
        **[Required]** Gets the vulnerable_artifacts_count of this VulnerabilityAudit.
        Count of vulnerable artifacts.


        :return: The vulnerable_artifacts_count of this VulnerabilityAudit.
        :rtype: int
        """
        return self._vulnerable_artifacts_count

    @vulnerable_artifacts_count.setter
    def vulnerable_artifacts_count(self, vulnerable_artifacts_count):
        """
        Sets the vulnerable_artifacts_count of this VulnerabilityAudit.
        Count of vulnerable artifacts.


        :param vulnerable_artifacts_count: The vulnerable_artifacts_count of this VulnerabilityAudit.
        :type: int
        """
        self._vulnerable_artifacts_count = vulnerable_artifacts_count

    @property
    def configuration(self):
        """
        Gets the configuration of this VulnerabilityAudit.

        :return: The configuration of this VulnerabilityAudit.
        :rtype: oci.adm.models.VulnerabilityAuditConfiguration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this VulnerabilityAudit.

        :param configuration: The configuration of this VulnerabilityAudit.
        :type: oci.adm.models.VulnerabilityAuditConfiguration
        """
        self._configuration = configuration

    @property
    def is_success(self):
        """
        Gets the is_success of this VulnerabilityAudit.
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.


        :return: The is_success of this VulnerabilityAudit.
        :rtype: bool
        """
        return self._is_success

    @is_success.setter
    def is_success(self, is_success):
        """
        Sets the is_success of this VulnerabilityAudit.
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.


        :param is_success: The is_success of this VulnerabilityAudit.
        :type: bool
        """
        self._is_success = is_success

    @property
    def build_type(self):
        """
        **[Required]** Gets the build_type of this VulnerabilityAudit.
        The type of the build tool.

        Allowed values for this property are: "MAVEN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The build_type of this VulnerabilityAudit.
        :rtype: str
        """
        return self._build_type

    @build_type.setter
    def build_type(self, build_type):
        """
        Sets the build_type of this VulnerabilityAudit.
        The type of the build tool.


        :param build_type: The build_type of this VulnerabilityAudit.
        :type: str
        """
        allowed_values = ["MAVEN"]
        if not value_allowed_none_or_none_sentinel(build_type, allowed_values):
            build_type = 'UNKNOWN_ENUM_VALUE'
        self._build_type = build_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the compartment associated with the Vulnerability Audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this VulnerabilityAudit.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VulnerabilityAudit.
        The Oracle Cloud identifier (`OCID`__) of the compartment associated with the Vulnerability Audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this VulnerabilityAudit.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this VulnerabilityAudit.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this VulnerabilityAudit.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this VulnerabilityAudit.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this VulnerabilityAudit.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this VulnerabilityAudit.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this VulnerabilityAudit.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this VulnerabilityAudit.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this VulnerabilityAudit.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this VulnerabilityAudit.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this VulnerabilityAudit.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this VulnerabilityAudit.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this VulnerabilityAudit.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
