# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityAuditConfiguration(object):
    """
    Configuration for a Vulnerability Audit
    type: object
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityAuditConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param max_permissible_cvss_v2_score:
            The value to assign to the max_permissible_cvss_v2_score property of this VulnerabilityAuditConfiguration.
        :type max_permissible_cvss_v2_score: float

        :param max_permissible_cvss_v3_score:
            The value to assign to the max_permissible_cvss_v3_score property of this VulnerabilityAuditConfiguration.
        :type max_permissible_cvss_v3_score: float

        :param exclusions:
            The value to assign to the exclusions property of this VulnerabilityAuditConfiguration.
        :type exclusions: list[str]

        """
        self.swagger_types = {
            'max_permissible_cvss_v2_score': 'float',
            'max_permissible_cvss_v3_score': 'float',
            'exclusions': 'list[str]'
        }

        self.attribute_map = {
            'max_permissible_cvss_v2_score': 'maxPermissibleCvssV2Score',
            'max_permissible_cvss_v3_score': 'maxPermissibleCvssV3Score',
            'exclusions': 'exclusions'
        }

        self._max_permissible_cvss_v2_score = None
        self._max_permissible_cvss_v3_score = None
        self._exclusions = None

    @property
    def max_permissible_cvss_v2_score(self):
        """
        Gets the max_permissible_cvss_v2_score of this VulnerabilityAuditConfiguration.
        The minimum CVSS V2 score for a vulnerability to be considered by the audit as failed.


        :return: The max_permissible_cvss_v2_score of this VulnerabilityAuditConfiguration.
        :rtype: float
        """
        return self._max_permissible_cvss_v2_score

    @max_permissible_cvss_v2_score.setter
    def max_permissible_cvss_v2_score(self, max_permissible_cvss_v2_score):
        """
        Sets the max_permissible_cvss_v2_score of this VulnerabilityAuditConfiguration.
        The minimum CVSS V2 score for a vulnerability to be considered by the audit as failed.


        :param max_permissible_cvss_v2_score: The max_permissible_cvss_v2_score of this VulnerabilityAuditConfiguration.
        :type: float
        """
        self._max_permissible_cvss_v2_score = max_permissible_cvss_v2_score

    @property
    def max_permissible_cvss_v3_score(self):
        """
        Gets the max_permissible_cvss_v3_score of this VulnerabilityAuditConfiguration.
        The minimum CVSS V3 score for a vulnerability to be considered by the audit as failed.


        :return: The max_permissible_cvss_v3_score of this VulnerabilityAuditConfiguration.
        :rtype: float
        """
        return self._max_permissible_cvss_v3_score

    @max_permissible_cvss_v3_score.setter
    def max_permissible_cvss_v3_score(self, max_permissible_cvss_v3_score):
        """
        Sets the max_permissible_cvss_v3_score of this VulnerabilityAuditConfiguration.
        The minimum CVSS V3 score for a vulnerability to be considered by the audit as failed.


        :param max_permissible_cvss_v3_score: The max_permissible_cvss_v3_score of this VulnerabilityAuditConfiguration.
        :type: float
        """
        self._max_permissible_cvss_v3_score = max_permissible_cvss_v3_score

    @property
    def exclusions(self):
        """
        Gets the exclusions of this VulnerabilityAuditConfiguration.
        Pattern to exclude artifacts from audit.


        :return: The exclusions of this VulnerabilityAuditConfiguration.
        :rtype: list[str]
        """
        return self._exclusions

    @exclusions.setter
    def exclusions(self, exclusions):
        """
        Sets the exclusions of this VulnerabilityAuditConfiguration.
        Pattern to exclude artifacts from audit.


        :param exclusions: The exclusions of this VulnerabilityAuditConfiguration.
        :type: list[str]
        """
        self._exclusions = exclusions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
