# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

from __future__ import absolute_import

from .add_drg_route_distribution_statement_details import AddDrgRouteDistributionStatementDetails
from .add_drg_route_distribution_statements_details import AddDrgRouteDistributionStatementsDetails
from .add_drg_route_rule_details import AddDrgRouteRuleDetails
from .add_drg_route_rules_details import AddDrgRouteRulesDetails
from .add_image_shape_compatibility_entry_details import AddImageShapeCompatibilityEntryDetails
from .add_network_security_group_security_rules_details import AddNetworkSecurityGroupSecurityRulesDetails
from .add_public_ip_pool_capacity_details import AddPublicIpPoolCapacityDetails
from .add_security_rule_details import AddSecurityRuleDetails
from .add_subnet_ipv6_cidr_details import AddSubnetIpv6CidrDetails
from .add_vcn_cidr_details import AddVcnCidrDetails
from .add_vcn_ipv6_cidr_details import AddVcnIpv6CidrDetails
from .added_network_security_group_security_rules import AddedNetworkSecurityGroupSecurityRules
from .allowed_ike_ip_sec_parameters import AllowedIkeIPSecParameters
from .allowed_phase_one_parameters import AllowedPhaseOneParameters
from .allowed_phase_two_parameters import AllowedPhaseTwoParameters
from .amd_milan_bm_launch_instance_platform_config import AmdMilanBmLaunchInstancePlatformConfig
from .amd_milan_bm_platform_config import AmdMilanBmPlatformConfig
from .amd_rome_bm_gpu_launch_instance_platform_config import AmdRomeBmGpuLaunchInstancePlatformConfig
from .amd_rome_bm_gpu_platform_config import AmdRomeBmGpuPlatformConfig
from .amd_rome_bm_launch_instance_platform_config import AmdRomeBmLaunchInstancePlatformConfig
from .amd_rome_bm_platform_config import AmdRomeBmPlatformConfig
from .amd_vm_launch_instance_platform_config import AmdVmLaunchInstancePlatformConfig
from .amd_vm_platform_config import AmdVmPlatformConfig
from .app_catalog_listing import AppCatalogListing
from .app_catalog_listing_resource_version import AppCatalogListingResourceVersion
from .app_catalog_listing_resource_version_agreements import AppCatalogListingResourceVersionAgreements
from .app_catalog_listing_resource_version_summary import AppCatalogListingResourceVersionSummary
from .app_catalog_listing_summary import AppCatalogListingSummary
from .app_catalog_subscription import AppCatalogSubscription
from .app_catalog_subscription_summary import AppCatalogSubscriptionSummary
from .attach_boot_volume_details import AttachBootVolumeDetails
from .attach_emulated_volume_details import AttachEmulatedVolumeDetails
from .attach_i_scsi_volume_details import AttachIScsiVolumeDetails
from .attach_instance_pool_instance_details import AttachInstancePoolInstanceDetails
from .attach_load_balancer_details import AttachLoadBalancerDetails
from .attach_paravirtualized_volume_details import AttachParavirtualizedVolumeDetails
from .attach_service_determined_volume_details import AttachServiceDeterminedVolumeDetails
from .attach_vnic_details import AttachVnicDetails
from .attach_volume_details import AttachVolumeDetails
from .bgp_session_info import BgpSessionInfo
from .block_volume_replica import BlockVolumeReplica
from .block_volume_replica_details import BlockVolumeReplicaDetails
from .block_volume_replica_info import BlockVolumeReplicaInfo
from .boolean_image_capability_schema_descriptor import BooleanImageCapabilitySchemaDescriptor
from .boot_volume import BootVolume
from .boot_volume_attachment import BootVolumeAttachment
from .boot_volume_backup import BootVolumeBackup
from .boot_volume_kms_key import BootVolumeKmsKey
from .boot_volume_replica import BootVolumeReplica
from .boot_volume_replica_details import BootVolumeReplicaDetails
from .boot_volume_replica_info import BootVolumeReplicaInfo
from .boot_volume_source_details import BootVolumeSourceDetails
from .boot_volume_source_from_boot_volume_backup_details import BootVolumeSourceFromBootVolumeBackupDetails
from .boot_volume_source_from_boot_volume_details import BootVolumeSourceFromBootVolumeDetails
from .boot_volume_source_from_boot_volume_replica_details import BootVolumeSourceFromBootVolumeReplicaDetails
from .bulk_add_virtual_circuit_public_prefixes_details import BulkAddVirtualCircuitPublicPrefixesDetails
from .bulk_delete_virtual_circuit_public_prefixes_details import BulkDeleteVirtualCircuitPublicPrefixesDetails
from .byoip_allocated_range_collection import ByoipAllocatedRangeCollection
from .byoip_allocated_range_summary import ByoipAllocatedRangeSummary
from .byoip_range import ByoipRange
from .byoip_range_collection import ByoipRangeCollection
from .byoip_range_summary import ByoipRangeSummary
from .byoip_range_vcn_ipv6_allocation_summary import ByoipRangeVcnIpv6AllocationSummary
from .byoipv6_cidr_details import Byoipv6CidrDetails
from .capacity_reservation_instance_summary import CapacityReservationInstanceSummary
from .capture_console_history_details import CaptureConsoleHistoryDetails
from .capture_filter import CaptureFilter
from .change_boot_volume_backup_compartment_details import ChangeBootVolumeBackupCompartmentDetails
from .change_boot_volume_compartment_details import ChangeBootVolumeCompartmentDetails
from .change_byoip_range_compartment_details import ChangeByoipRangeCompartmentDetails
from .change_capture_filter_compartment_details import ChangeCaptureFilterCompartmentDetails
from .change_cluster_network_compartment_details import ChangeClusterNetworkCompartmentDetails
from .change_compute_capacity_reservation_compartment_details import ChangeComputeCapacityReservationCompartmentDetails
from .change_compute_image_capability_schema_compartment_details import ChangeComputeImageCapabilitySchemaCompartmentDetails
from .change_cpe_compartment_details import ChangeCpeCompartmentDetails
from .change_cross_connect_compartment_details import ChangeCrossConnectCompartmentDetails
from .change_cross_connect_group_compartment_details import ChangeCrossConnectGroupCompartmentDetails
from .change_dedicated_vm_host_compartment_details import ChangeDedicatedVmHostCompartmentDetails
from .change_dhcp_options_compartment_details import ChangeDhcpOptionsCompartmentDetails
from .change_drg_compartment_details import ChangeDrgCompartmentDetails
from .change_ip_sec_connection_compartment_details import ChangeIPSecConnectionCompartmentDetails
from .change_image_compartment_details import ChangeImageCompartmentDetails
from .change_instance_compartment_details import ChangeInstanceCompartmentDetails
from .change_instance_configuration_compartment_details import ChangeInstanceConfigurationCompartmentDetails
from .change_instance_pool_compartment_details import ChangeInstancePoolCompartmentDetails
from .change_internet_gateway_compartment_details import ChangeInternetGatewayCompartmentDetails
from .change_local_peering_gateway_compartment_details import ChangeLocalPeeringGatewayCompartmentDetails
from .change_nat_gateway_compartment_details import ChangeNatGatewayCompartmentDetails
from .change_network_security_group_compartment_details import ChangeNetworkSecurityGroupCompartmentDetails
from .change_public_ip_compartment_details import ChangePublicIpCompartmentDetails
from .change_public_ip_pool_compartment_details import ChangePublicIpPoolCompartmentDetails
from .change_remote_peering_connection_compartment_details import ChangeRemotePeeringConnectionCompartmentDetails
from .change_route_table_compartment_details import ChangeRouteTableCompartmentDetails
from .change_security_list_compartment_details import ChangeSecurityListCompartmentDetails
from .change_service_gateway_compartment_details import ChangeServiceGatewayCompartmentDetails
from .change_subnet_compartment_details import ChangeSubnetCompartmentDetails
from .change_vcn_compartment_details import ChangeVcnCompartmentDetails
from .change_virtual_circuit_compartment_details import ChangeVirtualCircuitCompartmentDetails
from .change_vlan_compartment_details import ChangeVlanCompartmentDetails
from .change_volume_backup_compartment_details import ChangeVolumeBackupCompartmentDetails
from .change_volume_compartment_details import ChangeVolumeCompartmentDetails
from .change_volume_group_backup_compartment_details import ChangeVolumeGroupBackupCompartmentDetails
from .change_volume_group_compartment_details import ChangeVolumeGroupCompartmentDetails
from .change_vtap_compartment_details import ChangeVtapCompartmentDetails
from .cluster_network import ClusterNetwork
from .cluster_network_placement_configuration_details import ClusterNetworkPlacementConfigurationDetails
from .cluster_network_summary import ClusterNetworkSummary
from .compartment_internal import CompartmentInternal
from .compute_capacity_reservation import ComputeCapacityReservation
from .compute_capacity_reservation_instance_shape_summary import ComputeCapacityReservationInstanceShapeSummary
from .compute_capacity_reservation_summary import ComputeCapacityReservationSummary
from .compute_global_image_capability_schema import ComputeGlobalImageCapabilitySchema
from .compute_global_image_capability_schema_summary import ComputeGlobalImageCapabilitySchemaSummary
from .compute_global_image_capability_schema_version import ComputeGlobalImageCapabilitySchemaVersion
from .compute_global_image_capability_schema_version_summary import ComputeGlobalImageCapabilitySchemaVersionSummary
from .compute_image_capability_schema import ComputeImageCapabilitySchema
from .compute_image_capability_schema_summary import ComputeImageCapabilitySchemaSummary
from .compute_instance_details import ComputeInstanceDetails
from .connect_local_peering_gateways_details import ConnectLocalPeeringGatewaysDetails
from .connect_remote_peering_connections_details import ConnectRemotePeeringConnectionsDetails
from .console_history import ConsoleHistory
from .copy_boot_volume_backup_details import CopyBootVolumeBackupDetails
from .copy_volume_backup_details import CopyVolumeBackupDetails
from .copy_volume_group_backup_details import CopyVolumeGroupBackupDetails
from .cpe import Cpe
from .cpe_device_config_answer import CpeDeviceConfigAnswer
from .cpe_device_config_question import CpeDeviceConfigQuestion
from .cpe_device_info import CpeDeviceInfo
from .cpe_device_shape_detail import CpeDeviceShapeDetail
from .cpe_device_shape_summary import CpeDeviceShapeSummary
from .create_app_catalog_subscription_details import CreateAppCatalogSubscriptionDetails
from .create_boot_volume_backup_details import CreateBootVolumeBackupDetails
from .create_boot_volume_details import CreateBootVolumeDetails
from .create_byoip_range_details import CreateByoipRangeDetails
from .create_capture_filter_details import CreateCaptureFilterDetails
from .create_cluster_network_details import CreateClusterNetworkDetails
from .create_cluster_network_instance_pool_details import CreateClusterNetworkInstancePoolDetails
from .create_compute_capacity_reservation_details import CreateComputeCapacityReservationDetails
from .create_compute_image_capability_schema_details import CreateComputeImageCapabilitySchemaDetails
from .create_cpe_details import CreateCpeDetails
from .create_cross_connect_details import CreateCrossConnectDetails
from .create_cross_connect_group_details import CreateCrossConnectGroupDetails
from .create_dedicated_vm_host_details import CreateDedicatedVmHostDetails
from .create_dhcp_details import CreateDhcpDetails
from .create_drg_attachment_details import CreateDrgAttachmentDetails
from .create_drg_details import CreateDrgDetails
from .create_drg_route_distribution_details import CreateDrgRouteDistributionDetails
from .create_drg_route_table_details import CreateDrgRouteTableDetails
from .create_ip_sec_connection_details import CreateIPSecConnectionDetails
from .create_ip_sec_connection_tunnel_details import CreateIPSecConnectionTunnelDetails
from .create_ip_sec_tunnel_bgp_session_details import CreateIPSecTunnelBgpSessionDetails
from .create_ip_sec_tunnel_encryption_domain_details import CreateIPSecTunnelEncryptionDomainDetails
from .create_image_details import CreateImageDetails
from .create_instance_configuration_base import CreateInstanceConfigurationBase
from .create_instance_configuration_details import CreateInstanceConfigurationDetails
from .create_instance_configuration_from_instance_details import CreateInstanceConfigurationFromInstanceDetails
from .create_instance_console_connection_details import CreateInstanceConsoleConnectionDetails
from .create_instance_pool_details import CreateInstancePoolDetails
from .create_instance_pool_placement_configuration_details import CreateInstancePoolPlacementConfigurationDetails
from .create_internet_gateway_details import CreateInternetGatewayDetails
from .create_ipv6_details import CreateIpv6Details
from .create_local_peering_gateway_details import CreateLocalPeeringGatewayDetails
from .create_macsec_key import CreateMacsecKey
from .create_macsec_properties import CreateMacsecProperties
from .create_nat_gateway_details import CreateNatGatewayDetails
from .create_network_security_group_details import CreateNetworkSecurityGroupDetails
from .create_private_ip_details import CreatePrivateIpDetails
from .create_public_ip_details import CreatePublicIpDetails
from .create_public_ip_pool_details import CreatePublicIpPoolDetails
from .create_remote_peering_connection_details import CreateRemotePeeringConnectionDetails
from .create_route_table_details import CreateRouteTableDetails
from .create_security_list_details import CreateSecurityListDetails
from .create_service_gateway_details import CreateServiceGatewayDetails
from .create_subnet_details import CreateSubnetDetails
from .create_vcn_details import CreateVcnDetails
from .create_virtual_circuit_details import CreateVirtualCircuitDetails
from .create_virtual_circuit_public_prefix_details import CreateVirtualCircuitPublicPrefixDetails
from .create_vlan_details import CreateVlanDetails
from .create_vnic_details import CreateVnicDetails
from .create_volume_backup_details import CreateVolumeBackupDetails
from .create_volume_backup_policy_assignment_details import CreateVolumeBackupPolicyAssignmentDetails
from .create_volume_backup_policy_details import CreateVolumeBackupPolicyDetails
from .create_volume_details import CreateVolumeDetails
from .create_volume_group_backup_details import CreateVolumeGroupBackupDetails
from .create_volume_group_details import CreateVolumeGroupDetails
from .create_vtap_details import CreateVtapDetails
from .cross_connect import CrossConnect
from .cross_connect_group import CrossConnectGroup
from .cross_connect_location import CrossConnectLocation
from .cross_connect_mapping import CrossConnectMapping
from .cross_connect_mapping_details import CrossConnectMappingDetails
from .cross_connect_mapping_details_collection import CrossConnectMappingDetailsCollection
from .cross_connect_port_speed_shape import CrossConnectPortSpeedShape
from .cross_connect_status import CrossConnectStatus
from .dedicated_vm_host import DedicatedVmHost
from .dedicated_vm_host_instance_shape_summary import DedicatedVmHostInstanceShapeSummary
from .dedicated_vm_host_instance_summary import DedicatedVmHostInstanceSummary
from .dedicated_vm_host_shape_summary import DedicatedVmHostShapeSummary
from .dedicated_vm_host_summary import DedicatedVmHostSummary
from .default_drg_route_tables import DefaultDrgRouteTables
from .default_phase_one_parameters import DefaultPhaseOneParameters
from .default_phase_two_parameters import DefaultPhaseTwoParameters
from .delete_virtual_circuit_public_prefix_details import DeleteVirtualCircuitPublicPrefixDetails
from .detach_instance_pool_instance_details import DetachInstancePoolInstanceDetails
from .detach_load_balancer_details import DetachLoadBalancerDetails
from .device import Device
from .dhcp_dns_option import DhcpDnsOption
from .dhcp_option import DhcpOption
from .dhcp_options import DhcpOptions
from .dhcp_search_domain_option import DhcpSearchDomainOption
from .dpd_config import DpdConfig
from .drg import Drg
from .drg_attachment import DrgAttachment
from .drg_attachment_id_drg_route_distribution_match_criteria import DrgAttachmentIdDrgRouteDistributionMatchCriteria
from .drg_attachment_info import DrgAttachmentInfo
from .drg_attachment_match_all_drg_route_distribution_match_criteria import DrgAttachmentMatchAllDrgRouteDistributionMatchCriteria
from .drg_attachment_network_create_details import DrgAttachmentNetworkCreateDetails
from .drg_attachment_network_details import DrgAttachmentNetworkDetails
from .drg_attachment_network_update_details import DrgAttachmentNetworkUpdateDetails
from .drg_attachment_type_drg_route_distribution_match_criteria import DrgAttachmentTypeDrgRouteDistributionMatchCriteria
from .drg_redundancy_status import DrgRedundancyStatus
from .drg_route_distribution import DrgRouteDistribution
from .drg_route_distribution_match_criteria import DrgRouteDistributionMatchCriteria
from .drg_route_distribution_statement import DrgRouteDistributionStatement
from .drg_route_rule import DrgRouteRule
from .drg_route_table import DrgRouteTable
from .egress_security_rule import EgressSecurityRule
from .emulated_volume_attachment import EmulatedVolumeAttachment
from .encryption_domain_config import EncryptionDomainConfig
from .enum_integer_image_capability_descriptor import EnumIntegerImageCapabilityDescriptor
from .enum_string_image_capability_schema_descriptor import EnumStringImageCapabilitySchemaDescriptor
from .export_image_details import ExportImageDetails
from .export_image_via_object_storage_tuple_details import ExportImageViaObjectStorageTupleDetails
from .export_image_via_object_storage_uri_details import ExportImageViaObjectStorageUriDetails
from .fast_connect_provider_service import FastConnectProviderService
from .fast_connect_provider_service_key import FastConnectProviderServiceKey
from .get_public_ip_by_ip_address_details import GetPublicIpByIpAddressDetails
from .get_public_ip_by_private_ip_id_details import GetPublicIpByPrivateIpIdDetails
from .ip_sec_connection import IPSecConnection
from .ip_sec_connection_device_config import IPSecConnectionDeviceConfig
from .ip_sec_connection_device_status import IPSecConnectionDeviceStatus
from .ip_sec_connection_tunnel import IPSecConnectionTunnel
from .ip_sec_connection_tunnel_error_details import IPSecConnectionTunnelErrorDetails
from .ip_sec_connection_tunnel_shared_secret import IPSecConnectionTunnelSharedSecret
from .i_scsi_volume_attachment import IScsiVolumeAttachment
from .icmp_options import IcmpOptions
from .image import Image
from .image_capability_schema_descriptor import ImageCapabilitySchemaDescriptor
from .image_memory_constraints import ImageMemoryConstraints
from .image_ocpu_constraints import ImageOcpuConstraints
from .image_shape_compatibility_entry import ImageShapeCompatibilityEntry
from .image_shape_compatibility_summary import ImageShapeCompatibilitySummary
from .image_source_details import ImageSourceDetails
from .image_source_via_object_storage_tuple_details import ImageSourceViaObjectStorageTupleDetails
from .image_source_via_object_storage_uri_details import ImageSourceViaObjectStorageUriDetails
from .ingress_security_rule import IngressSecurityRule
from .instance import Instance
from .instance_agent_config import InstanceAgentConfig
from .instance_agent_features import InstanceAgentFeatures
from .instance_agent_plugin_config_details import InstanceAgentPluginConfigDetails
from .instance_availability_config import InstanceAvailabilityConfig
from .instance_configuration import InstanceConfiguration
from .instance_configuration_amd_milan_bm_launch_instance_platform_config import InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig
from .instance_configuration_amd_rome_bm_gpu_launch_instance_platform_config import InstanceConfigurationAmdRomeBmGpuLaunchInstancePlatformConfig
from .instance_configuration_amd_rome_bm_launch_instance_platform_config import InstanceConfigurationAmdRomeBmLaunchInstancePlatformConfig
from .instance_configuration_amd_vm_launch_instance_platform_config import InstanceConfigurationAmdVmLaunchInstancePlatformConfig
from .instance_configuration_attach_vnic_details import InstanceConfigurationAttachVnicDetails
from .instance_configuration_attach_volume_details import InstanceConfigurationAttachVolumeDetails
from .instance_configuration_availability_config import InstanceConfigurationAvailabilityConfig
from .instance_configuration_block_volume_details import InstanceConfigurationBlockVolumeDetails
from .instance_configuration_create_vnic_details import InstanceConfigurationCreateVnicDetails
from .instance_configuration_create_volume_details import InstanceConfigurationCreateVolumeDetails
from .instance_configuration_instance_details import InstanceConfigurationInstanceDetails
from .instance_configuration_instance_options import InstanceConfigurationInstanceOptions
from .instance_configuration_instance_source_details import InstanceConfigurationInstanceSourceDetails
from .instance_configuration_instance_source_via_boot_volume_details import InstanceConfigurationInstanceSourceViaBootVolumeDetails
from .instance_configuration_instance_source_via_image_details import InstanceConfigurationInstanceSourceViaImageDetails
from .instance_configuration_intel_icelake_bm_launch_instance_platform_config import InstanceConfigurationIntelIcelakeBmLaunchInstancePlatformConfig
from .instance_configuration_intel_skylake_bm_launch_instance_platform_config import InstanceConfigurationIntelSkylakeBmLaunchInstancePlatformConfig
from .instance_configuration_intel_vm_launch_instance_platform_config import InstanceConfigurationIntelVmLaunchInstancePlatformConfig
from .instance_configuration_iscsi_attach_volume_details import InstanceConfigurationIscsiAttachVolumeDetails
from .instance_configuration_launch_instance_agent_config_details import InstanceConfigurationLaunchInstanceAgentConfigDetails
from .instance_configuration_launch_instance_details import InstanceConfigurationLaunchInstanceDetails
from .instance_configuration_launch_instance_platform_config import InstanceConfigurationLaunchInstancePlatformConfig
from .instance_configuration_launch_instance_shape_config_details import InstanceConfigurationLaunchInstanceShapeConfigDetails
from .instance_configuration_launch_options import InstanceConfigurationLaunchOptions
from .instance_configuration_paravirtualized_attach_volume_details import InstanceConfigurationParavirtualizedAttachVolumeDetails
from .instance_configuration_summary import InstanceConfigurationSummary
from .instance_configuration_volume_source_details import InstanceConfigurationVolumeSourceDetails
from .instance_configuration_volume_source_from_volume_backup_details import InstanceConfigurationVolumeSourceFromVolumeBackupDetails
from .instance_configuration_volume_source_from_volume_details import InstanceConfigurationVolumeSourceFromVolumeDetails
from .instance_console_connection import InstanceConsoleConnection
from .instance_credentials import InstanceCredentials
from .instance_options import InstanceOptions
from .instance_pool import InstancePool
from .instance_pool_instance import InstancePoolInstance
from .instance_pool_instance_load_balancer_backend import InstancePoolInstanceLoadBalancerBackend
from .instance_pool_load_balancer_attachment import InstancePoolLoadBalancerAttachment
from .instance_pool_placement_configuration import InstancePoolPlacementConfiguration
from .instance_pool_placement_secondary_vnic_subnet import InstancePoolPlacementSecondaryVnicSubnet
from .instance_pool_summary import InstancePoolSummary
from .instance_power_action_details import InstancePowerActionDetails
from .instance_reservation_config import InstanceReservationConfig
from .instance_reservation_config_details import InstanceReservationConfigDetails
from .instance_reservation_shape_config_details import InstanceReservationShapeConfigDetails
from .instance_shape_config import InstanceShapeConfig
from .instance_source_details import InstanceSourceDetails
from .instance_source_via_boot_volume_details import InstanceSourceViaBootVolumeDetails
from .instance_source_via_image_details import InstanceSourceViaImageDetails
from .instance_summary import InstanceSummary
from .intel_icelake_bm_launch_instance_platform_config import IntelIcelakeBmLaunchInstancePlatformConfig
from .intel_icelake_bm_platform_config import IntelIcelakeBmPlatformConfig
from .intel_skylake_bm_launch_instance_platform_config import IntelSkylakeBmLaunchInstancePlatformConfig
from .intel_skylake_bm_platform_config import IntelSkylakeBmPlatformConfig
from .intel_vm_launch_instance_platform_config import IntelVmLaunchInstancePlatformConfig
from .intel_vm_platform_config import IntelVmPlatformConfig
from .internet_gateway import InternetGateway
from .ipsec_tunnel_drg_attachment_network_details import IpsecTunnelDrgAttachmentNetworkDetails
from .ipv6 import Ipv6
from .launch_instance_agent_config_details import LaunchInstanceAgentConfigDetails
from .launch_instance_availability_config_details import LaunchInstanceAvailabilityConfigDetails
from .launch_instance_details import LaunchInstanceDetails
from .launch_instance_platform_config import LaunchInstancePlatformConfig
from .launch_instance_shape_config_details import LaunchInstanceShapeConfigDetails
from .launch_options import LaunchOptions
from .letter_of_authority import LetterOfAuthority
from .local_peering_gateway import LocalPeeringGateway
from .macsec_key import MacsecKey
from .macsec_properties import MacsecProperties
from .measured_boot_entry import MeasuredBootEntry
from .measured_boot_report import MeasuredBootReport
from .measured_boot_report_measurements import MeasuredBootReportMeasurements
from .member_replica import MemberReplica
from .modify_vcn_cidr_details import ModifyVcnCidrDetails
from .multipath_device import MultipathDevice
from .nat_gateway import NatGateway
from .network_security_group import NetworkSecurityGroup
from .network_security_group_vnic import NetworkSecurityGroupVnic
from .networking_topology import NetworkingTopology
from .paravirtualized_volume_attachment import ParavirtualizedVolumeAttachment
from .peer_region_for_remote_peering import PeerRegionForRemotePeering
from .percentage_of_cores_enabled_options import PercentageOfCoresEnabledOptions
from .phase_one_config_details import PhaseOneConfigDetails
from .phase_two_config_details import PhaseTwoConfigDetails
from .platform_config import PlatformConfig
from .port_range import PortRange
from .preemptible_instance_config_details import PreemptibleInstanceConfigDetails
from .preemption_action import PreemptionAction
from .private_ip import PrivateIp
from .public_ip import PublicIp
from .public_ip_pool import PublicIpPool
from .public_ip_pool_collection import PublicIpPoolCollection
from .public_ip_pool_summary import PublicIpPoolSummary
from .remote_peering_connection import RemotePeeringConnection
from .remote_peering_connection_drg_attachment_network_details import RemotePeeringConnectionDrgAttachmentNetworkDetails
from .remove_drg_route_distribution_statements_details import RemoveDrgRouteDistributionStatementsDetails
from .remove_drg_route_rules_details import RemoveDrgRouteRulesDetails
from .remove_network_security_group_security_rules_details import RemoveNetworkSecurityGroupSecurityRulesDetails
from .remove_public_ip_pool_capacity_details import RemovePublicIpPoolCapacityDetails
from .remove_subnet_ipv6_cidr_details import RemoveSubnetIpv6CidrDetails
from .remove_vcn_cidr_details import RemoveVcnCidrDetails
from .remove_vcn_ipv6_cidr_details import RemoveVcnIpv6CidrDetails
from .reset_action_details import ResetActionDetails
from .route_rule import RouteRule
from .route_table import RouteTable
from .security_list import SecurityList
from .security_rule import SecurityRule
from .service import Service
from .service_gateway import ServiceGateway
from .service_id_request_details import ServiceIdRequestDetails
from .service_id_response_details import ServiceIdResponseDetails
from .shape import Shape
from .shape_access_control_service_enabled_platform_options import ShapeAccessControlServiceEnabledPlatformOptions
from .shape_alternative_object import ShapeAlternativeObject
from .shape_input_output_memory_management_unit_enabled_platform_options import ShapeInputOutputMemoryManagementUnitEnabledPlatformOptions
from .shape_max_vnic_attachment_options import ShapeMaxVnicAttachmentOptions
from .shape_measured_boot_options import ShapeMeasuredBootOptions
from .shape_memory_options import ShapeMemoryOptions
from .shape_networking_bandwidth_options import ShapeNetworkingBandwidthOptions
from .shape_numa_nodes_per_socket_platform_options import ShapeNumaNodesPerSocketPlatformOptions
from .shape_ocpu_options import ShapeOcpuOptions
from .shape_platform_config_options import ShapePlatformConfigOptions
from .shape_secure_boot_options import ShapeSecureBootOptions
from .shape_symmetric_multi_threading_enabled_platform_options import ShapeSymmetricMultiThreadingEnabledPlatformOptions
from .shape_trusted_platform_module_options import ShapeTrustedPlatformModuleOptions
from .shape_virtual_instructions_enabled_platform_options import ShapeVirtualInstructionsEnabledPlatformOptions
from .soft_reset_action_details import SoftResetActionDetails
from .subnet import Subnet
from .subnet_topology import SubnetTopology
from .tcp_options import TcpOptions
from .terminate_preemption_action import TerminatePreemptionAction
from .topology import Topology
from .topology_associated_with_entity_relationship import TopologyAssociatedWithEntityRelationship
from .topology_associated_with_relationship_details import TopologyAssociatedWithRelationshipDetails
from .topology_contains_entity_relationship import TopologyContainsEntityRelationship
from .topology_entity_relationship import TopologyEntityRelationship
from .topology_routes_to_entity_relationship import TopologyRoutesToEntityRelationship
from .topology_routes_to_relationship_details import TopologyRoutesToRelationshipDetails
from .tunnel_config import TunnelConfig
from .tunnel_cpe_device_config import TunnelCpeDeviceConfig
from .tunnel_phase_one_details import TunnelPhaseOneDetails
from .tunnel_phase_two_details import TunnelPhaseTwoDetails
from .tunnel_route_summary import TunnelRouteSummary
from .tunnel_security_association_summary import TunnelSecurityAssociationSummary
from .tunnel_status import TunnelStatus
from .udp_options import UdpOptions
from .update_boot_volume_backup_details import UpdateBootVolumeBackupDetails
from .update_boot_volume_details import UpdateBootVolumeDetails
from .update_boot_volume_kms_key_details import UpdateBootVolumeKmsKeyDetails
from .update_byoip_range_details import UpdateByoipRangeDetails
from .update_capture_filter_details import UpdateCaptureFilterDetails
from .update_cluster_network_details import UpdateClusterNetworkDetails
from .update_cluster_network_instance_pool_details import UpdateClusterNetworkInstancePoolDetails
from .update_compute_capacity_reservation_details import UpdateComputeCapacityReservationDetails
from .update_compute_image_capability_schema_details import UpdateComputeImageCapabilitySchemaDetails
from .update_console_history_details import UpdateConsoleHistoryDetails
from .update_cpe_details import UpdateCpeDetails
from .update_cross_connect_details import UpdateCrossConnectDetails
from .update_cross_connect_group_details import UpdateCrossConnectGroupDetails
from .update_dedicated_vm_host_details import UpdateDedicatedVmHostDetails
from .update_dhcp_details import UpdateDhcpDetails
from .update_drg_attachment_details import UpdateDrgAttachmentDetails
from .update_drg_details import UpdateDrgDetails
from .update_drg_route_distribution_details import UpdateDrgRouteDistributionDetails
from .update_drg_route_distribution_statement_details import UpdateDrgRouteDistributionStatementDetails
from .update_drg_route_distribution_statements_details import UpdateDrgRouteDistributionStatementsDetails
from .update_drg_route_rule_details import UpdateDrgRouteRuleDetails
from .update_drg_route_rules_details import UpdateDrgRouteRulesDetails
from .update_drg_route_table_details import UpdateDrgRouteTableDetails
from .update_ip_sec_connection_details import UpdateIPSecConnectionDetails
from .update_ip_sec_connection_tunnel_details import UpdateIPSecConnectionTunnelDetails
from .update_ip_sec_connection_tunnel_shared_secret_details import UpdateIPSecConnectionTunnelSharedSecretDetails
from .update_ip_sec_tunnel_bgp_session_details import UpdateIPSecTunnelBgpSessionDetails
from .update_ip_sec_tunnel_encryption_domain_details import UpdateIPSecTunnelEncryptionDomainDetails
from .update_image_details import UpdateImageDetails
from .update_instance_agent_config_details import UpdateInstanceAgentConfigDetails
from .update_instance_availability_config_details import UpdateInstanceAvailabilityConfigDetails
from .update_instance_configuration_details import UpdateInstanceConfigurationDetails
from .update_instance_console_connection_details import UpdateInstanceConsoleConnectionDetails
from .update_instance_details import UpdateInstanceDetails
from .update_instance_pool_details import UpdateInstancePoolDetails
from .update_instance_pool_placement_configuration_details import UpdateInstancePoolPlacementConfigurationDetails
from .update_instance_shape_config_details import UpdateInstanceShapeConfigDetails
from .update_internet_gateway_details import UpdateInternetGatewayDetails
from .update_ipv6_details import UpdateIpv6Details
from .update_launch_options import UpdateLaunchOptions
from .update_local_peering_gateway_details import UpdateLocalPeeringGatewayDetails
from .update_macsec_key import UpdateMacsecKey
from .update_macsec_properties import UpdateMacsecProperties
from .update_nat_gateway_details import UpdateNatGatewayDetails
from .update_network_security_group_details import UpdateNetworkSecurityGroupDetails
from .update_network_security_group_security_rules_details import UpdateNetworkSecurityGroupSecurityRulesDetails
from .update_private_ip_details import UpdatePrivateIpDetails
from .update_public_ip_details import UpdatePublicIpDetails
from .update_public_ip_pool_details import UpdatePublicIpPoolDetails
from .update_remote_peering_connection_details import UpdateRemotePeeringConnectionDetails
from .update_route_table_details import UpdateRouteTableDetails
from .update_security_list_details import UpdateSecurityListDetails
from .update_security_rule_details import UpdateSecurityRuleDetails
from .update_service_gateway_details import UpdateServiceGatewayDetails
from .update_subnet_details import UpdateSubnetDetails
from .update_tunnel_cpe_device_config_details import UpdateTunnelCpeDeviceConfigDetails
from .update_vcn_details import UpdateVcnDetails
from .update_virtual_circuit_details import UpdateVirtualCircuitDetails
from .update_vlan_details import UpdateVlanDetails
from .update_vnic_details import UpdateVnicDetails
from .update_volume_attachment_details import UpdateVolumeAttachmentDetails
from .update_volume_backup_details import UpdateVolumeBackupDetails
from .update_volume_backup_policy_details import UpdateVolumeBackupPolicyDetails
from .update_volume_details import UpdateVolumeDetails
from .update_volume_group_backup_details import UpdateVolumeGroupBackupDetails
from .update_volume_group_details import UpdateVolumeGroupDetails
from .update_volume_kms_key_details import UpdateVolumeKmsKeyDetails
from .update_vtap_details import UpdateVtapDetails
from .updated_network_security_group_security_rules import UpdatedNetworkSecurityGroupSecurityRules
from .upgrade_status import UpgradeStatus
from .vcn import Vcn
from .vcn_dns_resolver_association import VcnDnsResolverAssociation
from .vcn_drg_attachment_network_create_details import VcnDrgAttachmentNetworkCreateDetails
from .vcn_drg_attachment_network_details import VcnDrgAttachmentNetworkDetails
from .vcn_drg_attachment_network_update_details import VcnDrgAttachmentNetworkUpdateDetails
from .vcn_topology import VcnTopology
from .virtual_circuit import VirtualCircuit
from .virtual_circuit_bandwidth_shape import VirtualCircuitBandwidthShape
from .virtual_circuit_drg_attachment_network_details import VirtualCircuitDrgAttachmentNetworkDetails
from .virtual_circuit_public_prefix import VirtualCircuitPublicPrefix
from .vlan import Vlan
from .vnic import Vnic
from .vnic_attachment import VnicAttachment
from .volume import Volume
from .volume_attachment import VolumeAttachment
from .volume_backup import VolumeBackup
from .volume_backup_policy import VolumeBackupPolicy
from .volume_backup_policy_assignment import VolumeBackupPolicyAssignment
from .volume_backup_schedule import VolumeBackupSchedule
from .volume_group import VolumeGroup
from .volume_group_backup import VolumeGroupBackup
from .volume_group_replica import VolumeGroupReplica
from .volume_group_replica_details import VolumeGroupReplicaDetails
from .volume_group_replica_info import VolumeGroupReplicaInfo
from .volume_group_source_details import VolumeGroupSourceDetails
from .volume_group_source_from_volume_group_backup_details import VolumeGroupSourceFromVolumeGroupBackupDetails
from .volume_group_source_from_volume_group_details import VolumeGroupSourceFromVolumeGroupDetails
from .volume_group_source_from_volume_group_replica_details import VolumeGroupSourceFromVolumeGroupReplicaDetails
from .volume_group_source_from_volumes_details import VolumeGroupSourceFromVolumesDetails
from .volume_kms_key import VolumeKmsKey
from .volume_source_details import VolumeSourceDetails
from .volume_source_from_block_volume_replica_details import VolumeSourceFromBlockVolumeReplicaDetails
from .volume_source_from_volume_backup_details import VolumeSourceFromVolumeBackupDetails
from .volume_source_from_volume_details import VolumeSourceFromVolumeDetails
from .vtap import Vtap
from .vtap_capture_filter_rule_details import VtapCaptureFilterRuleDetails

# Maps type names to classes for core services.
core_type_mapping = {
    "AddDrgRouteDistributionStatementDetails": AddDrgRouteDistributionStatementDetails,
    "AddDrgRouteDistributionStatementsDetails": AddDrgRouteDistributionStatementsDetails,
    "AddDrgRouteRuleDetails": AddDrgRouteRuleDetails,
    "AddDrgRouteRulesDetails": AddDrgRouteRulesDetails,
    "AddImageShapeCompatibilityEntryDetails": AddImageShapeCompatibilityEntryDetails,
    "AddNetworkSecurityGroupSecurityRulesDetails": AddNetworkSecurityGroupSecurityRulesDetails,
    "AddPublicIpPoolCapacityDetails": AddPublicIpPoolCapacityDetails,
    "AddSecurityRuleDetails": AddSecurityRuleDetails,
    "AddSubnetIpv6CidrDetails": AddSubnetIpv6CidrDetails,
    "AddVcnCidrDetails": AddVcnCidrDetails,
    "AddVcnIpv6CidrDetails": AddVcnIpv6CidrDetails,
    "AddedNetworkSecurityGroupSecurityRules": AddedNetworkSecurityGroupSecurityRules,
    "AllowedIkeIPSecParameters": AllowedIkeIPSecParameters,
    "AllowedPhaseOneParameters": AllowedPhaseOneParameters,
    "AllowedPhaseTwoParameters": AllowedPhaseTwoParameters,
    "AmdMilanBmLaunchInstancePlatformConfig": AmdMilanBmLaunchInstancePlatformConfig,
    "AmdMilanBmPlatformConfig": AmdMilanBmPlatformConfig,
    "AmdRomeBmGpuLaunchInstancePlatformConfig": AmdRomeBmGpuLaunchInstancePlatformConfig,
    "AmdRomeBmGpuPlatformConfig": AmdRomeBmGpuPlatformConfig,
    "AmdRomeBmLaunchInstancePlatformConfig": AmdRomeBmLaunchInstancePlatformConfig,
    "AmdRomeBmPlatformConfig": AmdRomeBmPlatformConfig,
    "AmdVmLaunchInstancePlatformConfig": AmdVmLaunchInstancePlatformConfig,
    "AmdVmPlatformConfig": AmdVmPlatformConfig,
    "AppCatalogListing": AppCatalogListing,
    "AppCatalogListingResourceVersion": AppCatalogListingResourceVersion,
    "AppCatalogListingResourceVersionAgreements": AppCatalogListingResourceVersionAgreements,
    "AppCatalogListingResourceVersionSummary": AppCatalogListingResourceVersionSummary,
    "AppCatalogListingSummary": AppCatalogListingSummary,
    "AppCatalogSubscription": AppCatalogSubscription,
    "AppCatalogSubscriptionSummary": AppCatalogSubscriptionSummary,
    "AttachBootVolumeDetails": AttachBootVolumeDetails,
    "AttachEmulatedVolumeDetails": AttachEmulatedVolumeDetails,
    "AttachIScsiVolumeDetails": AttachIScsiVolumeDetails,
    "AttachInstancePoolInstanceDetails": AttachInstancePoolInstanceDetails,
    "AttachLoadBalancerDetails": AttachLoadBalancerDetails,
    "AttachParavirtualizedVolumeDetails": AttachParavirtualizedVolumeDetails,
    "AttachServiceDeterminedVolumeDetails": AttachServiceDeterminedVolumeDetails,
    "AttachVnicDetails": AttachVnicDetails,
    "AttachVolumeDetails": AttachVolumeDetails,
    "BgpSessionInfo": BgpSessionInfo,
    "BlockVolumeReplica": BlockVolumeReplica,
    "BlockVolumeReplicaDetails": BlockVolumeReplicaDetails,
    "BlockVolumeReplicaInfo": BlockVolumeReplicaInfo,
    "BooleanImageCapabilitySchemaDescriptor": BooleanImageCapabilitySchemaDescriptor,
    "BootVolume": BootVolume,
    "BootVolumeAttachment": BootVolumeAttachment,
    "BootVolumeBackup": BootVolumeBackup,
    "BootVolumeKmsKey": BootVolumeKmsKey,
    "BootVolumeReplica": BootVolumeReplica,
    "BootVolumeReplicaDetails": BootVolumeReplicaDetails,
    "BootVolumeReplicaInfo": BootVolumeReplicaInfo,
    "BootVolumeSourceDetails": BootVolumeSourceDetails,
    "BootVolumeSourceFromBootVolumeBackupDetails": BootVolumeSourceFromBootVolumeBackupDetails,
    "BootVolumeSourceFromBootVolumeDetails": BootVolumeSourceFromBootVolumeDetails,
    "BootVolumeSourceFromBootVolumeReplicaDetails": BootVolumeSourceFromBootVolumeReplicaDetails,
    "BulkAddVirtualCircuitPublicPrefixesDetails": BulkAddVirtualCircuitPublicPrefixesDetails,
    "BulkDeleteVirtualCircuitPublicPrefixesDetails": BulkDeleteVirtualCircuitPublicPrefixesDetails,
    "ByoipAllocatedRangeCollection": ByoipAllocatedRangeCollection,
    "ByoipAllocatedRangeSummary": ByoipAllocatedRangeSummary,
    "ByoipRange": ByoipRange,
    "ByoipRangeCollection": ByoipRangeCollection,
    "ByoipRangeSummary": ByoipRangeSummary,
    "ByoipRangeVcnIpv6AllocationSummary": ByoipRangeVcnIpv6AllocationSummary,
    "Byoipv6CidrDetails": Byoipv6CidrDetails,
    "CapacityReservationInstanceSummary": CapacityReservationInstanceSummary,
    "CaptureConsoleHistoryDetails": CaptureConsoleHistoryDetails,
    "CaptureFilter": CaptureFilter,
    "ChangeBootVolumeBackupCompartmentDetails": ChangeBootVolumeBackupCompartmentDetails,
    "ChangeBootVolumeCompartmentDetails": ChangeBootVolumeCompartmentDetails,
    "ChangeByoipRangeCompartmentDetails": ChangeByoipRangeCompartmentDetails,
    "ChangeCaptureFilterCompartmentDetails": ChangeCaptureFilterCompartmentDetails,
    "ChangeClusterNetworkCompartmentDetails": ChangeClusterNetworkCompartmentDetails,
    "ChangeComputeCapacityReservationCompartmentDetails": ChangeComputeCapacityReservationCompartmentDetails,
    "ChangeComputeImageCapabilitySchemaCompartmentDetails": ChangeComputeImageCapabilitySchemaCompartmentDetails,
    "ChangeCpeCompartmentDetails": ChangeCpeCompartmentDetails,
    "ChangeCrossConnectCompartmentDetails": ChangeCrossConnectCompartmentDetails,
    "ChangeCrossConnectGroupCompartmentDetails": ChangeCrossConnectGroupCompartmentDetails,
    "ChangeDedicatedVmHostCompartmentDetails": ChangeDedicatedVmHostCompartmentDetails,
    "ChangeDhcpOptionsCompartmentDetails": ChangeDhcpOptionsCompartmentDetails,
    "ChangeDrgCompartmentDetails": ChangeDrgCompartmentDetails,
    "ChangeIPSecConnectionCompartmentDetails": ChangeIPSecConnectionCompartmentDetails,
    "ChangeImageCompartmentDetails": ChangeImageCompartmentDetails,
    "ChangeInstanceCompartmentDetails": ChangeInstanceCompartmentDetails,
    "ChangeInstanceConfigurationCompartmentDetails": ChangeInstanceConfigurationCompartmentDetails,
    "ChangeInstancePoolCompartmentDetails": ChangeInstancePoolCompartmentDetails,
    "ChangeInternetGatewayCompartmentDetails": ChangeInternetGatewayCompartmentDetails,
    "ChangeLocalPeeringGatewayCompartmentDetails": ChangeLocalPeeringGatewayCompartmentDetails,
    "ChangeNatGatewayCompartmentDetails": ChangeNatGatewayCompartmentDetails,
    "ChangeNetworkSecurityGroupCompartmentDetails": ChangeNetworkSecurityGroupCompartmentDetails,
    "ChangePublicIpCompartmentDetails": ChangePublicIpCompartmentDetails,
    "ChangePublicIpPoolCompartmentDetails": ChangePublicIpPoolCompartmentDetails,
    "ChangeRemotePeeringConnectionCompartmentDetails": ChangeRemotePeeringConnectionCompartmentDetails,
    "ChangeRouteTableCompartmentDetails": ChangeRouteTableCompartmentDetails,
    "ChangeSecurityListCompartmentDetails": ChangeSecurityListCompartmentDetails,
    "ChangeServiceGatewayCompartmentDetails": ChangeServiceGatewayCompartmentDetails,
    "ChangeSubnetCompartmentDetails": ChangeSubnetCompartmentDetails,
    "ChangeVcnCompartmentDetails": ChangeVcnCompartmentDetails,
    "ChangeVirtualCircuitCompartmentDetails": ChangeVirtualCircuitCompartmentDetails,
    "ChangeVlanCompartmentDetails": ChangeVlanCompartmentDetails,
    "ChangeVolumeBackupCompartmentDetails": ChangeVolumeBackupCompartmentDetails,
    "ChangeVolumeCompartmentDetails": ChangeVolumeCompartmentDetails,
    "ChangeVolumeGroupBackupCompartmentDetails": ChangeVolumeGroupBackupCompartmentDetails,
    "ChangeVolumeGroupCompartmentDetails": ChangeVolumeGroupCompartmentDetails,
    "ChangeVtapCompartmentDetails": ChangeVtapCompartmentDetails,
    "ClusterNetwork": ClusterNetwork,
    "ClusterNetworkPlacementConfigurationDetails": ClusterNetworkPlacementConfigurationDetails,
    "ClusterNetworkSummary": ClusterNetworkSummary,
    "CompartmentInternal": CompartmentInternal,
    "ComputeCapacityReservation": ComputeCapacityReservation,
    "ComputeCapacityReservationInstanceShapeSummary": ComputeCapacityReservationInstanceShapeSummary,
    "ComputeCapacityReservationSummary": ComputeCapacityReservationSummary,
    "ComputeGlobalImageCapabilitySchema": ComputeGlobalImageCapabilitySchema,
    "ComputeGlobalImageCapabilitySchemaSummary": ComputeGlobalImageCapabilitySchemaSummary,
    "ComputeGlobalImageCapabilitySchemaVersion": ComputeGlobalImageCapabilitySchemaVersion,
    "ComputeGlobalImageCapabilitySchemaVersionSummary": ComputeGlobalImageCapabilitySchemaVersionSummary,
    "ComputeImageCapabilitySchema": ComputeImageCapabilitySchema,
    "ComputeImageCapabilitySchemaSummary": ComputeImageCapabilitySchemaSummary,
    "ComputeInstanceDetails": ComputeInstanceDetails,
    "ConnectLocalPeeringGatewaysDetails": ConnectLocalPeeringGatewaysDetails,
    "ConnectRemotePeeringConnectionsDetails": ConnectRemotePeeringConnectionsDetails,
    "ConsoleHistory": ConsoleHistory,
    "CopyBootVolumeBackupDetails": CopyBootVolumeBackupDetails,
    "CopyVolumeBackupDetails": CopyVolumeBackupDetails,
    "CopyVolumeGroupBackupDetails": CopyVolumeGroupBackupDetails,
    "Cpe": Cpe,
    "CpeDeviceConfigAnswer": CpeDeviceConfigAnswer,
    "CpeDeviceConfigQuestion": CpeDeviceConfigQuestion,
    "CpeDeviceInfo": CpeDeviceInfo,
    "CpeDeviceShapeDetail": CpeDeviceShapeDetail,
    "CpeDeviceShapeSummary": CpeDeviceShapeSummary,
    "CreateAppCatalogSubscriptionDetails": CreateAppCatalogSubscriptionDetails,
    "CreateBootVolumeBackupDetails": CreateBootVolumeBackupDetails,
    "CreateBootVolumeDetails": CreateBootVolumeDetails,
    "CreateByoipRangeDetails": CreateByoipRangeDetails,
    "CreateCaptureFilterDetails": CreateCaptureFilterDetails,
    "CreateClusterNetworkDetails": CreateClusterNetworkDetails,
    "CreateClusterNetworkInstancePoolDetails": CreateClusterNetworkInstancePoolDetails,
    "CreateComputeCapacityReservationDetails": CreateComputeCapacityReservationDetails,
    "CreateComputeImageCapabilitySchemaDetails": CreateComputeImageCapabilitySchemaDetails,
    "CreateCpeDetails": CreateCpeDetails,
    "CreateCrossConnectDetails": CreateCrossConnectDetails,
    "CreateCrossConnectGroupDetails": CreateCrossConnectGroupDetails,
    "CreateDedicatedVmHostDetails": CreateDedicatedVmHostDetails,
    "CreateDhcpDetails": CreateDhcpDetails,
    "CreateDrgAttachmentDetails": CreateDrgAttachmentDetails,
    "CreateDrgDetails": CreateDrgDetails,
    "CreateDrgRouteDistributionDetails": CreateDrgRouteDistributionDetails,
    "CreateDrgRouteTableDetails": CreateDrgRouteTableDetails,
    "CreateIPSecConnectionDetails": CreateIPSecConnectionDetails,
    "CreateIPSecConnectionTunnelDetails": CreateIPSecConnectionTunnelDetails,
    "CreateIPSecTunnelBgpSessionDetails": CreateIPSecTunnelBgpSessionDetails,
    "CreateIPSecTunnelEncryptionDomainDetails": CreateIPSecTunnelEncryptionDomainDetails,
    "CreateImageDetails": CreateImageDetails,
    "CreateInstanceConfigurationBase": CreateInstanceConfigurationBase,
    "CreateInstanceConfigurationDetails": CreateInstanceConfigurationDetails,
    "CreateInstanceConfigurationFromInstanceDetails": CreateInstanceConfigurationFromInstanceDetails,
    "CreateInstanceConsoleConnectionDetails": CreateInstanceConsoleConnectionDetails,
    "CreateInstancePoolDetails": CreateInstancePoolDetails,
    "CreateInstancePoolPlacementConfigurationDetails": CreateInstancePoolPlacementConfigurationDetails,
    "CreateInternetGatewayDetails": CreateInternetGatewayDetails,
    "CreateIpv6Details": CreateIpv6Details,
    "CreateLocalPeeringGatewayDetails": CreateLocalPeeringGatewayDetails,
    "CreateMacsecKey": CreateMacsecKey,
    "CreateMacsecProperties": CreateMacsecProperties,
    "CreateNatGatewayDetails": CreateNatGatewayDetails,
    "CreateNetworkSecurityGroupDetails": CreateNetworkSecurityGroupDetails,
    "CreatePrivateIpDetails": CreatePrivateIpDetails,
    "CreatePublicIpDetails": CreatePublicIpDetails,
    "CreatePublicIpPoolDetails": CreatePublicIpPoolDetails,
    "CreateRemotePeeringConnectionDetails": CreateRemotePeeringConnectionDetails,
    "CreateRouteTableDetails": CreateRouteTableDetails,
    "CreateSecurityListDetails": CreateSecurityListDetails,
    "CreateServiceGatewayDetails": CreateServiceGatewayDetails,
    "CreateSubnetDetails": CreateSubnetDetails,
    "CreateVcnDetails": CreateVcnDetails,
    "CreateVirtualCircuitDetails": CreateVirtualCircuitDetails,
    "CreateVirtualCircuitPublicPrefixDetails": CreateVirtualCircuitPublicPrefixDetails,
    "CreateVlanDetails": CreateVlanDetails,
    "CreateVnicDetails": CreateVnicDetails,
    "CreateVolumeBackupDetails": CreateVolumeBackupDetails,
    "CreateVolumeBackupPolicyAssignmentDetails": CreateVolumeBackupPolicyAssignmentDetails,
    "CreateVolumeBackupPolicyDetails": CreateVolumeBackupPolicyDetails,
    "CreateVolumeDetails": CreateVolumeDetails,
    "CreateVolumeGroupBackupDetails": CreateVolumeGroupBackupDetails,
    "CreateVolumeGroupDetails": CreateVolumeGroupDetails,
    "CreateVtapDetails": CreateVtapDetails,
    "CrossConnect": CrossConnect,
    "CrossConnectGroup": CrossConnectGroup,
    "CrossConnectLocation": CrossConnectLocation,
    "CrossConnectMapping": CrossConnectMapping,
    "CrossConnectMappingDetails": CrossConnectMappingDetails,
    "CrossConnectMappingDetailsCollection": CrossConnectMappingDetailsCollection,
    "CrossConnectPortSpeedShape": CrossConnectPortSpeedShape,
    "CrossConnectStatus": CrossConnectStatus,
    "DedicatedVmHost": DedicatedVmHost,
    "DedicatedVmHostInstanceShapeSummary": DedicatedVmHostInstanceShapeSummary,
    "DedicatedVmHostInstanceSummary": DedicatedVmHostInstanceSummary,
    "DedicatedVmHostShapeSummary": DedicatedVmHostShapeSummary,
    "DedicatedVmHostSummary": DedicatedVmHostSummary,
    "DefaultDrgRouteTables": DefaultDrgRouteTables,
    "DefaultPhaseOneParameters": DefaultPhaseOneParameters,
    "DefaultPhaseTwoParameters": DefaultPhaseTwoParameters,
    "DeleteVirtualCircuitPublicPrefixDetails": DeleteVirtualCircuitPublicPrefixDetails,
    "DetachInstancePoolInstanceDetails": DetachInstancePoolInstanceDetails,
    "DetachLoadBalancerDetails": DetachLoadBalancerDetails,
    "Device": Device,
    "DhcpDnsOption": DhcpDnsOption,
    "DhcpOption": DhcpOption,
    "DhcpOptions": DhcpOptions,
    "DhcpSearchDomainOption": DhcpSearchDomainOption,
    "DpdConfig": DpdConfig,
    "Drg": Drg,
    "DrgAttachment": DrgAttachment,
    "DrgAttachmentIdDrgRouteDistributionMatchCriteria": DrgAttachmentIdDrgRouteDistributionMatchCriteria,
    "DrgAttachmentInfo": DrgAttachmentInfo,
    "DrgAttachmentMatchAllDrgRouteDistributionMatchCriteria": DrgAttachmentMatchAllDrgRouteDistributionMatchCriteria,
    "DrgAttachmentNetworkCreateDetails": DrgAttachmentNetworkCreateDetails,
    "DrgAttachmentNetworkDetails": DrgAttachmentNetworkDetails,
    "DrgAttachmentNetworkUpdateDetails": DrgAttachmentNetworkUpdateDetails,
    "DrgAttachmentTypeDrgRouteDistributionMatchCriteria": DrgAttachmentTypeDrgRouteDistributionMatchCriteria,
    "DrgRedundancyStatus": DrgRedundancyStatus,
    "DrgRouteDistribution": DrgRouteDistribution,
    "DrgRouteDistributionMatchCriteria": DrgRouteDistributionMatchCriteria,
    "DrgRouteDistributionStatement": DrgRouteDistributionStatement,
    "DrgRouteRule": DrgRouteRule,
    "DrgRouteTable": DrgRouteTable,
    "EgressSecurityRule": EgressSecurityRule,
    "EmulatedVolumeAttachment": EmulatedVolumeAttachment,
    "EncryptionDomainConfig": EncryptionDomainConfig,
    "EnumIntegerImageCapabilityDescriptor": EnumIntegerImageCapabilityDescriptor,
    "EnumStringImageCapabilitySchemaDescriptor": EnumStringImageCapabilitySchemaDescriptor,
    "ExportImageDetails": ExportImageDetails,
    "ExportImageViaObjectStorageTupleDetails": ExportImageViaObjectStorageTupleDetails,
    "ExportImageViaObjectStorageUriDetails": ExportImageViaObjectStorageUriDetails,
    "FastConnectProviderService": FastConnectProviderService,
    "FastConnectProviderServiceKey": FastConnectProviderServiceKey,
    "GetPublicIpByIpAddressDetails": GetPublicIpByIpAddressDetails,
    "GetPublicIpByPrivateIpIdDetails": GetPublicIpByPrivateIpIdDetails,
    "IPSecConnection": IPSecConnection,
    "IPSecConnectionDeviceConfig": IPSecConnectionDeviceConfig,
    "IPSecConnectionDeviceStatus": IPSecConnectionDeviceStatus,
    "IPSecConnectionTunnel": IPSecConnectionTunnel,
    "IPSecConnectionTunnelErrorDetails": IPSecConnectionTunnelErrorDetails,
    "IPSecConnectionTunnelSharedSecret": IPSecConnectionTunnelSharedSecret,
    "IScsiVolumeAttachment": IScsiVolumeAttachment,
    "IcmpOptions": IcmpOptions,
    "Image": Image,
    "ImageCapabilitySchemaDescriptor": ImageCapabilitySchemaDescriptor,
    "ImageMemoryConstraints": ImageMemoryConstraints,
    "ImageOcpuConstraints": ImageOcpuConstraints,
    "ImageShapeCompatibilityEntry": ImageShapeCompatibilityEntry,
    "ImageShapeCompatibilitySummary": ImageShapeCompatibilitySummary,
    "ImageSourceDetails": ImageSourceDetails,
    "ImageSourceViaObjectStorageTupleDetails": ImageSourceViaObjectStorageTupleDetails,
    "ImageSourceViaObjectStorageUriDetails": ImageSourceViaObjectStorageUriDetails,
    "IngressSecurityRule": IngressSecurityRule,
    "Instance": Instance,
    "InstanceAgentConfig": InstanceAgentConfig,
    "InstanceAgentFeatures": InstanceAgentFeatures,
    "InstanceAgentPluginConfigDetails": InstanceAgentPluginConfigDetails,
    "InstanceAvailabilityConfig": InstanceAvailabilityConfig,
    "InstanceConfiguration": InstanceConfiguration,
    "InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig": InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig,
    "InstanceConfigurationAmdRomeBmGpuLaunchInstancePlatformConfig": InstanceConfigurationAmdRomeBmGpuLaunchInstancePlatformConfig,
    "InstanceConfigurationAmdRomeBmLaunchInstancePlatformConfig": InstanceConfigurationAmdRomeBmLaunchInstancePlatformConfig,
    "InstanceConfigurationAmdVmLaunchInstancePlatformConfig": InstanceConfigurationAmdVmLaunchInstancePlatformConfig,
    "InstanceConfigurationAttachVnicDetails": InstanceConfigurationAttachVnicDetails,
    "InstanceConfigurationAttachVolumeDetails": InstanceConfigurationAttachVolumeDetails,
    "InstanceConfigurationAvailabilityConfig": InstanceConfigurationAvailabilityConfig,
    "InstanceConfigurationBlockVolumeDetails": InstanceConfigurationBlockVolumeDetails,
    "InstanceConfigurationCreateVnicDetails": InstanceConfigurationCreateVnicDetails,
    "InstanceConfigurationCreateVolumeDetails": InstanceConfigurationCreateVolumeDetails,
    "InstanceConfigurationInstanceDetails": InstanceConfigurationInstanceDetails,
    "InstanceConfigurationInstanceOptions": InstanceConfigurationInstanceOptions,
    "InstanceConfigurationInstanceSourceDetails": InstanceConfigurationInstanceSourceDetails,
    "InstanceConfigurationInstanceSourceViaBootVolumeDetails": InstanceConfigurationInstanceSourceViaBootVolumeDetails,
    "InstanceConfigurationInstanceSourceViaImageDetails": InstanceConfigurationInstanceSourceViaImageDetails,
    "InstanceConfigurationIntelIcelakeBmLaunchInstancePlatformConfig": InstanceConfigurationIntelIcelakeBmLaunchInstancePlatformConfig,
    "InstanceConfigurationIntelSkylakeBmLaunchInstancePlatformConfig": InstanceConfigurationIntelSkylakeBmLaunchInstancePlatformConfig,
    "InstanceConfigurationIntelVmLaunchInstancePlatformConfig": InstanceConfigurationIntelVmLaunchInstancePlatformConfig,
    "InstanceConfigurationIscsiAttachVolumeDetails": InstanceConfigurationIscsiAttachVolumeDetails,
    "InstanceConfigurationLaunchInstanceAgentConfigDetails": InstanceConfigurationLaunchInstanceAgentConfigDetails,
    "InstanceConfigurationLaunchInstanceDetails": InstanceConfigurationLaunchInstanceDetails,
    "InstanceConfigurationLaunchInstancePlatformConfig": InstanceConfigurationLaunchInstancePlatformConfig,
    "InstanceConfigurationLaunchInstanceShapeConfigDetails": InstanceConfigurationLaunchInstanceShapeConfigDetails,
    "InstanceConfigurationLaunchOptions": InstanceConfigurationLaunchOptions,
    "InstanceConfigurationParavirtualizedAttachVolumeDetails": InstanceConfigurationParavirtualizedAttachVolumeDetails,
    "InstanceConfigurationSummary": InstanceConfigurationSummary,
    "InstanceConfigurationVolumeSourceDetails": InstanceConfigurationVolumeSourceDetails,
    "InstanceConfigurationVolumeSourceFromVolumeBackupDetails": InstanceConfigurationVolumeSourceFromVolumeBackupDetails,
    "InstanceConfigurationVolumeSourceFromVolumeDetails": InstanceConfigurationVolumeSourceFromVolumeDetails,
    "InstanceConsoleConnection": InstanceConsoleConnection,
    "InstanceCredentials": InstanceCredentials,
    "InstanceOptions": InstanceOptions,
    "InstancePool": InstancePool,
    "InstancePoolInstance": InstancePoolInstance,
    "InstancePoolInstanceLoadBalancerBackend": InstancePoolInstanceLoadBalancerBackend,
    "InstancePoolLoadBalancerAttachment": InstancePoolLoadBalancerAttachment,
    "InstancePoolPlacementConfiguration": InstancePoolPlacementConfiguration,
    "InstancePoolPlacementSecondaryVnicSubnet": InstancePoolPlacementSecondaryVnicSubnet,
    "InstancePoolSummary": InstancePoolSummary,
    "InstancePowerActionDetails": InstancePowerActionDetails,
    "InstanceReservationConfig": InstanceReservationConfig,
    "InstanceReservationConfigDetails": InstanceReservationConfigDetails,
    "InstanceReservationShapeConfigDetails": InstanceReservationShapeConfigDetails,
    "InstanceShapeConfig": InstanceShapeConfig,
    "InstanceSourceDetails": InstanceSourceDetails,
    "InstanceSourceViaBootVolumeDetails": InstanceSourceViaBootVolumeDetails,
    "InstanceSourceViaImageDetails": InstanceSourceViaImageDetails,
    "InstanceSummary": InstanceSummary,
    "IntelIcelakeBmLaunchInstancePlatformConfig": IntelIcelakeBmLaunchInstancePlatformConfig,
    "IntelIcelakeBmPlatformConfig": IntelIcelakeBmPlatformConfig,
    "IntelSkylakeBmLaunchInstancePlatformConfig": IntelSkylakeBmLaunchInstancePlatformConfig,
    "IntelSkylakeBmPlatformConfig": IntelSkylakeBmPlatformConfig,
    "IntelVmLaunchInstancePlatformConfig": IntelVmLaunchInstancePlatformConfig,
    "IntelVmPlatformConfig": IntelVmPlatformConfig,
    "InternetGateway": InternetGateway,
    "IpsecTunnelDrgAttachmentNetworkDetails": IpsecTunnelDrgAttachmentNetworkDetails,
    "Ipv6": Ipv6,
    "LaunchInstanceAgentConfigDetails": LaunchInstanceAgentConfigDetails,
    "LaunchInstanceAvailabilityConfigDetails": LaunchInstanceAvailabilityConfigDetails,
    "LaunchInstanceDetails": LaunchInstanceDetails,
    "LaunchInstancePlatformConfig": LaunchInstancePlatformConfig,
    "LaunchInstanceShapeConfigDetails": LaunchInstanceShapeConfigDetails,
    "LaunchOptions": LaunchOptions,
    "LetterOfAuthority": LetterOfAuthority,
    "LocalPeeringGateway": LocalPeeringGateway,
    "MacsecKey": MacsecKey,
    "MacsecProperties": MacsecProperties,
    "MeasuredBootEntry": MeasuredBootEntry,
    "MeasuredBootReport": MeasuredBootReport,
    "MeasuredBootReportMeasurements": MeasuredBootReportMeasurements,
    "MemberReplica": MemberReplica,
    "ModifyVcnCidrDetails": ModifyVcnCidrDetails,
    "MultipathDevice": MultipathDevice,
    "NatGateway": NatGateway,
    "NetworkSecurityGroup": NetworkSecurityGroup,
    "NetworkSecurityGroupVnic": NetworkSecurityGroupVnic,
    "NetworkingTopology": NetworkingTopology,
    "ParavirtualizedVolumeAttachment": ParavirtualizedVolumeAttachment,
    "PeerRegionForRemotePeering": PeerRegionForRemotePeering,
    "PercentageOfCoresEnabledOptions": PercentageOfCoresEnabledOptions,
    "PhaseOneConfigDetails": PhaseOneConfigDetails,
    "PhaseTwoConfigDetails": PhaseTwoConfigDetails,
    "PlatformConfig": PlatformConfig,
    "PortRange": PortRange,
    "PreemptibleInstanceConfigDetails": PreemptibleInstanceConfigDetails,
    "PreemptionAction": PreemptionAction,
    "PrivateIp": PrivateIp,
    "PublicIp": PublicIp,
    "PublicIpPool": PublicIpPool,
    "PublicIpPoolCollection": PublicIpPoolCollection,
    "PublicIpPoolSummary": PublicIpPoolSummary,
    "RemotePeeringConnection": RemotePeeringConnection,
    "RemotePeeringConnectionDrgAttachmentNetworkDetails": RemotePeeringConnectionDrgAttachmentNetworkDetails,
    "RemoveDrgRouteDistributionStatementsDetails": RemoveDrgRouteDistributionStatementsDetails,
    "RemoveDrgRouteRulesDetails": RemoveDrgRouteRulesDetails,
    "RemoveNetworkSecurityGroupSecurityRulesDetails": RemoveNetworkSecurityGroupSecurityRulesDetails,
    "RemovePublicIpPoolCapacityDetails": RemovePublicIpPoolCapacityDetails,
    "RemoveSubnetIpv6CidrDetails": RemoveSubnetIpv6CidrDetails,
    "RemoveVcnCidrDetails": RemoveVcnCidrDetails,
    "RemoveVcnIpv6CidrDetails": RemoveVcnIpv6CidrDetails,
    "ResetActionDetails": ResetActionDetails,
    "RouteRule": RouteRule,
    "RouteTable": RouteTable,
    "SecurityList": SecurityList,
    "SecurityRule": SecurityRule,
    "Service": Service,
    "ServiceGateway": ServiceGateway,
    "ServiceIdRequestDetails": ServiceIdRequestDetails,
    "ServiceIdResponseDetails": ServiceIdResponseDetails,
    "Shape": Shape,
    "ShapeAccessControlServiceEnabledPlatformOptions": ShapeAccessControlServiceEnabledPlatformOptions,
    "ShapeAlternativeObject": ShapeAlternativeObject,
    "ShapeInputOutputMemoryManagementUnitEnabledPlatformOptions": ShapeInputOutputMemoryManagementUnitEnabledPlatformOptions,
    "ShapeMaxVnicAttachmentOptions": ShapeMaxVnicAttachmentOptions,
    "ShapeMeasuredBootOptions": ShapeMeasuredBootOptions,
    "ShapeMemoryOptions": ShapeMemoryOptions,
    "ShapeNetworkingBandwidthOptions": ShapeNetworkingBandwidthOptions,
    "ShapeNumaNodesPerSocketPlatformOptions": ShapeNumaNodesPerSocketPlatformOptions,
    "ShapeOcpuOptions": ShapeOcpuOptions,
    "ShapePlatformConfigOptions": ShapePlatformConfigOptions,
    "ShapeSecureBootOptions": ShapeSecureBootOptions,
    "ShapeSymmetricMultiThreadingEnabledPlatformOptions": ShapeSymmetricMultiThreadingEnabledPlatformOptions,
    "ShapeTrustedPlatformModuleOptions": ShapeTrustedPlatformModuleOptions,
    "ShapeVirtualInstructionsEnabledPlatformOptions": ShapeVirtualInstructionsEnabledPlatformOptions,
    "SoftResetActionDetails": SoftResetActionDetails,
    "Subnet": Subnet,
    "SubnetTopology": SubnetTopology,
    "TcpOptions": TcpOptions,
    "TerminatePreemptionAction": TerminatePreemptionAction,
    "Topology": Topology,
    "TopologyAssociatedWithEntityRelationship": TopologyAssociatedWithEntityRelationship,
    "TopologyAssociatedWithRelationshipDetails": TopologyAssociatedWithRelationshipDetails,
    "TopologyContainsEntityRelationship": TopologyContainsEntityRelationship,
    "TopologyEntityRelationship": TopologyEntityRelationship,
    "TopologyRoutesToEntityRelationship": TopologyRoutesToEntityRelationship,
    "TopologyRoutesToRelationshipDetails": TopologyRoutesToRelationshipDetails,
    "TunnelConfig": TunnelConfig,
    "TunnelCpeDeviceConfig": TunnelCpeDeviceConfig,
    "TunnelPhaseOneDetails": TunnelPhaseOneDetails,
    "TunnelPhaseTwoDetails": TunnelPhaseTwoDetails,
    "TunnelRouteSummary": TunnelRouteSummary,
    "TunnelSecurityAssociationSummary": TunnelSecurityAssociationSummary,
    "TunnelStatus": TunnelStatus,
    "UdpOptions": UdpOptions,
    "UpdateBootVolumeBackupDetails": UpdateBootVolumeBackupDetails,
    "UpdateBootVolumeDetails": UpdateBootVolumeDetails,
    "UpdateBootVolumeKmsKeyDetails": UpdateBootVolumeKmsKeyDetails,
    "UpdateByoipRangeDetails": UpdateByoipRangeDetails,
    "UpdateCaptureFilterDetails": UpdateCaptureFilterDetails,
    "UpdateClusterNetworkDetails": UpdateClusterNetworkDetails,
    "UpdateClusterNetworkInstancePoolDetails": UpdateClusterNetworkInstancePoolDetails,
    "UpdateComputeCapacityReservationDetails": UpdateComputeCapacityReservationDetails,
    "UpdateComputeImageCapabilitySchemaDetails": UpdateComputeImageCapabilitySchemaDetails,
    "UpdateConsoleHistoryDetails": UpdateConsoleHistoryDetails,
    "UpdateCpeDetails": UpdateCpeDetails,
    "UpdateCrossConnectDetails": UpdateCrossConnectDetails,
    "UpdateCrossConnectGroupDetails": UpdateCrossConnectGroupDetails,
    "UpdateDedicatedVmHostDetails": UpdateDedicatedVmHostDetails,
    "UpdateDhcpDetails": UpdateDhcpDetails,
    "UpdateDrgAttachmentDetails": UpdateDrgAttachmentDetails,
    "UpdateDrgDetails": UpdateDrgDetails,
    "UpdateDrgRouteDistributionDetails": UpdateDrgRouteDistributionDetails,
    "UpdateDrgRouteDistributionStatementDetails": UpdateDrgRouteDistributionStatementDetails,
    "UpdateDrgRouteDistributionStatementsDetails": UpdateDrgRouteDistributionStatementsDetails,
    "UpdateDrgRouteRuleDetails": UpdateDrgRouteRuleDetails,
    "UpdateDrgRouteRulesDetails": UpdateDrgRouteRulesDetails,
    "UpdateDrgRouteTableDetails": UpdateDrgRouteTableDetails,
    "UpdateIPSecConnectionDetails": UpdateIPSecConnectionDetails,
    "UpdateIPSecConnectionTunnelDetails": UpdateIPSecConnectionTunnelDetails,
    "UpdateIPSecConnectionTunnelSharedSecretDetails": UpdateIPSecConnectionTunnelSharedSecretDetails,
    "UpdateIPSecTunnelBgpSessionDetails": UpdateIPSecTunnelBgpSessionDetails,
    "UpdateIPSecTunnelEncryptionDomainDetails": UpdateIPSecTunnelEncryptionDomainDetails,
    "UpdateImageDetails": UpdateImageDetails,
    "UpdateInstanceAgentConfigDetails": UpdateInstanceAgentConfigDetails,
    "UpdateInstanceAvailabilityConfigDetails": UpdateInstanceAvailabilityConfigDetails,
    "UpdateInstanceConfigurationDetails": UpdateInstanceConfigurationDetails,
    "UpdateInstanceConsoleConnectionDetails": UpdateInstanceConsoleConnectionDetails,
    "UpdateInstanceDetails": UpdateInstanceDetails,
    "UpdateInstancePoolDetails": UpdateInstancePoolDetails,
    "UpdateInstancePoolPlacementConfigurationDetails": UpdateInstancePoolPlacementConfigurationDetails,
    "UpdateInstanceShapeConfigDetails": UpdateInstanceShapeConfigDetails,
    "UpdateInternetGatewayDetails": UpdateInternetGatewayDetails,
    "UpdateIpv6Details": UpdateIpv6Details,
    "UpdateLaunchOptions": UpdateLaunchOptions,
    "UpdateLocalPeeringGatewayDetails": UpdateLocalPeeringGatewayDetails,
    "UpdateMacsecKey": UpdateMacsecKey,
    "UpdateMacsecProperties": UpdateMacsecProperties,
    "UpdateNatGatewayDetails": UpdateNatGatewayDetails,
    "UpdateNetworkSecurityGroupDetails": UpdateNetworkSecurityGroupDetails,
    "UpdateNetworkSecurityGroupSecurityRulesDetails": UpdateNetworkSecurityGroupSecurityRulesDetails,
    "UpdatePrivateIpDetails": UpdatePrivateIpDetails,
    "UpdatePublicIpDetails": UpdatePublicIpDetails,
    "UpdatePublicIpPoolDetails": UpdatePublicIpPoolDetails,
    "UpdateRemotePeeringConnectionDetails": UpdateRemotePeeringConnectionDetails,
    "UpdateRouteTableDetails": UpdateRouteTableDetails,
    "UpdateSecurityListDetails": UpdateSecurityListDetails,
    "UpdateSecurityRuleDetails": UpdateSecurityRuleDetails,
    "UpdateServiceGatewayDetails": UpdateServiceGatewayDetails,
    "UpdateSubnetDetails": UpdateSubnetDetails,
    "UpdateTunnelCpeDeviceConfigDetails": UpdateTunnelCpeDeviceConfigDetails,
    "UpdateVcnDetails": UpdateVcnDetails,
    "UpdateVirtualCircuitDetails": UpdateVirtualCircuitDetails,
    "UpdateVlanDetails": UpdateVlanDetails,
    "UpdateVnicDetails": UpdateVnicDetails,
    "UpdateVolumeAttachmentDetails": UpdateVolumeAttachmentDetails,
    "UpdateVolumeBackupDetails": UpdateVolumeBackupDetails,
    "UpdateVolumeBackupPolicyDetails": UpdateVolumeBackupPolicyDetails,
    "UpdateVolumeDetails": UpdateVolumeDetails,
    "UpdateVolumeGroupBackupDetails": UpdateVolumeGroupBackupDetails,
    "UpdateVolumeGroupDetails": UpdateVolumeGroupDetails,
    "UpdateVolumeKmsKeyDetails": UpdateVolumeKmsKeyDetails,
    "UpdateVtapDetails": UpdateVtapDetails,
    "UpdatedNetworkSecurityGroupSecurityRules": UpdatedNetworkSecurityGroupSecurityRules,
    "UpgradeStatus": UpgradeStatus,
    "Vcn": Vcn,
    "VcnDnsResolverAssociation": VcnDnsResolverAssociation,
    "VcnDrgAttachmentNetworkCreateDetails": VcnDrgAttachmentNetworkCreateDetails,
    "VcnDrgAttachmentNetworkDetails": VcnDrgAttachmentNetworkDetails,
    "VcnDrgAttachmentNetworkUpdateDetails": VcnDrgAttachmentNetworkUpdateDetails,
    "VcnTopology": VcnTopology,
    "VirtualCircuit": VirtualCircuit,
    "VirtualCircuitBandwidthShape": VirtualCircuitBandwidthShape,
    "VirtualCircuitDrgAttachmentNetworkDetails": VirtualCircuitDrgAttachmentNetworkDetails,
    "VirtualCircuitPublicPrefix": VirtualCircuitPublicPrefix,
    "Vlan": Vlan,
    "Vnic": Vnic,
    "VnicAttachment": VnicAttachment,
    "Volume": Volume,
    "VolumeAttachment": VolumeAttachment,
    "VolumeBackup": VolumeBackup,
    "VolumeBackupPolicy": VolumeBackupPolicy,
    "VolumeBackupPolicyAssignment": VolumeBackupPolicyAssignment,
    "VolumeBackupSchedule": VolumeBackupSchedule,
    "VolumeGroup": VolumeGroup,
    "VolumeGroupBackup": VolumeGroupBackup,
    "VolumeGroupReplica": VolumeGroupReplica,
    "VolumeGroupReplicaDetails": VolumeGroupReplicaDetails,
    "VolumeGroupReplicaInfo": VolumeGroupReplicaInfo,
    "VolumeGroupSourceDetails": VolumeGroupSourceDetails,
    "VolumeGroupSourceFromVolumeGroupBackupDetails": VolumeGroupSourceFromVolumeGroupBackupDetails,
    "VolumeGroupSourceFromVolumeGroupDetails": VolumeGroupSourceFromVolumeGroupDetails,
    "VolumeGroupSourceFromVolumeGroupReplicaDetails": VolumeGroupSourceFromVolumeGroupReplicaDetails,
    "VolumeGroupSourceFromVolumesDetails": VolumeGroupSourceFromVolumesDetails,
    "VolumeKmsKey": VolumeKmsKey,
    "VolumeSourceDetails": VolumeSourceDetails,
    "VolumeSourceFromBlockVolumeReplicaDetails": VolumeSourceFromBlockVolumeReplicaDetails,
    "VolumeSourceFromVolumeBackupDetails": VolumeSourceFromVolumeBackupDetails,
    "VolumeSourceFromVolumeDetails": VolumeSourceFromVolumeDetails,
    "Vtap": Vtap,
    "VtapCaptureFilterRuleDetails": VtapCaptureFilterRuleDetails
}
