# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicationScanSettings(object):
    """
    Agent scan settings for applicaiton scan
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicationScanSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param application_scan_recurrence:
            The value to assign to the application_scan_recurrence property of this ApplicationScanSettings.
        :type application_scan_recurrence: str

        :param is_enabled:
            The value to assign to the is_enabled property of this ApplicationScanSettings.
        :type is_enabled: bool

        :param folders_to_scan:
            The value to assign to the folders_to_scan property of this ApplicationScanSettings.
        :type folders_to_scan: list[oci.vulnerability_scanning.models.FolderToScan]

        """
        self.swagger_types = {
            'application_scan_recurrence': 'str',
            'is_enabled': 'bool',
            'folders_to_scan': 'list[FolderToScan]'
        }

        self.attribute_map = {
            'application_scan_recurrence': 'applicationScanRecurrence',
            'is_enabled': 'isEnabled',
            'folders_to_scan': 'foldersToScan'
        }

        self._application_scan_recurrence = None
        self._is_enabled = None
        self._folders_to_scan = None

    @property
    def application_scan_recurrence(self):
        """
        **[Required]** Gets the application_scan_recurrence of this ApplicationScanSettings.
        Scan recurrences in RFC-5545 section 3.3.10 format.
        Only supported input are weekly, biweekly, monthly listed below
        FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan on the specified weekday (e.g. Sunday)
        FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This bi-weekly scan on the specified weekday (e.g. Sunday)
        FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This monthly scan on the specified weekday (e.g. Sunday, starting from the next such weekday based on the time of setting creation)


        :return: The application_scan_recurrence of this ApplicationScanSettings.
        :rtype: str
        """
        return self._application_scan_recurrence

    @application_scan_recurrence.setter
    def application_scan_recurrence(self, application_scan_recurrence):
        """
        Sets the application_scan_recurrence of this ApplicationScanSettings.
        Scan recurrences in RFC-5545 section 3.3.10 format.
        Only supported input are weekly, biweekly, monthly listed below
        FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan on the specified weekday (e.g. Sunday)
        FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This bi-weekly scan on the specified weekday (e.g. Sunday)
        FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This monthly scan on the specified weekday (e.g. Sunday, starting from the next such weekday based on the time of setting creation)


        :param application_scan_recurrence: The application_scan_recurrence of this ApplicationScanSettings.
        :type: str
        """
        self._application_scan_recurrence = application_scan_recurrence

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this ApplicationScanSettings.
        Enable or disable application scan


        :return: The is_enabled of this ApplicationScanSettings.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this ApplicationScanSettings.
        Enable or disable application scan


        :param is_enabled: The is_enabled of this ApplicationScanSettings.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def folders_to_scan(self):
        """
        **[Required]** Gets the folders_to_scan of this ApplicationScanSettings.
        List of folders selected for scanning


        :return: The folders_to_scan of this ApplicationScanSettings.
        :rtype: list[oci.vulnerability_scanning.models.FolderToScan]
        """
        return self._folders_to_scan

    @folders_to_scan.setter
    def folders_to_scan(self, folders_to_scan):
        """
        Sets the folders_to_scan of this ApplicationScanSettings.
        List of folders selected for scanning


        :param folders_to_scan: The folders_to_scan of this ApplicationScanSettings.
        :type: list[oci.vulnerability_scanning.models.FolderToScan]
        """
        self._folders_to_scan = folders_to_scan

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
