# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerScanResultSummary(object):
    """
    A summary of a result for a container scan
    """

    #: A constant which can be used with the highest_problem_severity property of a ContainerScanResultSummary.
    #: This constant has a value of "NONE"
    HIGHEST_PROBLEM_SEVERITY_NONE = "NONE"

    #: A constant which can be used with the highest_problem_severity property of a ContainerScanResultSummary.
    #: This constant has a value of "LOW"
    HIGHEST_PROBLEM_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the highest_problem_severity property of a ContainerScanResultSummary.
    #: This constant has a value of "MEDIUM"
    HIGHEST_PROBLEM_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the highest_problem_severity property of a ContainerScanResultSummary.
    #: This constant has a value of "HIGH"
    HIGHEST_PROBLEM_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the highest_problem_severity property of a ContainerScanResultSummary.
    #: This constant has a value of "CRITICAL"
    HIGHEST_PROBLEM_SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerScanResultSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ContainerScanResultSummary.
        :type id: str

        :param repository:
            The value to assign to the repository property of this ContainerScanResultSummary.
        :type repository: str

        :param image:
            The value to assign to the image property of this ContainerScanResultSummary.
        :type image: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ContainerScanResultSummary.
        :type compartment_id: str

        :param container_scan_target_id:
            The value to assign to the container_scan_target_id property of this ContainerScanResultSummary.
        :type container_scan_target_id: str

        :param highest_problem_severity:
            The value to assign to the highest_problem_severity property of this ContainerScanResultSummary.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type highest_problem_severity: str

        :param problem_count:
            The value to assign to the problem_count property of this ContainerScanResultSummary.
        :type problem_count: int

        :param time_started:
            The value to assign to the time_started property of this ContainerScanResultSummary.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this ContainerScanResultSummary.
        :type time_finished: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'repository': 'str',
            'image': 'str',
            'compartment_id': 'str',
            'container_scan_target_id': 'str',
            'highest_problem_severity': 'str',
            'problem_count': 'int',
            'time_started': 'datetime',
            'time_finished': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'repository': 'repository',
            'image': 'image',
            'compartment_id': 'compartmentId',
            'container_scan_target_id': 'containerScanTargetId',
            'highest_problem_severity': 'highestProblemSeverity',
            'problem_count': 'problemCount',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished'
        }

        self._id = None
        self._repository = None
        self._image = None
        self._compartment_id = None
        self._container_scan_target_id = None
        self._highest_problem_severity = None
        self._problem_count = None
        self._time_started = None
        self._time_finished = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ContainerScanResultSummary.
        The `OCID`__ of container scan result. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContainerScanResultSummary.
        The `OCID`__ of container scan result. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ContainerScanResultSummary.
        :type: str
        """
        self._id = id

    @property
    def repository(self):
        """
        **[Required]** Gets the repository of this ContainerScanResultSummary.
        Repository in which the container image scanned is located


        :return: The repository of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """
        Sets the repository of this ContainerScanResultSummary.
        Repository in which the container image scanned is located


        :param repository: The repository of this ContainerScanResultSummary.
        :type: str
        """
        self._repository = repository

    @property
    def image(self):
        """
        **[Required]** Gets the image of this ContainerScanResultSummary.
        Image name


        :return: The image of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this ContainerScanResultSummary.
        Image name


        :param image: The image of this ContainerScanResultSummary.
        :type: str
        """
        self._image = image

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ContainerScanResultSummary.
        The `OCID`__ of the container scan result's compartment. This is set to the same as the compartmentId of the container scan target

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ContainerScanResultSummary.
        The `OCID`__ of the container scan result's compartment. This is set to the same as the compartmentId of the container scan target

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ContainerScanResultSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def container_scan_target_id(self):
        """
        Gets the container_scan_target_id of this ContainerScanResultSummary.
        The `OCID`__ of container scan target. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The container_scan_target_id of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._container_scan_target_id

    @container_scan_target_id.setter
    def container_scan_target_id(self, container_scan_target_id):
        """
        Sets the container_scan_target_id of this ContainerScanResultSummary.
        The `OCID`__ of container scan target. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param container_scan_target_id: The container_scan_target_id of this ContainerScanResultSummary.
        :type: str
        """
        self._container_scan_target_id = container_scan_target_id

    @property
    def highest_problem_severity(self):
        """
        **[Required]** Gets the highest_problem_severity of this ContainerScanResultSummary.
        Highest problem severity in this report

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The highest_problem_severity of this ContainerScanResultSummary.
        :rtype: str
        """
        return self._highest_problem_severity

    @highest_problem_severity.setter
    def highest_problem_severity(self, highest_problem_severity):
        """
        Sets the highest_problem_severity of this ContainerScanResultSummary.
        Highest problem severity in this report


        :param highest_problem_severity: The highest_problem_severity of this ContainerScanResultSummary.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(highest_problem_severity, allowed_values):
            highest_problem_severity = 'UNKNOWN_ENUM_VALUE'
        self._highest_problem_severity = highest_problem_severity

    @property
    def problem_count(self):
        """
        **[Required]** Gets the problem_count of this ContainerScanResultSummary.
        Total number of problems found in this scan


        :return: The problem_count of this ContainerScanResultSummary.
        :rtype: int
        """
        return self._problem_count

    @problem_count.setter
    def problem_count(self, problem_count):
        """
        Sets the problem_count of this ContainerScanResultSummary.
        Total number of problems found in this scan


        :param problem_count: The problem_count of this ContainerScanResultSummary.
        :type: int
        """
        self._problem_count = problem_count

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this ContainerScanResultSummary.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this ContainerScanResultSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this ContainerScanResultSummary.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this ContainerScanResultSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this ContainerScanResultSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this ContainerScanResultSummary.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this ContainerScanResultSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this ContainerScanResultSummary.
        :type: datetime
        """
        self._time_finished = time_finished

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
