# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostAgentScanResultProblem(object):
    """
    A problem found in a host agent scan
    """

    #: A constant which can be used with the severity property of a HostAgentScanResultProblem.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a HostAgentScanResultProblem.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a HostAgentScanResultProblem.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a HostAgentScanResultProblem.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a HostAgentScanResultProblem.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the state property of a HostAgentScanResultProblem.
    #: This constant has a value of "OPEN"
    STATE_OPEN = "OPEN"

    #: A constant which can be used with the state property of a HostAgentScanResultProblem.
    #: This constant has a value of "FIXED"
    STATE_FIXED = "FIXED"

    #: A constant which can be used with the state property of a HostAgentScanResultProblem.
    #: This constant has a value of "NOT_APPLICABLE"
    STATE_NOT_APPLICABLE = "NOT_APPLICABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new HostAgentScanResultProblem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this HostAgentScanResultProblem.
        :type name: str

        :param description:
            The value to assign to the description property of this HostAgentScanResultProblem.
        :type description: str

        :param severity:
            The value to assign to the severity property of this HostAgentScanResultProblem.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param state:
            The value to assign to the state property of this HostAgentScanResultProblem.
            Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param cve_reference:
            The value to assign to the cve_reference property of this HostAgentScanResultProblem.
        :type cve_reference: str

        :param issue_id:
            The value to assign to the issue_id property of this HostAgentScanResultProblem.
        :type issue_id: int

        :param time_first_detected:
            The value to assign to the time_first_detected property of this HostAgentScanResultProblem.
        :type time_first_detected: datetime

        :param time_last_detected:
            The value to assign to the time_last_detected property of this HostAgentScanResultProblem.
        :type time_last_detected: datetime

        :param vulnerable_packages:
            The value to assign to the vulnerable_packages property of this HostAgentScanResultProblem.
        :type vulnerable_packages: list[oci.vulnerability_scanning.models.Package]

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'severity': 'str',
            'state': 'str',
            'cve_reference': 'str',
            'issue_id': 'int',
            'time_first_detected': 'datetime',
            'time_last_detected': 'datetime',
            'vulnerable_packages': 'list[Package]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'severity': 'severity',
            'state': 'state',
            'cve_reference': 'cveReference',
            'issue_id': 'issueId',
            'time_first_detected': 'timeFirstDetected',
            'time_last_detected': 'timeLastDetected',
            'vulnerable_packages': 'vulnerablePackages'
        }

        self._name = None
        self._description = None
        self._severity = None
        self._state = None
        self._cve_reference = None
        self._issue_id = None
        self._time_first_detected = None
        self._time_last_detected = None
        self._vulnerable_packages = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this HostAgentScanResultProblem.
        Name of the problem


        :return: The name of this HostAgentScanResultProblem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this HostAgentScanResultProblem.
        Name of the problem


        :param name: The name of this HostAgentScanResultProblem.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this HostAgentScanResultProblem.
        Problem description


        :return: The description of this HostAgentScanResultProblem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this HostAgentScanResultProblem.
        Problem description


        :param description: The description of this HostAgentScanResultProblem.
        :type: str
        """
        self._description = description

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this HostAgentScanResultProblem.
        Problem severity

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this HostAgentScanResultProblem.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this HostAgentScanResultProblem.
        Problem severity


        :param severity: The severity of this HostAgentScanResultProblem.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def state(self):
        """
        Gets the state of this HostAgentScanResultProblem.
        State of the vulnerability

        Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this HostAgentScanResultProblem.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this HostAgentScanResultProblem.
        State of the vulnerability


        :param state: The state of this HostAgentScanResultProblem.
        :type: str
        """
        allowed_values = ["OPEN", "FIXED", "NOT_APPLICABLE"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def cve_reference(self):
        """
        Gets the cve_reference of this HostAgentScanResultProblem.
        Reference to problem MITRE CVE ID


        :return: The cve_reference of this HostAgentScanResultProblem.
        :rtype: str
        """
        return self._cve_reference

    @cve_reference.setter
    def cve_reference(self, cve_reference):
        """
        Sets the cve_reference of this HostAgentScanResultProblem.
        Reference to problem MITRE CVE ID


        :param cve_reference: The cve_reference of this HostAgentScanResultProblem.
        :type: str
        """
        self._cve_reference = cve_reference

    @property
    def issue_id(self):
        """
        Gets the issue_id of this HostAgentScanResultProblem.
        Reference to problem issue ID


        :return: The issue_id of this HostAgentScanResultProblem.
        :rtype: int
        """
        return self._issue_id

    @issue_id.setter
    def issue_id(self, issue_id):
        """
        Sets the issue_id of this HostAgentScanResultProblem.
        Reference to problem issue ID


        :param issue_id: The issue_id of this HostAgentScanResultProblem.
        :type: int
        """
        self._issue_id = issue_id

    @property
    def time_first_detected(self):
        """
        Gets the time_first_detected of this HostAgentScanResultProblem.
        Date of scan result that first reported the vulnerability


        :return: The time_first_detected of this HostAgentScanResultProblem.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this HostAgentScanResultProblem.
        Date of scan result that first reported the vulnerability


        :param time_first_detected: The time_first_detected of this HostAgentScanResultProblem.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def time_last_detected(self):
        """
        Gets the time_last_detected of this HostAgentScanResultProblem.
        Date of scan result that most recently reported the vulnerability


        :return: The time_last_detected of this HostAgentScanResultProblem.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this HostAgentScanResultProblem.
        Date of scan result that most recently reported the vulnerability


        :param time_last_detected: The time_last_detected of this HostAgentScanResultProblem.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def vulnerable_packages(self):
        """
        Gets the vulnerable_packages of this HostAgentScanResultProblem.
        Packages in which the problem is detected


        :return: The vulnerable_packages of this HostAgentScanResultProblem.
        :rtype: list[oci.vulnerability_scanning.models.Package]
        """
        return self._vulnerable_packages

    @vulnerable_packages.setter
    def vulnerable_packages(self, vulnerable_packages):
        """
        Sets the vulnerable_packages of this HostAgentScanResultProblem.
        Packages in which the problem is detected


        :param vulnerable_packages: The vulnerable_packages of this HostAgentScanResultProblem.
        :type: list[oci.vulnerability_scanning.models.Package]
        """
        self._vulnerable_packages = vulnerable_packages

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
