# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateHostScanRecipeDetails(object):
    """
    The information to update an existing host scan recipe
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateHostScanRecipeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateHostScanRecipeDetails.
        :type display_name: str

        :param port_settings:
            The value to assign to the port_settings property of this UpdateHostScanRecipeDetails.
        :type port_settings: oci.vulnerability_scanning.models.HostScanPortSettings

        :param agent_settings:
            The value to assign to the agent_settings property of this UpdateHostScanRecipeDetails.
        :type agent_settings: oci.vulnerability_scanning.models.HostScanAgentSettings

        :param application_settings:
            The value to assign to the application_settings property of this UpdateHostScanRecipeDetails.
        :type application_settings: oci.vulnerability_scanning.models.ApplicationScanSettings

        :param schedule:
            The value to assign to the schedule property of this UpdateHostScanRecipeDetails.
        :type schedule: oci.vulnerability_scanning.models.Schedule

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateHostScanRecipeDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateHostScanRecipeDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'port_settings': 'HostScanPortSettings',
            'agent_settings': 'HostScanAgentSettings',
            'application_settings': 'ApplicationScanSettings',
            'schedule': 'Schedule',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'port_settings': 'portSettings',
            'agent_settings': 'agentSettings',
            'application_settings': 'applicationSettings',
            'schedule': 'schedule',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._port_settings = None
        self._agent_settings = None
        self._application_settings = None
        self._schedule = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateHostScanRecipeDetails.
        Recipe identifier, which can be renamed. Avoid entering confidential information.


        :return: The display_name of this UpdateHostScanRecipeDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateHostScanRecipeDetails.
        Recipe identifier, which can be renamed. Avoid entering confidential information.


        :param display_name: The display_name of this UpdateHostScanRecipeDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def port_settings(self):
        """
        Gets the port_settings of this UpdateHostScanRecipeDetails.

        :return: The port_settings of this UpdateHostScanRecipeDetails.
        :rtype: oci.vulnerability_scanning.models.HostScanPortSettings
        """
        return self._port_settings

    @port_settings.setter
    def port_settings(self, port_settings):
        """
        Sets the port_settings of this UpdateHostScanRecipeDetails.

        :param port_settings: The port_settings of this UpdateHostScanRecipeDetails.
        :type: oci.vulnerability_scanning.models.HostScanPortSettings
        """
        self._port_settings = port_settings

    @property
    def agent_settings(self):
        """
        Gets the agent_settings of this UpdateHostScanRecipeDetails.

        :return: The agent_settings of this UpdateHostScanRecipeDetails.
        :rtype: oci.vulnerability_scanning.models.HostScanAgentSettings
        """
        return self._agent_settings

    @agent_settings.setter
    def agent_settings(self, agent_settings):
        """
        Sets the agent_settings of this UpdateHostScanRecipeDetails.

        :param agent_settings: The agent_settings of this UpdateHostScanRecipeDetails.
        :type: oci.vulnerability_scanning.models.HostScanAgentSettings
        """
        self._agent_settings = agent_settings

    @property
    def application_settings(self):
        """
        Gets the application_settings of this UpdateHostScanRecipeDetails.

        :return: The application_settings of this UpdateHostScanRecipeDetails.
        :rtype: oci.vulnerability_scanning.models.ApplicationScanSettings
        """
        return self._application_settings

    @application_settings.setter
    def application_settings(self, application_settings):
        """
        Sets the application_settings of this UpdateHostScanRecipeDetails.

        :param application_settings: The application_settings of this UpdateHostScanRecipeDetails.
        :type: oci.vulnerability_scanning.models.ApplicationScanSettings
        """
        self._application_settings = application_settings

    @property
    def schedule(self):
        """
        Gets the schedule of this UpdateHostScanRecipeDetails.

        :return: The schedule of this UpdateHostScanRecipeDetails.
        :rtype: oci.vulnerability_scanning.models.Schedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this UpdateHostScanRecipeDetails.

        :param schedule: The schedule of this UpdateHostScanRecipeDetails.
        :type: oci.vulnerability_scanning.models.Schedule
        """
        self._schedule = schedule

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateHostScanRecipeDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateHostScanRecipeDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateHostScanRecipeDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateHostScanRecipeDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateHostScanRecipeDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateHostScanRecipeDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateHostScanRecipeDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateHostScanRecipeDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
