"""
Characterization tests for TunaCode UI diff generation and display.
Covers: Integration of render_file_diff and console output.
"""

from unittest.mock import patch


def test_diff_display_renders_diff_and_prints():
    # Patch render_file_diff and console.print
    with patch("tunacode.utils.diff_utils.render_file_diff", return_value="FAKE_DIFF") as mock_diff:
        with patch("tunacode.ui.output.console.print") as mock_print:
            # Simulate a UI function that displays a diff
            from tunacode.ui import output

            # Assume a function like output.print_diff exists, or simulate the pattern
            if hasattr(output, "print_diff"):
                output.print_diff("old", "new", "file.py")
                mock_diff.assert_called_once_with("old", "new", "file.py")
                mock_print.assert_called_once_with("FAKE_DIFF")
            else:
                # If no such function, just test the diff utility and print integration
                diff = mock_diff("old", "new", "file.py")
                output.console.print(diff)
                mock_print.assert_called_once_with("FAKE_DIFF")
