# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['widelearning']
setup_kwargs = {
    'name': 'widelearning',
    'version': '0.8.6',
    'description': 'Library for searching the optimal neural network architecture',
    'long_description': "# wideLearning\n\n[**`Инструкция`**](https://github.com/brinkinvision/wideLearning/tree/main/Туториал) | [**`Github`**](https://github.com/brinkinvision/wideLearning) | [**`GitFlic`**](https://gitflic.ru/project/brinkinvision/wide-learning) | [**`Пример новых вариантов использования`**](https://github.com/brinkinvision/wideLearning/tree/main/Обучение_на_ошибках)\n\n# Минимальные требования к аппаратной части:\n* Операционная система: Windows 7 или выше (64-bit), Linux (64-bit)\n* Оперативная память: не менее 2 GB\n* Процессор: двухъядерный с частотой 1.6 GHz или выше\n* Свободное место на жестком диске: не менее 2 GB\n\n# Направления прикладного использования:\n1. Компьютерное зрение. Упрощение архитектур сверточных нейронных сетей для задач классификации и распознавания изображений, сегментации и детектирования объектов.\n2. Медицинская диагностика. Оптимизация нейронных сетей, используемых при анализе изображений и сигналов, полученных от медицинских приборов. Может использоваться для обнаружения и классификации заболеваний.\n3. Рекомендательные системы. Может использоваться для классификации на основе некоторых признаков контента и выдачи персонализированных рекомендаций.\n4. Развертывание моделей нейронных сетей на устройствах малой вычислительной мощности, например, мобильные гаджеты (смартфоны/планшеты), встраиваемые устройства (промышленные контроллеры/смарт-устройства) и т.п.\n\n# Установка\n```\npip install widelearning\n```\n\n# Импорт библиотеки\n```\nimport widelearning as wdl \n```\n\n# Описание функций\n\n### txt_kernel(file_path)\t\n    \n    Функция преобразования сгенерированного ядра для вставки в структуру TensorFlow \n    (для черно-белых, одноканальных изображений)\n\n    Параметры\n    ----------\n    file_path : str\n        путь к текстовому файлу, содержащему сверточное ядро, записанное в следующем виде \n        (с запятыми в конце каждой строки)\n        1,2,3,\n        4,5,6,\n        7,8,9,\n\n    Пример использования:\n    wdl.txt_kernel('horizontal.txt')\n\n### txt_kernel_rgb(k1, k2, k3) \n    \n    Функция преобразования сгенерированного ядра для вставки в структуру TensorFlow \n    (для цветных, трехканальных изображений)\n    \n    Параметры\n    ----------\n    k1 : str\n        путь к текстовому файлу, содержащему сверточное ядро первого цветового канала R, записанное в следующем виде \n        (с запятыми в конце каждой строки)\n        1,2,3,\n        4,5,6,\n        7,8,9,\n    k2 : str\n        путь к текстовому файлу, содержащему сверточное ядро второго цветового канала G\n    k3 : str\n        путь к текстовому файлу, содержащему сверточное ядро третьего цветового канала B\n\n    Пример использования:\n    wdl.txt_kernel_rgb('k1.txt', 'k2.txt', 'k3.txt')\n\n### add_kernel(path, init_kernel)\n    \n    Функция позволяет устанавливать дополнительные ядра сверточного слоя к уже установленным исходным\n    (для черно-белых, одноканальных изображений)\n\n    Параметры\n    ----------\n    path : str\n        путь к файлу в формате txt, который содержит значения сгенерированного сверточного ядра, \n        добавляемого к исходным\n    init_kernel : list\n        значения исходного/ых ядер, к которым происходит добавление. \n        Это может быть либо переменная, которой присвоено значение исходных ядер, \n        либо сами значения, полученные после преобразования с помощью функции txt_kernel:\n        [[[[1]], [[2]], [[3]]], [[[4]], [[5]], [[6]]], [[[7]], [[8]], [[9]]]].\n\n    Пример использования:\n    wdl.add_kernel('vertical.txt', w1)\n    \n### add_kernel_rgb(k1, k2, k3, w)\n    \n    Функция позволяет устанавливать дополнительные ядра сверточного слоя к уже установленным исходным\n    (для цветных, трехканальных изображений)\n\n    Параметры\n    ----------\n    path : str\n        путь к файлу в формате txt, который содержит значения сгенерированного сверточного ядра, \n        добавляемого к исходным\n    init_kernel : list\n        значения исходного/ых ядер, к которым происходит добавление. \n        Это может быть либо переменная, которой присвоено значение исходных ядер, \n        либо сами значения, полученные после преобразования с помощью функции txt_kernel_rgb\n\n    Параметры\n    ----------\n    k1 : str\n        путь к файлу в формате txt, который содержит значения сгенерированного сверточного ядра первого цветового канала R, \n        добавляемого к исходным в данном цветовом канале\n    k2 : str\n        путь к файлу в формате txt, который содержит значения сгенерированного сверточного ядра второго цветового канала G, \n        добавляемого к исходным в данном цветовом канале\n    k3 : str\n        путь к файлу в формате txt, который содержит значения сгенерированного сверточного ядра первого цветового канала B, \n        добавляемого к исходным в данном цветовом канале\n    w : list\n        значения исходного/ых ядер, к которым происходит добавление. \n        Это может быть либо переменная, которой присвоено значение исходных ядер, \n        либо сами значения, полученные после преобразования с помощью функции txt_kernel_rgb\n\n    Пример использования:\n    wdl.add_kernel_rgb('k1.txt', 'k2.txt', 'k3.txt', w1)\n\n### horizontal(dim, values)\n    \n    Функция для генерации линейного сверточного ядра горизонтального типа\n\n    Параметры\n    ----------\n    dim : int\n        размерность генерируемой матрицы \n    values : list\n        список значений, которые будут использоваться для заполнения матрицы.\n\n    Пример использования:\n    wdl.horizontal(32, [-7,-5,-3,-1,1,3,5,7])\n\t\n### vertical(dim, values)\n    \n    Функция для генерации линейного сверточного ядра вертикального типа\n\n    Параметры\n    ----------\n    dim : int\n        размерность генерируемой матрицы \n    values : list\n        список значений, которые будут использоваться для заполнения матрицы.\n\n    Пример использования:\n    wdl.vertical(32, [-7,-5,-3,-1,1,3,5,7])\n\n### diagonal(up, down, d, dimension)\n    \n    Функция для генерации линейного сверточного ядра диагонального типа\n\n    Parameters\n    ----------\n    up : list\n        список значений, которые будут размещены над диагональю выходной матрицы\n    down : list\n        список значений, которые будут размещены ниже диагонали\n    d : int\n        значение, из которого состоит диагональ.\n    dimension : int\n        размерность генерируемого ядра\n\n    Пример использования:\n    wdl.diagonal([-7, -5, -3, -1], [1, 3, 5, 7], 1, 32)\t\n\t\n### show_kernel(N, name)\n    \n    Функция вывода коэффициентов сверточного ядра на экран пользователя\n\n    Параметры\n    ----------\n    N : int\n        номер слоя, для которого необходимо вывести значения весовых коэффициентов\n    name : object\n        объект модели нейронной сети\n        название переменной, которой присвоена структура модели\n\n    Пример использования:\n    wdl.show_kernel(0, model)\n    \n### auto_select(neuron, path, label, target, quantity)\n\n    Функция для расчета первоначального приближения с автоматическим выбором целевого класса.\n\n    Параметры\n    ----------\n    neuron : int\n        номер нейрона, для которого производится расчет\n    path : str\n        путь к целочисленной обучающей выборке в формате csv \n    label : str\n        название столбца с метками классов\n    target : str, list\n        параметр, на основании которого выбирается целевой класс\n        1. 'up' - максимальное количество отсеченных экземпляров сверху\n        2. 'mx_ratio' - максимальная доля отсеченных экземпляров к неотсеченным сверху\n        3. [class] - собственный выбор целевого класса, вместо class необходимо добавить название класса в виде строки или числа \n    quantity : str\n        'many' - если обучающая выборка содержит более двух классов\n        'binary' - для бинарного варианта набора данных\n        \n    Пример использования:\n    wdl.auto_select(1, 'KH_train.csv', 'UNS', ['very_low'], 'many') \n    wdl.auto_select(8, 'KH_train.csv', 'UNS', 'mx_ratio', 'binary') \n\n### select_top(path, label)\n    \n    Функция позволяет получить грубое первоначальное приближение вектора весов\n\n    Параметры\n    ----------\n    path : str\n        путь к целочисленной обучающей выборке в формате csv\n    label : str\n        название столбца с метками классов\n\n    Пример использования:\n    wdl.select_top('KAHRAMAN_train.csv', 'UNS')\n\n### select_top_binary(path, label)\n    \n    Функция позволяет получить грубое первоначальное приближение вектора весов для бинарной обучающей выборки\n\n    Параметры\n    ----------\n    path : str\n        путь к целочисленной бинарной обучающей выборке в формате csv\n    label : str\n        название столбца с метками классов\n\n    Пример использования:\n    wdl.select_top_binary('train_6.csv', 'UNS')\n\n### grad_boost(path, t, oth, l, s, from_initial, weights_main)\n    \n    Вспомогательная функция для корректировки весовых коэффициентов с помощью градиентного уточнения, одиночный проход по вектору\n\n    Параметры\n    ----------\n    path : str\n        путь к обучающей выборке, подаваемой на вход функции select_top\n    t : list\n        метка выбранного на этапе первоначального приближения целевого класса\n    oth : list\n        список, содержащий метки оставшихся классов, которые не относятся к целевому\n    l : str\n        название столбца с метками классов\n    s : int\n        шаг изменения значений элементов вектора весов, шаг градиентного уточнения;\n    from_initial : int\n        1, если вектор берется из select_top (грубое приближение), \n        0 - если вектор снова корректируется (после grad_boost)\n    weights_main : list\n        вектор весов для корректировки\n\n### grad_boost_save_files(path, t, oth, l, s, from_initial, weights_main)\n    \n    Вспомогательная функция для сохранения усеченных обучающих выборок и скорректированных векторов весов после градиентного уточнения\n\n    Параметры\n    ----------\n    path : str\n        путь к обучающей выборке, подаваемой на вход функции select_top\n    t : list\n        метка выбранного на этапе первоначального приближения целевого класса\n    oth : list\n        список, содержащий метки оставшихся классов, которые не относятся к целевому\n    l : str\n        название столбца с метками классов\n    s : int\n        шаг изменения значений элементов вектора весов, шаг градиентного уточнения;\n    from_initial : int\n        1, если вектор берется из select_top (грубое приближение), \n        0 - если вектор снова корректируется (после grad_boost)\n    weights_main : list\n        вектор весов для корректировки\n\n### grad(path, t, oth, l, s, weights)\n    \n    Функция осуществляет градиентное уточнение полученного после первоначального приближения вектора весов \n\n    Параметры\n    ----------\n    path : str\n        путь к обучающей выборке, подаваемой на вход функции select_top\n    t : list\n        метка выбранного на этапе первоначального приближения целевого класса\n    oth : list\n        список, содержащий метки оставшихся классов, которые не относятся к целевому\n    l : str\n        название столбца с метками классов\n    s : int\n        шаг изменения значений элементов вектора весов, шаг градиентного уточнения\n    weights_main : list\n        вектор весов, значения которого необходимо изменить с целью получения большего количества \n        отсеченных экземпляров обучающей выборки\n\n    Пример использования:\n    wdl.grad('KAHRAMAN_train.csv', ['High'], ['very_low', 'Low', 'Middle'], 'UNS', 1, [455.02247191011236, 552.8764044943821, 273.38202247191015, 518.2921348314607, 2276.179775280899])\n\t\n### grad_binary(path, t, oth, l, s, weights_main)\n    \n    Функция осуществляет градиентное уточнение полученного после первоначального приближения вектора весов \n    для бинарной обучающей выборки\n\n    Параметры\n    ----------\n    path : str\n        путь к бинарной обучающей выборке, подаваемой на вход функции select_top\n    t : list\n        метка выбранного на этапе первоначального приближения целевого класса\n    oth : list\n        список, содержащий метки оставшихся классов, которые не относятся к целевому\n    l : str\n        название столбца с метками классов\n    s : int\n        шаг изменения значений элементов вектора весов, шаг градиентного уточнения\n    weights_main : list\n        вектор весов, значения которого необходимо изменить с целью получения большего количества \n        отсеченных экземпляров обучающей выборки\n\n    Пример использования:\n    wdl.grad_binary('train_6.csv', ['Low'], ['Middle'], 'UNS', 1, [1009.0, 48.0, -929.0, -1056.0, -13.0])\n\n### data_int(path, decimal, name)\n    \n    Функция преобразует набор данных, представленный в вещественнозначном виде в целочисленный вид\n\n    Параметры\n    ----------\n    path : str\n        путь к обучающей выборке в формате csv\n    decimal : str\n        путь к текстовому файлу, содержащему в каждой строке число, обозначающее количество десятичных знаков после \n        запятой в соответствующем столбце выборки\n    name : str\n        аргумент функции, обозначающий желаемое название выходных генерируемых файлов\n\n    Пример использования:\n    wdl.data_int('kahraman.csv', 'dec.txt', 'KAHRAMAN') \n\n### scale_weights(label, data_folder, weights_folder)\n    \n    Функция для масштабирования полученных векторов весов в диапазон от -1 до +1\n\n    Параметры\n    ----------\n    label : str\n        название столбца с метками классов\n    data_folder : str\n        путь к папке, содержащей обучающие выборки каждого нейрона\n    weights_folder : str\n        путь к папке, содержащей веса каждого нейрона\n\n    Пример использования:\n    wdl.scale_weights('UNS', 'data/', 'weights/')\n\n### generate_fa(label, data_folder, weights_folder)\n    \n    Функция, которая на основании проведенного обучения модифицированного полносвязного слоя, генерирует вложенную \n    логическую функцию активации для проверки весовых коэффициентов на тестовых данных\n\n    Параметры\n    ----------\n    label : str\n        название столбца обучающих выборок, в котором содержатся наименования (метки) классов\n    data_folder : str\n        путь к папке result, сгенерированной в результате выполнения функции scale_weights\n    weights_folder : str\n        путь к каталогу scale, который сгенерирован после применения функции scale_weights\n\n    Пример использования:\n    wdl.generate_fa('UNS', 'result', 'scale')\n\n### check_test(train, weights, test, label)\n    \n    Функция осуществляет проверку обучения с помощью правил логического вывода\n\n    Параметры\n    ----------\n    train : str\n        путь к полной целочисленной обучающей выборке\n    weights : str\n        путь к текстовому файлу weights.txt из сгенерированного каталога all_weights после функции scale_weights\n    test : str\n        путь к целочисленной тестовой выборке (в случае проверки обучающей выборки передается путь к полной обучающей выборке, \n        аналогичный параметру train)\n    label : str\n        название столбца с метками классов\n\n    Пример использования:\n    wdl.check_test('train_1.csv', 'weights.txt', 'KAHRAMAN_test.csv', 'UNS')\n\n### getNameColumn(nameFileTrain)\n    \n    Вспомогательная функция для определения названий всех столбцов, кроме столбца с метками классов\n\n    Параметры\n    ----------\n    nameFileTrain : str\n        путь к обучающей выборке \n\n### getCountNeuronSizeVector(nameFileTrain)\n    \n    Вспомогательная функция для определения необходимого количества нейронов в слое\n\n    Параметры\n    ----------\n    nameFileTrain : str\n        путь к обучающей выборке \n\n### initializingDictionaryKeys()\n    \n    Вспомогательная функция для инициализации ключей для правила логического вывода\n\n### initializationDictionaryValues(nameFileTrain)\n    \n    Вспомогательная функция для создания словаря логического вывода\n\n    Параметры\n    ----------\n    nameFileTrain : str\n        путь к обучающей выборке \n\n### count_conv_operations(height, width, color_channels, kernel_size, stride, num_kernels)\n    \n    Функция для подсчета количества вычислительных операций в сверточном слое \n\n    Параметры\n    ----------\n    height : int\n        высота исходного изображения выборки данных\n    width : int\n        ширина исходного изображения\n    color_channels : int\n        количество цветовых каналов изображения \n        (1 – если изображение представлено в черно-белом одноканальном виде, 3 – если изображение является цветным)\n    kernel_size : int\n        размерность сверточного ядра квадратной формы\n    stride : int\n        шаг прохода сверточного ядра по изображению\n    num_kernels : int\n        количество сверточных ядер в слое\n\n    Пример использования:\n    wdl.count_conv_operations(28, 28, 1, 14, 7, 4)\n\n# Шаблоны вызова функций сверточного слоя\n```\nwdl.txt_kernel('путь_к_сгенерированному_ядру.txt')\n```\n```\nwdl.txt_kernel_rgb('путь_к_сгенерированному_ядру_ПЕРВОГО_цветового_канала.txt', 'путь_к_сгенерированному_ядру_ВТОРОГО_цветового_канала.txt', 'путь_к_сгенерированному_ядру_ТРЕТЬЕГО_цветового_канала.txt')\n```\n```\nwdl.add_kernel('путь_к_добавляемому_ядру.txt', переменная_уже_установленных_ядер)\n```\n```\nwdl.add_kernel_rgb('путь_к_добавляемому_ядру_ПЕРВОГО_цветового_канала.txt', 'путь_к_добавляемому_ядру_ВТОРОГО_цветового_канала.txt', 'путь_к_добавляемому_ядру_ТРЕТЬЕГО_цветового_канала.txt', переменная_уже_установленных_ядер)\n```\n```\nwdl.horizontal(размерность_ядра, [список_значений_ядра])\n```\n```\nwdl.vertical(размерность_ядра, [список_значений_ядра])\n```\n```\nwdl.diagonal([список_значений_выше_диагонали], [список_значений_ниже_диагонали], значение_диагонали, размерность_ядра)\n```\n```\nwdl.show_kernel(номер_сверточного_слоя, объект_модели)\n```\n```\nwdl.count_conv_operations(высота_изображения, ширина_изображения, количество_цветовых_каналов, размерность_квадратного_ядра, шаг_ядра, количество_ядер)\n```\n\n# Шаблоны вызова функций полносвязного слоя\n```\nwdl.data_int('путь_к_обучающей_выборке.csv', 'путь_к_файлу_со_значениями_кол-ва_знаков_после_запятой.txt', 'название_выходных_файлов')\n```\n```\nwdl.select_top('путь_к_целочисленной_обучающей_выборке.csv', 'название_столбца_с_метками_классов')\n```\n```\nwdl.select_top_binary('путь_к_целочисленной_обучающей_выборке.csv', 'название_столбца_с_метками_классов')\n```\n```\nwdl.grad('путь_к_целочисленной_обучающей_выборке.csv', [целевой_класс], [список_остальных_классов], 'название_столбца_с_метками_классов', шаг, [вектор_весов])\n```\n```\nwdl.grad_binary('путь_к_целочисленной_обучающей_выборке.csv', [целевой_класс], [список_остальных_классов], 'название_столбца_с_метками_классов', шаг, [вектор_весов])\n```\n```\nwdl.scale_weights('название_столбца_с_метками_классов', 'путь_к_папке_с_обучающими_выборками', 'путь_к_папке_с_весами')\n```\n```\nwdl.generate_fa('название_столбца_с_метками_классов', 'путь_к_папке_result', 'путь_к_папке_scale')\n```\n```\nwdl.check_test('путь_к_полной_обучающей_выборке.csv', 'путь_к_файлу_со_всеми_весами.txt', 'путь_к_тестовой_выборке.csv', 'название_столбца_с_метками_классов')\n```\n",
    'author': 'Brinkinvision',
    'author_email': 'brinkinvision@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'py_modules': modules,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
