from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ynab_cli.adapters.ynab.models.existing_transaction import ExistingTransaction


T = TypeVar("T", bound="PutTransactionWrapper")


@_attrs_define
class PutTransactionWrapper:
    """
    Attributes:
        transaction (ExistingTransaction):
    """

    transaction: "ExistingTransaction"
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        transaction = self.transaction.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "transaction": transaction,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ynab_cli.adapters.ynab.models.existing_transaction import ExistingTransaction

        d = dict(src_dict)
        transaction = ExistingTransaction.from_dict(d.pop("transaction"))

        put_transaction_wrapper = cls(
            transaction=transaction,
        )

        put_transaction_wrapper.additional_properties = d
        return put_transaction_wrapper

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
