from enum import Enum, auto


class Field(Enum):
    """
    ----------------------------------------------------------------
    股票 ST
    ----------------------------------------------------------------
    """
    ST_开盘价 = auto()
    ST_最高价 = auto()
    ST_最低价 = auto()
    ST_收盘价 = auto()
    ST_昨收价 = auto()  # 后复权
    ST_涨跌额 = auto()
    ST_涨跌幅 = auto()  # 后复权
    ST_成交量 = auto()
    ST_成交额 = auto()  # 万元
    ST_振幅 = auto()
    ST_换手率 = auto()
    ST_自由流通股换手率 = auto()
    ST_量比 = auto()
    ST_总市值 = auto()
    ST_流通市值 = auto()

    """
    ----------------------------------------------------------------
    利润表 IS
    ----------------------------------------------------------------
    """
    IS_营业总收入 = auto()
    IS_营业总成本 = auto()
    IS_营业利润 = auto()
    IS_利润总额 = auto()
    IS_息税前利润 = auto()
    IS_息税折旧摊销前利润 = auto()
    IS_所得税费用 = auto()
    IS_净利润 = auto()
    IS_归母净利润 = auto()
    IS_综合收益 = auto()
    IS_归母综合收益 = auto()

    IS_销售费用 = auto()
    IS_管理费用 = auto()
    IS_财务费用 = auto()
    IS_研发费用 = auto()

    """
    ----------------------------------------------------------------
    资产负债表 BS
    ----------------------------------------------------------------
    """
    BS_总股本 = auto()
    BS_库存股 = auto()
    BS_资本公积 = auto()
    BS_盈余公积 = auto()
    BS_未分配利润 = auto()
    BS_股东权益合计 = auto()
    BS_归母股东权益合计 = auto()

    BS_货币资金 = auto()
    BS_交易性金融资产 = auto()
    BS_应收票据 = auto()
    BS_应收账款 = auto()
    BS_应收股利 = auto()
    BS_应收利息 = auto()
    BS_其他应收款 = auto()
    BS_预付款项 = auto()
    BS_存货 = auto()
    BS_一年内到期的非流动资产 = auto()
    BS_可供出售金融资产 = auto()
    BS_持有至到期投资 = auto()
    BS_长期股权投资 = auto()
    BS_投资性房地产 = auto()
    BS_定期存款 = auto()
    BS_长期应收款 = auto()
    BS_固定资产 = auto()
    BS_在建工程 = auto()
    BS_无形资产 = auto()
    BS_研发支出 = auto()
    BS_商誉 = auto()
    BS_流动资产合计 = auto()
    BS_非流动资产合计 = auto()
    BS_资产合计 = auto()

    BS_短期借款 = auto()
    BS_长期借款 = auto()
    BS_交易性金融负债 = auto()
    BS_应付票据 = auto()
    BS_应付账款 = auto()
    BS_应付职工薪酬 = auto()
    BS_应付利息 = auto()
    BS_应付股利 = auto()
    BS_应付短期债券 = auto()
    BS_应付债券 = auto()
    BS_长期应付款 = auto()
    BS_预收款项 = auto()
    BS_一年内到期的非流动负债 = auto()
    BS_流动负债合计 = auto()
    BS_非流动负债合计 = auto()
    BS_负债合计 = auto()

    """
    ----------------------------------------------------------------
    现金流量表 CS
    ----------------------------------------------------------------
    """
    CS_经营活动现金流入 = auto()
    CS_经营活动现金流出 = auto()
    CS_经营活动净现金流 = auto()

    CS_投资活动现金流入 = auto()
    CS_投资活动现金流出 = auto()
    CS_投资活动净现金流 = auto()

    CS_筹资活动现金流入 = auto()
    CS_筹资活动现金流出 = auto()
    CS_筹资活动净现金流 = auto()

    CS_现金及现金等价物净增加额 = auto()

    """
    ----------------------------------------------------------------
    财务指标 FI
    ----------------------------------------------------------------
    """
    FI_基本每股收益 = auto()
    FI_稀释每股收益 = auto()
    FI_期末摊薄每股收益 = auto()

    FI_每股营业总收入 = auto()
    FI_每股营业收入 = auto()
    FI_每股资本公积 = auto()
    FI_每股盈余公积 = auto()
    FI_每股未分配利润 = auto()
    FI_每股净资产 = auto()
    FI_每股经营活动产生的现金流量净额 = auto()
    FI_每股留存收益 = auto()
    FI_每股现金流量净额 = auto()
    FI_每股息税前利润 = auto()
    FI_每股企业自由现金流量 = auto()
    FI_每股股东自由现金流量 = auto()

    FI_流动比率 = auto()
    FI_速动比率 = auto()
    FI_现金比率 = auto()
    FI_利息保障倍数 = auto()

    FI_存货周转率 = auto()
    FI_应收账款周转率 = auto()
    FI_流动资产周转率 = auto()
    FI_固定资产周转率 = auto()
    FI_总资产周转率 = auto()
    FI_营业周期 = auto()

    FI_企业自由现金流量 = auto()
    FI_股权自由现金流量 = auto()

    FI_销售净利率 = auto()
    FI_销售毛利率 = auto()
    FI_销售成本率 = auto()
    FI_销售期间费用率 = auto()

    FI_净资产收益率 = auto()
    FI_加权平均净资产收益率 = auto()
    FI_扣除非经常损益净资产收益率 = auto()

    FI_总资产报酬率 = auto()
    FI_总资产净利润 = auto()
    FI_投入资本回报率 = auto()
    FI_平均净资产收益率 = auto()

    FI_资产负债率 = auto()
    FI_权益乘数 = auto()
    FI_产权比率 = auto()


    """
    ----------------------------------------------------------------
    指数 IN
    ----------------------------------------------------------------
    """
    IN_开盘点位 = auto()
    IN_收盘点位 = auto()
    IN_最高点位 = auto()
    IN_最低点位 = auto()

    """
    ----------------------------------------------------------------
    杠杆率 LEV
    ----------------------------------------------------------------
    """
    LEV_居民部门 = auto()  # 注意单位: %
    LEV_非金融企业部门 = auto()  # 注意单位: %
    LEV_政府部门 = auto()  # 注意单位: %
    LEV_中央政府 = auto()  # 注意单位: %
    LEV_地方政府 = auto()  # 注意单位: %
    LEV_实体经济部门 = auto()  # 注意单位: %
    LEV_金融部门资产方 = auto()  # 注意单位: %
    LEV_金融部门负债方 = auto()  # 注意单位: %

    """
    ----------------------------------------------------------------
    企业商品交易价格指数 CGPI
    ----------------------------------------------------------------
    """
    CGPI_总指数 = auto()
    CGPI_总指数同比增长 = auto()  # 注意单位: %
    CGPI_总指数环比增长 = auto()  # 注意单位: %
    CGPI_农产品 = auto()
    CGPI_农产品同比增长 = auto()  # 注意单位: %
    CGPI_农产品环比增长 = auto()  # 注意单位: %
    CGPI_矿产品 = auto()
    CGPI_矿产品同比增长 = auto()  # 注意单位: %
    CGPI_矿产品环比增长 = auto()  # 注意单位: %
    CGPI_煤油电 = auto()
    CGPI_煤油电同比增长 = auto()  # 注意单位: %
    CGPI_煤油电环比增长 = auto()  # 注意单位: %

    """
    ----------------------------------------------------------------
    国际直接投资 FDI
    ----------------------------------------------------------------
    """
    FDI_当月 = auto()  # 注意单位: 万美元
    FDI_当月同比增长 = auto()  # 注意单位: %
    FDI_当月环比增长 = auto()  # 注意单位: %
    FDI_累计 = auto()  # 注意单位: 万美元
    FDI_累计同比增长 = auto()  # 注意单位: %

    """
    ----------------------------------------------------------------
    利率 RATE
    ----------------------------------------------------------------
    """
    RATE_LPR1年 = auto()  # 注意单位: %
    RATE_LPR5年 = auto()  # 注意单位: %
    RATE_短期贷款 = auto()  # 注意单位: %
    RATE_中长期贷款 = auto()  # 注意单位: %

    """
    ----------------------------------------------------------------
    社会融资规模 AFRE
    ----------------------------------------------------------------
    """
    AFRE_总增量 = auto()  # 注意单位: 亿元
    AFRE_人民币贷款增量 = auto()  # 注意单位: 亿元
    AFRE_委托贷款外币贷款增量 = auto()  # 注意单位: 折合人民币, 亿元
    AFRE_委托贷款增量 = auto()  # 注意单位: 亿元
    AFRE_信托贷款增量 = auto()  # 注意单位: 亿元
    AFRE_未贴现银行承兑汇票增量 = auto()  # 注意单位: 亿元
    AFRE_企业债券增量 = auto()  # 注意单位: 亿元
    AFRE_非金融企业境内股票融资增量 = auto()  # 注意单位: 亿元

    """
    ----------------------------------------------------------------
    百度指数 BAIN
    ----------------------------------------------------------------
    """

    BAIN_搜索指数 = auto()
    BAIN_资讯指数 = auto()

    def __repr__(self):
        return self.name

    __str__ = __repr__


__all__ = ["Field"]
