# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessPolicyArgs', 'AccessPolicy']

@pulumi.input_type
class AccessPolicyArgs:
    def __init__(__self__, *,
                 realms: pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]],
                 region: pulumi.Input[builtins.str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccessPolicy resource.
        :param pulumi.Input[builtins.str] region: Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]] conditions: Conditions for the access policy.
        :param pulumi.Input[builtins.str] display_name: Display name of the access policy. Defaults to the name.
        :param pulumi.Input[builtins.str] name: Name of the access policy.
        """
        pulumi.set(__self__, "realms", realms)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "scopes", scopes)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def realms(self) -> pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]]:
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]]):
        pulumi.set(self, "realms", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]]:
        """
        Conditions for the access policy.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the access policy. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AccessPolicyState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]] conditions: Conditions for the access policy.
        :param pulumi.Input[builtins.str] created_at: Creation date of the access policy.
        :param pulumi.Input[builtins.str] display_name: Display name of the access policy. Defaults to the name.
        :param pulumi.Input[builtins.str] name: Name of the access policy.
        :param pulumi.Input[builtins.str] policy_id: ID of the access policy.
        :param pulumi.Input[builtins.str] region: Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        :param pulumi.Input[builtins.str] updated_at: Last update date of the access policy.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if realms is not None:
            pulumi.set(__self__, "realms", realms)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]]:
        """
        Conditions for the access policy.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date of the access policy.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the access policy. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the access policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def realms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]]]:
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRealmArgs']]]]):
        pulumi.set(self, "realms", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last update date of the access policy.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("grafana:cloud/accessPolicy:AccessPolicy")
class AccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyConditionArgs', 'AccessPolicyConditionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRealmArgs', 'AccessPolicyRealmArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-an-access-policy)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_organization(slug="<your org slug>")
        test = grafana.cloud.AccessPolicy("test",
            region="prod-us-east-0",
            name="my-policy",
            display_name="My Policy",
            scopes=[
                "metrics:read",
                "logs:read",
            ],
            realms=[{
                "type": "org",
                "identifier": current.id,
                "label_policies": [{
                    "selector": "{namespace=\\"default\\"}",
                }],
            }])
        test_access_policy_token = grafana.cloud.AccessPolicyToken("test",
            region="prod-us-east-0",
            access_policy_id=test.policy_id,
            name="my-policy-token",
            display_name="My Policy Token",
            expires_at="2023-01-01T00:00:00Z")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/accessPolicy:AccessPolicy name "{{ region }}:{{ policyId }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyConditionArgs', 'AccessPolicyConditionArgsDict']]]] conditions: Conditions for the access policy.
        :param pulumi.Input[builtins.str] display_name: Display name of the access policy. Defaults to the name.
        :param pulumi.Input[builtins.str] name: Name of the access policy.
        :param pulumi.Input[builtins.str] region: Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-an-access-policy)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_organization(slug="<your org slug>")
        test = grafana.cloud.AccessPolicy("test",
            region="prod-us-east-0",
            name="my-policy",
            display_name="My Policy",
            scopes=[
                "metrics:read",
                "logs:read",
            ],
            realms=[{
                "type": "org",
                "identifier": current.id,
                "label_policies": [{
                    "selector": "{namespace=\\"default\\"}",
                }],
            }])
        test_access_policy_token = grafana.cloud.AccessPolicyToken("test",
            region="prod-us-east-0",
            access_policy_id=test.policy_id,
            name="my-policy-token",
            display_name="My Policy Token",
            expires_at="2023-01-01T00:00:00Z")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/accessPolicy:AccessPolicy name "{{ region }}:{{ policyId }}"
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyConditionArgs', 'AccessPolicyConditionArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRealmArgs', 'AccessPolicyRealmArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyArgs.__new__(AccessPolicyArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            if realms is None and not opts.urn:
                raise TypeError("Missing required property 'realms'")
            __props__.__dict__["realms"] = realms
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["created_at"] = None
            __props__.__dict__["policy_id"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/cloudAccessPolicy:CloudAccessPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(AccessPolicy, __self__).__init__(
            'grafana:cloud/accessPolicy:AccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyConditionArgs', 'AccessPolicyConditionArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            realms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRealmArgs', 'AccessPolicyRealmArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'AccessPolicy':
        """
        Get an existing AccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyConditionArgs', 'AccessPolicyConditionArgsDict']]]] conditions: Conditions for the access policy.
        :param pulumi.Input[builtins.str] created_at: Creation date of the access policy.
        :param pulumi.Input[builtins.str] display_name: Display name of the access policy. Defaults to the name.
        :param pulumi.Input[builtins.str] name: Name of the access policy.
        :param pulumi.Input[builtins.str] policy_id: ID of the access policy.
        :param pulumi.Input[builtins.str] region: Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        :param pulumi.Input[builtins.str] updated_at: Last update date of the access policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyState.__new__(_AccessPolicyState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["realms"] = realms
        __props__.__dict__["region"] = region
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["updated_at"] = updated_at
        return AccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.AccessPolicyCondition']]]:
        """
        Conditions for the access policy.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation date of the access policy.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display name of the access policy. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the access policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the access policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def realms(self) -> pulumi.Output[Sequence['outputs.AccessPolicyRealm']]:
        return pulumi.get(self, "realms")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where the API is deployed. Generally where the stack is deployed. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Scopes of the access policy. See https://grafana.com/docs/grafana-cloud/security-and-account-management/authentication-and-permissions/access-policies/#scopes for possible values.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Last update date of the access policy.
        """
        return pulumi.get(self, "updated_at")

