# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIpsResult',
    'AwaitableGetIpsResult',
    'get_ips',
    'get_ips_output',
]

@pulumi.output_type
class GetIpsResult:
    """
    A collection of values returned by getIps.
    """
    def __init__(__self__, hosted_alerts=None, hosted_grafanas=None, hosted_logs=None, hosted_metrics=None, hosted_traces=None, id=None):
        if hosted_alerts and not isinstance(hosted_alerts, list):
            raise TypeError("Expected argument 'hosted_alerts' to be a list")
        pulumi.set(__self__, "hosted_alerts", hosted_alerts)
        if hosted_grafanas and not isinstance(hosted_grafanas, list):
            raise TypeError("Expected argument 'hosted_grafanas' to be a list")
        pulumi.set(__self__, "hosted_grafanas", hosted_grafanas)
        if hosted_logs and not isinstance(hosted_logs, list):
            raise TypeError("Expected argument 'hosted_logs' to be a list")
        pulumi.set(__self__, "hosted_logs", hosted_logs)
        if hosted_metrics and not isinstance(hosted_metrics, list):
            raise TypeError("Expected argument 'hosted_metrics' to be a list")
        pulumi.set(__self__, "hosted_metrics", hosted_metrics)
        if hosted_traces and not isinstance(hosted_traces, list):
            raise TypeError("Expected argument 'hosted_traces' to be a list")
        pulumi.set(__self__, "hosted_traces", hosted_traces)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="hostedAlerts")
    def hosted_alerts(self) -> Sequence[builtins.str]:
        """
        Set of IP addresses that are used for hosted alerts.
        """
        return pulumi.get(self, "hosted_alerts")

    @property
    @pulumi.getter(name="hostedGrafanas")
    def hosted_grafanas(self) -> Sequence[builtins.str]:
        """
        Set of IP addresses that are used for hosted Grafana.
        """
        return pulumi.get(self, "hosted_grafanas")

    @property
    @pulumi.getter(name="hostedLogs")
    def hosted_logs(self) -> Sequence[builtins.str]:
        """
        Set of IP addresses that are used for hosted logs.
        """
        return pulumi.get(self, "hosted_logs")

    @property
    @pulumi.getter(name="hostedMetrics")
    def hosted_metrics(self) -> Sequence[builtins.str]:
        """
        Set of IP addresses that are used for hosted metrics.
        """
        return pulumi.get(self, "hosted_metrics")

    @property
    @pulumi.getter(name="hostedTraces")
    def hosted_traces(self) -> Sequence[builtins.str]:
        """
        Set of IP addresses that are used for hosted traces.
        """
        return pulumi.get(self, "hosted_traces")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetIpsResult(GetIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsResult(
            hosted_alerts=self.hosted_alerts,
            hosted_grafanas=self.hosted_grafanas,
            hosted_logs=self.hosted_logs,
            hosted_metrics=self.hosted_metrics,
            hosted_traces=self.hosted_traces,
            id=self.id)


def get_ips(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsResult:
    """
    Data source for retrieving sets of cloud IPs. See https://grafana.com/docs/grafana-cloud/reference/allow-list/ for more info

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.cloud.get_ips()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:cloud/getIps:getIps', __args__, opts=opts, typ=GetIpsResult).value

    return AwaitableGetIpsResult(
        hosted_alerts=pulumi.get(__ret__, 'hosted_alerts'),
        hosted_grafanas=pulumi.get(__ret__, 'hosted_grafanas'),
        hosted_logs=pulumi.get(__ret__, 'hosted_logs'),
        hosted_metrics=pulumi.get(__ret__, 'hosted_metrics'),
        hosted_traces=pulumi.get(__ret__, 'hosted_traces'),
        id=pulumi.get(__ret__, 'id'))
def get_ips_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsResult]:
    """
    Data source for retrieving sets of cloud IPs. See https://grafana.com/docs/grafana-cloud/reference/allow-list/ for more info

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.cloud.get_ips()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:cloud/getIps:getIps', __args__, opts=opts, typ=GetIpsResult)
    return __ret__.apply(lambda __response__: GetIpsResult(
        hosted_alerts=pulumi.get(__response__, 'hosted_alerts'),
        hosted_grafanas=pulumi.get(__response__, 'hosted_grafanas'),
        hosted_logs=pulumi.get(__response__, 'hosted_logs'),
        hosted_metrics=pulumi.get(__response__, 'hosted_metrics'),
        hosted_traces=pulumi.get(__response__, 'hosted_traces'),
        id=pulumi.get(__response__, 'id')))
