# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProviderAwsAccountResult',
    'AwaitableGetProviderAwsAccountResult',
    'get_provider_aws_account',
    'get_provider_aws_account_output',
]

warnings.warn("""grafana.cloud/getproviderawsaccount.getProviderAwsAccount has been deprecated in favor of grafana.cloudprovider/getawsaccount.getAwsAccount""", DeprecationWarning)

@pulumi.output_type
class GetProviderAwsAccountResult:
    """
    A collection of values returned by getProviderAwsAccount.
    """
    def __init__(__self__, id=None, name=None, regions=None, resource_id=None, role_arn=None, stack_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if stack_id and not isinstance(stack_id, str):
            raise TypeError("Expected argument 'stack_id' to be a str")
        pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        An optional human-readable name for this AWS Account resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        A set of regions that this AWS Account resource applies to.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The ID given by the Grafana Cloud Provider API to this AWS Account resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        An IAM Role ARN string to represent with this AWS Account resource.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> builtins.str:
        return pulumi.get(self, "stack_id")


class AwaitableGetProviderAwsAccountResult(GetProviderAwsAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProviderAwsAccountResult(
            id=self.id,
            name=self.name,
            regions=self.regions,
            resource_id=self.resource_id,
            role_arn=self.role_arn,
            stack_id=self.stack_id)


def get_provider_aws_account(resource_id: Optional[builtins.str] = None,
                             stack_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProviderAwsAccountResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.cloud.get_stack(slug="gcloudstacktest")
    test_aws_account = grafana.cloud_provider.AwsAccount("test",
        stack_id=test.id,
        role_arn=test_aws_iam_role["arn"],
        regions=[
            "us-east-2",
            "eu-west-3",
        ])
    test_get_aws_account = test_aws_account.resource_id.apply(lambda resource_id: grafana.cloudProvider.get_aws_account(stack_id=test.id,
        resource_id=resource_id))
    ```


    :param builtins.str resource_id: The ID given by the Grafana Cloud Provider API to this AWS Account resource.
    """
    pulumi.log.warn("""get_provider_aws_account is deprecated: grafana.cloud/getproviderawsaccount.getProviderAwsAccount has been deprecated in favor of grafana.cloudprovider/getawsaccount.getAwsAccount""")
    __args__ = dict()
    __args__['resourceId'] = resource_id
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:cloud/getProviderAwsAccount:getProviderAwsAccount', __args__, opts=opts, typ=GetProviderAwsAccountResult).value

    return AwaitableGetProviderAwsAccountResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        regions=pulumi.get(__ret__, 'regions'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        stack_id=pulumi.get(__ret__, 'stack_id'))
def get_provider_aws_account_output(resource_id: Optional[pulumi.Input[builtins.str]] = None,
                                    stack_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProviderAwsAccountResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.cloud.get_stack(slug="gcloudstacktest")
    test_aws_account = grafana.cloud_provider.AwsAccount("test",
        stack_id=test.id,
        role_arn=test_aws_iam_role["arn"],
        regions=[
            "us-east-2",
            "eu-west-3",
        ])
    test_get_aws_account = test_aws_account.resource_id.apply(lambda resource_id: grafana.cloudProvider.get_aws_account(stack_id=test.id,
        resource_id=resource_id))
    ```


    :param builtins.str resource_id: The ID given by the Grafana Cloud Provider API to this AWS Account resource.
    """
    pulumi.log.warn("""get_provider_aws_account is deprecated: grafana.cloud/getproviderawsaccount.getProviderAwsAccount has been deprecated in favor of grafana.cloudprovider/getawsaccount.getAwsAccount""")
    __args__ = dict()
    __args__['resourceId'] = resource_id
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:cloud/getProviderAwsAccount:getProviderAwsAccount', __args__, opts=opts, typ=GetProviderAwsAccountResult)
    return __ret__.apply(lambda __response__: GetProviderAwsAccountResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        regions=pulumi.get(__response__, 'regions'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        stack_id=pulumi.get(__response__, 'stack_id')))
