# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 slug: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[builtins.bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param pulumi.Input[builtins.str] slug: Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        :param pulumi.Input[builtins.str] description: Description of stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        :param pulumi.Input[builtins.str] name: Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        :param pulumi.Input[builtins.str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[builtins.bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[builtins.str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        pulumi.set(__self__, "slug", slug)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_slug is not None:
            pulumi.set(__self__, "region_slug", region_slug)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if wait_for_readiness is not None:
            pulumi.set(__self__, "wait_for_readiness", wait_for_readiness)
        if wait_for_readiness_timeout is not None:
            pulumi.set(__self__, "wait_for_readiness_timeout", wait_for_readiness_timeout)

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Input[builtins.str]:
        """
        Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_slug", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @wait_for_readiness.setter
    def wait_for_readiness(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wait_for_readiness", value)

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

    @wait_for_readiness_timeout.setter
    def wait_for_readiness_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wait_for_readiness_timeout", value)


@pulumi.input_type
class _StackState:
    def __init__(__self__, *,
                 alertmanager_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 alertmanager_name: Optional[pulumi.Input[builtins.str]] = None,
                 alertmanager_status: Optional[pulumi.Input[builtins.str]] = None,
                 alertmanager_url: Optional[pulumi.Input[builtins.str]] = None,
                 alertmanager_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_slug: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_management_status: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_management_url: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_management_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 grafanas_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_name: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_status: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_url: Optional[pulumi.Input[builtins.str]] = None,
                 graphite_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 influx_url: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 logs_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 logs_name: Optional[pulumi.Input[builtins.str]] = None,
                 logs_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 logs_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 logs_status: Optional[pulumi.Input[builtins.str]] = None,
                 logs_url: Optional[pulumi.Input[builtins.str]] = None,
                 logs_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.int]] = None,
                 org_name: Optional[pulumi.Input[builtins.str]] = None,
                 org_slug: Optional[pulumi.Input[builtins.str]] = None,
                 otlp_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 otlp_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 otlp_url: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_api_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_api_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_gateway_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_gateway_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_name: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_status: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_url: Optional[pulumi.Input[builtins.str]] = None,
                 profiles_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 prometheus_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_name: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_remote_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_remote_write_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_status: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_url: Optional[pulumi.Input[builtins.str]] = None,
                 prometheus_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 region_slug: Optional[pulumi.Input[builtins.str]] = None,
                 slug: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 traces_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
                 traces_name: Optional[pulumi.Input[builtins.str]] = None,
                 traces_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 traces_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 traces_status: Optional[pulumi.Input[builtins.str]] = None,
                 traces_url: Optional[pulumi.Input[builtins.str]] = None,
                 traces_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[builtins.bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Stack resources.
        :param pulumi.Input[builtins.str] alertmanager_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Alertmanager instances (Optional)
        :param pulumi.Input[builtins.str] alertmanager_name: Name of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] alertmanager_status: Status of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] alertmanager_url: Base URL of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.int] alertmanager_user_id: User ID of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] cluster_slug: Slug of the cluster where this stack resides.
        :param pulumi.Input[builtins.str] description: Description of stack.
        :param pulumi.Input[builtins.str] fleet_management_name: Name of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] fleet_management_status: Status of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] fleet_management_url: Base URL of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.int] fleet_management_user_id: User ID of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] grafanas_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the grafana instance (Optional)
        :param pulumi.Input[builtins.str] graphite_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Graphite instance (Optional)
        :param pulumi.Input[builtins.str] graphite_private_connectivity_info_private_dns: Private DNS for Graphite when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] graphite_private_connectivity_info_service_name: Service Name for Graphite when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] influx_url: Base URL of the InfluxDB instance configured for this stack. The username is the same as the metrics' (`prometheus_user_id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/metrics/metrics-influxdb/push-from-telegraf/ for docs on how to use this.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        :param pulumi.Input[builtins.str] logs_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Logs instance (Optional)
        :param pulumi.Input[builtins.str] logs_private_connectivity_info_private_dns: Private DNS for Logs when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] logs_private_connectivity_info_service_name: Service Name for Logs when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] name: Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        :param pulumi.Input[builtins.int] org_id: Organization id to assign to this stack.
        :param pulumi.Input[builtins.str] org_name: Organization name to assign to this stack.
        :param pulumi.Input[builtins.str] org_slug: Organization slug to assign to this stack.
        :param pulumi.Input[builtins.str] otlp_private_connectivity_info_private_dns: Private DNS for OTLP when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] otlp_private_connectivity_info_service_name: Service Name for OTLP when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] otlp_url: Base URL of the OTLP instance configured for this stack. The username is the stack's ID (`id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/otlp/send-data-otlp/ for docs on how to use this.
        :param pulumi.Input[builtins.str] pdc_api_private_connectivity_info_private_dns: Private DNS for PDC's API when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_api_private_connectivity_info_service_name: Service Name for PDC's API when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_gateway_private_connectivity_info_private_dns: Private DNS for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_gateway_private_connectivity_info_service_name: Service Name for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] profiles_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Profiles instance (Optional)
        :param pulumi.Input[builtins.str] profiles_private_connectivity_info_private_dns: Private DNS for Profiles when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] profiles_private_connectivity_info_service_name: Service Name for Profiles when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Prometheus instance (Optional)
        :param pulumi.Input[builtins.str] prometheus_name: Prometheus name for this instance.
        :param pulumi.Input[builtins.str] prometheus_private_connectivity_info_private_dns: Private DNS for Prometheus when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_private_connectivity_info_service_name: Service Name for Prometheus when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_remote_endpoint: Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        :param pulumi.Input[builtins.str] prometheus_remote_write_endpoint: Use this URL to send prometheus metrics to Grafana cloud
        :param pulumi.Input[builtins.str] prometheus_status: Prometheus status for this instance.
        :param pulumi.Input[builtins.str] prometheus_url: Prometheus url for this instance.
        :param pulumi.Input[builtins.int] prometheus_user_id: Prometheus user ID. Used for e.g. remote_write.
        :param pulumi.Input[builtins.str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] slug: Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        :param pulumi.Input[builtins.str] status: Status of the stack.
        :param pulumi.Input[builtins.str] traces_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Traces instance (Optional)
        :param pulumi.Input[builtins.str] traces_private_connectivity_info_private_dns: Private DNS for Traces when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] traces_private_connectivity_info_service_name: Service Name for Traces when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] traces_url: Base URL of the Traces instance configured for this stack. To use this in the Tempo data source in Grafana, append `/tempo` to the URL.
        :param pulumi.Input[builtins.str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[builtins.bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[builtins.str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        if alertmanager_ip_allow_list_cname is not None:
            pulumi.set(__self__, "alertmanager_ip_allow_list_cname", alertmanager_ip_allow_list_cname)
        if alertmanager_name is not None:
            pulumi.set(__self__, "alertmanager_name", alertmanager_name)
        if alertmanager_status is not None:
            pulumi.set(__self__, "alertmanager_status", alertmanager_status)
        if alertmanager_url is not None:
            pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        if alertmanager_user_id is not None:
            pulumi.set(__self__, "alertmanager_user_id", alertmanager_user_id)
        if cluster_slug is not None:
            pulumi.set(__self__, "cluster_slug", cluster_slug)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fleet_management_name is not None:
            pulumi.set(__self__, "fleet_management_name", fleet_management_name)
        if fleet_management_status is not None:
            pulumi.set(__self__, "fleet_management_status", fleet_management_status)
        if fleet_management_url is not None:
            pulumi.set(__self__, "fleet_management_url", fleet_management_url)
        if fleet_management_user_id is not None:
            pulumi.set(__self__, "fleet_management_user_id", fleet_management_user_id)
        if grafanas_ip_allow_list_cname is not None:
            pulumi.set(__self__, "grafanas_ip_allow_list_cname", grafanas_ip_allow_list_cname)
        if graphite_ip_allow_list_cname is not None:
            pulumi.set(__self__, "graphite_ip_allow_list_cname", graphite_ip_allow_list_cname)
        if graphite_name is not None:
            pulumi.set(__self__, "graphite_name", graphite_name)
        if graphite_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "graphite_private_connectivity_info_private_dns", graphite_private_connectivity_info_private_dns)
        if graphite_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "graphite_private_connectivity_info_service_name", graphite_private_connectivity_info_service_name)
        if graphite_status is not None:
            pulumi.set(__self__, "graphite_status", graphite_status)
        if graphite_url is not None:
            pulumi.set(__self__, "graphite_url", graphite_url)
        if graphite_user_id is not None:
            pulumi.set(__self__, "graphite_user_id", graphite_user_id)
        if influx_url is not None:
            pulumi.set(__self__, "influx_url", influx_url)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logs_ip_allow_list_cname is not None:
            pulumi.set(__self__, "logs_ip_allow_list_cname", logs_ip_allow_list_cname)
        if logs_name is not None:
            pulumi.set(__self__, "logs_name", logs_name)
        if logs_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "logs_private_connectivity_info_private_dns", logs_private_connectivity_info_private_dns)
        if logs_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "logs_private_connectivity_info_service_name", logs_private_connectivity_info_service_name)
        if logs_status is not None:
            pulumi.set(__self__, "logs_status", logs_status)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if logs_user_id is not None:
            pulumi.set(__self__, "logs_user_id", logs_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if org_name is not None:
            pulumi.set(__self__, "org_name", org_name)
        if org_slug is not None:
            pulumi.set(__self__, "org_slug", org_slug)
        if otlp_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "otlp_private_connectivity_info_private_dns", otlp_private_connectivity_info_private_dns)
        if otlp_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "otlp_private_connectivity_info_service_name", otlp_private_connectivity_info_service_name)
        if otlp_url is not None:
            pulumi.set(__self__, "otlp_url", otlp_url)
        if pdc_api_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "pdc_api_private_connectivity_info_private_dns", pdc_api_private_connectivity_info_private_dns)
        if pdc_api_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "pdc_api_private_connectivity_info_service_name", pdc_api_private_connectivity_info_service_name)
        if pdc_gateway_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "pdc_gateway_private_connectivity_info_private_dns", pdc_gateway_private_connectivity_info_private_dns)
        if pdc_gateway_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "pdc_gateway_private_connectivity_info_service_name", pdc_gateway_private_connectivity_info_service_name)
        if profiles_ip_allow_list_cname is not None:
            pulumi.set(__self__, "profiles_ip_allow_list_cname", profiles_ip_allow_list_cname)
        if profiles_name is not None:
            pulumi.set(__self__, "profiles_name", profiles_name)
        if profiles_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "profiles_private_connectivity_info_private_dns", profiles_private_connectivity_info_private_dns)
        if profiles_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "profiles_private_connectivity_info_service_name", profiles_private_connectivity_info_service_name)
        if profiles_status is not None:
            pulumi.set(__self__, "profiles_status", profiles_status)
        if profiles_url is not None:
            pulumi.set(__self__, "profiles_url", profiles_url)
        if profiles_user_id is not None:
            pulumi.set(__self__, "profiles_user_id", profiles_user_id)
        if prometheus_ip_allow_list_cname is not None:
            pulumi.set(__self__, "prometheus_ip_allow_list_cname", prometheus_ip_allow_list_cname)
        if prometheus_name is not None:
            pulumi.set(__self__, "prometheus_name", prometheus_name)
        if prometheus_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "prometheus_private_connectivity_info_private_dns", prometheus_private_connectivity_info_private_dns)
        if prometheus_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "prometheus_private_connectivity_info_service_name", prometheus_private_connectivity_info_service_name)
        if prometheus_remote_endpoint is not None:
            pulumi.set(__self__, "prometheus_remote_endpoint", prometheus_remote_endpoint)
        if prometheus_remote_write_endpoint is not None:
            pulumi.set(__self__, "prometheus_remote_write_endpoint", prometheus_remote_write_endpoint)
        if prometheus_status is not None:
            pulumi.set(__self__, "prometheus_status", prometheus_status)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if prometheus_user_id is not None:
            pulumi.set(__self__, "prometheus_user_id", prometheus_user_id)
        if region_slug is not None:
            pulumi.set(__self__, "region_slug", region_slug)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traces_ip_allow_list_cname is not None:
            pulumi.set(__self__, "traces_ip_allow_list_cname", traces_ip_allow_list_cname)
        if traces_name is not None:
            pulumi.set(__self__, "traces_name", traces_name)
        if traces_private_connectivity_info_private_dns is not None:
            pulumi.set(__self__, "traces_private_connectivity_info_private_dns", traces_private_connectivity_info_private_dns)
        if traces_private_connectivity_info_service_name is not None:
            pulumi.set(__self__, "traces_private_connectivity_info_service_name", traces_private_connectivity_info_service_name)
        if traces_status is not None:
            pulumi.set(__self__, "traces_status", traces_status)
        if traces_url is not None:
            pulumi.set(__self__, "traces_url", traces_url)
        if traces_user_id is not None:
            pulumi.set(__self__, "traces_user_id", traces_user_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if wait_for_readiness is not None:
            pulumi.set(__self__, "wait_for_readiness", wait_for_readiness)
        if wait_for_readiness_timeout is not None:
            pulumi.set(__self__, "wait_for_readiness_timeout", wait_for_readiness_timeout)

    @property
    @pulumi.getter(name="alertmanagerIpAllowListCname")
    def alertmanager_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Alertmanager instances (Optional)
        """
        return pulumi.get(self, "alertmanager_ip_allow_list_cname")

    @alertmanager_ip_allow_list_cname.setter
    def alertmanager_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alertmanager_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="alertmanagerName")
    def alertmanager_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_name")

    @alertmanager_name.setter
    def alertmanager_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alertmanager_name", value)

    @property
    @pulumi.getter(name="alertmanagerStatus")
    def alertmanager_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_status")

    @alertmanager_status.setter
    def alertmanager_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alertmanager_status", value)

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_url")

    @alertmanager_url.setter
    def alertmanager_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alertmanager_url", value)

    @property
    @pulumi.getter(name="alertmanagerUserId")
    def alertmanager_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        User ID of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_user_id")

    @alertmanager_user_id.setter
    def alertmanager_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "alertmanager_user_id", value)

    @property
    @pulumi.getter(name="clusterSlug")
    def cluster_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Slug of the cluster where this stack resides.
        """
        return pulumi.get(self, "cluster_slug")

    @cluster_slug.setter
    def cluster_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_slug", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fleetManagementName")
    def fleet_management_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_name")

    @fleet_management_name.setter
    def fleet_management_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_management_name", value)

    @property
    @pulumi.getter(name="fleetManagementStatus")
    def fleet_management_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_status")

    @fleet_management_status.setter
    def fleet_management_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_management_status", value)

    @property
    @pulumi.getter(name="fleetManagementUrl")
    def fleet_management_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_url")

    @fleet_management_url.setter
    def fleet_management_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_management_url", value)

    @property
    @pulumi.getter(name="fleetManagementUserId")
    def fleet_management_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        User ID of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_user_id")

    @fleet_management_user_id.setter
    def fleet_management_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fleet_management_user_id", value)

    @property
    @pulumi.getter(name="grafanasIpAllowListCname")
    def grafanas_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the grafana instance (Optional)
        """
        return pulumi.get(self, "grafanas_ip_allow_list_cname")

    @grafanas_ip_allow_list_cname.setter
    def grafanas_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grafanas_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="graphiteIpAllowListCname")
    def graphite_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Graphite instance (Optional)
        """
        return pulumi.get(self, "graphite_ip_allow_list_cname")

    @graphite_ip_allow_list_cname.setter
    def graphite_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="graphiteName")
    def graphite_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "graphite_name")

    @graphite_name.setter
    def graphite_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_name", value)

    @property
    @pulumi.getter(name="graphitePrivateConnectivityInfoPrivateDns")
    def graphite_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for Graphite when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "graphite_private_connectivity_info_private_dns")

    @graphite_private_connectivity_info_private_dns.setter
    def graphite_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="graphitePrivateConnectivityInfoServiceName")
    def graphite_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for Graphite when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "graphite_private_connectivity_info_service_name")

    @graphite_private_connectivity_info_service_name.setter
    def graphite_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="graphiteStatus")
    def graphite_status(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "graphite_status")

    @graphite_status.setter
    def graphite_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_status", value)

    @property
    @pulumi.getter(name="graphiteUrl")
    def graphite_url(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "graphite_url")

    @graphite_url.setter
    def graphite_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graphite_url", value)

    @property
    @pulumi.getter(name="graphiteUserId")
    def graphite_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "graphite_user_id")

    @graphite_user_id.setter
    def graphite_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "graphite_user_id", value)

    @property
    @pulumi.getter(name="influxUrl")
    def influx_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of the InfluxDB instance configured for this stack. The username is the same as the metrics' (`prometheus_user_id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/metrics/metrics-influxdb/push-from-telegraf/ for docs on how to use this.
        """
        return pulumi.get(self, "influx_url")

    @influx_url.setter
    def influx_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "influx_url", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logsIpAllowListCname")
    def logs_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Logs instance (Optional)
        """
        return pulumi.get(self, "logs_ip_allow_list_cname")

    @logs_ip_allow_list_cname.setter
    def logs_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="logsName")
    def logs_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "logs_name")

    @logs_name.setter
    def logs_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_name", value)

    @property
    @pulumi.getter(name="logsPrivateConnectivityInfoPrivateDns")
    def logs_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for Logs when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "logs_private_connectivity_info_private_dns")

    @logs_private_connectivity_info_private_dns.setter
    def logs_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="logsPrivateConnectivityInfoServiceName")
    def logs_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for Logs when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "logs_private_connectivity_info_service_name")

    @logs_private_connectivity_info_service_name.setter
    def logs_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="logsStatus")
    def logs_status(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "logs_status")

    @logs_status.setter
    def logs_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_status", value)

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "logs_url")

    @logs_url.setter
    def logs_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_url", value)

    @property
    @pulumi.getter(name="logsUserId")
    def logs_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "logs_user_id")

    @logs_user_id.setter
    def logs_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "logs_user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Organization id to assign to this stack.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="orgName")
    def org_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization name to assign to this stack.
        """
        return pulumi.get(self, "org_name")

    @org_name.setter
    def org_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_name", value)

    @property
    @pulumi.getter(name="orgSlug")
    def org_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization slug to assign to this stack.
        """
        return pulumi.get(self, "org_slug")

    @org_slug.setter
    def org_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_slug", value)

    @property
    @pulumi.getter(name="otlpPrivateConnectivityInfoPrivateDns")
    def otlp_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for OTLP when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "otlp_private_connectivity_info_private_dns")

    @otlp_private_connectivity_info_private_dns.setter
    def otlp_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "otlp_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="otlpPrivateConnectivityInfoServiceName")
    def otlp_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for OTLP when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "otlp_private_connectivity_info_service_name")

    @otlp_private_connectivity_info_service_name.setter
    def otlp_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "otlp_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="otlpUrl")
    def otlp_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of the OTLP instance configured for this stack. The username is the stack's ID (`id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/otlp/send-data-otlp/ for docs on how to use this.
        """
        return pulumi.get(self, "otlp_url")

    @otlp_url.setter
    def otlp_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "otlp_url", value)

    @property
    @pulumi.getter(name="pdcApiPrivateConnectivityInfoPrivateDns")
    def pdc_api_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for PDC's API when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_api_private_connectivity_info_private_dns")

    @pdc_api_private_connectivity_info_private_dns.setter
    def pdc_api_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdc_api_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="pdcApiPrivateConnectivityInfoServiceName")
    def pdc_api_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for PDC's API when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_api_private_connectivity_info_service_name")

    @pdc_api_private_connectivity_info_service_name.setter
    def pdc_api_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdc_api_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="pdcGatewayPrivateConnectivityInfoPrivateDns")
    def pdc_gateway_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_gateway_private_connectivity_info_private_dns")

    @pdc_gateway_private_connectivity_info_private_dns.setter
    def pdc_gateway_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdc_gateway_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="pdcGatewayPrivateConnectivityInfoServiceName")
    def pdc_gateway_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_gateway_private_connectivity_info_service_name")

    @pdc_gateway_private_connectivity_info_service_name.setter
    def pdc_gateway_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdc_gateway_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="profilesIpAllowListCname")
    def profiles_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Profiles instance (Optional)
        """
        return pulumi.get(self, "profiles_ip_allow_list_cname")

    @profiles_ip_allow_list_cname.setter
    def profiles_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="profilesName")
    def profiles_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "profiles_name")

    @profiles_name.setter
    def profiles_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_name", value)

    @property
    @pulumi.getter(name="profilesPrivateConnectivityInfoPrivateDns")
    def profiles_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for Profiles when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "profiles_private_connectivity_info_private_dns")

    @profiles_private_connectivity_info_private_dns.setter
    def profiles_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="profilesPrivateConnectivityInfoServiceName")
    def profiles_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for Profiles when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "profiles_private_connectivity_info_service_name")

    @profiles_private_connectivity_info_service_name.setter
    def profiles_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="profilesStatus")
    def profiles_status(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "profiles_status")

    @profiles_status.setter
    def profiles_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_status", value)

    @property
    @pulumi.getter(name="profilesUrl")
    def profiles_url(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "profiles_url")

    @profiles_url.setter
    def profiles_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profiles_url", value)

    @property
    @pulumi.getter(name="profilesUserId")
    def profiles_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "profiles_user_id")

    @profiles_user_id.setter
    def profiles_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "profiles_user_id", value)

    @property
    @pulumi.getter(name="prometheusIpAllowListCname")
    def prometheus_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Prometheus instance (Optional)
        """
        return pulumi.get(self, "prometheus_ip_allow_list_cname")

    @prometheus_ip_allow_list_cname.setter
    def prometheus_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="prometheusName")
    def prometheus_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus name for this instance.
        """
        return pulumi.get(self, "prometheus_name")

    @prometheus_name.setter
    def prometheus_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_name", value)

    @property
    @pulumi.getter(name="prometheusPrivateConnectivityInfoPrivateDns")
    def prometheus_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for Prometheus when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "prometheus_private_connectivity_info_private_dns")

    @prometheus_private_connectivity_info_private_dns.setter
    def prometheus_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="prometheusPrivateConnectivityInfoServiceName")
    def prometheus_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for Prometheus when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "prometheus_private_connectivity_info_service_name")

    @prometheus_private_connectivity_info_service_name.setter
    def prometheus_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="prometheusRemoteEndpoint")
    def prometheus_remote_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        """
        return pulumi.get(self, "prometheus_remote_endpoint")

    @prometheus_remote_endpoint.setter
    def prometheus_remote_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_remote_endpoint", value)

    @property
    @pulumi.getter(name="prometheusRemoteWriteEndpoint")
    def prometheus_remote_write_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use this URL to send prometheus metrics to Grafana cloud
        """
        return pulumi.get(self, "prometheus_remote_write_endpoint")

    @prometheus_remote_write_endpoint.setter
    def prometheus_remote_write_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_remote_write_endpoint", value)

    @property
    @pulumi.getter(name="prometheusStatus")
    def prometheus_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus status for this instance.
        """
        return pulumi.get(self, "prometheus_status")

    @prometheus_status.setter
    def prometheus_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_status", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prometheus url for this instance.
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter(name="prometheusUserId")
    def prometheus_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Prometheus user ID. Used for e.g. remote_write.
        """
        return pulumi.get(self, "prometheus_user_id")

    @prometheus_user_id.setter
    def prometheus_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "prometheus_user_id", value)

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_slug", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the stack.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tracesIpAllowListCname")
    def traces_ip_allow_list_cname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Traces instance (Optional)
        """
        return pulumi.get(self, "traces_ip_allow_list_cname")

    @traces_ip_allow_list_cname.setter
    def traces_ip_allow_list_cname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_ip_allow_list_cname", value)

    @property
    @pulumi.getter(name="tracesName")
    def traces_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "traces_name")

    @traces_name.setter
    def traces_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_name", value)

    @property
    @pulumi.getter(name="tracesPrivateConnectivityInfoPrivateDns")
    def traces_private_connectivity_info_private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS for Traces when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "traces_private_connectivity_info_private_dns")

    @traces_private_connectivity_info_private_dns.setter
    def traces_private_connectivity_info_private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_private_connectivity_info_private_dns", value)

    @property
    @pulumi.getter(name="tracesPrivateConnectivityInfoServiceName")
    def traces_private_connectivity_info_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service Name for Traces when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "traces_private_connectivity_info_service_name")

    @traces_private_connectivity_info_service_name.setter
    def traces_private_connectivity_info_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_private_connectivity_info_service_name", value)

    @property
    @pulumi.getter(name="tracesStatus")
    def traces_status(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "traces_status")

    @traces_status.setter
    def traces_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_status", value)

    @property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of the Traces instance configured for this stack. To use this in the Tempo data source in Grafana, append `/tempo` to the URL.
        """
        return pulumi.get(self, "traces_url")

    @traces_url.setter
    def traces_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traces_url", value)

    @property
    @pulumi.getter(name="tracesUserId")
    def traces_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "traces_user_id")

    @traces_user_id.setter
    def traces_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "traces_user_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @wait_for_readiness.setter
    def wait_for_readiness(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wait_for_readiness", value)

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

    @wait_for_readiness_timeout.setter
    def wait_for_readiness_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wait_for_readiness_timeout", value)


@pulumi.type_token("grafana:cloud/stack:Stack")
class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[builtins.str]] = None,
                 slug: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[builtins.bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#stacks/)

        Required access policy scopes:

        * stacks:read
        * stacks:write
        * stacks:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.cloud.Stack("test",
            name="gcloudstacktest",
            slug="gcloudstacktest",
            region_slug="eu",
            description="Test Grafana Cloud Stack")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/stack:Stack name "{{ stackSlugOrID }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        :param pulumi.Input[builtins.str] name: Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        :param pulumi.Input[builtins.str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] slug: Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        :param pulumi.Input[builtins.str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[builtins.bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[builtins.str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#stacks/)

        Required access policy scopes:

        * stacks:read
        * stacks:write
        * stacks:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.cloud.Stack("test",
            name="gcloudstacktest",
            slug="gcloudstacktest",
            region_slug="eu",
            description="Test Grafana Cloud Stack")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/stack:Stack name "{{ stackSlugOrID }}"
        ```

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[builtins.str]] = None,
                 slug: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[builtins.bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["region_slug"] = region_slug
            if slug is None and not opts.urn:
                raise TypeError("Missing required property 'slug'")
            __props__.__dict__["slug"] = slug
            __props__.__dict__["url"] = url
            __props__.__dict__["wait_for_readiness"] = wait_for_readiness
            __props__.__dict__["wait_for_readiness_timeout"] = wait_for_readiness_timeout
            __props__.__dict__["alertmanager_ip_allow_list_cname"] = None
            __props__.__dict__["alertmanager_name"] = None
            __props__.__dict__["alertmanager_status"] = None
            __props__.__dict__["alertmanager_url"] = None
            __props__.__dict__["alertmanager_user_id"] = None
            __props__.__dict__["cluster_slug"] = None
            __props__.__dict__["fleet_management_name"] = None
            __props__.__dict__["fleet_management_status"] = None
            __props__.__dict__["fleet_management_url"] = None
            __props__.__dict__["fleet_management_user_id"] = None
            __props__.__dict__["grafanas_ip_allow_list_cname"] = None
            __props__.__dict__["graphite_ip_allow_list_cname"] = None
            __props__.__dict__["graphite_name"] = None
            __props__.__dict__["graphite_private_connectivity_info_private_dns"] = None
            __props__.__dict__["graphite_private_connectivity_info_service_name"] = None
            __props__.__dict__["graphite_status"] = None
            __props__.__dict__["graphite_url"] = None
            __props__.__dict__["graphite_user_id"] = None
            __props__.__dict__["influx_url"] = None
            __props__.__dict__["logs_ip_allow_list_cname"] = None
            __props__.__dict__["logs_name"] = None
            __props__.__dict__["logs_private_connectivity_info_private_dns"] = None
            __props__.__dict__["logs_private_connectivity_info_service_name"] = None
            __props__.__dict__["logs_status"] = None
            __props__.__dict__["logs_url"] = None
            __props__.__dict__["logs_user_id"] = None
            __props__.__dict__["org_id"] = None
            __props__.__dict__["org_name"] = None
            __props__.__dict__["org_slug"] = None
            __props__.__dict__["otlp_private_connectivity_info_private_dns"] = None
            __props__.__dict__["otlp_private_connectivity_info_service_name"] = None
            __props__.__dict__["otlp_url"] = None
            __props__.__dict__["pdc_api_private_connectivity_info_private_dns"] = None
            __props__.__dict__["pdc_api_private_connectivity_info_service_name"] = None
            __props__.__dict__["pdc_gateway_private_connectivity_info_private_dns"] = None
            __props__.__dict__["pdc_gateway_private_connectivity_info_service_name"] = None
            __props__.__dict__["profiles_ip_allow_list_cname"] = None
            __props__.__dict__["profiles_name"] = None
            __props__.__dict__["profiles_private_connectivity_info_private_dns"] = None
            __props__.__dict__["profiles_private_connectivity_info_service_name"] = None
            __props__.__dict__["profiles_status"] = None
            __props__.__dict__["profiles_url"] = None
            __props__.__dict__["profiles_user_id"] = None
            __props__.__dict__["prometheus_ip_allow_list_cname"] = None
            __props__.__dict__["prometheus_name"] = None
            __props__.__dict__["prometheus_private_connectivity_info_private_dns"] = None
            __props__.__dict__["prometheus_private_connectivity_info_service_name"] = None
            __props__.__dict__["prometheus_remote_endpoint"] = None
            __props__.__dict__["prometheus_remote_write_endpoint"] = None
            __props__.__dict__["prometheus_status"] = None
            __props__.__dict__["prometheus_url"] = None
            __props__.__dict__["prometheus_user_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["traces_ip_allow_list_cname"] = None
            __props__.__dict__["traces_name"] = None
            __props__.__dict__["traces_private_connectivity_info_private_dns"] = None
            __props__.__dict__["traces_private_connectivity_info_service_name"] = None
            __props__.__dict__["traces_status"] = None
            __props__.__dict__["traces_url"] = None
            __props__.__dict__["traces_user_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/cloudStack:CloudStack")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Stack, __self__).__init__(
            'grafana:cloud/stack:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alertmanager_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            alertmanager_name: Optional[pulumi.Input[builtins.str]] = None,
            alertmanager_status: Optional[pulumi.Input[builtins.str]] = None,
            alertmanager_url: Optional[pulumi.Input[builtins.str]] = None,
            alertmanager_user_id: Optional[pulumi.Input[builtins.int]] = None,
            cluster_slug: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fleet_management_name: Optional[pulumi.Input[builtins.str]] = None,
            fleet_management_status: Optional[pulumi.Input[builtins.str]] = None,
            fleet_management_url: Optional[pulumi.Input[builtins.str]] = None,
            fleet_management_user_id: Optional[pulumi.Input[builtins.int]] = None,
            grafanas_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            graphite_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            graphite_name: Optional[pulumi.Input[builtins.str]] = None,
            graphite_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            graphite_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            graphite_status: Optional[pulumi.Input[builtins.str]] = None,
            graphite_url: Optional[pulumi.Input[builtins.str]] = None,
            graphite_user_id: Optional[pulumi.Input[builtins.int]] = None,
            influx_url: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            logs_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            logs_name: Optional[pulumi.Input[builtins.str]] = None,
            logs_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            logs_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            logs_status: Optional[pulumi.Input[builtins.str]] = None,
            logs_url: Optional[pulumi.Input[builtins.str]] = None,
            logs_user_id: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.int]] = None,
            org_name: Optional[pulumi.Input[builtins.str]] = None,
            org_slug: Optional[pulumi.Input[builtins.str]] = None,
            otlp_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            otlp_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            otlp_url: Optional[pulumi.Input[builtins.str]] = None,
            pdc_api_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            pdc_api_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            pdc_gateway_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            pdc_gateway_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            profiles_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            profiles_name: Optional[pulumi.Input[builtins.str]] = None,
            profiles_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            profiles_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            profiles_status: Optional[pulumi.Input[builtins.str]] = None,
            profiles_url: Optional[pulumi.Input[builtins.str]] = None,
            profiles_user_id: Optional[pulumi.Input[builtins.int]] = None,
            prometheus_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_name: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_remote_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_remote_write_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_status: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_url: Optional[pulumi.Input[builtins.str]] = None,
            prometheus_user_id: Optional[pulumi.Input[builtins.int]] = None,
            region_slug: Optional[pulumi.Input[builtins.str]] = None,
            slug: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            traces_ip_allow_list_cname: Optional[pulumi.Input[builtins.str]] = None,
            traces_name: Optional[pulumi.Input[builtins.str]] = None,
            traces_private_connectivity_info_private_dns: Optional[pulumi.Input[builtins.str]] = None,
            traces_private_connectivity_info_service_name: Optional[pulumi.Input[builtins.str]] = None,
            traces_status: Optional[pulumi.Input[builtins.str]] = None,
            traces_url: Optional[pulumi.Input[builtins.str]] = None,
            traces_user_id: Optional[pulumi.Input[builtins.int]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            wait_for_readiness: Optional[pulumi.Input[builtins.bool]] = None,
            wait_for_readiness_timeout: Optional[pulumi.Input[builtins.str]] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alertmanager_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Alertmanager instances (Optional)
        :param pulumi.Input[builtins.str] alertmanager_name: Name of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] alertmanager_status: Status of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] alertmanager_url: Base URL of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.int] alertmanager_user_id: User ID of the Alertmanager instance configured for this stack.
        :param pulumi.Input[builtins.str] cluster_slug: Slug of the cluster where this stack resides.
        :param pulumi.Input[builtins.str] description: Description of stack.
        :param pulumi.Input[builtins.str] fleet_management_name: Name of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] fleet_management_status: Status of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] fleet_management_url: Base URL of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.int] fleet_management_user_id: User ID of the Fleet Management instance configured for this stack.
        :param pulumi.Input[builtins.str] grafanas_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the grafana instance (Optional)
        :param pulumi.Input[builtins.str] graphite_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Graphite instance (Optional)
        :param pulumi.Input[builtins.str] graphite_private_connectivity_info_private_dns: Private DNS for Graphite when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] graphite_private_connectivity_info_service_name: Service Name for Graphite when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] influx_url: Base URL of the InfluxDB instance configured for this stack. The username is the same as the metrics' (`prometheus_user_id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/metrics/metrics-influxdb/push-from-telegraf/ for docs on how to use this.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        :param pulumi.Input[builtins.str] logs_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Logs instance (Optional)
        :param pulumi.Input[builtins.str] logs_private_connectivity_info_private_dns: Private DNS for Logs when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] logs_private_connectivity_info_service_name: Service Name for Logs when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] name: Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        :param pulumi.Input[builtins.int] org_id: Organization id to assign to this stack.
        :param pulumi.Input[builtins.str] org_name: Organization name to assign to this stack.
        :param pulumi.Input[builtins.str] org_slug: Organization slug to assign to this stack.
        :param pulumi.Input[builtins.str] otlp_private_connectivity_info_private_dns: Private DNS for OTLP when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] otlp_private_connectivity_info_service_name: Service Name for OTLP when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] otlp_url: Base URL of the OTLP instance configured for this stack. The username is the stack's ID (`id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/otlp/send-data-otlp/ for docs on how to use this.
        :param pulumi.Input[builtins.str] pdc_api_private_connectivity_info_private_dns: Private DNS for PDC's API when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_api_private_connectivity_info_service_name: Service Name for PDC's API when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_gateway_private_connectivity_info_private_dns: Private DNS for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] pdc_gateway_private_connectivity_info_service_name: Service Name for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] profiles_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Profiles instance (Optional)
        :param pulumi.Input[builtins.str] profiles_private_connectivity_info_private_dns: Private DNS for Profiles when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] profiles_private_connectivity_info_service_name: Service Name for Profiles when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Prometheus instance (Optional)
        :param pulumi.Input[builtins.str] prometheus_name: Prometheus name for this instance.
        :param pulumi.Input[builtins.str] prometheus_private_connectivity_info_private_dns: Private DNS for Prometheus when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_private_connectivity_info_service_name: Service Name for Prometheus when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] prometheus_remote_endpoint: Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        :param pulumi.Input[builtins.str] prometheus_remote_write_endpoint: Use this URL to send prometheus metrics to Grafana cloud
        :param pulumi.Input[builtins.str] prometheus_status: Prometheus status for this instance.
        :param pulumi.Input[builtins.str] prometheus_url: Prometheus url for this instance.
        :param pulumi.Input[builtins.int] prometheus_user_id: Prometheus user ID. Used for e.g. remote_write.
        :param pulumi.Input[builtins.str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] slug: Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        :param pulumi.Input[builtins.str] status: Status of the stack.
        :param pulumi.Input[builtins.str] traces_ip_allow_list_cname: Comma-separated list of CNAMEs that can be whitelisted to access the Traces instance (Optional)
        :param pulumi.Input[builtins.str] traces_private_connectivity_info_private_dns: Private DNS for Traces when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] traces_private_connectivity_info_service_name: Service Name for Traces when using AWS PrivateLink (only for AWS stacks)
        :param pulumi.Input[builtins.str] traces_url: Base URL of the Traces instance configured for this stack. To use this in the Tempo data source in Grafana, append `/tempo` to the URL.
        :param pulumi.Input[builtins.str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[builtins.bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[builtins.str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackState.__new__(_StackState)

        __props__.__dict__["alertmanager_ip_allow_list_cname"] = alertmanager_ip_allow_list_cname
        __props__.__dict__["alertmanager_name"] = alertmanager_name
        __props__.__dict__["alertmanager_status"] = alertmanager_status
        __props__.__dict__["alertmanager_url"] = alertmanager_url
        __props__.__dict__["alertmanager_user_id"] = alertmanager_user_id
        __props__.__dict__["cluster_slug"] = cluster_slug
        __props__.__dict__["description"] = description
        __props__.__dict__["fleet_management_name"] = fleet_management_name
        __props__.__dict__["fleet_management_status"] = fleet_management_status
        __props__.__dict__["fleet_management_url"] = fleet_management_url
        __props__.__dict__["fleet_management_user_id"] = fleet_management_user_id
        __props__.__dict__["grafanas_ip_allow_list_cname"] = grafanas_ip_allow_list_cname
        __props__.__dict__["graphite_ip_allow_list_cname"] = graphite_ip_allow_list_cname
        __props__.__dict__["graphite_name"] = graphite_name
        __props__.__dict__["graphite_private_connectivity_info_private_dns"] = graphite_private_connectivity_info_private_dns
        __props__.__dict__["graphite_private_connectivity_info_service_name"] = graphite_private_connectivity_info_service_name
        __props__.__dict__["graphite_status"] = graphite_status
        __props__.__dict__["graphite_url"] = graphite_url
        __props__.__dict__["graphite_user_id"] = graphite_user_id
        __props__.__dict__["influx_url"] = influx_url
        __props__.__dict__["labels"] = labels
        __props__.__dict__["logs_ip_allow_list_cname"] = logs_ip_allow_list_cname
        __props__.__dict__["logs_name"] = logs_name
        __props__.__dict__["logs_private_connectivity_info_private_dns"] = logs_private_connectivity_info_private_dns
        __props__.__dict__["logs_private_connectivity_info_service_name"] = logs_private_connectivity_info_service_name
        __props__.__dict__["logs_status"] = logs_status
        __props__.__dict__["logs_url"] = logs_url
        __props__.__dict__["logs_user_id"] = logs_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["org_name"] = org_name
        __props__.__dict__["org_slug"] = org_slug
        __props__.__dict__["otlp_private_connectivity_info_private_dns"] = otlp_private_connectivity_info_private_dns
        __props__.__dict__["otlp_private_connectivity_info_service_name"] = otlp_private_connectivity_info_service_name
        __props__.__dict__["otlp_url"] = otlp_url
        __props__.__dict__["pdc_api_private_connectivity_info_private_dns"] = pdc_api_private_connectivity_info_private_dns
        __props__.__dict__["pdc_api_private_connectivity_info_service_name"] = pdc_api_private_connectivity_info_service_name
        __props__.__dict__["pdc_gateway_private_connectivity_info_private_dns"] = pdc_gateway_private_connectivity_info_private_dns
        __props__.__dict__["pdc_gateway_private_connectivity_info_service_name"] = pdc_gateway_private_connectivity_info_service_name
        __props__.__dict__["profiles_ip_allow_list_cname"] = profiles_ip_allow_list_cname
        __props__.__dict__["profiles_name"] = profiles_name
        __props__.__dict__["profiles_private_connectivity_info_private_dns"] = profiles_private_connectivity_info_private_dns
        __props__.__dict__["profiles_private_connectivity_info_service_name"] = profiles_private_connectivity_info_service_name
        __props__.__dict__["profiles_status"] = profiles_status
        __props__.__dict__["profiles_url"] = profiles_url
        __props__.__dict__["profiles_user_id"] = profiles_user_id
        __props__.__dict__["prometheus_ip_allow_list_cname"] = prometheus_ip_allow_list_cname
        __props__.__dict__["prometheus_name"] = prometheus_name
        __props__.__dict__["prometheus_private_connectivity_info_private_dns"] = prometheus_private_connectivity_info_private_dns
        __props__.__dict__["prometheus_private_connectivity_info_service_name"] = prometheus_private_connectivity_info_service_name
        __props__.__dict__["prometheus_remote_endpoint"] = prometheus_remote_endpoint
        __props__.__dict__["prometheus_remote_write_endpoint"] = prometheus_remote_write_endpoint
        __props__.__dict__["prometheus_status"] = prometheus_status
        __props__.__dict__["prometheus_url"] = prometheus_url
        __props__.__dict__["prometheus_user_id"] = prometheus_user_id
        __props__.__dict__["region_slug"] = region_slug
        __props__.__dict__["slug"] = slug
        __props__.__dict__["status"] = status
        __props__.__dict__["traces_ip_allow_list_cname"] = traces_ip_allow_list_cname
        __props__.__dict__["traces_name"] = traces_name
        __props__.__dict__["traces_private_connectivity_info_private_dns"] = traces_private_connectivity_info_private_dns
        __props__.__dict__["traces_private_connectivity_info_service_name"] = traces_private_connectivity_info_service_name
        __props__.__dict__["traces_status"] = traces_status
        __props__.__dict__["traces_url"] = traces_url
        __props__.__dict__["traces_user_id"] = traces_user_id
        __props__.__dict__["url"] = url
        __props__.__dict__["wait_for_readiness"] = wait_for_readiness
        __props__.__dict__["wait_for_readiness_timeout"] = wait_for_readiness_timeout
        return Stack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertmanagerIpAllowListCname")
    def alertmanager_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Alertmanager instances (Optional)
        """
        return pulumi.get(self, "alertmanager_ip_allow_list_cname")

    @property
    @pulumi.getter(name="alertmanagerName")
    def alertmanager_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_name")

    @property
    @pulumi.getter(name="alertmanagerStatus")
    def alertmanager_status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_status")

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_url")

    @property
    @pulumi.getter(name="alertmanagerUserId")
    def alertmanager_user_id(self) -> pulumi.Output[builtins.int]:
        """
        User ID of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_user_id")

    @property
    @pulumi.getter(name="clusterSlug")
    def cluster_slug(self) -> pulumi.Output[builtins.str]:
        """
        Slug of the cluster where this stack resides.
        """
        return pulumi.get(self, "cluster_slug")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fleetManagementName")
    def fleet_management_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_name")

    @property
    @pulumi.getter(name="fleetManagementStatus")
    def fleet_management_status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_status")

    @property
    @pulumi.getter(name="fleetManagementUrl")
    def fleet_management_url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_url")

    @property
    @pulumi.getter(name="fleetManagementUserId")
    def fleet_management_user_id(self) -> pulumi.Output[builtins.int]:
        """
        User ID of the Fleet Management instance configured for this stack.
        """
        return pulumi.get(self, "fleet_management_user_id")

    @property
    @pulumi.getter(name="grafanasIpAllowListCname")
    def grafanas_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the grafana instance (Optional)
        """
        return pulumi.get(self, "grafanas_ip_allow_list_cname")

    @property
    @pulumi.getter(name="graphiteIpAllowListCname")
    def graphite_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Graphite instance (Optional)
        """
        return pulumi.get(self, "graphite_ip_allow_list_cname")

    @property
    @pulumi.getter(name="graphiteName")
    def graphite_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "graphite_name")

    @property
    @pulumi.getter(name="graphitePrivateConnectivityInfoPrivateDns")
    def graphite_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for Graphite when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "graphite_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="graphitePrivateConnectivityInfoServiceName")
    def graphite_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for Graphite when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "graphite_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="graphiteStatus")
    def graphite_status(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "graphite_status")

    @property
    @pulumi.getter(name="graphiteUrl")
    def graphite_url(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "graphite_url")

    @property
    @pulumi.getter(name="graphiteUserId")
    def graphite_user_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "graphite_user_id")

    @property
    @pulumi.getter(name="influxUrl")
    def influx_url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of the InfluxDB instance configured for this stack. The username is the same as the metrics' (`prometheus_user_id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/metrics/metrics-influxdb/push-from-telegraf/ for docs on how to use this.
        """
        return pulumi.get(self, "influx_url")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of labels to assign to the stack. Label keys and values must match the following regexp: "^[a-zA-Z0-9/\\-.]+$" and stacks cannot have more than 10 labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logsIpAllowListCname")
    def logs_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Logs instance (Optional)
        """
        return pulumi.get(self, "logs_ip_allow_list_cname")

    @property
    @pulumi.getter(name="logsName")
    def logs_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "logs_name")

    @property
    @pulumi.getter(name="logsPrivateConnectivityInfoPrivateDns")
    def logs_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for Logs when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "logs_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="logsPrivateConnectivityInfoServiceName")
    def logs_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for Logs when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "logs_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="logsStatus")
    def logs_status(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "logs_status")

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "logs_url")

    @property
    @pulumi.getter(name="logsUserId")
    def logs_user_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "logs_user_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. `<stack_slug>.grafana.net`).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.int]:
        """
        Organization id to assign to this stack.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="orgName")
    def org_name(self) -> pulumi.Output[builtins.str]:
        """
        Organization name to assign to this stack.
        """
        return pulumi.get(self, "org_name")

    @property
    @pulumi.getter(name="orgSlug")
    def org_slug(self) -> pulumi.Output[builtins.str]:
        """
        Organization slug to assign to this stack.
        """
        return pulumi.get(self, "org_slug")

    @property
    @pulumi.getter(name="otlpPrivateConnectivityInfoPrivateDns")
    def otlp_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for OTLP when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "otlp_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="otlpPrivateConnectivityInfoServiceName")
    def otlp_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for OTLP when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "otlp_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="otlpUrl")
    def otlp_url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of the OTLP instance configured for this stack. The username is the stack's ID (`id` attribute of this resource). See https://grafana.com/docs/grafana-cloud/send-data/otlp/send-data-otlp/ for docs on how to use this.
        """
        return pulumi.get(self, "otlp_url")

    @property
    @pulumi.getter(name="pdcApiPrivateConnectivityInfoPrivateDns")
    def pdc_api_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for PDC's API when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_api_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="pdcApiPrivateConnectivityInfoServiceName")
    def pdc_api_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for PDC's API when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_api_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="pdcGatewayPrivateConnectivityInfoPrivateDns")
    def pdc_gateway_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_gateway_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="pdcGatewayPrivateConnectivityInfoServiceName")
    def pdc_gateway_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for PDC's Gateway when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "pdc_gateway_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="profilesIpAllowListCname")
    def profiles_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Profiles instance (Optional)
        """
        return pulumi.get(self, "profiles_ip_allow_list_cname")

    @property
    @pulumi.getter(name="profilesName")
    def profiles_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "profiles_name")

    @property
    @pulumi.getter(name="profilesPrivateConnectivityInfoPrivateDns")
    def profiles_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for Profiles when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "profiles_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="profilesPrivateConnectivityInfoServiceName")
    def profiles_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for Profiles when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "profiles_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="profilesStatus")
    def profiles_status(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "profiles_status")

    @property
    @pulumi.getter(name="profilesUrl")
    def profiles_url(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "profiles_url")

    @property
    @pulumi.getter(name="profilesUserId")
    def profiles_user_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "profiles_user_id")

    @property
    @pulumi.getter(name="prometheusIpAllowListCname")
    def prometheus_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Prometheus instance (Optional)
        """
        return pulumi.get(self, "prometheus_ip_allow_list_cname")

    @property
    @pulumi.getter(name="prometheusName")
    def prometheus_name(self) -> pulumi.Output[builtins.str]:
        """
        Prometheus name for this instance.
        """
        return pulumi.get(self, "prometheus_name")

    @property
    @pulumi.getter(name="prometheusPrivateConnectivityInfoPrivateDns")
    def prometheus_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for Prometheus when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "prometheus_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="prometheusPrivateConnectivityInfoServiceName")
    def prometheus_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for Prometheus when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "prometheus_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="prometheusRemoteEndpoint")
    def prometheus_remote_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        """
        return pulumi.get(self, "prometheus_remote_endpoint")

    @property
    @pulumi.getter(name="prometheusRemoteWriteEndpoint")
    def prometheus_remote_write_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Use this URL to send prometheus metrics to Grafana cloud
        """
        return pulumi.get(self, "prometheus_remote_write_endpoint")

    @property
    @pulumi.getter(name="prometheusStatus")
    def prometheus_status(self) -> pulumi.Output[builtins.str]:
        """
        Prometheus status for this instance.
        """
        return pulumi.get(self, "prometheus_status")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> pulumi.Output[builtins.str]:
        """
        Prometheus url for this instance.
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter(name="prometheusUserId")
    def prometheus_user_id(self) -> pulumi.Output[builtins.int]:
        """
        Prometheus user ID. Used for e.g. remote_write.
        """
        return pulumi.get(self, "prometheus_user_id")

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[builtins.str]:
        """
        Subdomain that the Grafana instance will be available at. Setting slug to `<stack_slug>` will make the instance available at `https://<stack_slug>.grafana.net`.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the stack.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tracesIpAllowListCname")
    def traces_ip_allow_list_cname(self) -> pulumi.Output[builtins.str]:
        """
        Comma-separated list of CNAMEs that can be whitelisted to access the Traces instance (Optional)
        """
        return pulumi.get(self, "traces_ip_allow_list_cname")

    @property
    @pulumi.getter(name="tracesName")
    def traces_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "traces_name")

    @property
    @pulumi.getter(name="tracesPrivateConnectivityInfoPrivateDns")
    def traces_private_connectivity_info_private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS for Traces when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "traces_private_connectivity_info_private_dns")

    @property
    @pulumi.getter(name="tracesPrivateConnectivityInfoServiceName")
    def traces_private_connectivity_info_service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service Name for Traces when using AWS PrivateLink (only for AWS stacks)
        """
        return pulumi.get(self, "traces_private_connectivity_info_service_name")

    @property
    @pulumi.getter(name="tracesStatus")
    def traces_status(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "traces_status")

    @property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of the Traces instance configured for this stack. To use this in the Tempo data source in Grafana, append `/tempo` to the URL.
        """
        return pulumi.get(self, "traces_url")

    @property
    @pulumi.getter(name="tracesUserId")
    def traces_user_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "traces_user_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

