# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudOrgMemberArgs', 'CloudOrgMember']

@pulumi.input_type
class CloudOrgMemberArgs:
    def __init__(__self__, *,
                 org: pulumi.Input[builtins.str],
                 role: pulumi.Input[builtins.str],
                 user: pulumi.Input[builtins.str],
                 receive_billing_emails: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a CloudOrgMember resource.
        :param pulumi.Input[builtins.str] org: The slug or ID of the organization.
        :param pulumi.Input[builtins.str] role: The role to assign to the user in the organization.
        :param pulumi.Input[builtins.str] user: Username or ID of the user to add to the org's members.
        :param pulumi.Input[builtins.bool] receive_billing_emails: Whether the user should receive billing emails.
        """
        pulumi.set(__self__, "org", org)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "user", user)
        if receive_billing_emails is not None:
            pulumi.set(__self__, "receive_billing_emails", receive_billing_emails)

    @property
    @pulumi.getter
    def org(self) -> pulumi.Input[builtins.str]:
        """
        The slug or ID of the organization.
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        The role to assign to the user in the organization.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[builtins.str]:
        """
        Username or ID of the user to add to the org's members.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="receiveBillingEmails")
    def receive_billing_emails(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user should receive billing emails.
        """
        return pulumi.get(self, "receive_billing_emails")

    @receive_billing_emails.setter
    def receive_billing_emails(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "receive_billing_emails", value)


@pulumi.input_type
class _CloudOrgMemberState:
    def __init__(__self__, *,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 receive_billing_emails: Optional[pulumi.Input[builtins.bool]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudOrgMember resources.
        :param pulumi.Input[builtins.str] org: The slug or ID of the organization.
        :param pulumi.Input[builtins.bool] receive_billing_emails: Whether the user should receive billing emails.
        :param pulumi.Input[builtins.str] role: The role to assign to the user in the organization.
        :param pulumi.Input[builtins.str] user: Username or ID of the user to add to the org's members.
        """
        if org is not None:
            pulumi.set(__self__, "org", org)
        if receive_billing_emails is not None:
            pulumi.set(__self__, "receive_billing_emails", receive_billing_emails)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def org(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The slug or ID of the organization.
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org", value)

    @property
    @pulumi.getter(name="receiveBillingEmails")
    def receive_billing_emails(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user should receive billing emails.
        """
        return pulumi.get(self, "receive_billing_emails")

    @receive_billing_emails.setter
    def receive_billing_emails(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "receive_billing_emails", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role to assign to the user in the organization.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username or ID of the user to add to the org's members.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


warnings.warn("""grafana.index/cloudorgmember.CloudOrgMember has been deprecated in favor of grafana.cloud/orgmember.OrgMember""", DeprecationWarning)


@pulumi.type_token("grafana:index/cloudOrgMember:CloudOrgMember")
class CloudOrgMember(pulumi.CustomResource):
    warnings.warn("""grafana.index/cloudorgmember.CloudOrgMember has been deprecated in favor of grafana.cloud/orgmember.OrgMember""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 receive_billing_emails: Optional[pulumi.Input[builtins.bool]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the membership of a user in an organization.

        ## Import

        ```sh
        $ pulumi import grafana:index/cloudOrgMember:CloudOrgMember name "{{ orgSlugOrID }}:{{ usernameOrID }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] org: The slug or ID of the organization.
        :param pulumi.Input[builtins.bool] receive_billing_emails: Whether the user should receive billing emails.
        :param pulumi.Input[builtins.str] role: The role to assign to the user in the organization.
        :param pulumi.Input[builtins.str] user: Username or ID of the user to add to the org's members.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudOrgMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the membership of a user in an organization.

        ## Import

        ```sh
        $ pulumi import grafana:index/cloudOrgMember:CloudOrgMember name "{{ orgSlugOrID }}:{{ usernameOrID }}"
        ```

        :param str resource_name: The name of the resource.
        :param CloudOrgMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudOrgMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 receive_billing_emails: Optional[pulumi.Input[builtins.bool]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""CloudOrgMember is deprecated: grafana.index/cloudorgmember.CloudOrgMember has been deprecated in favor of grafana.cloud/orgmember.OrgMember""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudOrgMemberArgs.__new__(CloudOrgMemberArgs)

            if org is None and not opts.urn:
                raise TypeError("Missing required property 'org'")
            __props__.__dict__["org"] = org
            __props__.__dict__["receive_billing_emails"] = receive_billing_emails
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
        super(CloudOrgMember, __self__).__init__(
            'grafana:index/cloudOrgMember:CloudOrgMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            org: Optional[pulumi.Input[builtins.str]] = None,
            receive_billing_emails: Optional[pulumi.Input[builtins.bool]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudOrgMember':
        """
        Get an existing CloudOrgMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] org: The slug or ID of the organization.
        :param pulumi.Input[builtins.bool] receive_billing_emails: Whether the user should receive billing emails.
        :param pulumi.Input[builtins.str] role: The role to assign to the user in the organization.
        :param pulumi.Input[builtins.str] user: Username or ID of the user to add to the org's members.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudOrgMemberState.__new__(_CloudOrgMemberState)

        __props__.__dict__["org"] = org
        __props__.__dict__["receive_billing_emails"] = receive_billing_emails
        __props__.__dict__["role"] = role
        __props__.__dict__["user"] = user
        return CloudOrgMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def org(self) -> pulumi.Output[builtins.str]:
        """
        The slug or ID of the organization.
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter(name="receiveBillingEmails")
    def receive_billing_emails(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the user should receive billing emails.
        """
        return pulumi.get(self, "receive_billing_emails")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The role to assign to the user in the organization.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[builtins.str]:
        """
        Username or ID of the user to add to the org's members.
        """
        return pulumi.get(self, "user")

