# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 access_mode: Optional[pulumi.Input[builtins.str]] = None,
                 basic_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 basic_auth_username: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_data_source_connect_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 secure_json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[builtins.str] type: The data source type. Must be one of the supported data source keywords.
        :param pulumi.Input[builtins.str] access_mode: The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        :param pulumi.Input[builtins.bool] basic_auth_enabled: Whether to enable basic auth for the data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] basic_auth_username: Basic auth username. Defaults to ``.
        :param pulumi.Input[builtins.str] database_name: (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] http_headers: Custom HTTP headers
        :param pulumi.Input[builtins.bool] is_default: Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] json_data_encoded: Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] name: A unique name for the data source.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] private_data_source_connect_network_id: (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        :param pulumi.Input[builtins.str] secure_json_data_encoded: Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] uid: Unique identifier. If unset, this will be automatically generated.
        :param pulumi.Input[builtins.str] url: The URL for the data source. The type of URL required varies depending on the chosen data source type.
        :param pulumi.Input[builtins.str] username: (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        pulumi.set(__self__, "type", type)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if basic_auth_enabled is not None:
            pulumi.set(__self__, "basic_auth_enabled", basic_auth_enabled)
        if basic_auth_username is not None:
            pulumi.set(__self__, "basic_auth_username", basic_auth_username)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if json_data_encoded is not None:
            pulumi.set(__self__, "json_data_encoded", json_data_encoded)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if private_data_source_connect_network_id is not None:
            pulumi.set(__self__, "private_data_source_connect_network_id", private_data_source_connect_network_id)
        if secure_json_data_encoded is not None:
            pulumi.set(__self__, "secure_json_data_encoded", secure_json_data_encoded)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The data source type. Must be one of the supported data source keywords.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="basicAuthEnabled")
    def basic_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable basic auth for the data source. Defaults to `false`.
        """
        return pulumi.get(self, "basic_auth_enabled")

    @basic_auth_enabled.setter
    def basic_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "basic_auth_enabled", value)

    @property
    @pulumi.getter(name="basicAuthUsername")
    def basic_auth_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Basic auth username. Defaults to ``.
        """
        return pulumi.get(self, "basic_auth_username")

    @basic_auth_username.setter
    def basic_auth_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "basic_auth_username", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom HTTP headers
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="jsonDataEncoded")
    def json_data_encoded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "json_data_encoded")

    @json_data_encoded.setter
    def json_data_encoded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "json_data_encoded", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="privateDataSourceConnectNetworkId")
    def private_data_source_connect_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        """
        return pulumi.get(self, "private_data_source_connect_network_id")

    @private_data_source_connect_network_id.setter
    def private_data_source_connect_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_data_source_connect_network_id", value)

    @property
    @pulumi.getter(name="secureJsonDataEncoded")
    def secure_json_data_encoded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "secure_json_data_encoded")

    @secure_json_data_encoded.setter
    def secure_json_data_encoded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secure_json_data_encoded", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier. If unset, this will be automatically generated.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _DataSourceState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[builtins.str]] = None,
                 basic_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 basic_auth_username: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_data_source_connect_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 secure_json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataSource resources.
        :param pulumi.Input[builtins.str] access_mode: The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        :param pulumi.Input[builtins.bool] basic_auth_enabled: Whether to enable basic auth for the data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] basic_auth_username: Basic auth username. Defaults to ``.
        :param pulumi.Input[builtins.str] database_name: (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] http_headers: Custom HTTP headers
        :param pulumi.Input[builtins.bool] is_default: Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] json_data_encoded: Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] name: A unique name for the data source.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] private_data_source_connect_network_id: (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        :param pulumi.Input[builtins.str] secure_json_data_encoded: Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] type: The data source type. Must be one of the supported data source keywords.
        :param pulumi.Input[builtins.str] uid: Unique identifier. If unset, this will be automatically generated.
        :param pulumi.Input[builtins.str] url: The URL for the data source. The type of URL required varies depending on the chosen data source type.
        :param pulumi.Input[builtins.str] username: (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if basic_auth_enabled is not None:
            pulumi.set(__self__, "basic_auth_enabled", basic_auth_enabled)
        if basic_auth_username is not None:
            pulumi.set(__self__, "basic_auth_username", basic_auth_username)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if json_data_encoded is not None:
            pulumi.set(__self__, "json_data_encoded", json_data_encoded)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if private_data_source_connect_network_id is not None:
            pulumi.set(__self__, "private_data_source_connect_network_id", private_data_source_connect_network_id)
        if secure_json_data_encoded is not None:
            pulumi.set(__self__, "secure_json_data_encoded", secure_json_data_encoded)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="basicAuthEnabled")
    def basic_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable basic auth for the data source. Defaults to `false`.
        """
        return pulumi.get(self, "basic_auth_enabled")

    @basic_auth_enabled.setter
    def basic_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "basic_auth_enabled", value)

    @property
    @pulumi.getter(name="basicAuthUsername")
    def basic_auth_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Basic auth username. Defaults to ``.
        """
        return pulumi.get(self, "basic_auth_username")

    @basic_auth_username.setter
    def basic_auth_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "basic_auth_username", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom HTTP headers
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="jsonDataEncoded")
    def json_data_encoded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "json_data_encoded")

    @json_data_encoded.setter
    def json_data_encoded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "json_data_encoded", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="privateDataSourceConnectNetworkId")
    def private_data_source_connect_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        """
        return pulumi.get(self, "private_data_source_connect_network_id")

    @private_data_source_connect_network_id.setter
    def private_data_source_connect_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_data_source_connect_network_id", value)

    @property
    @pulumi.getter(name="secureJsonDataEncoded")
    def secure_json_data_encoded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "secure_json_data_encoded")

    @secure_json_data_encoded.setter
    def secure_json_data_encoded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secure_json_data_encoded", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The data source type. Must be one of the supported data source keywords.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier. If unset, this will be automatically generated.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


warnings.warn("""grafana.index/datasource.DataSource has been deprecated in favor of grafana.oss/datasource.DataSource""", DeprecationWarning)


@pulumi.type_token("grafana:index/dataSource:DataSource")
class DataSource(pulumi.CustomResource):
    warnings.warn("""grafana.index/datasource.DataSource has been deprecated in favor of grafana.oss/datasource.DataSource""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[builtins.str]] = None,
                 basic_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 basic_auth_username: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_data_source_connect_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 secure_json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/datasources/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/data_source/)

        The required arguments for this resource vary depending on the type of data
        source selected (via the 'type' argument).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        arbitrary_data = grafana.oss.DataSource("arbitrary-data",
            type="stackdriver",
            name="sd-arbitrary-data",
            json_data_encoded=json.dumps({
                "tokenUri": "https://oauth2.googleapis.com/token",
                "authenticationType": "jwt",
                "defaultProject": "default-project",
                "clientEmail": "client-email@default-project.iam.gserviceaccount.com",
            }),
            secure_json_data_encoded=json.dumps({
                "privateKey": \"\"\"-----BEGIN PRIVATE KEY-----
        private-key
        -----END PRIVATE KEY-----
        \"\"\",
            }))
        influxdb = grafana.oss.DataSource("influxdb",
            type="influxdb",
            name="myapp-metrics",
            url="http://influxdb.example.net:8086/",
            basic_auth_enabled=True,
            basic_auth_username="username",
            database_name="dbname",
            json_data_encoded=json.dumps({
                "authType": "default",
                "basicAuthPassword": "mypassword",
            }))
        cloudwatch = grafana.oss.DataSource("cloudwatch",
            type="cloudwatch",
            name="cw-example",
            json_data_encoded=json.dumps({
                "defaultRegion": "us-east-1",
                "authType": "keys",
            }),
            secure_json_data_encoded=json.dumps({
                "accessKey": "123",
                "secretKey": "456",
            }))
        cloudwatch_assume_arn = grafana.oss.DataSource("cloudwatch_assumeARN",
            type="cloudwatch",
            name="cw-assumeARN-example",
            json_data_encoded=json.dumps({
                "defaultRegion": "us-east-1",
                "authType": "grafana_assume_role",
                "assumeRoleArn": "arn:aws:iam::123456789012:root",
            }))
        prometheus = grafana.oss.DataSource("prometheus",
            type="prometheus",
            name="mimir",
            url="https://my-instances.com",
            basic_auth_enabled=True,
            basic_auth_username="username",
            json_data_encoded=json.dumps({
                "httpMethod": "POST",
                "prometheusType": "Mimir",
                "prometheusVersion": "2.4.0",
            }),
            secure_json_data_encoded=json.dumps({
                "basicAuthPassword": "password",
            }))
        ```

        ## Import

        ```sh
        $ pulumi import grafana:index/dataSource:DataSource name "{{ uid }}"
        ```

        ```sh
        $ pulumi import grafana:index/dataSource:DataSource name "{{ orgID }}:{{ uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_mode: The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        :param pulumi.Input[builtins.bool] basic_auth_enabled: Whether to enable basic auth for the data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] basic_auth_username: Basic auth username. Defaults to ``.
        :param pulumi.Input[builtins.str] database_name: (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] http_headers: Custom HTTP headers
        :param pulumi.Input[builtins.bool] is_default: Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] json_data_encoded: Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] name: A unique name for the data source.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] private_data_source_connect_network_id: (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        :param pulumi.Input[builtins.str] secure_json_data_encoded: Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] type: The data source type. Must be one of the supported data source keywords.
        :param pulumi.Input[builtins.str] uid: Unique identifier. If unset, this will be automatically generated.
        :param pulumi.Input[builtins.str] url: The URL for the data source. The type of URL required varies depending on the chosen data source type.
        :param pulumi.Input[builtins.str] username: (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/datasources/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/data_source/)

        The required arguments for this resource vary depending on the type of data
        source selected (via the 'type' argument).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        arbitrary_data = grafana.oss.DataSource("arbitrary-data",
            type="stackdriver",
            name="sd-arbitrary-data",
            json_data_encoded=json.dumps({
                "tokenUri": "https://oauth2.googleapis.com/token",
                "authenticationType": "jwt",
                "defaultProject": "default-project",
                "clientEmail": "client-email@default-project.iam.gserviceaccount.com",
            }),
            secure_json_data_encoded=json.dumps({
                "privateKey": \"\"\"-----BEGIN PRIVATE KEY-----
        private-key
        -----END PRIVATE KEY-----
        \"\"\",
            }))
        influxdb = grafana.oss.DataSource("influxdb",
            type="influxdb",
            name="myapp-metrics",
            url="http://influxdb.example.net:8086/",
            basic_auth_enabled=True,
            basic_auth_username="username",
            database_name="dbname",
            json_data_encoded=json.dumps({
                "authType": "default",
                "basicAuthPassword": "mypassword",
            }))
        cloudwatch = grafana.oss.DataSource("cloudwatch",
            type="cloudwatch",
            name="cw-example",
            json_data_encoded=json.dumps({
                "defaultRegion": "us-east-1",
                "authType": "keys",
            }),
            secure_json_data_encoded=json.dumps({
                "accessKey": "123",
                "secretKey": "456",
            }))
        cloudwatch_assume_arn = grafana.oss.DataSource("cloudwatch_assumeARN",
            type="cloudwatch",
            name="cw-assumeARN-example",
            json_data_encoded=json.dumps({
                "defaultRegion": "us-east-1",
                "authType": "grafana_assume_role",
                "assumeRoleArn": "arn:aws:iam::123456789012:root",
            }))
        prometheus = grafana.oss.DataSource("prometheus",
            type="prometheus",
            name="mimir",
            url="https://my-instances.com",
            basic_auth_enabled=True,
            basic_auth_username="username",
            json_data_encoded=json.dumps({
                "httpMethod": "POST",
                "prometheusType": "Mimir",
                "prometheusVersion": "2.4.0",
            }),
            secure_json_data_encoded=json.dumps({
                "basicAuthPassword": "password",
            }))
        ```

        ## Import

        ```sh
        $ pulumi import grafana:index/dataSource:DataSource name "{{ uid }}"
        ```

        ```sh
        $ pulumi import grafana:index/dataSource:DataSource name "{{ orgID }}:{{ uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[builtins.str]] = None,
                 basic_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 basic_auth_username: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_data_source_connect_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 secure_json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""DataSource is deprecated: grafana.index/datasource.DataSource has been deprecated in favor of grafana.oss/datasource.DataSource""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["basic_auth_enabled"] = basic_auth_enabled
            __props__.__dict__["basic_auth_username"] = basic_auth_username
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["http_headers"] = None if http_headers is None else pulumi.Output.secret(http_headers)
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["json_data_encoded"] = json_data_encoded
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["private_data_source_connect_network_id"] = private_data_source_connect_network_id
            __props__.__dict__["secure_json_data_encoded"] = None if secure_json_data_encoded is None else pulumi.Output.secret(secure_json_data_encoded)
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uid"] = uid
            __props__.__dict__["url"] = url
            __props__.__dict__["username"] = username
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/dataSource:DataSource")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["httpHeaders", "secureJsonDataEncoded"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DataSource, __self__).__init__(
            'grafana:index/dataSource:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[builtins.str]] = None,
            basic_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            basic_auth_username: Optional[pulumi.Input[builtins.str]] = None,
            database_name: Optional[pulumi.Input[builtins.str]] = None,
            http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            private_data_source_connect_network_id: Optional[pulumi.Input[builtins.str]] = None,
            secure_json_data_encoded: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_mode: The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        :param pulumi.Input[builtins.bool] basic_auth_enabled: Whether to enable basic auth for the data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] basic_auth_username: Basic auth username. Defaults to ``.
        :param pulumi.Input[builtins.str] database_name: (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] http_headers: Custom HTTP headers
        :param pulumi.Input[builtins.bool] is_default: Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        :param pulumi.Input[builtins.str] json_data_encoded: Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] name: A unique name for the data source.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] private_data_source_connect_network_id: (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        :param pulumi.Input[builtins.str] secure_json_data_encoded: Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        :param pulumi.Input[builtins.str] type: The data source type. Must be one of the supported data source keywords.
        :param pulumi.Input[builtins.str] uid: Unique identifier. If unset, this will be automatically generated.
        :param pulumi.Input[builtins.str] url: The URL for the data source. The type of URL required varies depending on the chosen data source type.
        :param pulumi.Input[builtins.str] username: (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceState.__new__(_DataSourceState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["basic_auth_enabled"] = basic_auth_enabled
        __props__.__dict__["basic_auth_username"] = basic_auth_username
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["http_headers"] = http_headers
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["json_data_encoded"] = json_data_encoded
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["private_data_source_connect_network_id"] = private_data_source_connect_network_id
        __props__.__dict__["secure_json_data_encoded"] = secure_json_data_encoded
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The method by which Grafana will access the data source: `proxy` or `direct`. Defaults to `proxy`.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="basicAuthEnabled")
    def basic_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable basic auth for the data source. Defaults to `false`.
        """
        return pulumi.get(self, "basic_auth_enabled")

    @property
    @pulumi.getter(name="basicAuthUsername")
    def basic_auth_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Basic auth username. Defaults to ``.
        """
        return pulumi.get(self, "basic_auth_username")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Required by some data source types) The name of the database to use on the selected data source server. Defaults to ``.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Custom HTTP headers
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to set the data source as default. This should only be `true` to a single data source. Defaults to `false`.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="jsonDataEncoded")
    def json_data_encoded(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "json_data_encoded")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the data source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="privateDataSourceConnectNetworkId")
    def private_data_source_connect_network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source. Defaults to ``.
        """
        return pulumi.get(self, "private_data_source_connect_network_id")

    @property
    @pulumi.getter(name="secureJsonDataEncoded")
    def secure_json_data_encoded(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Serialized JSON string containing the secure json data. This attribute can be used to pass secure configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "secure_json_data_encoded")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The data source type. Must be one of the supported data source keywords.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier. If unset, this will be automatically generated.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Required by some data source types) The username to use to authenticate to the data source. Defaults to ``.
        """
        return pulumi.get(self, "username")

