# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCollectorResult',
    'AwaitableGetCollectorResult',
    'get_collector',
    'get_collector_output',
]

@pulumi.output_type
class GetCollectorResult:
    """
    A collection of values returned by getCollector.
    """
    def __init__(__self__, enabled=None, id=None, local_attributes=None, remote_attributes=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_attributes and not isinstance(local_attributes, dict):
            raise TypeError("Expected argument 'local_attributes' to be a dict")
        pulumi.set(__self__, "local_attributes", local_attributes)
        if remote_attributes and not isinstance(remote_attributes, dict):
            raise TypeError("Expected argument 'remote_attributes' to be a dict")
        pulumi.set(__self__, "remote_attributes", remote_attributes)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether the collector is enabled or not
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the collector
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localAttributes")
    def local_attributes(self) -> Mapping[str, builtins.str]:
        """
        Local attributes for the collector
        """
        return pulumi.get(self, "local_attributes")

    @property
    @pulumi.getter(name="remoteAttributes")
    def remote_attributes(self) -> Mapping[str, builtins.str]:
        """
        Remote attributes for the collector
        """
        return pulumi.get(self, "remote_attributes")


class AwaitableGetCollectorResult(GetCollectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCollectorResult(
            enabled=self.enabled,
            id=self.id,
            local_attributes=self.local_attributes,
            remote_attributes=self.remote_attributes)


def get_collector(id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCollectorResult:
    """
    Represents a Grafana Fleet Management collector.

    * [Official documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/)
    * [API documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/api-reference/collector-api/)

    Required access policy scopes:

    * fleet-management:read

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.fleetManagement.get_collector(id="my_collector")
    ```


    :param builtins.str id: ID of the collector
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:fleetManagement/getCollector:getCollector', __args__, opts=opts, typ=GetCollectorResult).value

    return AwaitableGetCollectorResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        local_attributes=pulumi.get(__ret__, 'local_attributes'),
        remote_attributes=pulumi.get(__ret__, 'remote_attributes'))
def get_collector_output(id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCollectorResult]:
    """
    Represents a Grafana Fleet Management collector.

    * [Official documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/)
    * [API documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/api-reference/collector-api/)

    Required access policy scopes:

    * fleet-management:read

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.fleetManagement.get_collector(id="my_collector")
    ```


    :param builtins.str id: ID of the collector
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:fleetManagement/getCollector:getCollector', __args__, opts=opts, typ=GetCollectorResult)
    return __ret__.apply(lambda __response__: GetCollectorResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        local_attributes=pulumi.get(__response__, 'local_attributes'),
        remote_attributes=pulumi.get(__response__, 'remote_attributes')))
