# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 extra_log_attributes: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 settings: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 stack_id: pulumi.Input[builtins.int],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: A list of allowed origins for CORS.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] extra_log_attributes: The extra attributes to append in each signal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "extra_log_attributes", extra_log_attributes)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "stack_id", stack_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="extraLogAttributes")
    def extra_log_attributes(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        The extra attributes to append in each signal.
        """
        return pulumi.get(self, "extra_log_attributes")

    @extra_log_attributes.setter
    def extra_log_attributes(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "extra_log_attributes", value)

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 collector_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 extra_log_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: A list of allowed origins for CORS.
        :param pulumi.Input[builtins.str] collector_endpoint: The collector URL Grafana Cloud Frontend Observability. Use this endpoint to send your Telemetry.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] extra_log_attributes: The extra attributes to append in each signal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if collector_endpoint is not None:
            pulumi.set(__self__, "collector_endpoint", collector_endpoint)
        if extra_log_attributes is not None:
            pulumi.set(__self__, "extra_log_attributes", extra_log_attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="collectorEndpoint")
    def collector_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The collector URL Grafana Cloud Frontend Observability. Use this endpoint to send your Telemetry.
        """
        return pulumi.get(self, "collector_endpoint")

    @collector_endpoint.setter
    def collector_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collector_endpoint", value)

    @property
    @pulumi.getter(name="extraLogAttributes")
    def extra_log_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The extra attributes to append in each signal.
        """
        return pulumi.get(self, "extra_log_attributes")

    @extra_log_attributes.setter
    def extra_log_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "extra_log_attributes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "stack_id", value)


@pulumi.type_token("grafana:frontendObservability/app:App")
class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 extra_log_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import grafana:frontendObservability/app:App name "{{ stack_id }}:{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: A list of allowed origins for CORS.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] extra_log_attributes: The extra attributes to append in each signal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import grafana:frontendObservability/app:App name "{{ stack_id }}:{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 extra_log_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            if allowed_origins is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_origins'")
            __props__.__dict__["allowed_origins"] = allowed_origins
            if extra_log_attributes is None and not opts.urn:
                raise TypeError("Missing required property 'extra_log_attributes'")
            __props__.__dict__["extra_log_attributes"] = extra_log_attributes
            __props__.__dict__["name"] = name
            if settings is None and not opts.urn:
                raise TypeError("Missing required property 'settings'")
            __props__.__dict__["settings"] = settings
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["collector_endpoint"] = None
        super(App, __self__).__init__(
            'grafana:frontendObservability/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            collector_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            extra_log_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            stack_id: Optional[pulumi.Input[builtins.int]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: A list of allowed origins for CORS.
        :param pulumi.Input[builtins.str] collector_endpoint: The collector URL Grafana Cloud Frontend Observability. Use this endpoint to send your Telemetry.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] extra_log_attributes: The extra attributes to append in each signal.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["allowed_origins"] = allowed_origins
        __props__.__dict__["collector_endpoint"] = collector_endpoint
        __props__.__dict__["extra_log_attributes"] = extra_log_attributes
        __props__.__dict__["name"] = name
        __props__.__dict__["settings"] = settings
        __props__.__dict__["stack_id"] = stack_id
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="collectorEndpoint")
    def collector_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The collector URL Grafana Cloud Frontend Observability. Use this endpoint to send your Telemetry.
        """
        return pulumi.get(self, "collector_endpoint")

    @property
    @pulumi.getter(name="extraLogAttributes")
    def extra_log_attributes(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The extra attributes to append in each signal.
        """
        return pulumi.get(self, "extra_log_attributes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The key-value settings of the Frontend Observability app. Available Settings: `{combineLabData=(0|1)}`
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "stack_id")

