# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    """
    A collection of values returned by getApp.
    """
    def __init__(__self__, allowed_origins=None, collector_endpoint=None, extra_log_attributes=None, id=None, name=None, settings=None, stack_id=None):
        if allowed_origins and not isinstance(allowed_origins, list):
            raise TypeError("Expected argument 'allowed_origins' to be a list")
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if collector_endpoint and not isinstance(collector_endpoint, str):
            raise TypeError("Expected argument 'collector_endpoint' to be a str")
        pulumi.set(__self__, "collector_endpoint", collector_endpoint)
        if extra_log_attributes and not isinstance(extra_log_attributes, dict):
            raise TypeError("Expected argument 'extra_log_attributes' to be a dict")
        pulumi.set(__self__, "extra_log_attributes", extra_log_attributes)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if stack_id and not isinstance(stack_id, int):
            raise TypeError("Expected argument 'stack_id' to be a int")
        pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[builtins.str]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="collectorEndpoint")
    def collector_endpoint(self) -> builtins.str:
        """
        The collector URL Grafana Cloud Frontend Observability. Use this endpoint to send your Telemetry.
        """
        return pulumi.get(self, "collector_endpoint")

    @property
    @pulumi.getter(name="extraLogAttributes")
    def extra_log_attributes(self) -> Mapping[str, builtins.str]:
        """
        The extra attributes to append in each signal.
        """
        return pulumi.get(self, "extra_log_attributes")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> Mapping[str, builtins.str]:
        """
        The settings of the Frontend Observability App.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> builtins.int:
        return pulumi.get(self, "stack_id")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            allowed_origins=self.allowed_origins,
            collector_endpoint=self.collector_endpoint,
            extra_log_attributes=self.extra_log_attributes,
            id=self.id,
            name=self.name,
            settings=self.settings,
            stack_id=self.stack_id)


def get_app(name: Optional[builtins.str] = None,
            stack_id: Optional[builtins.int] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    ## Example Usage
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:frontendObservability/getApp:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        allowed_origins=pulumi.get(__ret__, 'allowed_origins'),
        collector_endpoint=pulumi.get(__ret__, 'collector_endpoint'),
        extra_log_attributes=pulumi.get(__ret__, 'extra_log_attributes'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        settings=pulumi.get(__ret__, 'settings'),
        stack_id=pulumi.get(__ret__, 'stack_id'))
def get_app_output(name: Optional[pulumi.Input[builtins.str]] = None,
                   stack_id: Optional[pulumi.Input[builtins.int]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppResult]:
    """
    ## Example Usage
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:frontendObservability/getApp:getApp', __args__, opts=opts, typ=GetAppResult)
    return __ret__.apply(lambda __response__: GetAppResult(
        allowed_origins=pulumi.get(__response__, 'allowed_origins'),
        collector_endpoint=pulumi.get(__response__, 'collector_endpoint'),
        extra_log_attributes=pulumi.get(__response__, 'extra_log_attributes'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        settings=pulumi.get(__response__, 'settings'),
        stack_id=pulumi.get(__response__, 'stack_id')))
