# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OncallOnCallShiftArgs', 'OncallOnCallShift']

@pulumi.input_type
class OncallOnCallShiftArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 start: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 by_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 by_monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 by_months: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 level: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rolling_users: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 start_rotation_from_user_index: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 until: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 week_start: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OncallOnCallShift resource.
        :param pulumi.Input[builtins.int] duration: The duration of the event.
        :param pulumi.Input[builtins.str] start: The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[builtins.str] type: The shift's type. Can be rolling*users, recurrent*event, single_event
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] by_days: This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_monthdays: This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_months: This parameter takes a list of months. Valid values are 1 to 12
        :param pulumi.Input[builtins.str] frequency: The frequency of the event. Can be hourly, daily, weekly, monthly
        :param pulumi.Input[builtins.int] interval: The positive integer representing at which intervals the recurrence rule repeats.
        :param pulumi.Input[builtins.int] level: The priority level. The higher the value, the higher the priority.
        :param pulumi.Input[builtins.str] name: The shift's name.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] rolling_users: The list of lists with on-call users (for rolling_users event type)
        :param pulumi.Input[builtins.int] start_rotation_from_user_index: The index of the list of users in rolling_users, from which on-call rotation starts.
        :param pulumi.Input[builtins.str] team_id: The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        :param pulumi.Input[builtins.str] time_zone: The shift's timezone.  Overrides schedule's timezone.
        :param pulumi.Input[builtins.str] until: The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of on-call users (for single*event and recurrent*event event type).
        :param pulumi.Input[builtins.str] week_start: Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "type", type)
        if by_days is not None:
            pulumi.set(__self__, "by_days", by_days)
        if by_monthdays is not None:
            pulumi.set(__self__, "by_monthdays", by_monthdays)
        if by_months is not None:
            pulumi.set(__self__, "by_months", by_months)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rolling_users is not None:
            pulumi.set(__self__, "rolling_users", rolling_users)
        if start_rotation_from_user_index is not None:
            pulumi.set(__self__, "start_rotation_from_user_index", start_rotation_from_user_index)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if until is not None:
            pulumi.set(__self__, "until", until)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        """
        The duration of the event.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[builtins.str]:
        """
        The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The shift's type. Can be rolling*users, recurrent*event, single_event
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="byDays")
    def by_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "by_days")

    @by_days.setter
    def by_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "by_days", value)

    @property
    @pulumi.getter(name="byMonthdays")
    def by_monthdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        """
        return pulumi.get(self, "by_monthdays")

    @by_monthdays.setter
    def by_monthdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "by_monthdays", value)

    @property
    @pulumi.getter(name="byMonths")
    def by_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        This parameter takes a list of months. Valid values are 1 to 12
        """
        return pulumi.get(self, "by_months")

    @by_months.setter
    def by_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "by_months", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The frequency of the event. Can be hourly, daily, weekly, monthly
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The positive integer representing at which intervals the recurrence rule repeats.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority level. The higher the value, the higher the priority.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shift's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rollingUsers")
    def rolling_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        The list of lists with on-call users (for rolling_users event type)
        """
        return pulumi.get(self, "rolling_users")

    @rolling_users.setter
    def rolling_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "rolling_users", value)

    @property
    @pulumi.getter(name="startRotationFromUserIndex")
    def start_rotation_from_user_index(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The index of the list of users in rolling_users, from which on-call rotation starts.
        """
        return pulumi.get(self, "start_rotation_from_user_index")

    @start_rotation_from_user_index.setter
    def start_rotation_from_user_index(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_rotation_from_user_index", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shift's timezone.  Overrides schedule's timezone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "until")

    @until.setter
    def until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "until", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of on-call users (for single*event and recurrent*event event type).
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "week_start", value)


@pulumi.input_type
class _OncallOnCallShiftState:
    def __init__(__self__, *,
                 by_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 by_monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 by_months: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 duration: Optional[pulumi.Input[builtins.int]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 level: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rolling_users: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 start_rotation_from_user_index: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 until: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 week_start: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OncallOnCallShift resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] by_days: This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_monthdays: This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_months: This parameter takes a list of months. Valid values are 1 to 12
        :param pulumi.Input[builtins.int] duration: The duration of the event.
        :param pulumi.Input[builtins.str] frequency: The frequency of the event. Can be hourly, daily, weekly, monthly
        :param pulumi.Input[builtins.int] interval: The positive integer representing at which intervals the recurrence rule repeats.
        :param pulumi.Input[builtins.int] level: The priority level. The higher the value, the higher the priority.
        :param pulumi.Input[builtins.str] name: The shift's name.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] rolling_users: The list of lists with on-call users (for rolling_users event type)
        :param pulumi.Input[builtins.str] start: The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[builtins.int] start_rotation_from_user_index: The index of the list of users in rolling_users, from which on-call rotation starts.
        :param pulumi.Input[builtins.str] team_id: The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        :param pulumi.Input[builtins.str] time_zone: The shift's timezone.  Overrides schedule's timezone.
        :param pulumi.Input[builtins.str] type: The shift's type. Can be rolling*users, recurrent*event, single_event
        :param pulumi.Input[builtins.str] until: The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of on-call users (for single*event and recurrent*event event type).
        :param pulumi.Input[builtins.str] week_start: Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        if by_days is not None:
            pulumi.set(__self__, "by_days", by_days)
        if by_monthdays is not None:
            pulumi.set(__self__, "by_monthdays", by_monthdays)
        if by_months is not None:
            pulumi.set(__self__, "by_months", by_months)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rolling_users is not None:
            pulumi.set(__self__, "rolling_users", rolling_users)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if start_rotation_from_user_index is not None:
            pulumi.set(__self__, "start_rotation_from_user_index", start_rotation_from_user_index)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if until is not None:
            pulumi.set(__self__, "until", until)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter(name="byDays")
    def by_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "by_days")

    @by_days.setter
    def by_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "by_days", value)

    @property
    @pulumi.getter(name="byMonthdays")
    def by_monthdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        """
        return pulumi.get(self, "by_monthdays")

    @by_monthdays.setter
    def by_monthdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "by_monthdays", value)

    @property
    @pulumi.getter(name="byMonths")
    def by_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        This parameter takes a list of months. Valid values are 1 to 12
        """
        return pulumi.get(self, "by_months")

    @by_months.setter
    def by_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "by_months", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The duration of the event.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The frequency of the event. Can be hourly, daily, weekly, monthly
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The positive integer representing at which intervals the recurrence rule repeats.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority level. The higher the value, the higher the priority.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shift's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rollingUsers")
    def rolling_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        The list of lists with on-call users (for rolling_users event type)
        """
        return pulumi.get(self, "rolling_users")

    @rolling_users.setter
    def rolling_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "rolling_users", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="startRotationFromUserIndex")
    def start_rotation_from_user_index(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The index of the list of users in rolling_users, from which on-call rotation starts.
        """
        return pulumi.get(self, "start_rotation_from_user_index")

    @start_rotation_from_user_index.setter
    def start_rotation_from_user_index(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_rotation_from_user_index", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shift's timezone.  Overrides schedule's timezone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shift's type. Can be rolling*users, recurrent*event, single_event
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "until")

    @until.setter
    def until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "until", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of on-call users (for single*event and recurrent*event event type).
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "week_start", value)


warnings.warn("""grafana.index/oncalloncallshift.OncallOnCallShift has been deprecated in favor of grafana.oncall/oncallshift.OnCallShift""", DeprecationWarning)


@pulumi.type_token("grafana:index/oncallOnCallShift:OncallOnCallShift")
class OncallOnCallShift(pulumi.CustomResource):
    warnings.warn("""grafana.index/oncalloncallshift.OncallOnCallShift has been deprecated in favor of grafana.oncall/oncallshift.OnCallShift""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 by_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 by_monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 by_months: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 duration: Optional[pulumi.Input[builtins.int]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 level: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rolling_users: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 start_rotation_from_user_index: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 until: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 week_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/on_call_shifts/)

        ## Import

        ```sh
        $ pulumi import grafana:index/oncallOnCallShift:OncallOnCallShift name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] by_days: This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_monthdays: This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_months: This parameter takes a list of months. Valid values are 1 to 12
        :param pulumi.Input[builtins.int] duration: The duration of the event.
        :param pulumi.Input[builtins.str] frequency: The frequency of the event. Can be hourly, daily, weekly, monthly
        :param pulumi.Input[builtins.int] interval: The positive integer representing at which intervals the recurrence rule repeats.
        :param pulumi.Input[builtins.int] level: The priority level. The higher the value, the higher the priority.
        :param pulumi.Input[builtins.str] name: The shift's name.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] rolling_users: The list of lists with on-call users (for rolling_users event type)
        :param pulumi.Input[builtins.str] start: The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[builtins.int] start_rotation_from_user_index: The index of the list of users in rolling_users, from which on-call rotation starts.
        :param pulumi.Input[builtins.str] team_id: The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        :param pulumi.Input[builtins.str] time_zone: The shift's timezone.  Overrides schedule's timezone.
        :param pulumi.Input[builtins.str] type: The shift's type. Can be rolling*users, recurrent*event, single_event
        :param pulumi.Input[builtins.str] until: The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of on-call users (for single*event and recurrent*event event type).
        :param pulumi.Input[builtins.str] week_start: Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OncallOnCallShiftArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/on_call_shifts/)

        ## Import

        ```sh
        $ pulumi import grafana:index/oncallOnCallShift:OncallOnCallShift name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param OncallOnCallShiftArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OncallOnCallShiftArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 by_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 by_monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 by_months: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 duration: Optional[pulumi.Input[builtins.int]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 level: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rolling_users: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 start_rotation_from_user_index: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 until: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 week_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""OncallOnCallShift is deprecated: grafana.index/oncalloncallshift.OncallOnCallShift has been deprecated in favor of grafana.oncall/oncallshift.OnCallShift""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OncallOnCallShiftArgs.__new__(OncallOnCallShiftArgs)

            __props__.__dict__["by_days"] = by_days
            __props__.__dict__["by_monthdays"] = by_monthdays
            __props__.__dict__["by_months"] = by_months
            if duration is None and not opts.urn:
                raise TypeError("Missing required property 'duration'")
            __props__.__dict__["duration"] = duration
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["interval"] = interval
            __props__.__dict__["level"] = level
            __props__.__dict__["name"] = name
            __props__.__dict__["rolling_users"] = rolling_users
            if start is None and not opts.urn:
                raise TypeError("Missing required property 'start'")
            __props__.__dict__["start"] = start
            __props__.__dict__["start_rotation_from_user_index"] = start_rotation_from_user_index
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["time_zone"] = time_zone
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["until"] = until
            __props__.__dict__["users"] = users
            __props__.__dict__["week_start"] = week_start
        super(OncallOnCallShift, __self__).__init__(
            'grafana:index/oncallOnCallShift:OncallOnCallShift',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            by_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            by_monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            by_months: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            duration: Optional[pulumi.Input[builtins.int]] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            level: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rolling_users: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
            start: Optional[pulumi.Input[builtins.str]] = None,
            start_rotation_from_user_index: Optional[pulumi.Input[builtins.int]] = None,
            team_id: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            until: Optional[pulumi.Input[builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            week_start: Optional[pulumi.Input[builtins.str]] = None) -> 'OncallOnCallShift':
        """
        Get an existing OncallOnCallShift resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] by_days: This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_monthdays: This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] by_months: This parameter takes a list of months. Valid values are 1 to 12
        :param pulumi.Input[builtins.int] duration: The duration of the event.
        :param pulumi.Input[builtins.str] frequency: The frequency of the event. Can be hourly, daily, weekly, monthly
        :param pulumi.Input[builtins.int] interval: The positive integer representing at which intervals the recurrence rule repeats.
        :param pulumi.Input[builtins.int] level: The priority level. The higher the value, the higher the priority.
        :param pulumi.Input[builtins.str] name: The shift's name.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] rolling_users: The list of lists with on-call users (for rolling_users event type)
        :param pulumi.Input[builtins.str] start: The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[builtins.int] start_rotation_from_user_index: The index of the list of users in rolling_users, from which on-call rotation starts.
        :param pulumi.Input[builtins.str] team_id: The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        :param pulumi.Input[builtins.str] time_zone: The shift's timezone.  Overrides schedule's timezone.
        :param pulumi.Input[builtins.str] type: The shift's type. Can be rolling*users, recurrent*event, single_event
        :param pulumi.Input[builtins.str] until: The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of on-call users (for single*event and recurrent*event event type).
        :param pulumi.Input[builtins.str] week_start: Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OncallOnCallShiftState.__new__(_OncallOnCallShiftState)

        __props__.__dict__["by_days"] = by_days
        __props__.__dict__["by_monthdays"] = by_monthdays
        __props__.__dict__["by_months"] = by_months
        __props__.__dict__["duration"] = duration
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["interval"] = interval
        __props__.__dict__["level"] = level
        __props__.__dict__["name"] = name
        __props__.__dict__["rolling_users"] = rolling_users
        __props__.__dict__["start"] = start
        __props__.__dict__["start_rotation_from_user_index"] = start_rotation_from_user_index
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        __props__.__dict__["until"] = until
        __props__.__dict__["users"] = users
        __props__.__dict__["week_start"] = week_start
        return OncallOnCallShift(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="byDays")
    def by_days(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        This parameter takes a list of days in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "by_days")

    @property
    @pulumi.getter(name="byMonthdays")
    def by_monthdays(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        This parameter takes a list of days of the month.  Valid values are 1 to 31 or -31 to -1
        """
        return pulumi.get(self, "by_monthdays")

    @property
    @pulumi.getter(name="byMonths")
    def by_months(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        This parameter takes a list of months. Valid values are 1 to 12
        """
        return pulumi.get(self, "by_months")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[builtins.int]:
        """
        The duration of the event.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The frequency of the event. Can be hourly, daily, weekly, monthly
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The positive integer representing at which intervals the recurrence rule repeats.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The priority level. The higher the value, the higher the priority.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The shift's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rollingUsers")
    def rolling_users(self) -> pulumi.Output[Optional[Sequence[Sequence[builtins.str]]]]:
        """
        The list of lists with on-call users (for rolling_users event type)
        """
        return pulumi.get(self, "rolling_users")

    @property
    @pulumi.getter
    def start(self) -> pulumi.Output[builtins.str]:
        """
        The start time of the on-call shift. This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="startRotationFromUserIndex")
    def start_rotation_from_user_index(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The index of the list of users in rolling_users, from which on-call rotation starts.
        """
        return pulumi.get(self, "start_rotation_from_user_index")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the OnCall team. To get one, create a team in Grafana, and navigate to the OnCall plugin (to sync the team with OnCall). You can then get the ID using the `on_call_get_team` datasource.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The shift's timezone.  Overrides schedule's timezone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The shift's type. Can be rolling*users, recurrent*event, single_event
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def until(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The end time of recurrent on-call shifts (endless if null). This parameter takes a date format as yyyy-MM-dd'T'HH:mm:ss (for example "2020-09-05T08:00:00")
        """
        return pulumi.get(self, "until")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of on-call users (for single*event and recurrent*event event type).
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Start day of the week in iCal format. Can be MO, TU, WE, TH, FR, SA, SU
        """
        return pulumi.get(self, "week_start")

