# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceAccountArgs', 'ServiceAccount']

@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[builtins.str],
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceAccount resource.
        :param pulumi.Input[builtins.str] role: The basic role of the service account in the organization.
        :param pulumi.Input[builtins.bool] is_disabled: The disabled status for the service account. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the service account.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        pulumi.set(__self__, "role", role)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        The basic role of the service account in the organization.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The disabled status for the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.input_type
class _ServiceAccountState:
    def __init__(__self__, *,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceAccount resources.
        :param pulumi.Input[builtins.bool] is_disabled: The disabled status for the service account. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the service account.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role: The basic role of the service account in the organization.
        """
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The disabled status for the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic role of the service account in the organization.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


warnings.warn("""grafana.index/serviceaccount.ServiceAccount has been deprecated in favor of grafana.oss/serviceaccount.ServiceAccount""", DeprecationWarning)


@pulumi.type_token("grafana:index/serviceAccount:ServiceAccount")
class ServiceAccount(pulumi.CustomResource):
    warnings.warn("""grafana.index/serviceaccount.ServiceAccount has been deprecated in favor of grafana.oss/serviceaccount.ServiceAccount""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        **Note:** This resource is available only with Grafana 9.1+.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/service-accounts/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        admin = grafana.oss.ServiceAccount("admin",
            name="admin sa",
            role="Admin",
            is_disabled=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:index/serviceAccount:ServiceAccount name "{{ id }}"
        ```

        ```sh
        $ pulumi import grafana:index/serviceAccount:ServiceAccount name "{{ orgID }}:{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_disabled: The disabled status for the service account. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the service account.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role: The basic role of the service account in the organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Note:** This resource is available only with Grafana 9.1+.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/service-accounts/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        admin = grafana.oss.ServiceAccount("admin",
            name="admin sa",
            role="Admin",
            is_disabled=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:index/serviceAccount:ServiceAccount name "{{ id }}"
        ```

        ```sh
        $ pulumi import grafana:index/serviceAccount:ServiceAccount name "{{ orgID }}:{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""ServiceAccount is deprecated: grafana.index/serviceaccount.ServiceAccount has been deprecated in favor of grafana.oss/serviceaccount.ServiceAccount""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountArgs.__new__(ServiceAccountArgs)

            __props__.__dict__["is_disabled"] = is_disabled
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/serviceAccount:ServiceAccount")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ServiceAccount, __self__).__init__(
            'grafana:index/serviceAccount:ServiceAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceAccount':
        """
        Get an existing ServiceAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_disabled: The disabled status for the service account. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the service account.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        :param pulumi.Input[builtins.str] role: The basic role of the service account in the organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountState.__new__(_ServiceAccountState)

        __props__.__dict__["is_disabled"] = is_disabled
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["role"] = role
        return ServiceAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The disabled status for the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the service account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The basic role of the service account in the organization.
        """
        return pulumi.get(self, "role")

