# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/11_super_resolution_utils.ipynb.

# %% auto 0
__all__ = ['get_device']

# %% ../nbs/11_super_resolution_utils.ipynb 3
import re
import torch

# %% ../nbs/11_super_resolution_utils.ipynb 4
IS_HIGH_VERSION = [int(m) for m in list(re.findall(r"^([0-9]+)\.([0-9]+)\.([0-9]+)([^0-9][a-zA-Z0-9]*)?(\+git.*)?$",\
    torch.__version__)[0][:3])] >= [1, 12, 0]

# %% ../nbs/11_super_resolution_utils.ipynb 5
def get_device(gpu_id=None):
    if gpu_id is None:
        gpu_str = ''
    elif isinstance(gpu_id, int):
        gpu_str = f':{gpu_id}'
    else:
        raise TypeError('Input should be int value.')

    if IS_HIGH_VERSION:
        if torch.backends.mps.is_available():
            return torch.device('mps'+gpu_str)
    return torch.device('cuda'+gpu_str if torch.cuda.is_available() and torch.backends.cudnn.is_available() else 'cpu')
