# Changelog

All notable changes to Comp-LEO SDK will be documented in this file.

## [0.1.1] - 2025-10-27

### Added
- 🎨 **Interactive Menu Mode** - Beautiful TUI with questionary for menu-based navigation
- 📁 **Auto File Discovery** - Automatically scans for Leo files in current and parent directories
- 🎯 **Quick Check Menu** - One-click access to recently scanned Leo files
- 🔄 **Rescan Feature** - Refresh Leo file list without restarting
- 📋 **Dynamic Menus** - Context-aware options (e.g., export only shows after checks)
- 🎨 **ASCII Banner** - Beautiful gradient COMP-LEO branding
- 📦 **Optional Dependencies** - `[interactive]`, `[watch]`, `[all]` install options
- 🛠️ **CI Generator** - `comp-leo init-ci` generates GitHub Actions, GitLab CI, pre-commit hooks
- 📊 **Enhanced Formatters** - Added `format_report()` function for all export formats
- 📝 **WHY_LOCAL.md** - Comprehensive doc on privacy and decentralization philosophy

### Changed
- 🎨 Updated CLI to show banner by default
- 📋 Improved `comp-leo --help` output with better organization
- 🔧 Interactive mode now supports both menu (`--interactive`) and classic (`--classic`) modes
- 📊 Better error handling and user feedback throughout

### Fixed
- 🐛 Fixed missing `format_report` import error
- 🔧 Improved relative path handling in file browser
- 📁 Better directory traversal for Leo file discovery

## [0.1.0] - 2025-10-27

### Added
- 🚀 Initial release
- 🔍 Leo parser with regex-based AST extraction
- 🛡️ 10+ security and compliance rules (aleo-baseline policy)
- 📊 Smart scoring algorithm (0-100 scale)
- 🎨 Beautiful CLI with rich formatting
- 📈 Multiple export formats (JSON, HTML, Markdown)
- 🤖 CI/CD integration examples
- 🔒 100% local analysis (zero network calls)
- ⚡ Fast performance (<100ms per file)
- 📚 Comprehensive documentation
- 🧪 Test suite with real Leo programs
- 📦 Published to PyPI

### Architecture
- `LeoParser` - Regex-based source code parser
- `ComplianceChecker` - Rule engine with policy packs
- `CheckResult` - Pydantic models for type safety
- CLI with Click framework
- Rich library for beautiful terminal output

---

## [Unreleased]

### Planned for v0.2.0
- Complete NIST 800-53 policy pack (1200+ controls)
- Complete ISO 27001 policy pack (114 controls)
- VS Code extension
- File watching mode improvements
- More granular rule configuration

### Planned for v0.3.0
- PCI-DSS policy pack
- GDPR policy pack
- Custom rule creation guide
- Performance optimizations
- Multi-file batch analysis

### Planned for v0.4.0
- AI-powered auto-fix (opt-in with user's API key)
- Local LLM support (Ollama, LM Studio)
- Fix confidence scoring
- Automated PR generation

---

**Version Format:** MAJOR.MINOR.PATCH
- MAJOR: Breaking changes
- MINOR: New features (backwards compatible)
- PATCH: Bug fixes (backwards compatible)
