"""add triggers [479103df60b6].

Revision ID: 479103df60b6
Revises: 76a7b9451ccd
Create Date: 2024-02-21 09:31:48.400366

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "479103df60b6"
down_revision = "76a7b9451ccd"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "event_source",
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "flavor", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "plugin_subtype",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        ),
        sa.Column(
            "description", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("configuration", sa.LargeBinary(), nullable=False),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_event_source_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_event_source_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "trigger",
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column(
            "event_source_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column(
            "service_account_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("description", sa.TEXT(), nullable=True),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("auth_window", sa.Integer(), nullable=False),
        sa.Column("event_filter", sa.LargeBinary(), nullable=False),
        sa.Column("action", sa.LargeBinary(), nullable=False),
        sa.Column(
            "action_flavor", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "action_subtype",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        ),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["event_source_id"],
            ["event_source.id"],
            name="fk_trigger_event_source_id_event_source",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["service_account_id"],
            ["user.id"],
            name="fk_trigger_service_account_id_user",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_trigger_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_trigger_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "trigger_execution",
        sa.Column("trigger_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("event_metadata", sa.LargeBinary(), nullable=True),
        sa.ForeignKeyConstraint(
            ["trigger_id"],
            ["trigger.id"],
            name="fk_trigger_execution_trigger_id_trigger",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "trigger_execution_id",
                sqlmodel.sql.sqltypes.GUID(),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            "fk_pipeline_run_trigger_execution_id_trigger_execution",
            "trigger_execution",
            ["trigger_execution_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_pipeline_run_trigger_execution_id_trigger_execution",
            type_="foreignkey",
        )
        batch_op.drop_column("trigger_execution_id")

    op.drop_table("trigger_execution")
    op.drop_table("trigger")
    op.drop_table("event_source")
    # ### end Alembic commands ###
