"""Added logs table [ade72effebaf].

Revision ID: ade72effebaf
Revises: 0.40.2
Create Date: 2023-05-10 17:26:03.716357

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "ade72effebaf"
down_revision = "0.40.2"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "logs",
        sa.Column(
            "pipeline_run_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
        ),
        sa.Column("step_run_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column(
            "artifact_store_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("uri", sa.TEXT(), nullable=False),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["artifact_store_id"],
            ["stack_component.id"],
            name="fk_logs_stack_component_id_stack_component",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["pipeline_run_id"],
            ["pipeline_run.id"],
            name="fk_logs_pipeline_run_id_pipeline_run",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["step_run_id"],
            ["step_run.id"],
            name="fk_logs_step_run_id_step_run",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("logs")
    # ### end Alembic commands ###
