# rustmodels

A high-performance statistical modeling library that combines the speed of Rust with the familiar syntax of R. rustmodels provides Python bindings for statistical models implemented in Rust, offering significant performance improvements while maintaining an intuitive R-like formula interface.

## Overview

rustmodels bridges the gap between R's expressive formula syntax and Python's ecosystem, delivering computational efficiency through Rust's zero-cost abstractions and memory safety. The library is designed for data scientists and statisticians who need the familiar formula-based model specification of R but want the performance benefits of compiled code.

The library currently focuses on foundational statistical models with plans to expand to more complex modeling techniques. All models are implemented from scratch in Rust to ensure optimal performance and reliability.

## Features

- **R-like Formula Syntax**: Specify models using familiar R formula notation (e.g., `y ~ x1 + x2 + x1:x2`)
- **High Performance**: Core algorithms implemented in Rust for maximum computational efficiency
- **Memory Safe**: Leverages Rust's ownership system to prevent common memory-related bugs
- **Python Integration**: Seamless integration with the Python data science ecosystem
- **Type Safety**: Compile-time guarantees help catch errors before runtime

## Currently Implemented Models

- Linear Regression (in development)

## Planned Models

- Mixed Effects Models
- Generalized Linear Models

And potentially more!

## Installation

```bash
pip install rustmodels
```

## Quick Start

### Basic Linear Regression

[CODE EXAMPLE PLACEHOLDER - Linear regression with simple formula]

### Multiple Predictors

[CODE EXAMPLE PLACEHOLDER - Multiple predictors with interactions]

### Working with DataFrames

[CODE EXAMPLE PLACEHOLDER - Integration with polars DataFrames]

## Formula Syntax

rustmodels supports standard R formula notation:

- `y ~ x`: Simple linear regression
- `y ~ x1 + x2`: Multiple regression
- `y ~ x1 * x2`: Main effects and interaction (equivalent to `x1 + x2 + x1:x2`)
- `y ~ x1:x2`: Interaction only
- `y ~ x - 1`: Remove intercept

[DETAILED FORMULA SYNTAX EXAMPLES PLACEHOLDER]

## API Reference

### LinearRegression

[API DOCUMENTATION PLACEHOLDER]

## Performance

rustmodels is designed for performance. Benchmarks show significant speed improvements over equivalent implementations in pure Python, particularly for large datasets.

[PERFORMANCE BENCHMARKS PLACEHOLDER]

## Requirements

- Python 3.8 or higher

## Development Status

This project is in active development. The API may change between versions until reaching 1.0. Currently implementing core linear regression functionality with plans to expand to more sophisticated models.

## Contributing

Contributions are welcome! This project involves both Rust and Python development. Please see the contributing guidelines for details on setting up the development environment.

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Acknowledgments

Inspired by R's formula interface and the broader statistical computing community's work on making statistical modeling accessible and efficient.