from .core.http import HttpClient

class AgentFlows:
    def __init__(self, http: HttpClient):
        self.http = http

    def list(
        self,
        project_id: str | None = None,
        projectID: str | None = None,
        skip: int | None = None,
        limit: int | None = None,
    ):
        # API expects 'projectID' (capital D); accept both and normalize
        pid = projectID or project_id
        params: dict | None = None
        if pid is not None or skip is not None or limit is not None:
            params = {}
            if pid is not None:
                params["projectID"] = pid
            if skip is not None:
                params["skip"] = skip
            if limit is not None:
                params["limit"] = limit
        return self.http.request("GET", "/agentflows", params=params)

    def get(self, id: str):
        return self.http.request("GET", f"/agentflow/{id}")

    def create(self, body: dict):
        return self.http.request("POST", "/agentflow/", json=body)

    def update(self, id: str, body: dict):
        return self.http.request("PUT", f"/agentflow/{id}", json=body)

    def delete(self, project_id: str, id: str):
        return self.http.request("DELETE", f"/agentflow/{project_id}/{id}")
