from __future__ import annotations
from typing import Optional, Dict, Any

from .core.http import HttpClient

class Projects:
    def __init__(self, http: HttpClient):
        self.http = http

    # Per developers.wexa.ai: POST https://api.wexa.ai/v1/project
    def create(self, body: Dict[str, Any]):
        """
        Expected body (example):
        {
          "orgId": "67fdea40aac77be632954f0f",
          "projectName": "New",
          "description": "yoooo",
          "coworker_role": "testrole"
        }
        """
        return self.http.request("POST", "/v1/project", json=body)

    def list(self):
        return self.http.request("GET", "/v1/project")

    def get(self, project_id: str):
        return self.http.request("GET", f"/v1/project/{project_id}")

    def update(self, project_id: str, body: Dict[str, Any]):
        return self.http.request("PUT", f"/v1/project/{project_id}", json=body)

    def delete(self, project_id: str):
        return self.http.request("DELETE", f"/v1/project/{project_id}")
