"""Drop dataset filters

Revision ID: 47351f8c7ebc
Revises: fbce16ff4e47
Create Date: 2025-03-26 11:10:17.869028

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "47351f8c7ebc"
down_revision = "fbce16ff4e47"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.drop_column("type_filters")
        batch_op.drop_column("attribute_filters")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "attribute_filters",
                postgresql.JSON(astext_type=sa.Text()),
                server_default=sa.text("'{}'::json"),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "type_filters",
                postgresql.JSON(astext_type=sa.Text()),
                server_default=sa.text("'{}'::json"),
                autoincrement=False,
                nullable=False,
            )
        )

    # ### end Alembic commands ###
