"""Add ApplyWorkflow.first_task_index and ApplyWorkflow.last_task_index

Revision ID: 70e77f1c38b0
Revises: f384e1c0cf5d
Create Date: 2023-07-17 11:39:47.679582

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.sql import column
from sqlalchemy.sql import table

# revision identifiers, used by Alembic.
revision = "70e77f1c38b0"
down_revision = "f384e1c0cf5d"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """ """

    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("first_task_index", sa.Integer(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_task_index", sa.Integer(), nullable=True)
        )

    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        applyworkflow = table("applyworkflow", column("first_task_index"))
        batch_op.execute(applyworkflow.update().values(first_task_index=9999))
        applyworkflow = table("applyworkflow", column("last_task_index"))
        batch_op.execute(applyworkflow.update().values(last_task_index=9999))

    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.alter_column("first_task_index", nullable=False)
        batch_op.alter_column("last_task_index", nullable=False)


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.drop_column("last_task_index")
        batch_op.drop_column("first_task_index")

    # ### end Alembic commands ###
