"""Add accounting tables

Revision ID: af1ef1c83c9b
Revises: 1eac13a26c83
Create Date: 2025-02-17 14:22:32.701581

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "af1ef1c83c9b"
down_revision = "1eac13a26c83"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "accountingrecord",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("timestamp", sa.DateTime(timezone=True), nullable=False),
        sa.Column("num_tasks", sa.Integer(), nullable=False),
        sa.Column("num_new_images", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
            name=op.f("fk_accountingrecord_user_id_user_oauth"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_accountingrecord")),
    )
    op.create_table(
        "accountingrecordslurm",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("timestamp", sa.DateTime(timezone=True), nullable=False),
        sa.Column(
            "slurm_job_ids", postgresql.ARRAY(sa.Integer()), nullable=True
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
            name=op.f("fk_accountingrecordslurm_user_id_user_oauth"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_accountingrecordslurm")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("accountingrecordslurm")
    op.drop_table("accountingrecord")
    # ### end Alembic commands ###
