"""TaskGroup Activity and venv-info to TaskGroup

Revision ID: d256a7379ab8
Revises: 19eca0dd47a9
Create Date: 2024-11-20 15:01:52.659832

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "d256a7379ab8"
down_revision = "19eca0dd47a9"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "taskgroupactivityv2",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("taskgroupv2_id", sa.Integer(), nullable=True),
        sa.Column(
            "timestamp_started", sa.DateTime(timezone=True), nullable=False
        ),
        sa.Column(
            "pkg_name", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "version", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "status", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "action", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("log", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column(
            "timestamp_ended", sa.DateTime(timezone=True), nullable=True
        ),
        sa.ForeignKeyConstraint(
            ["taskgroupv2_id"],
            ["taskgroupv2.id"],
            name=op.f("fk_taskgroupactivityv2_taskgroupv2_id_taskgroupv2"),
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
            name=op.f("fk_taskgroupactivityv2_user_id_user_oauth"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_taskgroupactivityv2")),
    )
    op.drop_table("collectionstatev2")
    with op.batch_alter_table("taskgroupv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "pip_freeze", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column("venv_size_in_kB", sa.Integer(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("venv_file_number", sa.Integer(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "timestamp_last_used",
                sa.DateTime(timezone=True),
                server_default="2024-11-20T00:00:00+00:00",
                nullable=False,
            )
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("taskgroupv2", schema=None) as batch_op:
        batch_op.drop_column("timestamp_last_used")
        batch_op.drop_column("venv_file_number")
        batch_op.drop_column("venv_size_in_kB")
        batch_op.drop_column("pip_freeze")

    op.create_table(
        "collectionstatev2",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "data",
            postgresql.JSON(astext_type=sa.Text()),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "timestamp",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "taskgroupv2_id", sa.INTEGER(), autoincrement=False, nullable=True
        ),
        sa.ForeignKeyConstraint(
            ["taskgroupv2_id"],
            ["taskgroupv2.id"],
            name="fk_collectionstatev2_taskgroupv2_id_taskgroupv2",
        ),
        sa.PrimaryKeyConstraint("id", name="pk_collectionstatev2"),
    )
    op.drop_table("taskgroupactivityv2")
    # ### end Alembic commands ###
