"""split filters and keep old columns

Revision ID: db09233ad13a
Revises: 316140ff7ee1
Create Date: 2025-01-14 14:50:46.007222

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "db09233ad13a"
down_revision = "316140ff7ee1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "type_filters", sa.JSON(), server_default="{}", nullable=False
            )
        )
        batch_op.add_column(
            sa.Column(
                "attribute_filters",
                sa.JSON(),
                server_default="{}",
                nullable=False,
            )
        )
        batch_op.alter_column(
            "filters",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            nullable=True,
            server_default="null",
        )

    with op.batch_alter_table("jobv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "attribute_filters",
                sa.JSON(),
                server_default="{}",
                nullable=False,
            )
        )

    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "type_filters", sa.JSON(), server_default="{}", nullable=False
            )
        )
        batch_op.alter_column(
            "input_filters",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            nullable=True,
            server_default="null",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.alter_column(
            "input_filters",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            nullable=False,
            existing_server_default=sa.text(
                '\'{"attributes": {}, "types": {}}\'::json'
            ),
        )
        batch_op.drop_column("type_filters")

    with op.batch_alter_table("jobv2", schema=None) as batch_op:
        batch_op.drop_column("attribute_filters")

    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.alter_column(
            "filters",
            existing_type=postgresql.JSON(astext_type=sa.Text()),
            nullable=False,
            existing_server_default=sa.text(
                '\'{"attributes": {}, "types": {}}\'::json'
            ),
        )
        batch_op.drop_column("attribute_filters")
        batch_op.drop_column("type_filters")

    # ### end Alembic commands ###
