# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['c2cciutils',
 'c2cciutils.lib',
 'c2cciutils.node_modules.snyk.pysrc',
 'c2cciutils.node_modules.snyk.pysrc.pytoml',
 'c2cciutils.node_modules.snyk.pysrc.requirements',
 'c2cciutils.scripts',
 'c2cciutils.scripts.k8s']

package_data = \
{'': ['*'],
 'c2cciutils': ['node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/browser.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/constants.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/helpers.js',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.cjs',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/index.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/lib/monorepo.js',
                'node_modules/@pkgr/utils/package.json',
                'node_modules/@toml-tools/lexer/lib/*',
                'node_modules/@toml-tools/lexer/package.json',
                'node_modules/@toml-tools/parser/lib/*',
                'node_modules/@toml-tools/parser/package.json',
                'node_modules/chevrotain/lib/chevrotain.js',
                'node_modules/chevrotain/lib/chevrotain.js',
                'node_modules/chevrotain/lib/chevrotain.min.js',
                'node_modules/chevrotain/lib/chevrotain.min.js',
                'node_modules/chevrotain/lib/src/*',
                'node_modules/chevrotain/lib/src/diagrams/*',
                'node_modules/chevrotain/lib/src/generate/*',
                'node_modules/chevrotain/lib/src/lang/*',
                'node_modules/chevrotain/lib/src/parse/*',
                'node_modules/chevrotain/lib/src/parse/cst/*',
                'node_modules/chevrotain/lib/src/parse/grammar/*',
                'node_modules/chevrotain/lib/src/parse/grammar/gast/*',
                'node_modules/chevrotain/lib/src/parse/parser/*',
                'node_modules/chevrotain/lib/src/parse/parser/traits/*',
                'node_modules/chevrotain/lib/src/scan/*',
                'node_modules/chevrotain/lib/src/text/*',
                'node_modules/chevrotain/lib/src/utils/*',
                'node_modules/chevrotain/package.json',
                'node_modules/cross-spawn/index.js',
                'node_modules/cross-spawn/index.js',
                'node_modules/cross-spawn/lib/*',
                'node_modules/cross-spawn/lib/util/*',
                'node_modules/cross-spawn/package.json',
                'node_modules/cross-spawn/package.json',
                'node_modules/define-lazy-prop/index.js',
                'node_modules/define-lazy-prop/index.js',
                'node_modules/define-lazy-prop/package.json',
                'node_modules/define-lazy-prop/package.json',
                'node_modules/globalyzer/package.json',
                'node_modules/globalyzer/src/index.js',
                'node_modules/globrex/index.js',
                'node_modules/globrex/index.js',
                'node_modules/globrex/package.json',
                'node_modules/globrex/package.json',
                'node_modules/is-docker/cli.js',
                'node_modules/is-docker/cli.js',
                'node_modules/is-docker/cli.js',
                'node_modules/is-docker/index.js',
                'node_modules/is-docker/index.js',
                'node_modules/is-docker/index.js',
                'node_modules/is-docker/package.json',
                'node_modules/is-docker/package.json',
                'node_modules/is-docker/package.json',
                'node_modules/is-extglob/index.js',
                'node_modules/is-extglob/index.js',
                'node_modules/is-extglob/package.json',
                'node_modules/is-extglob/package.json',
                'node_modules/is-glob/index.js',
                'node_modules/is-glob/index.js',
                'node_modules/is-glob/package.json',
                'node_modules/is-glob/package.json',
                'node_modules/is-wsl/index.js',
                'node_modules/is-wsl/index.js',
                'node_modules/is-wsl/package.json',
                'node_modules/is-wsl/package.json',
                'node_modules/isexe/index.js',
                'node_modules/isexe/index.js',
                'node_modules/isexe/index.js',
                'node_modules/isexe/index.js',
                'node_modules/isexe/mode.js',
                'node_modules/isexe/mode.js',
                'node_modules/isexe/mode.js',
                'node_modules/isexe/mode.js',
                'node_modules/isexe/package.json',
                'node_modules/isexe/package.json',
                'node_modules/isexe/package.json',
                'node_modules/isexe/package.json',
                'node_modules/isexe/windows.js',
                'node_modules/isexe/windows.js',
                'node_modules/isexe/windows.js',
                'node_modules/isexe/windows.js',
                'node_modules/mvdan-sh/index.js',
                'node_modules/mvdan-sh/index.js',
                'node_modules/mvdan-sh/package.json',
                'node_modules/mvdan-sh/package.json',
                'node_modules/open/index.js',
                'node_modules/open/index.js',
                'node_modules/open/package.json',
                'node_modules/open/package.json',
                'node_modules/path-key/index.js',
                'node_modules/path-key/index.js',
                'node_modules/path-key/package.json',
                'node_modules/path-key/package.json',
                'node_modules/picocolors/package.json',
                'node_modules/picocolors/package.json',
                'node_modules/picocolors/package.json',
                'node_modules/picocolors/picocolors.browser.js',
                'node_modules/picocolors/picocolors.browser.js',
                'node_modules/picocolors/picocolors.browser.js',
                'node_modules/picocolors/picocolors.js',
                'node_modules/picocolors/picocolors.js',
                'node_modules/picocolors/picocolors.js',
                'node_modules/prettier-plugin-sh/lib/index.cjs',
                'node_modules/prettier-plugin-sh/lib/index.cjs',
                'node_modules/prettier-plugin-sh/lib/index.cjs',
                'node_modules/prettier-plugin-sh/lib/index.cjs',
                'node_modules/prettier-plugin-sh/lib/index.js',
                'node_modules/prettier-plugin-sh/lib/index.js',
                'node_modules/prettier-plugin-sh/lib/index.js',
                'node_modules/prettier-plugin-sh/lib/index.js',
                'node_modules/prettier-plugin-sh/lib/languages.js',
                'node_modules/prettier-plugin-sh/lib/languages.js',
                'node_modules/prettier-plugin-sh/lib/languages.js',
                'node_modules/prettier-plugin-sh/lib/languages.js',
                'node_modules/prettier-plugin-sh/lib/worker.js',
                'node_modules/prettier-plugin-sh/lib/worker.js',
                'node_modules/prettier-plugin-sh/lib/worker.js',
                'node_modules/prettier-plugin-sh/lib/worker.js',
                'node_modules/prettier-plugin-sh/package.json',
                'node_modules/prettier-plugin-toml/lib/*',
                'node_modules/prettier-plugin-toml/package.json',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/bin-prettier.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/cli.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/doc.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/index.js',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/package.json',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-angular.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-babel.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-espree.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-flow.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-glimmer.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-graphql.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-html.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-markdown.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-meriyah.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-postcss.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-typescript.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/parser-yaml.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/standalone.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/prettier/third-party.js',
                'node_modules/regexp-to-ast/lib/*',
                'node_modules/regexp-to-ast/package.json',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/browser.js',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.cjs',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/index.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/processor.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/shim.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/lib/types.js',
                'node_modules/sh-syntax/package.json',
                'node_modules/sh-syntax/vendors/wasm_exec.js',
                'node_modules/shebang-command/index.js',
                'node_modules/shebang-command/index.js',
                'node_modules/shebang-command/package.json',
                'node_modules/shebang-command/package.json',
                'node_modules/shebang-regex/index.js',
                'node_modules/shebang-regex/index.js',
                'node_modules/shebang-regex/package.json',
                'node_modules/shebang-regex/package.json',
                'node_modules/snyk/bin/*',
                'node_modules/snyk/dist/cli/*',
                'node_modules/snyk/dist/cli/commands/*',
                'node_modules/snyk/dist/cli/commands/apps/*',
                'node_modules/snyk/dist/cli/commands/auth/*',
                'node_modules/snyk/dist/cli/commands/fix/*',
                'node_modules/snyk/dist/cli/commands/help/*',
                'node_modules/snyk/dist/cli/commands/monitor/*',
                'node_modules/snyk/dist/cli/commands/protect/*',
                'node_modules/snyk/dist/cli/commands/test/*',
                'node_modules/snyk/dist/cli/commands/test/iac/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/org-settings/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/parsers/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/parsers/hcl-to-json-v2/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/process-results/*',
                'node_modules/snyk/dist/cli/commands/test/iac/local-execution/rules/*',
                'node_modules/snyk/dist/cli/commands/test/iac/v2/*',
                'node_modules/snyk/dist/cli/commands/woof/*',
                'node_modules/snyk/dist/elixirsrc/*',
                'node_modules/snyk/dist/elixirsrc/lib/*',
                'node_modules/snyk/dist/elixirsrc/lib/json/*',
                'node_modules/snyk/dist/elixirsrc/lib/json/lib/*',
                'node_modules/snyk/dist/elixirsrc/lib/json/lib/json/*',
                'node_modules/snyk/dist/elixirsrc/lib/json/lib/json/encoder/*',
                'node_modules/snyk/dist/elixirsrc/lib/json/lib/json/parser/*',
                'node_modules/snyk/dist/elixirsrc/lib/mix/tasks/*',
                'node_modules/snyk/dist/gosrc/*',
                'node_modules/snyk/dist/lib/*',
                'node_modules/snyk/dist/lib/analytics/*',
                'node_modules/snyk/dist/lib/apps/*',
                'node_modules/snyk/dist/lib/apps/create-app/*',
                'node_modules/snyk/dist/lib/config/*',
                'node_modules/snyk/dist/lib/container/*',
                'node_modules/snyk/dist/lib/ecosystems/*',
                'node_modules/snyk/dist/lib/ecosystems/unmanaged/*',
                'node_modules/snyk/dist/lib/errors/*',
                'node_modules/snyk/dist/lib/feature-flags/*',
                'node_modules/snyk/dist/lib/formatters/*',
                'node_modules/snyk/dist/lib/formatters/docker/*',
                'node_modules/snyk/dist/lib/formatters/iac-output/*',
                'node_modules/snyk/dist/lib/formatters/iac-output/text/*',
                'node_modules/snyk/dist/lib/formatters/iac-output/text/failures/*',
                'node_modules/snyk/dist/lib/formatters/iac-output/text/issues-list/*',
                'node_modules/snyk/dist/lib/formatters/test/*',
                'node_modules/snyk/dist/lib/iac/*',
                'node_modules/snyk/dist/lib/iac/assets/*',
                'node_modules/snyk/dist/lib/iac/drift/*',
                'node_modules/snyk/dist/lib/iac/test/v2/*',
                'node_modules/snyk/dist/lib/iac/test/v2/analytics/*',
                'node_modules/snyk/dist/lib/iac/test/v2/local-cache/*',
                'node_modules/snyk/dist/lib/iac/test/v2/local-cache/policy-engine/*',
                'node_modules/snyk/dist/lib/iac/test/v2/local-cache/policy-engine/constants/*',
                'node_modules/snyk/dist/lib/iac/test/v2/local-cache/rules-bundle/*',
                'node_modules/snyk/dist/lib/iac/test/v2/scan/*',
                'node_modules/snyk/dist/lib/module-info/*',
                'node_modules/snyk/dist/lib/monitor/*',
                'node_modules/snyk/dist/lib/plugins/*',
                'node_modules/snyk/dist/lib/plugins/nodejs-plugin/*',
                'node_modules/snyk/dist/lib/plugins/rubygems/*',
                'node_modules/snyk/dist/lib/plugins/rubygems/inspectors/*',
                'node_modules/snyk/dist/lib/plugins/sast/*',
                'node_modules/snyk/dist/lib/plugins/sast/errors/*',
                'node_modules/snyk/dist/lib/plugins/sast/format/*',
                'node_modules/snyk/dist/lib/plugins/sast/utils/*',
                'node_modules/snyk/dist/lib/policy/*',
                'node_modules/snyk/dist/lib/polling/*',
                'node_modules/snyk/dist/lib/project-metadata/*',
                'node_modules/snyk/dist/lib/project-metadata/target-builders/*',
                'node_modules/snyk/dist/lib/request/*',
                'node_modules/snyk/dist/lib/sln/*',
                'node_modules/snyk/dist/lib/snyk-test/*',
                'node_modules/snyk/dist/scala/*',
                'node_modules/snyk/package.json',
                'node_modules/synckit/lib/index.cjs',
                'node_modules/synckit/lib/index.cjs',
                'node_modules/synckit/lib/index.cjs',
                'node_modules/synckit/lib/index.js',
                'node_modules/synckit/lib/index.js',
                'node_modules/synckit/lib/index.js',
                'node_modules/synckit/lib/types.js',
                'node_modules/synckit/lib/types.js',
                'node_modules/synckit/lib/types.js',
                'node_modules/synckit/package.json',
                'node_modules/tiny-glob/index.js',
                'node_modules/tiny-glob/index.js',
                'node_modules/tiny-glob/index.js',
                'node_modules/tiny-glob/package.json',
                'node_modules/tiny-glob/package.json',
                'node_modules/tiny-glob/package.json',
                'node_modules/tiny-glob/sync.js',
                'node_modules/tiny-glob/sync.js',
                'node_modules/tiny-glob/sync.js',
                'node_modules/tslib/modules/*',
                'node_modules/tslib/package.json',
                'node_modules/tslib/package.json',
                'node_modules/tslib/package.json',
                'node_modules/tslib/tslib.es6.js',
                'node_modules/tslib/tslib.es6.js',
                'node_modules/tslib/tslib.es6.js',
                'node_modules/tslib/tslib.js',
                'node_modules/tslib/tslib.js',
                'node_modules/tslib/tslib.js',
                'node_modules/which/package.json',
                'node_modules/which/package.json',
                'node_modules/which/which.js',
                'node_modules/which/which.js']}

install_requires = \
['Markdown>=3.0.0,<4.0.0',
 'PyYAML>=6.0.0,<7.0.0',
 'click>=8.0.0,<9.0.0',
 'debian-inspector>=31.0.0,<32.0.0',
 'defusedxml>=0.0.0,<1.0.0',
 'jsonschema-gentypes>=1.4.0,<1.5.0',
 'jsonschema>=4.0.0,<5.0.0',
 'markdown-table>=2020.0.0,<2021.0.0',
 'node-vm2>=0.0.0,<1.0.0',
 'python-magic>=0.0.0,<1.0.0',
 'requests>=2.0.0,<3.0.0',
 'ruamel.yaml>=0.0.0,<1.0.0',
 'toml>=0.0.0,<1.0.0']

extras_require = \
{'checks': ['EditorConfig>=0.0.0,<1.0.0',
            'black==24.3.0',
            'isort==5.12.0',
            'codespell==2.2.6'],
 'pr-checks': ['codespell==2.2.6'],
 'publish': ['google-api-python-client>=2.0.0,<3.0.0',
             'google-auth-httplib2>=0.0.0,<1.0.0',
             'google-auth-oauthlib>=0.0.0,<1.0.0',
             'twine>=4.0.0,<5.0.0',
             'tomlkit>=0.0.0,<1.0.0']}

entry_points = \
{'console_scripts': ['c2cciutils = c2cciutils.scripts.main:main',
                     'c2cciutils-audit = c2cciutils.scripts.audit:main',
                     'c2cciutils-checks = c2cciutils.scripts.checks:main',
                     'c2cciutils-clean = c2cciutils.scripts.clean:main',
                     'c2cciutils-docker-logs = '
                     'c2cciutils.scripts.docker_logs:main',
                     'c2cciutils-docker-versions-gen = '
                     'c2cciutils.scripts.docker_versions_gen:main',
                     'c2cciutils-download-applications = '
                     'c2cciutils.scripts.download_applications:main',
                     'c2cciutils-google-calendar = '
                     'c2cciutils.publish:main_calendar',
                     'c2cciutils-k8s-db = c2cciutils.scripts.k8s.db:main',
                     'c2cciutils-k8s-install = '
                     'c2cciutils.scripts.k8s.install:main',
                     'c2cciutils-k8s-logs = c2cciutils.scripts.k8s.logs:main',
                     'c2cciutils-k8s-wait = c2cciutils.scripts.k8s.wait:main',
                     'c2cciutils-pin-pipenv = '
                     'c2cciutils.scripts.pin_pipenv:main',
                     'c2cciutils-publish = c2cciutils.scripts.publish:main',
                     'c2cciutils-pull-request-checks = '
                     'c2cciutils.scripts.pr_checks:main',
                     'c2cciutils-trigger-image-update = '
                     'c2cciutils.scripts.trigger_image_update:main']}

setup_kwargs = {
    'name': 'c2cciutils',
    'version': '1.5.15.dev3',
    'description': 'Common utilities for Camptocamp CI',
    'long_description': '# C2C CI utils\n\nThe goals of C2C CI utils are:\n\n- Have some global checks that\'s didn\'t request any dependency related to the application:\n  this commands return 3 types of results:\n  - Print some useful information:\n    - The version of some packages\n    - The used configuration (with default and autodetect)\n    - The environment variables\n    - The GitHub event file\n  - Check that some configuration where correct:\n    - Git attributes\n    - That the timeout is present in the GitHub workflow files\n    - That the stabilization version (get from the Security.md) are used everywhere it\'s needed\n  - Check the code style:\n    - End of files\n    - Black\n    - Isort\n    - Code spell\n    - Prettier\n  - Snyk tests\n    - Test (never failed)\n    - Code test (never failed, disabled by default)\n    - Iac Test (never failed, disabled by default)\n    - Fix (For information only, disabled by default)\n\nEvery check can be disabled with the following config (the configuration is `ci/config.yaml`):\n\n```yaml\nchecks:\n  <check name>: false\n```\n\nIt make easier to place the following workflows:\n\n- `audit.yaml`: Audit the stabilization branches of the application against vulnerabilities in the python and node dependency\n- `auto-review.yaml`: Auto review the Renovate pull requests\n- `backport.yaml`: Trigger the backports (work with labels)\n- `clean.yaml`: Clean the Docker images related on a deleted feature branch\n- `codeql.yaml`: Run a GitHub CodeQL check\n- `main.yaml`: Main workflow especially with the c2cciutils-checks command\n- `rebuild.yaml`: Daily rebuild of the Docker images on the stabilization branches.\n\nAll the provided commands:\n\n- `c2cciutils`: some generic tools.\n- `c2cciutils-checks`: Run the checks on the code (those checks don\'t need any project dependencies).\n- `c2cciutils-audit`: Do the audit, the main difference with checks is that it can change between runs on the same code.\n- `c2cciutils-publish`: Publish the project.\n- `c2cciutils-clean`: Delete Docker images on Docker Hub after corresponding branch have been deleted.\n- `c2cciutils-google-calendar`: Tool to test the Google credentials for calendar API and refresh them if needed. See `c2cciutils-google-calendar -h` for more information.\n- `c2cciutils-k8s-install`: Install a k3d / k3s cluster, see below.\n- `c2cciutils-k8s-db`: Create a database in the k8s cluster, see below.\n- `c2cciutils-k8s-wait`: Wait that the application started correctly in the cluster, see below.\n- `c2cciutils-k8s-logs`: Display the logs of the application in the k8s cluster, see below.\n- `c2cciutils-pin-pipenv`: Display all the dependencies that\'s in the `Pipenv.lock` but not in the `Pipenv` to be able to pin them.\n- `c2cciutils-docker-logs`: Display the logs of the application in Docker (compose).\n- `c2cciutils-trigger-image-update`: Trigger the ArgoCD repository about image update on the CI (automatically done in the publishing).\n- `c2cciutils-download-applications`: Download the applications with version managed by Renovate, see below.\n- `c2cciutils-docker-versions-gen`: Generate the Docker package versions file (`ci/dpkg-versions.yaml`), see below.\n\n## New project\n\nThe content of `example-project` can be a good base for a new project.\n\n## Secrets\n\nIn the CI we need to have the following secrets::\n\n- `HAS_SECRETS` to be set to \'HAS_SECRETS\', to avoid error errors from external\n  pull requests, already set globally on Camptocamp organization.\n- `GOPASS_CI_GITHUB_TOKEN` and `CI_GPG_PRIVATE_KEY` required to initialize the gopass password store,\n  the secrets exists in the Camptocamp organization but not shared on all project, then you should add\n  your project to the shared list.\n\n## Use locally, in the projects that use c2cciutils\n\nInstall it: `python3 -m pip install --user --requirement ci/requirements.txt`\nRun the checkers: `c2cciutils-checks [--fix] [--stop] [--check CHECK]`\nDry run publish: `GITHUB_REF=... c2cciutils-publish --dry-run ...`\n\n## Configuration\n\nYou can get the current configuration with `c2cciutils --get-config`, the default configuration depends on your project.\nNote that it didn\'t contain the default defined the schema and visible in the [generated documentation](./config.md).\n\nYou can override the configuration with the file `ci/config.yaml`.\n\nAt the base of the configuration you have:\n\n- `version`: Contains some regular expressions to find the versions branches and tags, and to convert them into application versions.\n- `checks`: The checker\'s configuration, see `c2cciutils/checks.py` for more information.\n- `audit`: The audit configuration, see `c2cciutils/audit.py` for more information.\n- `publish`: The publishing configuration, see `c2cciutils/publish.py` for more information.\n\nMany actions can be disabled by setting the corresponding configuration part to `False`.\n\n## SECURITY.md\n\nThe `SECURITY.md` file should contain the security policy of the repository, especially the end of\nsupport dates.\n\nFor compatibility with `c2cciutils` it should contain an array with at least the columns\n`Version` and `Supported Until`. The `Version` column will contain the concerned version.\nThe `Supported Until` will contain the date of end of support `dd/mm/yyyy`.\nIt can also contain the following sentences:\n\n- `Unsupported`: no longer supported => no audit, no rebuild.\n- `Best effort`: the support is ended, it is still rebuilt and audited, but this can be stopped without any notice.\n- `To be defined`: not yet released or the date will be set related of another project release date (like for GeoMapFish).\n\nSee also [GitHub Documentation](https://docs.github.com/en/github/managing-security-vulnerabilities/adding-a-security-policy-to-your-repository)\n\n## IDE\n\nThe IDE should be configured as:\n\n- using `black` and `isort` without any arguments,\n- using the `editorconfig` configuration.\n\n### VScode\n\n- Recommend extensions to work well with c2cciutils:\n  - [Prettier](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode) And use EditorConfig\n  - [shell-format](https://marketplace.visualstudio.com/items?itemName=foxundermoon.shell-format) With the configuration\n    `"shellformat.flag": "-bn"`.\n  - [Better TOML](https://marketplace.visualstudio.com/items?itemName=bodil.prettier-toml)\n- Other recommend extensions:\n  - [hadolint](https://marketplace.visualstudio.com/items?itemName=exiasr.hadolint)\n  - [Code Spell Checker](https://marketplace.visualstudio.com/items?itemName=streetsidesoftware.code-spell-checker)\n\nSelect a formatter:\n\n- `CTRL+MAJ+P`\n- Format document With...\n- Configure Default Formatter...\n- Select the formatter\n\n## Publishing\n\n### To pypi\n\nThe config is like this:\n\n```yaml\nversions:\n  # List of kinds of versions you want to publish, that can be:\n  # rebuild (specified with --type),\n  # version_tag, version_branch, feature_branch, feature_tag (for pull request)\n```\n\nIt we have a `setup.py` file, we will be in legacy mode:\nWhen publishing, the version computed from arguments or `GITHUB_REF` is put in environment variable `VERSION`, thus you should use it in `setup.py`, example:\n\n```python\nVERSION = os.environ.get("VERSION", "1.0.0")\n```\n\nAlso we consider that we use `poetry` with [poetry-dynamic-versioning](https://pypi.org/project/poetry-dynamic-versioning/) to manage the version, and [poetry-plugin-tweak-dependencies-version](https://pypi.org/project/poetry-plugin-tweak-dependencies-version/) to manage the dependencies versions.\n\nExample of configuration:\n\n```toml\n[tool.poetry-dynamic-versioning]\nenable = true\nvcs = "git"\npattern = "^(?P<base>\\\\d+(\\\\.\\\\d+)*)"\nformat-jinja = """\n{%- if env.get("VERSION_TYPE") == "version_branch" -%}\n{{serialize_pep440(bump_version(base, 1 if env.get("IS_MASTER") == "TRUE" else 2), dev=distance)}}\n{%- elif distance == 0 -%}\n{{serialize_pep440(base)}}\n{%- else -%}\n{{serialize_pep440(bump_version(base), dev=distance)}}\n{%- endif -%}\n"""\n\n```\n\nNote that we can access to the environment variables `VERSION`,`VERSION_TYPE` and `IS_MASTER`.\n\nThen by default:\n\n- Tag with `1.2.3` => release `1.2.3`\n- Commit on feature branch just do a validation\n- Commit on `master` branch after the tag 1.3.0 => release `1.4.0.dev1`\n- Commit on `1.3` branch after the tag 1.3.0 => release `1.3.1.dev1`\n\nTo make it working in the `Dockerfile` you should have in the `poetry` stage:\n\n```Dockerfile\nENV POETRY_DYNAMIC_VERSIONING_BYPASS=dev\nRUN poetry export --extras=checks --extras=publish --extras=audit --output=requirements.txt \\\n    && poetry export --with=dev --output=requirements-dev.txt\n```\n\nAnd in the `run` stage\n\n```Dockerfile\nARG VERSION=dev\nRUN --mount=type=cache,target=/root/.cache \\\n    POETRY_DYNAMIC_VERSIONING_BYPASS=${VERSION} python3 -m pip install --disable-pip-version-check --no-deps --editable=.\n```\n\nAnd in the `Makefile`:\n\n```Makefile\nVERSION = $(strip $(shell poetry version --short))\n\n.PHONY: build\nbuild: ## Build the Docker images\n    docker build --build-arg=VERSION=$(VERSION) --tag=$(GITHUB_REPOSITORY) .\n```\n\n### To Docker registry\n\nThe config is like this:\n\n```yaml\nlatest: True\nimages:\n  - name: # The base name of the image we want to publish\nrepository:\n  <internal_name>:\n    \'server\': # The fqdn name of the server if not Docker hub\n    \'version\':# List of kinds of versions you want to publish, that can be: rebuild (specified using --type),\n      # version_tag, version_branch, feature_branch, feature_tag (for pull request)\n    \'tags\':# List of tags we want to publish interpreted with `template(version=version)`\n      # e.g. if you use `{version}-lite` when you publish the version `1.2.3` the source tag\n      # (that should be built by the application build) is `latest-lite`, and it will be published\n      # with the tag `1.2.3-lite`.\n    \'group\':# If your images are published by different jobs you can separate them in different groups\n      # and publish them with `c2cciutils-publish --group=<group>`\n```\n\nBy default, the last line of the `SECURITY.md` file will be published (`docker`) with the tag\n`latest`. Set `latest` to `False` to disable it.\n\nWith the `c2cciutils-clean` the images on Docker hub for `feature_branch` will be removed on branch removing.\n\n## Download applications\n\nIn case some executables or applications from GitHub releases or any other URLs are required on the CI host\nand are not handled by any dependency manager, we provide a set of tools to install them and manage upgrades\nthrough Renovate.\n\nCreate an application file (e.-g. `applications.yaml`) with:\n\n```yaml\n# yaml-language-server: $schema=https://raw.githubusercontent.com/camptocamp/c2cciutils/master/c2cciutils/schema-applications.json\n\n# Application from GitHub release\n<organization>/<project>:\n  get-file-name: <file name present in the release>\n  to-file-name: <The file name you want to create in ~/.local/bin>\n  finish-command: # The command you want to run after the file is downloaded\n    - - chmod # To be executable (usually required)\n      - +x\n      - <to-file-name>\n    - - <to-file-name> # Print the version of the application\n      - --version\n# Application from GitHub release in a tar file (or tar.gz)\n<organization>/<project>:\n  get-file-name: <file name present in the release>\n  type: tar\n  tar-file-name: <The file name available in the tar file>\n  to-file-name: <The file name you want to create in ~/.local/bin>\n  finish-command: [...] # The command you want to run after the file is downloaded\n# Application from an URL\n<application reference name>:\n  url-pattern: <The URL used to download the application>\n  to-file-name: <The file name you want to create in ~/.local/bin>\n  finish-command: [...] # The command you want to run after the file is downloaded\n```\n\nIn the attributes `url-pattern`, `get-file-name` you can use the following variables:\n\n- `{version}`: The version of the application present in the version file.\n- `{version_quote}`: The URL encoded version.\n- `{short_version}`: The version without the `v` prefix.\n\nThe `applications-versions.yaml` file is a map of applications and their versions.\n\nAdd in your Renovate configuration:\n\n```json5\n\n  regexManagers: [\n    {\n      fileMatch: [\'^applications-versions.yaml$\'],\n      matchStrings: [\n        \'(?<depName>[^\\\\s]+): (?<currentValue>[^\\\\s]+) # (?<datasource>[^\\\\s]+)\',\n      ],\n    },\n  ],\n```\n\nNow you need to call `c2cciutils-download-applications --applications-file=applications.yaml --versions-file=applications-version.yaml`\nto install required applications on CI host before using them (an already installed application is installed only if needed).\n\n## Use Renovate to trigger a new build instead of the legacy rebuild\n\nRun the command `c2cciutils-docker-versions-gen camptocamp/image[:tag]` to generate a file that is a kind of package lock of the Debian packages in the file `ci/dpkg-versions.yaml`.\n\nAdd in your renovate configuration:\n\n```javascript\n  regexManagers: [\n    {\n      fileMatch: [\'^ci/dpkg-versions.yaml$\'],\n      matchStrings: [" *(?<depName>[^\'\\\\s]+): \'?(?<currentValue>[^\'\\\\s/]*[0-9][^\'\\\\s/]*)\'?"],\n      datasourceTemplate: \'repology\',\n      versioningTemplate: \'loose\',\n    },\n  ],\n```\n\nWhen a new version of a Debian package will be available:\n\n- Renovate will automatically open a pull request to update the file `ci/dpkg-versions.yaml`.\n- And the continuous integration will build a new fresh Docker image with latest versions of all Debian packages.\n\n## Kubernetes\n\nC2cciutils provide some commands for Kubernetes.\n\nYou can define a workflow like that:\n\n```yaml\n- name: Install k3s/k3d (Kubernetes cluster)\n  run: c2cciutils-k8s-install\n\n- name: Create a database to do the tests\n  run: c2cciutils-k8s-db --script=<my_script>.sql\n\n- name: Install the application in the Kubernetes cluster\n  run: kubectl apply -f <my_application>.yaml\n\n- name: Wait that the application is ready\n  run: c2cciutils-k8s-wait\n- name: Print the application status and logs\n  run: c2cciutils-k8s-logs\n  if: always()\n\n- name: Uninstall the application\n  run: kubectl delete -f <my_application>.yaml || true\n\n- name: Cleanup the database\n  run: c2cciutils-k8s-db --cleanup\n```\n\n`c2cciutils-k8s-install` can be configured in the `ci/config.yaml` file, in section `k8s/k3d/install-commands`, default is:\n\n```yaml\n- - k3d\n    cluster\n    create\n    test-cluster\n    --no-lb\n    --no-rollback\n```\n\nSee also: [K3d cluster create documentation](https://k3d.io/v4.4.8/usage/commands/k3d_cluster_create/).\n\n`c2cciutils-k8s-db` can be configured in the `ci/config.yaml` file, in section `k8s/db/chart-options`, default is:\n\n```yaml\npersistence.enabled: \'false\'\ntls.enabled: \'true\'\ntls.autoGenerated: \'true\'\npostgresqlPassword: mySuperTestingPassword\nvolumePermissions.enabled: \'true\'\n```\n\nSee also: [Parameters documentations](https://github.com/bitnami/charts/tree/master/bitnami/postgresql#parameters).\n',
    'author': 'Camptocamp',
    'author_email': 'info@camptocamp.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/camptocamp/c2cciutils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
