# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceCustomFieldArgs', 'ServiceCustomField']

@pulumi.input_type
class ServiceCustomFieldArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 field_type: pulumi.Input[_builtins.str],
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 field_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceCustomField resource.
        :param pulumi.Input[_builtins.str] data_type: The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the field. Must be unique across an account.
        :param pulumi.Input[_builtins.str] field_type: The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[_builtins.str] default_value: Default value for the field.
        :param pulumi.Input[_builtins.str] description: A description of the data this field contains.
        :param pulumi.Input[_builtins.bool] enabled: Whether the field is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]] field_options: Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        :param pulumi.Input[_builtins.str] name: The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "field_type", field_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if field_options is not None:
            pulumi.set(__self__, "field_options", field_options)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[_builtins.str]:
        """
        The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the field. Must be unique across an account.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @field_type.setter
    def field_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default value for the field.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the data this field contains.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the field is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fieldOptions")
    def field_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]]:
        """
        Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        """
        return pulumi.get(self, "field_options")

    @field_options.setter
    def field_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]]):
        pulumi.set(self, "field_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServiceCustomFieldState:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 field_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]] = None,
                 field_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 self: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceCustomField resources.
        :param pulumi.Input[_builtins.str] data_type: The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[_builtins.str] default_value: Default value for the field.
        :param pulumi.Input[_builtins.str] description: A description of the data this field contains.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the field. Must be unique across an account.
        :param pulumi.Input[_builtins.bool] enabled: Whether the field is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]] field_options: Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        :param pulumi.Input[_builtins.str] field_type: The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[_builtins.str] name: The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        :param pulumi.Input[_builtins.str] self: The API show URL at which the object is accessible
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to display_name
        :param pulumi.Input[_builtins.str] type: API object type
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if field_options is not None:
            pulumi.set(__self__, "field_options", field_options)
        if field_type is not None:
            pulumi.set(__self__, "field_type", field_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default value for the field.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the data this field contains.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the field. Must be unique across an account.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the field is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fieldOptions")
    def field_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]]:
        """
        Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        """
        return pulumi.get(self, "field_options")

    @field_options.setter
    def field_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldFieldOptionArgs']]]]):
        pulumi.set(self, "field_options", value)

    @_builtins.property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @field_type.setter
    def field_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API show URL at which the object is accessible
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to display_name
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API object type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("pagerduty:index/serviceCustomField:ServiceCustomField")
class ServiceCustomField(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 field_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldFieldOptionArgs', 'ServiceCustomFieldFieldOptionArgsDict']]]]] = None,
                 field_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A [service custom field](https://developer.pagerduty.com/api-reference/6075929031f7d-create-a-field)
        allows you to extend PagerDuty Services with custom data fields to provide
        additional context and support features such as customized filtering, search,
        and analytics.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        # Simple string field
        environment = pagerduty.ServiceCustomField("environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value",
            description="The environment this service runs in")
        # Field with fixed options
        deployment_tier = pagerduty.ServiceCustomField("deployment_tier",
            name="deployment_tier",
            display_name="Deployment Tier",
            data_type="string",
            field_type="single_value_fixed",
            description="The deployment tier of the service",
            field_options=[
                {
                    "value": "production",
                    "data_type": "string",
                },
                {
                    "value": "staging",
                    "data_type": "string",
                },
                {
                    "value": "development",
                    "data_type": "string",
                },
            ])
        # Multi-value field with fixed options
        regions = pagerduty.ServiceCustomField("regions",
            name="regions",
            display_name="AWS Regions",
            data_type="string",
            field_type="multi_value_fixed",
            description="AWS regions where this service is deployed",
            field_options=[
                {
                    "value": "us-east-1",
                    "data_type": "string",
                },
                {
                    "value": "us-west-1",
                    "data_type": "string",
                },
            ])
        # Boolean field
        critical = pagerduty.ServiceCustomField("critical",
            name="is_critical",
            display_name="Is Critical",
            data_type="boolean",
            field_type="single_value",
            description="Whether this is a critical service")
        # Integer field
        priority = pagerduty.ServiceCustomField("priority",
            name="priority_level",
            display_name="Priority Level",
            data_type="integer",
            field_type="single_value",
            description="Service priority level")
        ```

        ## Import

        Service custom fields can be imported using the field ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/serviceCustomField:ServiceCustomField example P123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_type: The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[_builtins.str] default_value: Default value for the field.
        :param pulumi.Input[_builtins.str] description: A description of the data this field contains.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the field. Must be unique across an account.
        :param pulumi.Input[_builtins.bool] enabled: Whether the field is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldFieldOptionArgs', 'ServiceCustomFieldFieldOptionArgsDict']]]] field_options: Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        :param pulumi.Input[_builtins.str] field_type: The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[_builtins.str] name: The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceCustomFieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A [service custom field](https://developer.pagerduty.com/api-reference/6075929031f7d-create-a-field)
        allows you to extend PagerDuty Services with custom data fields to provide
        additional context and support features such as customized filtering, search,
        and analytics.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        # Simple string field
        environment = pagerduty.ServiceCustomField("environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value",
            description="The environment this service runs in")
        # Field with fixed options
        deployment_tier = pagerduty.ServiceCustomField("deployment_tier",
            name="deployment_tier",
            display_name="Deployment Tier",
            data_type="string",
            field_type="single_value_fixed",
            description="The deployment tier of the service",
            field_options=[
                {
                    "value": "production",
                    "data_type": "string",
                },
                {
                    "value": "staging",
                    "data_type": "string",
                },
                {
                    "value": "development",
                    "data_type": "string",
                },
            ])
        # Multi-value field with fixed options
        regions = pagerduty.ServiceCustomField("regions",
            name="regions",
            display_name="AWS Regions",
            data_type="string",
            field_type="multi_value_fixed",
            description="AWS regions where this service is deployed",
            field_options=[
                {
                    "value": "us-east-1",
                    "data_type": "string",
                },
                {
                    "value": "us-west-1",
                    "data_type": "string",
                },
            ])
        # Boolean field
        critical = pagerduty.ServiceCustomField("critical",
            name="is_critical",
            display_name="Is Critical",
            data_type="boolean",
            field_type="single_value",
            description="Whether this is a critical service")
        # Integer field
        priority = pagerduty.ServiceCustomField("priority",
            name="priority_level",
            display_name="Priority Level",
            data_type="integer",
            field_type="single_value",
            description="Service priority level")
        ```

        ## Import

        Service custom fields can be imported using the field ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/serviceCustomField:ServiceCustomField example P123456
        ```

        :param str resource_name: The name of the resource.
        :param ServiceCustomFieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceCustomFieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 field_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldFieldOptionArgs', 'ServiceCustomFieldFieldOptionArgsDict']]]]] = None,
                 field_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceCustomFieldArgs.__new__(ServiceCustomFieldArgs)

            if data_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_type'")
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["field_options"] = field_options
            if field_type is None and not opts.urn:
                raise TypeError("Missing required property 'field_type'")
            __props__.__dict__["field_type"] = field_type
            __props__.__dict__["name"] = name
            __props__.__dict__["self"] = None
            __props__.__dict__["summary"] = None
            __props__.__dict__["type"] = None
        super(ServiceCustomField, __self__).__init__(
            'pagerduty:index/serviceCustomField:ServiceCustomField',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_type: Optional[pulumi.Input[_builtins.str]] = None,
            default_value: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            field_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldFieldOptionArgs', 'ServiceCustomFieldFieldOptionArgsDict']]]]] = None,
            field_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            self: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceCustomField':
        """
        Get an existing ServiceCustomField resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_type: The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[_builtins.str] default_value: Default value for the field.
        :param pulumi.Input[_builtins.str] description: A description of the data this field contains.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the field. Must be unique across an account.
        :param pulumi.Input[_builtins.bool] enabled: Whether the field is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldFieldOptionArgs', 'ServiceCustomFieldFieldOptionArgsDict']]]] field_options: Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        :param pulumi.Input[_builtins.str] field_type: The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[_builtins.str] name: The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        :param pulumi.Input[_builtins.str] self: The API show URL at which the object is accessible
        :param pulumi.Input[_builtins.str] summary: A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to display_name
        :param pulumi.Input[_builtins.str] type: API object type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceCustomFieldState.__new__(_ServiceCustomFieldState)

        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["field_options"] = field_options
        __props__.__dict__["field_type"] = field_type
        __props__.__dict__["name"] = name
        __props__.__dict__["self"] = self
        __props__.__dict__["summary"] = summary
        __props__.__dict__["type"] = type
        return ServiceCustomField(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[_builtins.str]:
        """
        The kind of data the custom field is allowed to contain. Can be one of: `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default value for the field.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the data this field contains.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the field. Must be unique across an account.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the field is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fieldOptions")
    def field_options(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceCustomFieldFieldOption']]]:
        """
        Configuration block for defining options for `single_value_fixed` or `multi_value_fixed` field types. Can be specified multiple times for multiple options.
        """
        return pulumi.get(self, "field_options")

    @_builtins.property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of field. Must be one of: `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the field. May include ASCII characters, specifically lowercase letters, digits, and underscores. Must be unique and cannot be changed once created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def self(self) -> pulumi.Output[_builtins.str]:
        """
        The API show URL at which the object is accessible
        """
        return pulumi.get(self, "self")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to display_name
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        API object type
        """
        return pulumi.get(self, "type")

