# MetaSpec

> 🤖 **Meta-Specification Framework for generating Spec-Driven X (SD-X) speckits for AI Agents**

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Python: 3.11+](https://img.shields.io/badge/python-3.11+-blue.svg)](https://www.python.org/downloads/)
[![Status: Alpha](https://img.shields.io/badge/status-alpha-green.svg)]()

---


## 🎯 What is Spec-Driven?

**Spec-Driven** is using structured specifications to drive workflows - from requirements to implementation. Define specs first, validate and generate, then execute. This ensures clarity, consistency, and enables AI agents to understand and assist throughout the process.

## 💡 What is MetaSpec?

**MetaSpec** is a meta-specification framework that enables AI Agents to automatically generate production-ready **speckits** (Spec-Driven X toolkits).

Define your speckit once → Get complete development environment with CLI, parser, validator, templates, and AI agent support.

**What are Speckits?**
- Specialized toolkits generated by MetaSpec
- Carry domain specifications as core assets
- Include built-in MetaSpec commands for development
- Follow spec-driven architecture patterns

```
What you can generate:
  ✅ SD-Development  - Spec-driven development
  ✅ SD-Design       - Spec-driven design systems  
  ✅ SD-Testing      - Spec-driven testing frameworks
  ✅ SD-Documentation - Spec-driven documentation
  ✅ SD-Operations   - Spec-driven operations
  ✅ SD-X            - Spec-driven generation for any domain
```

### 🌟 Key Features

**1. Meta-Level** - A **meta-specification framework** that generates speckits

**2. Any Domain** - Supports **any** domain, not limited to development

**3. Full Lifecycle** - Covers **complete lifecycle** (creation, updates, maintenance)

---

## 🚀 Quick Start

### Installation

```bash
# Recommended: Use uv (10-100x faster) ⚡
uv pip install git+https://github.com/ACNet-AI/MetaSpec.git

# Or use pip
pip install git+https://github.com/ACNet-AI/MetaSpec.git
```

<details>
<summary>Other installation methods</summary>

**Development mode**:
```bash
git clone https://github.com/ACNet-AI/MetaSpec.git && cd MetaSpec
uv pip install -e .
```

**Coming soon**: `pip install metaspec` 🚀
</details>

### Create Your First Speckit

**Option 1: Interactive (Recommended)**

```bash
metaspec init                       # Interactive wizard - guides you through
```

**Option 2: Quick start**

```bash
metaspec init my-spec-kit     # One command, done!
```

**Option 3: Preview first**

```bash
metaspec init my-spec-kit --dry-run    # Preview
metaspec init my-spec-kit              # Create
```

**Result**: Complete speckit with CLI, parser, validator, templates, and AI agent support!

---

---

## 🌱 Why MetaSpec?

### The Journey: From Practice to Insight

MetaSpec was born from real-world experience building spec-driven development tools:

**🔧 Phase 1: Universal SDD Tools**
- Built **spec-kit** and **OpenSpec** - covering 0→1→N generic spec-driven development workflows
- Proved SDD methodology works across different project scales

**💡 Phase 2: The Domain Insight**
- **Discovery**: While practicing SDD, we realized AI needs **domain-specific specifications** to generate expected results
- **Example**: To help AI develop MCP projects effectively, we need **MCP domain specifications** - not just generic development specs
- **Vision**: **Modular domain specifications** 🧩 that can be combined and composed to guide AI to generate content matching our expectations

**🚀 Phase 3: Beyond Development**
- **Realization**: This pattern isn't limited to software development
- **Breakthrough**: Any domain can benefit from specification-driven workflows
- **Vision**: A meta-framework that generates spec toolkits for ANY domain

### Core Philosophy

MetaSpec is built on two fundamental concepts:

**1️⃣ Domain Refinement**
- Specifications refine **from general to specific** through multiple levels
- Example: Development Spec → MCP Development Spec → Weather Query MCP Spec
- Each level adds more **context and constraints**, enabling more **precise AI guidance**

**2️⃣ Modular Composition**
- Specifications are **independent, reusable modules** that can be composed in two ways:
  - **Compose specs**: Combine sub-domain specs into a complete domain spec (Full-stack Web = Frontend + Backend + Database)
  - **Compose usage**: Apply multiple specs to one project (MetaSpec uses SDS + SDD; MCP project uses MCP + Python + Testing)
- This enables **flexible reuse** across different contexts and domains

Together, these create a **flexible specification network** where AI agents navigate domain knowledge through structured specs, combining them as needed to produce exactly what you envision.

---


## 📦 Features

**Simple, powerful commands:**

| Command | Description |
|---------|-------------|
| `metaspec init [name]` | 🚀 Create spec-driven speckit (interactive or template-based) |
| `metaspec search <query>` | 🔍 Search community speckits |
| `metaspec install <name>` | 📦 Install speckit from community |
| `metaspec list` | 📋 List installed speckits |
| `metaspec info <name>` | ℹ️ Show speckit information |
| `metaspec contribute <name>` | 🤝 Contribute to community registry |

**Common usage:**
```bash
# Create speckit (interactive)
metaspec init

# Create with quick start (fast)
metaspec init my-api-speckit

# Preview before creating
metaspec init my-spec-kit --dry-run

# Discover and install speckits
metaspec search "api"                # Search community
metaspec install api-speckit         # Install from community
metaspec list                        # List installed speckits

# Use installed speckits directly
api-speckit info                     # Direct usage (no metaspec prefix!)
```

**What you get**: CLI tools, parser, validator, templates, AGENTS.md, constitution, and full Python package structure.

### 🌟 Generated Speckits

MetaSpec generates **independent, production-ready toolkits**:

```bash
# Each generated speckit is a standalone CLI tool
cd my-speckit
./scripts/init.sh              # Install dependencies
my-speckit info                # Use directly (no metaspec prefix!)

# Generated speckits include built-in MetaSpec commands (AI-assisted development)
# MetaSpec Commands: /metaspec.sds.*, /metaspec.sdd.*, /metaspec.* (19 commands total)
```

**Key Principle**: MetaSpec is a **generator**, not a runtime. Generated speckits are independent tools.

**Built-in MetaSpec Workflow**: Every speckit includes 19 MetaSpec commands for complete development lifecycle (8 SDS + 8 SDD + 3 Evolution)

**Iteration-Aware Design**: Commands check for existing output and support update/new/append modes, preserving history and tracking progress across iterations ([Constitution Principle #6](memory/constitution.md#6-iteration-aware-design))

---

## 🌐 Community

Discover and share speckits with the community:

**📦 [Awesome Spec Kits](https://github.com/ACNet-AI/awesome-spec-kits)** - A curated list of community speckits

### For Users

```bash
# Search community speckits
metaspec search "api validation"

# Install from community
metaspec install <speckit-name>

# List installed speckits
metaspec list

# Get detailed information
metaspec info <command>
```

### For Developers

```bash
# Contribute your speckit
metaspec contribute my-speckit
# → Generates metadata JSON
# → Submit PR to awesome-spec-kits
```

**Join the community**:
- 🚀 [Create and share your speckit](https://github.com/ACNet-AI/awesome-spec-kits)
- 📚 [Community guide](./docs/community-registry.md)
- 💬 [Discussions](https://github.com/ACNet-AI/MetaSpec/discussions)

---

## 🤖 AI Assistant Ready

MetaSpec is designed for AI agents with strong reasoning capabilities. Speckit creation requires meta-level system design, entity modeling, and domain research.

👉 **Complete AI workflow guide**: [AGENTS.md](./AGENTS.md)

---

## 🤝 Works Well With

**MetaSpec** generates speckits. Since generated speckits are also projects, you can use spec-driven methodologies to develop them.

| Tool | Purpose | Built-in? | Access Method |
|------|---------|-----------|--------------|
| **MetaSpec Commands** | Complete spec-driven workflow (19 commands) | ✅ Yes | `/metaspec.sds.*`, `/metaspec.sdd.*`, `/metaspec.*` slash commands in generated speckits |

**Complete Workflow**:

```bash
# 1️⃣ CREATE: Generate speckit
metaspec init my-spec-kit

# 2️⃣ DEVELOP: Use built-in MetaSpec slash commands (no installation needed)
cd my-spec-kit

# SDS Commands (8) - Define domain specification
# /metaspec.sds.constitution - Define specification design principles
# /metaspec.sds.specify      - Define specification entities and operations
# /metaspec.sds.clarify      - Resolve specification ambiguities
# /metaspec.sds.plan         - Plan specification architecture and sub-specifications
# /metaspec.sds.tasks        - Break down specification work
# /metaspec.sds.implement    - Write specification documents
# /metaspec.sds.checklist    - Generate quality checklist for specification
# /metaspec.sds.analyze      - Check specification consistency

# SDD Commands (8) - Develop spec-driven toolkit
# /metaspec.sdd.constitution - Define toolkit principles
# /metaspec.sdd.specify      - Define toolkit specifications
# /metaspec.sdd.clarify      - Resolve toolkit ambiguities
# /metaspec.sdd.plan         - Plan implementation architecture
# /metaspec.sdd.tasks        - Generate actionable task lists
# /metaspec.sdd.implement    - Execute implementation
# /metaspec.sdd.checklist    - Validate specification quality
# /metaspec.sdd.analyze      - Analyze consistency

# Evolution Commands (3) - Controlled changes (shared)
# /metaspec.proposal "change" --type sds|sdd - Create change proposals
# /metaspec.apply <proposal-id>              - Apply approved changes
# /metaspec.archive <proposal-id>            - Archive completed changes
```

**Advantages**:
- ✅ **Complete workflow built-in** - Everything you need from day one
- ✅ **AI-assisted** - MetaSpec commands guide development
- ✅ **No external dependencies** - All tools included

### 🚀 Ecosystem Vision

MetaSpec is not just a generator—it's a **platform for speckits**:

1. **Create** speckits with `metaspec init`
2. **Develop** with built-in MetaSpec commands
3. **Publish** to community registry
4. **Install** and use directly - no prefix needed!

```bash
# Example: Developer workflow
metaspec init api-speckit
cd api-speckit
# ... develop using MetaSpec commands ...
metaspec contribute api-speckit

# User workflow  
metaspec search "api"
metaspec install api-speckit

# Use directly (no metaspec prefix!)
api-speckit init my-api.json
api-speckit validate my-api.json
```

**Future roadmap**: Enhanced community features, version management, analytics

📖 **Complete guide**: See [AGENTS.md](./AGENTS.md)

---

## 📖 Example

### Quick Example: Create an API Speckit

```bash
# Step 1: Create speckit (interactive mode)
metaspec init
# Or use template mode for quick start
metaspec init api-spec-kit

# Step 2: What you get
# api-spec-kit/
#   ├── src/api_spec_kit/          # Python package
#   │   ├── cli/                    # CLI commands
#   │   ├── parser.py               # Parser
#   │   └── validator.py            # Validator
#   ├── .metaspec/
#   │   ├── commands/               # MetaSpec commands (11 total)
#   │   └── templates/              # MetaSpec templates
#   ├── specs/                      # Feature specifications
#   ├── templates/                  # User project templates
#   ├── AGENTS.md                   # AI workflow guide
#   ├── README.md                   # User documentation
#   └── pyproject.toml              # Package config
```

### Develop the Generated Speckit

```bash
# Step 3: Install
cd api-spec-kit
pip install -e .

# Step 4: Define and implement using MetaSpec commands (in Cursor/AI editor)
# Phase 1: Define specification (SDS)
# /metaspec.sds.constitution  - Define specification design principles
# /metaspec.sds.specify       - Define specification entities and operations
# /metaspec.sds.plan          - Plan specification architecture (if complex)
# /metaspec.sds.tasks         - Break down specification work
# /metaspec.sds.implement     - Write specification documents
# /metaspec.sds.analyze       - Check specification consistency

# Phase 2: Develop toolkit (SDD)
# /metaspec.sdd.constitution  - Define toolkit principles
# /metaspec.sdd.specify       - Define toolkit specifications
# /metaspec.sdd.plan          - Plan implementation architecture
# /metaspec.sdd.tasks         - Break down implementation tasks
# /metaspec.sdd.implement     - Implement your speckit
```

📂 **More examples**: See [examples/](./examples/) (MCP, API testing, design systems)

---

## 🛠️ Commands

```bash
# Generation
metaspec init [NAME] [OPTIONS]     # Create speckit (interactive or template-based)

# Community
metaspec search <query>            # Search community speckits
metaspec install <name>            # Install from community
metaspec contribute <name>         # Contribute to community

# Information
metaspec list                      # List installed speckits
metaspec info <name>               # Show speckit details
metaspec version                   # Show MetaSpec version

# Examples
metaspec init                      # Interactive mode
metaspec init my-speckit           # Quick start (uses 'default')
metaspec init my-speckit default   # Explicit (same as above)
metaspec search "api"              # Search community
metaspec install api-speckit       # Install
metaspec list                      # List installed
```

Use `metaspec --help` or `metaspec <command> --help` for detailed options

---

## 🧪 Development

```bash
# Clone and install
git clone https://github.com/ACNet-AI/MetaSpec.git && cd MetaSpec
uv pip install -e ".[dev]"

# Run tests
uv run pytest                  # 138 tests, 69% coverage

# Code quality checks
uv run ruff check .            # Lint
uv run mypy src/metaspec       # Type check
```

📖 [Contributing Guide](./docs/contributing.md)

---

## 📚 Documentation

- **[quickstart.md](./docs/quickstart.md)** - 5-minute tutorial
- **[AGENTS.md](./AGENTS.md)** - AI workflow guide
- **[contributing.md](./docs/contributing.md)** - Contribution guide
- **[examples/](./examples/)** - Example meta-specs

**Iteration & Decision Guides**:
- **[Evolution Guide](./docs/evolution-guide.md)** - When to use formal evolution vs fast iteration
- **[Iteration Layers](./docs/iteration-layers.md)** - How Evolution and Command layers work together
- **[Iteration Roadmap](./docs/iteration-roadmap.md)** - Which commands support iteration and why

---

## 🏗️ Status

**v0.5.0** - Alpha Release 🎉

Core features complete: YAML validation, multi-domain generation, CLI tools, AI agent support, built-in MetaSpec commands (19 commands: 8 SDS + 8 SDD + 3 Evolution), recursive tree structure for specifications, unified spec interface.

---

## 🤝 Contributing

Contributions welcome! See [contributing.md](./docs/contributing.md) for guidelines.

```bash
git clone https://github.com/ACNet-AI/MetaSpec.git
git checkout -b feature/your-feature
# Make changes, test, commit
git push origin feature/your-feature
```

---

## 📄 License

MIT License - see [LICENSE](./LICENSE)

---

## 🙏 Acknowledgments

Inspired by [Spec-Kit](https://github.com/github/spec-kit), [Protocol Buffers](https://protobuf.dev/), and [OpenAPI](https://www.openapis.org/).

---

**A Meta-Specification Framework for Generating Spec-Driven Toolkits**
