# Generated by Django API Key Implementation

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('credits', '0005_ai_service_framework'),
    ]

    operations = [
        migrations.CreateModel(
            name='APIKey',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prefix', models.CharField(db_index=True, help_text='Short prefix for API key identification', max_length=8, verbose_name='prefix')),
                ('hashed_key', models.CharField(help_text='Hashed secret part of the API key', max_length=128, verbose_name='hashed key')),
                ('name', models.CharField(blank=True, help_text='Optional name for this API key', max_length=100, verbose_name='name')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('last_used_at', models.DateTimeField(blank=True, help_text='When this API key was last used', null=True, verbose_name='last used at')),
                ('is_active', models.BooleanField(default=True, help_text='Whether this API key is currently active', verbose_name='is active')),
                ('expiry_date', models.DateTimeField(blank=True, help_text='Optional expiration date for this API key', null=True, verbose_name='expiry date')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='api_keys', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'API key',
                'verbose_name_plural': 'API keys',
            },
        ),
        migrations.AddIndex(
            model_name='apikey',
            index=models.Index(fields=['prefix'], name='credits_apik_prefix_9f0ec5_idx'),
        ),
        migrations.AddIndex(
            model_name='apikey',
            index=models.Index(fields=['user', 'is_active'], name='credits_apik_user_id_c4b8ec_idx'),
        ),
        migrations.AddIndex(
            model_name='apikey',
            index=models.Index(fields=['is_active', 'expiry_date'], name='credits_apik_is_acti_74e2a1_idx'),
        ),
    ]