from collections.abc import AsyncIterator
from typing import Protocol, runtime_checkable

__all__ = ("StorageProtocol",)

from aiotgbot.helpers import Json


@runtime_checkable
class StorageProtocol(Protocol):
    async def connect(self) -> None: ...

    async def close(self) -> None: ...

    async def set(self, key: str, value: Json | None = None) -> None: ...

    async def get(self, key: str) -> Json: ...

    async def delete(self, key: str) -> None: ...

    def iterate(self, prefix: str = "") -> AsyncIterator[tuple[str, Json]]: ...

    async def clear(self) -> None: ...

    def raw_connection(self) -> object: ...
