"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 */
class InputFormat {
    constructor(className) {
        this.className = className;
    }
}
/**
 * An InputFormat for plain text files. Files are broken into lines. Either linefeed or
 * carriage-return are used to signal end of line. Keys are the position in the file, and
 * values are the line of text.
 *
 * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
 */
InputFormat.TextInputFormat = new InputFormat('org.apache.hadoop.mapred.TextInputFormat');
exports.InputFormat = InputFormat;
/**
 * Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
 */
class OutputFormat {
    constructor(className) {
        this.className = className;
    }
}
/**
 * Writes text data with a null key (value only).
 *
 * @see https://hive.apache.org/javadocs/r2.2.0/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
 */
OutputFormat.HiveIgnoreKeyTextOutputFormat = new OutputFormat('org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat');
exports.OutputFormat = OutputFormat;
/**
 * Serialization library to use when serializing/deserializing (SerDe) table records.
 *
 * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
 */
class SerializationLibrary {
    constructor(className) {
        this.className = className;
    }
}
/**
 * @see https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON
 */
SerializationLibrary.HiveJson = new SerializationLibrary('org.apache.hive.hcatalog.data.JsonSerDe');
/**
 * @see https://github.com/rcongiu/Hive-JSON-Serde
 */
SerializationLibrary.OpenXJson = new SerializationLibrary('org.openx.data.jsonserde.JsonSerDe');
exports.SerializationLibrary = SerializationLibrary;
var DataFormat;
(function (DataFormat) {
    /**
     * Stored as plain text files in JSON format.
     *
     * Uses OpenX Json SerDe for serialization and deseralization.
     *
     * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
     */
    DataFormat.Json = {
        inputFormat: InputFormat.TextInputFormat,
        outputFormat: OutputFormat.HiveIgnoreKeyTextOutputFormat,
        serializationLibrary: SerializationLibrary.OpenXJson
    };
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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