import cdk = require('@aws-cdk/cdk');
export interface IDatabase extends cdk.IConstruct {
    /**
     * The ARN of the catalog.
     */
    readonly catalogArn: string;
    /**
     * The catalog id of the database (usually, the AWS account id)
     */
    readonly catalogId: string;
    /**
     * The ARN of the database.
     */
    readonly databaseArn: string;
    /**
     * The name of the database.
     */
    readonly databaseName: string;
    /**
     * The location of the database (for example, an HDFS path).
     */
    readonly locationUri: string;
    export(): DatabaseImportProps;
}
export interface DatabaseImportProps {
    readonly catalogArn: string;
    readonly catalogId: string;
    readonly databaseArn: string;
    readonly databaseName: string;
    readonly locationUri: string;
}
export interface DatabaseProps {
    /**
     * The name of the database.
     */
    readonly databaseName: string;
    /**
     * The location of the database (for example, an HDFS path).
     *
     * @default a bucket is created and the database is stored under s3://<bucket-name>/<database-name>
     */
    readonly locationUri?: string;
}
/**
 * A Glue database.
 */
export declare class Database extends cdk.Construct {
    /**
     * Creates a Database construct that represents an external database.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param props A `DatabaseImportProps` object. Can be obtained from a call to `database.export()` or manually created.
     */
    static import(scope: cdk.Construct, id: string, props: DatabaseImportProps): IDatabase;
    /**
     * ARN of the Glue catalog in which this database is stored.
     */
    readonly catalogArn: string;
    /**
     * ID of the Glue catalog in which this database is stored.
     */
    readonly catalogId: string;
    /**
     * ARN of this database.
     */
    readonly databaseArn: string;
    /**
     * Name of this database.
     */
    readonly databaseName: string;
    /**
     * Location URI of this database.
     */
    readonly locationUri: string;
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
    /**
     * Exports this database from the stack.
     */
    export(): DatabaseImportProps;
}
