import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::Glue::Classifier`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export interface CfnClassifierProps {
    /**
     * `AWS::Glue::Classifier.GrokClassifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier
     */
    readonly grokClassifier?: CfnClassifier.GrokClassifierProperty | cdk.Token;
    /**
     * `AWS::Glue::Classifier.JsonClassifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier
     */
    readonly jsonClassifier?: CfnClassifier.JsonClassifierProperty | cdk.Token;
    /**
     * `AWS::Glue::Classifier.XMLClassifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier
     */
    readonly xmlClassifier?: CfnClassifier.XMLClassifierProperty | cdk.Token;
}
/**
 * A CloudFormation `AWS::Glue::Classifier`
 *
 * @cloudformationResource AWS::Glue::Classifier
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare class CfnClassifier extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Classifier";
    readonly classifierName: string;
    /**
     * Create a new `AWS::Glue::Classifier`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnClassifierProps);
    readonly propertyOverrides: CfnClassifierProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html
     */
    interface GrokClassifierProperty {
        /**
         * `CfnClassifier.GrokClassifierProperty.Classification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-classification
         */
        readonly classification: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.CustomPatterns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-custompatterns
         */
        readonly customPatterns?: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.GrokPattern`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-grokpattern
         */
        readonly grokPattern: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-name
         */
        readonly name?: string;
    }
}
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html
     */
    interface JsonClassifierProperty {
        /**
         * `CfnClassifier.JsonClassifierProperty.JsonPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-jsonpath
         */
        readonly jsonPath: string;
        /**
         * `CfnClassifier.JsonClassifierProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-name
         */
        readonly name?: string;
    }
}
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html
     */
    interface XMLClassifierProperty {
        /**
         * `CfnClassifier.XMLClassifierProperty.Classification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-classification
         */
        readonly classification: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-name
         */
        readonly name?: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.RowTag`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-rowtag
         */
        readonly rowTag: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Connection`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export interface CfnConnectionProps {
    /**
     * `AWS::Glue::Connection.CatalogId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Connection.ConnectionInput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput
     */
    readonly connectionInput: CfnConnection.ConnectionInputProperty | cdk.Token;
}
/**
 * A CloudFormation `AWS::Glue::Connection`
 *
 * @cloudformationResource AWS::Glue::Connection
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export declare class CfnConnection extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Connection";
    readonly connectionName: string;
    /**
     * Create a new `AWS::Glue::Connection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectionProps);
    readonly propertyOverrides: CfnConnectionProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnConnection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html
     */
    interface ConnectionInputProperty {
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionProperties`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectionproperties
         */
        readonly connectionProperties: object | cdk.Token;
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype
         */
        readonly connectionType: string;
        /**
         * `CfnConnection.ConnectionInputProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-description
         */
        readonly description?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.MatchCriteria`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-matchcriteria
         */
        readonly matchCriteria?: string[];
        /**
         * `CfnConnection.ConnectionInputProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name
         */
        readonly name?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.PhysicalConnectionRequirements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-physicalconnectionrequirements
         */
        readonly physicalConnectionRequirements?: CfnConnection.PhysicalConnectionRequirementsProperty | cdk.Token;
    }
}
export declare namespace CfnConnection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html
     */
    interface PhysicalConnectionRequirementsProperty {
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SecurityGroupIdList`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-securitygroupidlist
         */
        readonly securityGroupIdList?: string[];
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-subnetid
         */
        readonly subnetId?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Crawler`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export interface CfnCrawlerProps {
    /**
     * `AWS::Glue::Crawler.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Crawler.Role`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role
     */
    readonly role: string;
    /**
     * `AWS::Glue::Crawler.Targets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets
     */
    readonly targets: CfnCrawler.TargetsProperty | cdk.Token;
    /**
     * `AWS::Glue::Crawler.Classifiers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers
     */
    readonly classifiers?: string[];
    /**
     * `AWS::Glue::Crawler.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration
     */
    readonly configuration?: string;
    /**
     * `AWS::Glue::Crawler.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Crawler.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Crawler.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule
     */
    readonly schedule?: CfnCrawler.ScheduleProperty | cdk.Token;
    /**
     * `AWS::Glue::Crawler.SchemaChangePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy
     */
    readonly schemaChangePolicy?: CfnCrawler.SchemaChangePolicyProperty | cdk.Token;
    /**
     * `AWS::Glue::Crawler.TablePrefix`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix
     */
    readonly tablePrefix?: string;
}
/**
 * A CloudFormation `AWS::Glue::Crawler`
 *
 * @cloudformationResource AWS::Glue::Crawler
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare class CfnCrawler extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Crawler";
    readonly crawlerName: string;
    /**
     * Create a new `AWS::Glue::Crawler`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCrawlerProps);
    readonly propertyOverrides: CfnCrawlerProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html
     */
    interface JdbcTargetProperty {
        /**
         * `CfnCrawler.JdbcTargetProperty.ConnectionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-connectionname
         */
        readonly connectionName?: string;
        /**
         * `CfnCrawler.JdbcTargetProperty.Exclusions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-exclusions
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.JdbcTargetProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-path
         */
        readonly path?: string;
    }
}
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html
     */
    interface S3TargetProperty {
        /**
         * `CfnCrawler.S3TargetProperty.Exclusions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-exclusions
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.S3TargetProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-path
         */
        readonly path?: string;
    }
}
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCrawler.ScheduleProperty.ScheduleExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html#cfn-glue-crawler-schedule-scheduleexpression
         */
        readonly scheduleExpression?: string;
    }
}
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html
     */
    interface SchemaChangePolicyProperty {
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.DeleteBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior
         */
        readonly deleteBehavior?: string;
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.UpdateBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior
         */
        readonly updateBehavior?: string;
    }
}
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html
     */
    interface TargetsProperty {
        /**
         * `CfnCrawler.TargetsProperty.JdbcTargets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-jdbctargets
         */
        readonly jdbcTargets?: Array<CfnCrawler.JdbcTargetProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnCrawler.TargetsProperty.S3Targets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-s3targets
         */
        readonly s3Targets?: Array<CfnCrawler.S3TargetProperty | cdk.Token> | cdk.Token;
    }
}
/**
 * Properties for defining a `AWS::Glue::Database`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export interface CfnDatabaseProps {
    /**
     * `AWS::Glue::Database.CatalogId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Database.DatabaseInput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput
     */
    readonly databaseInput: CfnDatabase.DatabaseInputProperty | cdk.Token;
}
/**
 * A CloudFormation `AWS::Glue::Database`
 *
 * @cloudformationResource AWS::Glue::Database
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export declare class CfnDatabase extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Database";
    readonly databaseName: string;
    /**
     * Create a new `AWS::Glue::Database`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDatabaseProps);
    readonly propertyOverrides: CfnDatabaseProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnDatabase {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html
     */
    interface DatabaseInputProperty {
        /**
         * `CfnDatabase.DatabaseInputProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-description
         */
        readonly description?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.LocationUri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-locationuri
         */
        readonly locationUri?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-name
         */
        readonly name?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-parameters
         */
        readonly parameters?: object | cdk.Token;
    }
}
/**
 * Properties for defining a `AWS::Glue::DevEndpoint`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 */
export interface CfnDevEndpointProps {
    /**
     * `AWS::Glue::DevEndpoint.PublicKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey
     */
    readonly publicKey: string;
    /**
     * `AWS::Glue::DevEndpoint.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::Glue::DevEndpoint.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraJarsS3Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path
     */
    readonly extraJarsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraPythonLibsS3Path`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path
     */
    readonly extraPythonLibsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfNodes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes
     */
    readonly numberOfNodes?: number | cdk.Token;
    /**
     * `AWS::Glue::DevEndpoint.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::Glue::DevEndpoint.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid
     */
    readonly subnetId?: string;
}
/**
 * A CloudFormation `AWS::Glue::DevEndpoint`
 *
 * @cloudformationResource AWS::Glue::DevEndpoint
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 */
export declare class CfnDevEndpoint extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::DevEndpoint";
    readonly devEndpointId: string;
    /**
     * Create a new `AWS::Glue::DevEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDevEndpointProps);
    readonly propertyOverrides: CfnDevEndpointProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Glue::Job`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export interface CfnJobProps {
    /**
     * `AWS::Glue::Job.Command`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command
     */
    readonly command: CfnJob.JobCommandProperty | cdk.Token;
    /**
     * `AWS::Glue::Job.Role`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role
     */
    readonly role: string;
    /**
     * `AWS::Glue::Job.AllocatedCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity
     */
    readonly allocatedCapacity?: number | cdk.Token;
    /**
     * `AWS::Glue::Job.Connections`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections
     */
    readonly connections?: CfnJob.ConnectionsListProperty | cdk.Token;
    /**
     * `AWS::Glue::Job.DefaultArguments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments
     */
    readonly defaultArguments?: object | cdk.Token;
    /**
     * `AWS::Glue::Job.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Job.ExecutionProperty`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty
     */
    readonly executionProperty?: CfnJob.ExecutionPropertyProperty | cdk.Token;
    /**
     * `AWS::Glue::Job.LogUri`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri
     */
    readonly logUri?: string;
    /**
     * `AWS::Glue::Job.MaxRetries`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries
     */
    readonly maxRetries?: number | cdk.Token;
    /**
     * `AWS::Glue::Job.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::Glue::Job`
 *
 * @cloudformationResource AWS::Glue::Job
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare class CfnJob extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Job";
    readonly jobName: string;
    /**
     * Create a new `AWS::Glue::Job`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobProps);
    readonly propertyOverrides: CfnJobProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html
     */
    interface ConnectionsListProperty {
        /**
         * `CfnJob.ConnectionsListProperty.Connections`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html#cfn-glue-job-connectionslist-connections
         */
        readonly connections?: string[];
    }
}
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html
     */
    interface ExecutionPropertyProperty {
        /**
         * `CfnJob.ExecutionPropertyProperty.MaxConcurrentRuns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html#cfn-glue-job-executionproperty-maxconcurrentruns
         */
        readonly maxConcurrentRuns?: number | cdk.Token;
    }
}
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html
     */
    interface JobCommandProperty {
        /**
         * `CfnJob.JobCommandProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-name
         */
        readonly name?: string;
        /**
         * `CfnJob.JobCommandProperty.ScriptLocation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-scriptlocation
         */
        readonly scriptLocation?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Partition`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export interface CfnPartitionProps {
    /**
     * `AWS::Glue::Partition.CatalogId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Partition.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Partition.PartitionInput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput
     */
    readonly partitionInput: CfnPartition.PartitionInputProperty | cdk.Token;
    /**
     * `AWS::Glue::Partition.TableName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename
     */
    readonly tableName: string;
}
/**
 * A CloudFormation `AWS::Glue::Partition`
 *
 * @cloudformationResource AWS::Glue::Partition
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare class CfnPartition extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Partition";
    readonly partitionId: string;
    /**
     * Create a new `AWS::Glue::Partition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPartitionProps);
    readonly propertyOverrides: CfnPartitionProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnPartition.ColumnProperty.Comment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-comment
         */
        readonly comment?: string;
        /**
         * `CfnPartition.ColumnProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-name
         */
        readonly name: string;
        /**
         * `CfnPartition.ColumnProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html
     */
    interface OrderProperty {
        /**
         * `CfnPartition.OrderProperty.Column`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-column
         */
        readonly column: string;
        /**
         * `CfnPartition.OrderProperty.SortOrder`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-sortorder
         */
        readonly sortOrder?: number | cdk.Token;
    }
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html
     */
    interface PartitionInputProperty {
        /**
         * `CfnPartition.PartitionInputProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnPartition.PartitionInputProperty.StorageDescriptor`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-storagedescriptor
         */
        readonly storageDescriptor?: CfnPartition.StorageDescriptorProperty | cdk.Token;
        /**
         * `CfnPartition.PartitionInputProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-values
         */
        readonly values: string[];
    }
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html
     */
    interface SerdeInfoProperty {
        /**
         * `CfnPartition.SerdeInfoProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-name
         */
        readonly name?: string;
        /**
         * `CfnPartition.SerdeInfoProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnPartition.SerdeInfoProperty.SerializationLibrary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-serializationlibrary
         */
        readonly serializationLibrary?: string;
    }
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html
     */
    interface SkewedInfoProperty {
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnNames`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnnames
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValueLocationMaps`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvaluelocationmaps
         */
        readonly skewedColumnValueLocationMaps?: object | cdk.Token;
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValues`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvalues
         */
        readonly skewedColumnValues?: string[];
    }
}
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnPartition.StorageDescriptorProperty.BucketColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-bucketcolumns
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnPartition.StorageDescriptorProperty.Columns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-columns
         */
        readonly columns?: Array<CfnPartition.ColumnProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.Compressed`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-compressed
         */
        readonly compressed?: boolean | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.InputFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-inputformat
         */
        readonly inputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-location
         */
        readonly location?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.NumberOfBuckets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-numberofbuckets
         */
        readonly numberOfBuckets?: number | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.OutputFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-outputformat
         */
        readonly outputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.SerdeInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-serdeinfo
         */
        readonly serdeInfo?: CfnPartition.SerdeInfoProperty | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.SkewedInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-skewedinfo
         */
        readonly skewedInfo?: CfnPartition.SkewedInfoProperty | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.SortColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-sortcolumns
         */
        readonly sortColumns?: Array<CfnPartition.OrderProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnPartition.StorageDescriptorProperty.StoredAsSubDirectories`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-storedassubdirectories
         */
        readonly storedAsSubDirectories?: boolean | cdk.Token;
    }
}
/**
 * Properties for defining a `AWS::Glue::Table`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export interface CfnTableProps {
    /**
     * `AWS::Glue::Table.CatalogId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Table.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Table.TableInput`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput
     */
    readonly tableInput: CfnTable.TableInputProperty | cdk.Token;
}
/**
 * A CloudFormation `AWS::Glue::Table`
 *
 * @cloudformationResource AWS::Glue::Table
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare class CfnTable extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Table";
    readonly tableName: string;
    /**
     * Create a new `AWS::Glue::Table`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    readonly propertyOverrides: CfnTableProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnTable.ColumnProperty.Comment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-comment
         */
        readonly comment?: string;
        /**
         * `CfnTable.ColumnProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-name
         */
        readonly name: string;
        /**
         * `CfnTable.ColumnProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html
     */
    interface OrderProperty {
        /**
         * `CfnTable.OrderProperty.Column`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-column
         */
        readonly column: string;
        /**
         * `CfnTable.OrderProperty.SortOrder`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-sortorder
         */
        readonly sortOrder: number | cdk.Token;
    }
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html
     */
    interface SerdeInfoProperty {
        /**
         * `CfnTable.SerdeInfoProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-name
         */
        readonly name?: string;
        /**
         * `CfnTable.SerdeInfoProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnTable.SerdeInfoProperty.SerializationLibrary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-serializationlibrary
         */
        readonly serializationLibrary?: string;
    }
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html
     */
    interface SkewedInfoProperty {
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnNames`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnnames
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValueLocationMaps`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvaluelocationmaps
         */
        readonly skewedColumnValueLocationMaps?: object | cdk.Token;
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValues`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvalues
         */
        readonly skewedColumnValues?: string[];
    }
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnTable.StorageDescriptorProperty.BucketColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-bucketcolumns
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnTable.StorageDescriptorProperty.Columns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-columns
         */
        readonly columns?: Array<CfnTable.ColumnProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.Compressed`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-compressed
         */
        readonly compressed?: boolean | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.InputFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-inputformat
         */
        readonly inputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-location
         */
        readonly location?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.NumberOfBuckets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-numberofbuckets
         */
        readonly numberOfBuckets?: number | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.OutputFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-outputformat
         */
        readonly outputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.SerdeInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-serdeinfo
         */
        readonly serdeInfo?: CfnTable.SerdeInfoProperty | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.SkewedInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-skewedinfo
         */
        readonly skewedInfo?: CfnTable.SkewedInfoProperty | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.SortColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-sortcolumns
         */
        readonly sortColumns?: Array<CfnTable.OrderProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnTable.StorageDescriptorProperty.StoredAsSubDirectories`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-storedassubdirectories
         */
        readonly storedAsSubDirectories?: boolean | cdk.Token;
    }
}
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html
     */
    interface TableInputProperty {
        /**
         * `CfnTable.TableInputProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-description
         */
        readonly description?: string;
        /**
         * `CfnTable.TableInputProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-name
         */
        readonly name?: string;
        /**
         * `CfnTable.TableInputProperty.Owner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-owner
         */
        readonly owner?: string;
        /**
         * `CfnTable.TableInputProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters
         */
        readonly parameters?: object | cdk.Token;
        /**
         * `CfnTable.TableInputProperty.PartitionKeys`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-partitionkeys
         */
        readonly partitionKeys?: Array<CfnTable.ColumnProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnTable.TableInputProperty.Retention`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-retention
         */
        readonly retention?: number | cdk.Token;
        /**
         * `CfnTable.TableInputProperty.StorageDescriptor`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-storagedescriptor
         */
        readonly storageDescriptor?: CfnTable.StorageDescriptorProperty | cdk.Token;
        /**
         * `CfnTable.TableInputProperty.TableType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-tabletype
         */
        readonly tableType?: string;
        /**
         * `CfnTable.TableInputProperty.ViewExpandedText`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-viewexpandedtext
         */
        readonly viewExpandedText?: string;
        /**
         * `CfnTable.TableInputProperty.ViewOriginalText`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-vieworiginaltext
         */
        readonly viewOriginalText?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Trigger`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export interface CfnTriggerProps {
    /**
     * `AWS::Glue::Trigger.Actions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-actions
     */
    readonly actions: Array<CfnTrigger.ActionProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::Glue::Trigger.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-type
     */
    readonly type: string;
    /**
     * `AWS::Glue::Trigger.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Trigger.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Trigger.Predicate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-predicate
     */
    readonly predicate?: CfnTrigger.PredicateProperty | cdk.Token;
    /**
     * `AWS::Glue::Trigger.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-schedule
     */
    readonly schedule?: string;
}
/**
 * A CloudFormation `AWS::Glue::Trigger`
 *
 * @cloudformationResource AWS::Glue::Trigger
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare class CfnTrigger extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Glue::Trigger";
    readonly triggerName: string;
    /**
     * Create a new `AWS::Glue::Trigger`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTriggerProps);
    readonly propertyOverrides: CfnTriggerProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html
     */
    interface ActionProperty {
        /**
         * `CfnTrigger.ActionProperty.Arguments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-arguments
         */
        readonly arguments?: object | cdk.Token;
        /**
         * `CfnTrigger.ActionProperty.JobName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-jobname
         */
        readonly jobName?: string;
    }
}
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html
     */
    interface ConditionProperty {
        /**
         * `CfnTrigger.ConditionProperty.JobName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-jobname
         */
        readonly jobName?: string;
        /**
         * `CfnTrigger.ConditionProperty.LogicalOperator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-logicaloperator
         */
        readonly logicalOperator?: string;
        /**
         * `CfnTrigger.ConditionProperty.State`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-state
         */
        readonly state?: string;
    }
}
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html
     */
    interface PredicateProperty {
        /**
         * `CfnTrigger.PredicateProperty.Conditions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-conditions
         */
        readonly conditions?: Array<CfnTrigger.ConditionProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnTrigger.PredicateProperty.Logical`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-logical
         */
        readonly logical?: string;
    }
}
