#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/cdk");
const glue = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-glue');
const database = new glue.Database(stack, 'MyDatabase', {
    databaseName: 'my_database'
});
const ordinaryTable = new glue.Table(stack, 'MyTable', {
    database,
    tableName: 'my_table',
    columns: [{
            name: 'col1',
            type: glue.Schema.string
        }, {
            name: 'col2',
            type: glue.Schema.string,
            comment: 'col2 comment'
        }, {
            name: 'col3',
            type: glue.Schema.array(glue.Schema.string)
        }, {
            name: 'col4',
            type: glue.Schema.map(glue.Schema.string, glue.Schema.string)
        }, {
            name: 'col5',
            type: glue.Schema.struct([{
                    name: 'col1',
                    type: glue.Schema.string
                }])
        }],
    partitionKeys: [{
            name: 'year',
            type: glue.Schema.smallint
        }],
    dataFormat: glue.DataFormat.Json
});
const encryptedTable = new glue.Table(stack, 'MyEncryptedTable', {
    database,
    tableName: 'my_encrypted_table',
    columns: [{
            name: 'col1',
            type: glue.Schema.string
        }, {
            name: 'col2',
            type: glue.Schema.string,
            comment: 'col2 comment'
        }, {
            name: 'col3',
            type: glue.Schema.array(glue.Schema.string)
        }, {
            name: 'col4',
            type: glue.Schema.map(glue.Schema.string, glue.Schema.string)
        }, {
            name: 'col5',
            type: glue.Schema.struct([{
                    name: 'col1',
                    type: glue.Schema.string
                }])
        }],
    partitionKeys: [{
            name: 'year',
            type: glue.Schema.smallint
        }],
    dataFormat: glue.DataFormat.Json,
    encryption: glue.TableEncryption.Kms,
    encryptionKey: new kms.EncryptionKey(stack, 'MyKey')
});
const user = new iam.User(stack, 'MyUser');
ordinaryTable.grantReadWrite(user);
encryptedTable.grantReadWrite(user);
app.run();
//# sourceMappingURL=data:application/json;base64,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