"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const glue = require("../lib");
module.exports = {
    'default database creates a bucket to store the datbase'(test) {
        const stack = new cdk.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database'
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseBucket318AF64F: {
                    Type: 'AWS::S3::Bucket',
                    DeletionPolicy: "Retain"
                },
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: {
                                "Fn::Join": [
                                    "",
                                    [
                                        "s3://",
                                        {
                                            Ref: "DatabaseBucket318AF64F"
                                        },
                                        "/test_database"
                                    ]
                                ]
                            },
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'explicit locationURI'(test) {
        const stack = new cdk.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
            locationUri: 's3://my-uri/'
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: 's3://my-uri/',
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'export creates Outputs for catalog ARN/Id, database ARN/Name/LocationURI'(test) {
        const stack = new cdk.Stack();
        const db = new glue.Database(stack, 'Database', {
            databaseName: 'test_database'
        });
        glue.Database.import(new cdk.Stack(), 'Database', db.export());
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseBucket318AF64F: {
                    Type: 'AWS::S3::Bucket',
                    DeletionPolicy: "Retain"
                },
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: {
                                "Fn::Join": [
                                    "",
                                    [
                                        "s3://",
                                        {
                                            Ref: "DatabaseBucket318AF64F"
                                        },
                                        "/test_database"
                                    ]
                                ]
                            },
                            Name: "test_database"
                        }
                    }
                }
            },
            Outputs: {
                DatabaseCatalogArnE5C8063F: {
                    Value: {
                        "Fn::Join": [
                            "",
                            [
                                "arn:",
                                {
                                    Ref: "AWS::Partition"
                                },
                                ":glue:",
                                {
                                    Ref: "AWS::Region"
                                },
                                ":",
                                {
                                    Ref: "AWS::AccountId"
                                },
                                ":catalog"
                            ]
                        ]
                    },
                    Export: {
                        Name: "Stack:DatabaseCatalogArnE5C8063F"
                    }
                },
                DatabaseCatalogId509C6547: {
                    Value: {
                        Ref: "AWS::AccountId"
                    },
                    Export: {
                        Name: "Stack:DatabaseCatalogId509C6547"
                    }
                },
                DatabaseDatabaseArn157B38E0: {
                    Value: {
                        "Fn::Join": [
                            "",
                            [
                                "arn:",
                                {
                                    Ref: "AWS::Partition"
                                },
                                ":glue:",
                                {
                                    Ref: "AWS::Region"
                                },
                                ":",
                                {
                                    Ref: "AWS::AccountId"
                                },
                                ":database/",
                                {
                                    Ref: "DatabaseB269D8BB"
                                }
                            ]
                        ]
                    },
                    Export: {
                        Name: "Stack:DatabaseDatabaseArn157B38E0"
                    }
                },
                DatabaseDatabaseName925B74A8: {
                    Value: {
                        Ref: "DatabaseB269D8BB"
                    },
                    Export: {
                        Name: "Stack:DatabaseDatabaseName925B74A8"
                    }
                },
                DatabaseLocationURIF74653AF: {
                    Value: {
                        "Fn::Join": [
                            "",
                            [
                                "s3://",
                                {
                                    Ref: "DatabaseBucket318AF64F"
                                },
                                "/test_database"
                            ]
                        ]
                    },
                    Export: {
                        Name: "Stack:DatabaseLocationURIF74653AF"
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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