"use strict";
const lib_1 = require("../lib");
module.exports = {
    'boolean type'(test) {
        test.equals(lib_1.Schema.boolean.inputString, 'boolean');
        test.equals(lib_1.Schema.boolean.isPrimitive, true);
        test.done();
    },
    'binary type'(test) {
        test.equals(lib_1.Schema.binary.inputString, 'binary');
        test.equals(lib_1.Schema.binary.isPrimitive, true);
        test.done();
    },
    'bigint type'(test) {
        test.equals(lib_1.Schema.bigint.inputString, 'bigint');
        test.equals(lib_1.Schema.bigint.isPrimitive, true);
        test.done();
    },
    'double type'(test) {
        test.equals(lib_1.Schema.double.inputString, 'double');
        test.equals(lib_1.Schema.double.isPrimitive, true);
        test.done();
    },
    'float type'(test) {
        test.equals(lib_1.Schema.float.inputString, 'float');
        test.equals(lib_1.Schema.float.isPrimitive, true);
        test.done();
    },
    'integer type'(test) {
        test.equals(lib_1.Schema.integer.inputString, 'integer');
        test.equals(lib_1.Schema.integer.isPrimitive, true);
        test.done();
    },
    'smallint type'(test) {
        test.equals(lib_1.Schema.smallint.inputString, 'smallint');
        test.equals(lib_1.Schema.smallint.isPrimitive, true);
        test.done();
    },
    'tinyint type'(test) {
        test.equals(lib_1.Schema.tinyint.inputString, 'tinyint');
        test.equals(lib_1.Schema.tinyint.isPrimitive, true);
        test.done();
    },
    'decimal type'(test) {
        test.equals(lib_1.Schema.decimal(16).inputString, 'decimal(16)');
        test.equals(lib_1.Schema.decimal(16, 1).inputString, 'decimal(16,1)');
        test.equals(lib_1.Schema.decimal(16).isPrimitive, true);
        test.equals(lib_1.Schema.decimal(16, 1).isPrimitive, true);
        test.done();
    },
    // TODO: decimal bounds
    'date type'(test) {
        test.equals(lib_1.Schema.date.inputString, 'date');
        test.equals(lib_1.Schema.date.isPrimitive, true);
        test.done();
    },
    'timestamp type'(test) {
        test.equals(lib_1.Schema.timestamp.inputString, 'timestamp');
        test.equals(lib_1.Schema.timestamp.isPrimitive, true);
        test.done();
    },
    'string type'(test) {
        test.equals(lib_1.Schema.string.inputString, 'string');
        test.equals(lib_1.Schema.string.isPrimitive, true);
        test.done();
    },
    'char type'(test) {
        test.equals(lib_1.Schema.char(1).inputString, 'char(1)');
        test.equals(lib_1.Schema.char(1).isPrimitive, true);
        test.done();
    },
    'char length must be at least 1'(test) {
        test.doesNotThrow(() => lib_1.Schema.char(1));
        test.throws(() => lib_1.Schema.char(0));
        test.throws(() => lib_1.Schema.char(-1));
        test.done();
    },
    'char length must be <= 255'(test) {
        test.doesNotThrow(() => lib_1.Schema.char(255));
        test.throws(() => lib_1.Schema.char(256));
        test.done();
    },
    'varchar type'(test) {
        test.equals(lib_1.Schema.varchar(1).inputString, 'varchar(1)');
        test.equals(lib_1.Schema.varchar(1).isPrimitive, true);
        test.done();
    },
    'varchar length must be at least 1'(test) {
        test.doesNotThrow(() => lib_1.Schema.varchar(1));
        test.throws(() => lib_1.Schema.varchar(0));
        test.throws(() => lib_1.Schema.varchar(-1));
        test.done();
    },
    'varchar length must be <= 65535'(test) {
        test.doesNotThrow(() => lib_1.Schema.varchar(65535));
        test.throws(() => lib_1.Schema.varchar(65536));
        test.done();
    },
    'array<string>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.string);
        test.equals(type.inputString, 'array<string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<char(1)>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.char(1));
        test.equals(type.inputString, 'array<char(1)>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<array>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.array(lib_1.Schema.string));
        test.equals(type.inputString, 'array<array<string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<map>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.map(lib_1.Schema.string, lib_1.Schema.string));
        test.equals(type.inputString, 'array<map<string,string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<struct>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.string
            }]));
        test.equals(type.inputString, 'array<struct<key:string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,string>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.string, lib_1.Schema.string);
        test.equals(type.inputString, 'map<string,string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<integer,string>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.integer, lib_1.Schema.string);
        test.equals(type.inputString, 'map<integer,string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<char(1),char(1)>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.char(1));
        test.equals(type.inputString, 'map<char(1),char(1)>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,array>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.array(lib_1.Schema.string));
        test.equals(type.inputString, 'map<char(1),array<string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,map>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.map(lib_1.Schema.string, lib_1.Schema.string));
        test.equals(type.inputString, 'map<char(1),map<string,string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,struct>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.string
            }]));
        test.equals(type.inputString, 'map<char(1),struct<key:string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map throws if keyType is non-primitive'(test) {
        test.throws(() => lib_1.Schema.map(lib_1.Schema.array(lib_1.Schema.string), lib_1.Schema.string));
        test.throws(() => lib_1.Schema.map(lib_1.Schema.map(lib_1.Schema.string, lib_1.Schema.string), lib_1.Schema.string));
        test.throws(() => lib_1.Schema.map(lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.string
            }]), lib_1.Schema.string));
        test.done();
    },
    'struct type'(test) {
        const type = lib_1.Schema.struct([{
                name: 'primitive',
                type: lib_1.Schema.string
            }, {
                name: 'with_comment',
                type: lib_1.Schema.string,
                comment: 'this has a comment'
            }, {
                name: 'array',
                type: lib_1.Schema.array(lib_1.Schema.string)
            }, {
                name: 'map',
                type: lib_1.Schema.map(lib_1.Schema.string, lib_1.Schema.string)
            }, {
                name: 'nested_struct',
                type: lib_1.Schema.struct([{
                        name: 'nested',
                        type: lib_1.Schema.string,
                        comment: 'nested comment'
                    }])
            }]);
        test.equals(type.isPrimitive, false);
        test.equals(type.inputString, 
        // tslint:disable-next-line:max-line-length
        `struct<primitive:string,with_comment:string COMMENT 'this has a comment',array:array<string>,map:map<string,string>,nested_struct:struct<nested:string COMMENT 'nested comment'>>`);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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