"""Create tables

Revision ID: 99423c1dec60
Revises:
Create Date: 2024-03-01 05:37:31.862957+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "99423c1dec60"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "organizations",
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("organization_name", sa.String(), nullable=False),
        sa.Column("webhook_callback_url", sa.UnicodeText(), nullable=True),
        sa.Column("max_steps_per_run", sa.Integer(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("organization_id"),
    )
    op.create_index(
        op.f("ix_organizations_organization_id"),
        "organizations",
        ["organization_id"],
        unique=False,
    )
    op.create_table(
        "organization_auth_tokens",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column(
            "token_type",
            sa.Enum("api", name="organizationauthtokentype"),
            nullable=False,
        ),
        sa.Column("token", sa.String(), nullable=False),
        sa.Column("valid", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_organization_auth_tokens_id"),
        "organization_auth_tokens",
        ["id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_organization_auth_tokens_organization_id"),
        "organization_auth_tokens",
        ["organization_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_organization_auth_tokens_token"),
        "organization_auth_tokens",
        ["token"],
        unique=False,
    )
    op.create_table(
        "workflows",
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("workflow_definition", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_id"),
    )
    op.create_index(op.f("ix_workflows_workflow_id"), "workflows", ["workflow_id"], unique=False)
    op.create_table(
        "aws_secret_parameters",
        sa.Column("aws_secret_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("aws_key", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("aws_secret_parameter_id"),
    )
    op.create_index(
        op.f("ix_aws_secret_parameters_aws_secret_parameter_id"),
        "aws_secret_parameters",
        ["aws_secret_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_aws_secret_parameters_workflow_id"),
        "aws_secret_parameters",
        ["workflow_id"],
        unique=False,
    )
    op.create_table(
        "workflow_parameters",
        sa.Column("workflow_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_parameter_type", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("default_value", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_parameter_id"),
    )
    op.create_index(
        op.f("ix_workflow_parameters_workflow_id"),
        "workflow_parameters",
        ["workflow_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_workflow_parameters_workflow_parameter_id"),
        "workflow_parameters",
        ["workflow_parameter_id"],
        unique=False,
    )
    op.create_table(
        "workflow_runs",
        sa.Column("workflow_run_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("status", sa.String(), nullable=False),
        sa.Column(
            "proxy_location",
            sa.Enum(
                "US_CA",
                "US_NY",
                "US_TX",
                "US_FL",
                "US_WA",
                "RESIDENTIAL",
                "NONE",
                name="proxylocation",
            ),
            nullable=True,
        ),
        sa.Column("webhook_callback_url", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_run_id"),
    )
    op.create_index(
        op.f("ix_workflow_runs_workflow_run_id"),
        "workflow_runs",
        ["workflow_run_id"],
        unique=False,
    )
    op.create_table(
        "tasks",
        sa.Column("task_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("status", sa.String(), nullable=True),
        sa.Column("webhook_callback_url", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("navigation_goal", sa.String(), nullable=True),
        sa.Column("data_extraction_goal", sa.String(), nullable=True),
        sa.Column("navigation_payload", sa.JSON(), nullable=True),
        sa.Column("extracted_information", sa.JSON(), nullable=True),
        sa.Column("failure_reason", sa.String(), nullable=True),
        sa.Column(
            "proxy_location",
            sa.Enum(
                "US_CA",
                "US_NY",
                "US_TX",
                "US_FL",
                "US_WA",
                "RESIDENTIAL",
                "NONE",
                name="proxylocation",
            ),
            nullable=True,
        ),
        sa.Column("extracted_information_schema", sa.JSON(), nullable=True),
        sa.Column("workflow_run_id", sa.String(), nullable=True),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("retry", sa.Integer(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("task_id"),
    )
    op.create_index(op.f("ix_tasks_task_id"), "tasks", ["task_id"], unique=False)
    op.create_table(
        "workflow_run_parameters",
        sa.Column("workflow_run_id", sa.String(), nullable=False),
        sa.Column("workflow_parameter_id", sa.String(), nullable=False),
        sa.Column("value", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["workflow_parameter_id"],
            ["workflow_parameters.workflow_parameter_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_run_id", "workflow_parameter_id"),
    )
    op.create_index(
        op.f("ix_workflow_run_parameters_workflow_parameter_id"),
        "workflow_run_parameters",
        ["workflow_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_workflow_run_parameters_workflow_run_id"),
        "workflow_run_parameters",
        ["workflow_run_id"],
        unique=False,
    )
    op.create_table(
        "steps",
        sa.Column("step_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("task_id", sa.String(), nullable=True),
        sa.Column("status", sa.String(), nullable=True),
        sa.Column("output", sa.JSON(), nullable=True),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("is_last", sa.Boolean(), nullable=True),
        sa.Column("retry_index", sa.Integer(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("input_token_count", sa.Integer(), nullable=True),
        sa.Column("output_token_count", sa.Integer(), nullable=True),
        sa.Column("step_cost", sa.Numeric(), nullable=True),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["tasks.task_id"],
        ),
        sa.PrimaryKeyConstraint("step_id"),
    )
    op.create_index(op.f("ix_steps_step_id"), "steps", ["step_id"], unique=False)
    op.create_table(
        "artifacts",
        sa.Column("artifact_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("task_id", sa.String(), nullable=True),
        sa.Column("step_id", sa.String(), nullable=True),
        sa.Column("artifact_type", sa.String(), nullable=True),
        sa.Column("uri", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["step_id"],
            ["steps.step_id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["tasks.task_id"],
        ),
        sa.PrimaryKeyConstraint("artifact_id"),
    )
    op.create_index(op.f("ix_artifacts_artifact_id"), "artifacts", ["artifact_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_artifacts_artifact_id"), table_name="artifacts")
    op.drop_table("artifacts")
    op.drop_index(op.f("ix_steps_step_id"), table_name="steps")
    op.drop_table("steps")
    op.drop_index(
        op.f("ix_workflow_run_parameters_workflow_run_id"),
        table_name="workflow_run_parameters",
    )
    op.drop_index(
        op.f("ix_workflow_run_parameters_workflow_parameter_id"),
        table_name="workflow_run_parameters",
    )
    op.drop_table("workflow_run_parameters")
    op.drop_index(op.f("ix_tasks_task_id"), table_name="tasks")
    op.drop_table("tasks")
    op.drop_index(op.f("ix_workflow_runs_workflow_run_id"), table_name="workflow_runs")
    op.drop_table("workflow_runs")
    op.drop_index(
        op.f("ix_workflow_parameters_workflow_parameter_id"),
        table_name="workflow_parameters",
    )
    op.drop_index(op.f("ix_workflow_parameters_workflow_id"), table_name="workflow_parameters")
    op.drop_table("workflow_parameters")
    op.drop_index(op.f("ix_aws_secret_parameters_workflow_id"), table_name="aws_secret_parameters")
    op.drop_index(
        op.f("ix_aws_secret_parameters_aws_secret_parameter_id"),
        table_name="aws_secret_parameters",
    )
    op.drop_table("aws_secret_parameters")
    op.drop_index(op.f("ix_workflows_workflow_id"), table_name="workflows")
    op.drop_table("workflows")
    op.drop_index(op.f("ix_organization_auth_tokens_token"), table_name="organization_auth_tokens")
    op.drop_index(
        op.f("ix_organization_auth_tokens_organization_id"),
        table_name="organization_auth_tokens",
    )
    op.drop_index(op.f("ix_organization_auth_tokens_id"), table_name="organization_auth_tokens")
    op.drop_table("organization_auth_tokens")
    op.drop_index(op.f("ix_organizations_organization_id"), table_name="organizations")
    op.drop_table("organizations")
    # ### end Alembic commands ###
