"""Add title, error_code_mapping, and errors to tasks

Revision ID: 82a0c686152d
Revises: 99423c1dec60
Create Date: 2024-03-13 05:18:52.674264+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "82a0c686152d"
down_revision: Union[str, None] = "99423c1dec60"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("tasks", sa.Column("title", sa.String(), nullable=True))
    op.add_column("tasks", sa.Column("error_code_mapping", sa.JSON(), nullable=True))
    # In order to add a column with a default value, we need to add the column
    # as nullable, then set the default value, then set the column to not
    op.add_column("tasks", sa.Column("errors", sa.JSON(), nullable=True))
    op.execute("UPDATE tasks SET errors = '[]'::jsonb")
    op.alter_column("tasks", "errors", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("tasks", "errors")
    op.drop_column("tasks", "error_code_mapping")
    op.drop_column("tasks", "title")
    # ### end Alembic commands ###
